/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.extractors;

import java.io.StringReader;
import java.util.regex.Pattern;
import javax.swing.text.Document;
import javax.swing.text.rtf.RTFEditorKit;
import org.opencms.search.extractors.A_CmsTextExtractor;
import org.opencms.search.extractors.CmsExtractionResult;
import org.opencms.search.extractors.I_CmsExtractionResult;
import org.opencms.search.extractors.I_CmsTextExtractor;

public final class CmsExtractorRtf
extends A_CmsTextExtractor {
    private static final CmsExtractorRtf INSTANCE = new CmsExtractorRtf();
    private static final Pattern TS_REMOVE_PATTERN = Pattern.compile("\\{\\\\\\*\\\\ts[^\\}]*\\}", 32);

    private CmsExtractorRtf() {
    }

    public static I_CmsTextExtractor getExtractor() {
        return INSTANCE;
    }

    public I_CmsExtractionResult extractText(byte[] content, String encoding) throws Exception {
        String input = new String(content);
        input = TS_REMOVE_PATTERN.matcher(input).replaceAll("");
        RTFEditorKit rtfEditor = new RTFEditorKit();
        Document doc = rtfEditor.createDefaultDocument();
        rtfEditor.read(new StringReader(input), doc, 0);
        String result = doc.getText(0, doc.getLength());
        result = this.removeControlChars(result);
        return new CmsExtractionResult(result);
    }
}

