/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.search.fields;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opencms.search.fields.CmsSearchField;
import org.opencms.search.fields.CmsSearchFieldMapping;
import org.opencms.search.fields.CmsSearchFieldMappingType;

public class CmsSearchFieldConfiguration
implements Comparable {
    public static final CmsSearchFieldConfiguration DEFAULT_STANDARD = CmsSearchFieldConfiguration.createStandardConfiguration();
    public static final String STR_STANDARD = "standard";
    public static final String STR_STANDARD_DESCRIPTION = "The standard OpenCms 7.0 search index field configuration.";
    private String m_description;
    private List m_excerptFieldNames;
    private List m_fieldNames;
    private List m_fields = new ArrayList();
    private String m_name;

    private static CmsSearchFieldConfiguration createStandardConfiguration() {
        CmsSearchFieldConfiguration result = new CmsSearchFieldConfiguration();
        result.setName(STR_STANDARD);
        result.setDescription(STR_STANDARD_DESCRIPTION);
        CmsSearchField field = new CmsSearchField("content", "%(key.field.content)", true, true, true, true, 1.0f, null);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.CONTENT, null));
        result.addField(field);
        field = new CmsSearchField("title-key", "-", true, true, false, false, 0.0f, null);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Title"));
        result.addField(field);
        field = new CmsSearchField("title", "%(key.field.title)", false, true);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Title"));
        result.addField(field);
        field = new CmsSearchField("keywords", "%(key.field.keywords)", true, true);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Keywords"));
        result.addField(field);
        field = new CmsSearchField("description", "%(key.field.description)", true, true);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Description"));
        result.addField(field);
        field = new CmsSearchField("meta", "%(key.field.meta)", false, true);
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Title"));
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Keywords"));
        field.addMapping(new CmsSearchFieldMapping(CmsSearchFieldMappingType.PROPERTY, "Description"));
        result.addField(field);
        return result;
    }

    public void addField(CmsSearchField field) {
        if (field != null) {
            this.m_fields.add(field);
        }
    }

    public int compareTo(Object obj) {
        if (obj instanceof CmsSearchFieldConfiguration) {
            return this.m_name.compareTo(((CmsSearchFieldConfiguration)obj).m_name);
        }
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsSearchFieldConfiguration) {
            return ((CmsSearchFieldConfiguration)obj).m_name.equals(this.m_name);
        }
        return false;
    }

    public String getDescription() {
        return this.m_description;
    }

    public List getExcerptFieldNames() {
        if (this.m_excerptFieldNames == null) {
            this.m_excerptFieldNames = new ArrayList();
            Iterator i = this.m_fields.iterator();
            while (i.hasNext()) {
                CmsSearchField field = (CmsSearchField)i.next();
                if (!field.isInExcerptAndStored()) continue;
                this.m_excerptFieldNames.add(field.getName());
            }
        }
        return new ArrayList(this.m_excerptFieldNames);
    }

    public List getFieldNames() {
        if (this.m_fieldNames == null) {
            this.m_fieldNames = new ArrayList();
            Iterator i = this.m_fields.iterator();
            while (i.hasNext()) {
                this.m_fieldNames.add(((CmsSearchField)i.next()).getName());
            }
        }
        return new ArrayList(this.m_fieldNames);
    }

    public List getFields() {
        return this.m_fields;
    }

    public String getName() {
        return this.m_name;
    }

    public int hashCode() {
        return this.m_name.hashCode();
    }

    public void setDescription(String description) {
        this.m_description = description;
    }

    public void setName(String name) {
        this.m_name = name;
    }
}

