/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.security;

import java.util.Locale;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.security.Messages;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsOrganizationalUnit {
    public static final int FLAG_HIDE_LOGIN = 1;
    public static final int FLAG_WEBUSERS = 8;
    public static final String SEPARATOR = "/";
    private String m_description;
    private int m_flags;
    private final CmsUUID m_id;
    private final String m_name;
    private final CmsUUID m_projectId;

    public CmsOrganizationalUnit(CmsUUID id, String fqn, String description, int flags, CmsUUID projectId) {
        this.m_id = id;
        this.m_name = fqn;
        this.m_description = description;
        this.m_flags = flags;
        this.m_projectId = projectId;
    }

    public static final String getParentFqn(String fqn) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(fqn)) {
            return null;
        }
        int pos = fqn.endsWith(SEPARATOR) ? fqn.substring(0, fqn.length() - 1).lastIndexOf(SEPARATOR) : fqn.lastIndexOf(SEPARATOR);
        if (pos <= 0) {
            return "";
        }
        return fqn.substring(0, pos + 1);
    }

    public static final String getSimpleName(String fqn) {
        String parentFqn = CmsOrganizationalUnit.getParentFqn(fqn);
        if (parentFqn != null) {
            fqn = fqn.substring(parentFqn.length());
        }
        if (fqn != null && fqn.startsWith(SEPARATOR)) {
            fqn = fqn.substring(SEPARATOR.length());
        }
        return fqn;
    }

    public static String removeLeadingSeparator(String fqn) {
        if (fqn != null && fqn.startsWith(SEPARATOR)) {
            return fqn.substring(1);
        }
        return fqn;
    }

    public void addFlag(int flag) {
        this.m_flags ^= flag;
    }

    public Object clone() {
        return new CmsOrganizationalUnit(this.m_id, this.m_name, this.m_description, this.m_flags, this.m_projectId);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof CmsOrganizationalUnit && this.m_id != null) {
            return this.m_id.equals(((CmsOrganizationalUnit)obj).getId());
        }
        return false;
    }

    public String getDescription() {
        return this.m_description;
    }

    public String getDescription(Locale locale) {
        CmsMacroResolver macroResolver = new CmsMacroResolver();
        macroResolver.setMessages(org.opencms.db.generic.Messages.get().getBundle(locale));
        return macroResolver.resolveMacros(this.m_description);
    }

    public String getDisplayName(Locale locale) {
        if (this.getParentFqn() == null) {
            return this.getDescription(locale);
        }
        return Messages.get().getBundle(locale).key("GUI_ORGUNIT_DISPLAY_NAME_2", this.getDescription(locale), SEPARATOR + this.getName());
    }

    public int getFlags() {
        return this.m_flags;
    }

    public CmsUUID getId() {
        return this.m_id;
    }

    public String getName() {
        return this.m_name;
    }

    public String getParentFqn() {
        return CmsOrganizationalUnit.getParentFqn(this.m_name);
    }

    public CmsUUID getProjectId() {
        return this.m_projectId;
    }

    public String getSimpleName() {
        return CmsOrganizationalUnit.getSimpleName(this.m_name);
    }

    public boolean hasFlag(int flag) {
        return (this.m_flags & flag) == flag;
    }

    public boolean hasFlagHideLogin() {
        return this.hasFlag(1);
    }

    public boolean hasFlagWebuser() {
        return this.hasFlag(8);
    }

    public int hashCode() {
        if (this.m_id != null) {
            return this.m_id.hashCode();
        }
        return CmsUUID.getNullUUID().hashCode();
    }

    public void setDescription(String description) {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(description)) {
            throw new CmsIllegalArgumentException(org.opencms.db.Messages.get().container("ERR_BAD_OU_DESCRIPTION_EMPTY_0"));
        }
        this.m_description = description;
    }

    public void setFlagHideLogin() {
        this.addFlag(1);
    }

    public void setFlags(int value) {
        this.m_flags = value;
    }

    public void setFlagWebusers() {
        this.addFlag(8);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[Organizational Unit]");
        result.append(" fqn:");
        result.append(this.getName());
        result.append(" id:");
        result.append(this.m_id);
        result.append(" description:");
        result.append(this.m_description);
        return result.toString();
    }
}

