/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.site;

import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.site.CmsSite;

public final class CmsSiteManager {
    private CmsSiteManager() {
    }

    public static List getAvailableSites(CmsObject cms, boolean workplaceMode) {
        return OpenCms.getSiteManager().getAvailableSites(cms, workplaceMode, cms.getRequestContext().getOuFqn());
    }

    public static List getAvailableSites(CmsObject cms, boolean workplaceMode, String ouFqn) {
        return OpenCms.getSiteManager().getAvailableSites(cms, workplaceMode, ouFqn);
    }

    public static CmsSite getCurrentSite(CmsObject cms) {
        return OpenCms.getSiteManager().getCurrentSite(cms);
    }

    public static CmsSite getSite(String siteRoot) {
        return OpenCms.getSiteManager().getSiteForSiteRoot(siteRoot);
    }

    public static String getSiteRoot(String rootPath) {
        return OpenCms.getSiteManager().getSiteRoot(rootPath);
    }
}

