/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.staticexport;

import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsPublishedResource;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.loader.I_CmsResourceLoader;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.report.I_CmsReport;
import org.opencms.staticexport.A_CmsStaticExportHandler;
import org.opencms.staticexport.CmsExportFolderMatcher;
import org.opencms.staticexport.CmsStaticExportData;
import org.opencms.staticexport.CmsStaticExportExportRule;
import org.opencms.staticexport.CmsStaticExportManager;
import org.opencms.staticexport.CmsStaticExportRfsRule;
import org.opencms.staticexport.I_CmsStaticExportHandler;
import org.opencms.staticexport.Messages;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsAfterPublishStaticExportHandler
extends A_CmsStaticExportHandler
implements I_CmsStaticExportHandler {
    private static final String HEADER_FIELD_SET_COOKIE = "Set-Cookie";
    private static final Log LOG = CmsLog.getLog(CmsAfterPublishStaticExportHandler.class);
    private static final String REQUEST_METHOD_GET = "GET";
    private static final String REQUEST_PROPERTY_COOKIE = "Cookie";

    public void doExportAfterPublish(List resources, I_CmsReport report) throws CmsException, IOException, ServletException {
        List resourcesToExport;
        CmsObject cmsExportObject = OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserExport());
        boolean templatesFound = this.exportNonTemplateResources(cmsExportObject, resourcesToExport = this.getRelatedResources(cmsExportObject, resources), report);
        if (templatesFound || !OpenCms.getStaticExportManager().getQuickPlainExport()) {
            List publishedTemplateResources;
            CmsStaticExportManager manager = OpenCms.getStaticExportManager();
            HashSet<String> resourceFilter = new HashSet<String>();
            Iterator itExpRes = resourcesToExport.iterator();
            while (itExpRes.hasNext()) {
                CmsPublishedResource pubResource = (CmsPublishedResource)itExpRes.next();
                String rfsName = manager.getRfsName(cmsExportObject, pubResource.getRootPath());
                resourceFilter.add(rfsName.substring(manager.getRfsPrefixForRfsName(rfsName).length()));
            }
            long timestamp = 0L;
            int linkMode = 1;
            while ((publishedTemplateResources = cmsExportObject.readStaticExportResources(linkMode, timestamp)) != null) {
                boolean newTemplateLinksFound;
                boolean bl = newTemplateLinksFound = publishedTemplateResources.size() > 0;
                if (newTemplateLinksFound) {
                    if (linkMode == 1) {
                        linkMode = 2;
                        publishedTemplateResources.retainAll(resourceFilter);
                    } else {
                        timestamp = System.currentTimeMillis();
                        Iterator itPubTemplates = publishedTemplateResources.iterator();
                        while (itPubTemplates.hasNext()) {
                            String rfsName = (String)itPubTemplates.next();
                            if (resourceFilter.contains(rfsName.substring(0, rfsName.lastIndexOf(95)))) continue;
                            itPubTemplates.remove();
                        }
                    }
                    if (publishedTemplateResources.isEmpty()) break;
                    this.exportTemplateResources(cmsExportObject, publishedTemplateResources, report);
                }
                if (newTemplateLinksFound) continue;
            }
        }
    }

    public List getAllResources(CmsObject cms) throws CmsException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_GET_ALL_RESOURCES_0"));
        }
        List vfsResources = cms.readResources("/", CmsResourceFilter.ALL.addExcludeFlags(512));
        CmsExportFolderMatcher matcher = OpenCms.getStaticExportManager().getExportFolderMatcher();
        ArrayList<CmsPublishedResource> resources = new ArrayList<CmsPublishedResource>(vfsResources.size());
        Iterator i = vfsResources.iterator();
        while (i.hasNext()) {
            CmsResource resource = (CmsResource)i.next();
            if (!matcher.match(resource.getRootPath())) continue;
            CmsPublishedResource pubRes = new CmsPublishedResource(resource);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_PROCESSING_1", resource.getRootPath()));
            }
            resources.add(pubRes);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_NUM_RESOURCES_1", new Integer(resources.size())));
        }
        return resources;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performEventPublishProject(CmsUUID publishHistoryId, I_CmsReport report) {
        try {
            this.m_busy = true;
            this.exportAfterPublish(publishHistoryId, report);
        }
        catch (Throwable t) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_STATIC_EXPORT_ERROR_0"), t);
            }
            if (report != null) {
                report.addError(t);
            }
        }
        finally {
            this.m_busy = false;
        }
    }

    protected void exportAfterPublish(CmsUUID publishHistoryId, I_CmsReport report) throws CmsException, IOException, ServletException {
        File file;
        String rfsName = CmsFileUtil.normalizePath(OpenCms.getStaticExportManager().getExportPath(OpenCms.getStaticExportManager().getTestResource()) + OpenCms.getStaticExportManager().getTestResource());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_CHECKING_TEST_RESOURCE_1", rfsName));
        }
        if (!(file = new File(rfsName)).exists()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_TEST_RESOURCE_NOT_EXISTANT_0"));
            }
            OpenCms.getStaticExportManager().exportFullStaticRender(true, report);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_TEST_RESOURCE_EXISTS_0"));
            }
            List publishedResources = this.scrubExportFolders(publishHistoryId);
            this.doExportAfterPublish(publishedResources, report);
        }
    }

    protected boolean exportNonTemplateResources(CmsObject cms, List publishedResources, I_CmsReport report) throws CmsException, IOException, ServletException {
        report.println(Messages.get().container("RPT_STATICEXPORT_NONTEMPLATE_RESOURCES_BEGIN_0"), 2);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_EXPORTING_NON_TEMPLATE_1", new Integer(publishedResources.size())));
        }
        CmsStaticExportManager manager = OpenCms.getStaticExportManager();
        ArrayList resourcesToExport = new ArrayList();
        boolean templatesFound = this.readNonTemplateResourcesToExport(cms, publishedResources, resourcesToExport);
        int count = 1;
        int size = resourcesToExport.size();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_NUM_EXPORT_1", new Integer(size)));
        }
        Iterator i = resourcesToExport.iterator();
        while (i.hasNext()) {
            CmsStaticExportData exportData = (CmsStaticExportData)i.next();
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_EXPORT_FILE_2", exportData.getVfsName(), exportData.getRfsName()));
            }
            report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", new Integer(count++), new Integer(size)), 3);
            report.print(Messages.get().container("RPT_EXPORTING_0"), 3);
            report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", exportData.getVfsName()));
            report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            int status = manager.export(null, null, cms, exportData);
            if (status == 200) {
                report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
            } else {
                report.println(org.opencms.report.Messages.get().container("RPT_IGNORED_0"), 3);
            }
            if (LOG.isInfoEnabled()) {
                Object[] arguments = new Object[]{exportData.getVfsName(), exportData.getRfsName(), new Integer(status)};
                LOG.info((Object)Messages.get().getBundle().key("LOG_EXPORT_FILE_STATUS_3", arguments));
            }
            Thread.yield();
        }
        resourcesToExport = null;
        report.println(Messages.get().container("RPT_STATICEXPORT_NONTEMPLATE_RESOURCES_END_0"), 2);
        return templatesFound;
    }

    protected int exportTemplateResource(String rfsName, String vfsName, StringBuffer cookies) throws IOException {
        CmsStaticExportManager manager = OpenCms.getStaticExportManager();
        String exportUrlStr = manager.getExportUrl() + manager.getRfsPrefix(vfsName) + rfsName;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_SENDING_REQUEST_2", rfsName, exportUrlStr));
        }
        URL exportUrl = new URL(exportUrlStr);
        HttpURLConnection.setFollowRedirects(false);
        HttpURLConnection urlcon = (HttpURLConnection)exportUrl.openConnection();
        urlcon.setRequestMethod(REQUEST_METHOD_GET);
        urlcon.setRequestProperty("OpenCms-Export", CmsStringUtil.TRUE);
        if (manager.getAcceptLanguageHeader() != null) {
            urlcon.setRequestProperty("Accept-Language", manager.getAcceptLanguageHeader());
        } else {
            urlcon.setRequestProperty("Accept-Language", manager.getDefaultAcceptLanguageHeader());
        }
        if (manager.getAcceptCharsetHeader() != null) {
            urlcon.setRequestProperty("Accept-Charset", manager.getAcceptCharsetHeader());
        } else {
            urlcon.setRequestProperty("Accept-Charset", manager.getDefaultAcceptCharsetHeader());
        }
        String exportFileName = CmsFileUtil.normalizePath(manager.getExportPath(vfsName) + rfsName);
        File exportFile = new File(exportFileName);
        long dateLastModified = exportFile.lastModified();
        if (vfsName.startsWith("/system/")) {
            Iterator it = manager.getRfsRules().iterator();
            while (it.hasNext()) {
                CmsStaticExportRfsRule rule = (CmsStaticExportRfsRule)it.next();
                if (!rule.match(vfsName) || dateLastModified <= (exportFile = new File(exportFileName = CmsFileUtil.normalizePath(rule.getExportPath() + rfsName))).lastModified()) continue;
                dateLastModified = exportFile.lastModified();
            }
        }
        urlcon.setIfModifiedSince(dateLastModified);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_IF_MODIFIED_SINCE_SET_2", exportFile.getName(), new Long(dateLastModified / 1000L * 1000L)));
        }
        if (cookies.length() > 0) {
            urlcon.setRequestProperty(REQUEST_PROPERTY_COOKIE, cookies.toString());
        }
        urlcon.connect();
        int status = urlcon.getResponseCode();
        if (cookies.length() == 0) {
            cookies.append(urlcon.getHeaderField(HEADER_FIELD_SET_COOKIE));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_STATICEXPORT_COOKIES_1", cookies));
            }
        }
        urlcon.disconnect();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_REQUEST_RESULT_3", rfsName, exportUrlStr, new Integer(status)));
        }
        return status;
    }

    protected void exportTemplateResources(CmsObject cms, List publishedTemplateResources, I_CmsReport report) {
        CmsStaticExportManager manager = OpenCms.getStaticExportManager();
        int size = publishedTemplateResources.size();
        int count = 1;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_EXPORT_TEMPLATES_1", new Integer(size)));
        }
        report.println(Messages.get().container("RPT_STATICEXPORT_TEMPLATE_RESOURCES_BEGIN_0"), 2);
        StringBuffer cookies = new StringBuffer();
        Iterator i = publishedTemplateResources.iterator();
        while (i.hasNext()) {
            String rfsName = (String)i.next();
            String vfsName = manager.getVfsNameInternal(cms, rfsName);
            if (vfsName == null) {
                String rfsBaseName = rfsName;
                int pos = rfsName.lastIndexOf(95);
                if (pos >= 0) {
                    rfsBaseName = rfsName.substring(0, pos);
                }
                vfsName = manager.getVfsNameInternal(cms, rfsBaseName);
            }
            if (vfsName == null) continue;
            report.print(org.opencms.report.Messages.get().container("RPT_SUCCESSION_2", new Integer(count++), new Integer(size)), 3);
            report.print(Messages.get().container("RPT_EXPORTING_0"), 3);
            report.print(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", rfsName));
            report.print(org.opencms.report.Messages.get().container("RPT_DOTS_0"));
            try {
                int status = this.exportTemplateResource(rfsName, vfsName, cookies);
                if (status == 200) {
                    report.println(org.opencms.report.Messages.get().container("RPT_OK_0"), 4);
                } else if (status == 304) {
                    report.println(org.opencms.report.Messages.get().container("RPT_SKIPPED_0"), 3);
                } else if (status == 303) {
                    report.println(org.opencms.report.Messages.get().container("RPT_IGNORED_0"), 3);
                } else {
                    report.println(org.opencms.report.Messages.get().container("RPT_ARGUMENT_1", new Integer(status)), 4);
                }
            }
            catch (IOException e) {
                report.println(e);
            }
            Thread.yield();
        }
        report.println(Messages.get().container("RPT_STATICEXPORT_TEMPLATE_RESOURCES_END_0"), 2);
    }

    protected List getRelatedFilesToPurge(String exportFileName, String vfsName) {
        return Collections.EMPTY_LIST;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getRelatedResources(CmsObject cms, List publishedResources) throws CmsException {
        String storedSiteRoot = cms.getRequestContext().getSiteRoot();
        try {
            cms.getRequestContext().setSiteRoot("/");
            if (publishedResources == null) {
                List list = this.getAllResources(cms);
                return list;
            }
            HashMap<String, CmsPublishedResource> resourceMap = new HashMap<String, CmsPublishedResource>();
            Iterator itPubRes = publishedResources.iterator();
            while (itPubRes.hasNext()) {
                CmsPublishedResource pubResource = (CmsPublishedResource)itPubRes.next();
                if (cms.existsResource(pubResource.getRootPath())) {
                    CmsResource vfsResource = cms.readResource(pubResource.getRootPath());
                    if (!vfsResource.isInternal()) {
                        Iterator itSiblings = this.getSiblings(cms, pubResource).iterator();
                        while (itSiblings.hasNext()) {
                            CmsPublishedResource sibling = (CmsPublishedResource)itSiblings.next();
                            resourceMap.put(sibling.getRootPath(), sibling);
                        }
                    }
                } else {
                    resourceMap.put(pubResource.getRootPath(), pubResource);
                }
                boolean match = false;
                Iterator itExportRules = OpenCms.getStaticExportManager().getExportRules().iterator();
                while (itExportRules.hasNext()) {
                    CmsStaticExportExportRule rule = (CmsStaticExportExportRule)itExportRules.next();
                    Set relatedResources = rule.getRelatedResources(cms, pubResource);
                    if (relatedResources == null) continue;
                    Iterator itRelatedRes = relatedResources.iterator();
                    while (itRelatedRes.hasNext()) {
                        CmsPublishedResource relatedRes = (CmsPublishedResource)itRelatedRes.next();
                        resourceMap.put(relatedRes.getRootPath(), relatedRes);
                    }
                    match = true;
                }
                if (match) continue;
                List list = this.getAllResources(cms);
                return list;
            }
            ArrayList arrayList = new ArrayList(resourceMap.values());
            return arrayList;
        }
        finally {
            cms.getRequestContext().setSiteRoot(storedSiteRoot);
        }
    }

    protected Set getSiblings(CmsObject cms, CmsPublishedResource pubResource) throws CmsException {
        HashSet<CmsPublishedResource> siblings = new HashSet<CmsPublishedResource>();
        Iterator i = this.getSiblingsList(cms, pubResource.getRootPath()).iterator();
        while (i.hasNext()) {
            String sibling = (String)i.next();
            siblings.add(new CmsPublishedResource(cms.readResource(sibling)));
        }
        return siblings;
    }

    protected boolean readNonTemplateResourcesToExport(CmsObject cms, List publishedResources, List resourcesToExport) throws CmsException {
        CmsStaticExportManager manager = OpenCms.getStaticExportManager();
        boolean templatesFound = false;
        Iterator i = publishedResources.iterator();
        while (i.hasNext()) {
            CmsResource resource;
            CmsStaticExportData exportData;
            CmsPublishedResource pupRes;
            block9: {
                pupRes = (CmsPublishedResource)i.next();
                String vfsName = pupRes.getRootPath();
                if (!manager.getExportFolderMatcher().match(vfsName) || (exportData = manager.getExportData(vfsName, cms)) == null) continue;
                resource = null;
                if (pupRes.isFile()) {
                    resource = exportData.getResource();
                } else {
                    try {
                        String defaultFileName = cms.readPropertyObject(vfsName, "default-file", false).getValue();
                        if (defaultFileName == null) break block9;
                        resource = cms.readResource(vfsName + defaultFileName);
                    }
                    catch (CmsException e) {
                        for (int j = 0; j < OpenCms.getDefaultFiles().size(); ++j) {
                            String tmpResourceName = vfsName + OpenCms.getDefaultFiles().get(j);
                            try {
                                resource = cms.readResource(tmpResourceName);
                                break;
                            }
                            catch (CmsException e1) {
                                continue;
                            }
                        }
                    }
                }
            }
            if (resource == null || !resource.isFile()) continue;
            I_CmsResourceLoader loader = OpenCms.getResourceManager().getLoader(resource);
            if (!loader.isStaticExportProcessable()) {
                if (pupRes.getState().isDeleted()) continue;
                resourcesToExport.add(exportData);
                continue;
            }
            templatesFound = true;
            cms.writeStaticExportPublishedResource(exportData.getRfsName(), 1, "", System.currentTimeMillis());
        }
        return templatesFound;
    }
}

