/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.staticexport;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import org.opencms.db.CmsPublishedResource;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;

public class CmsStaticExportExportRule {
    private String m_description;
    private List m_exportResources;
    private List m_modifiedResources;
    private String m_name;

    public CmsStaticExportExportRule(String name, String description) {
        this.m_name = name;
        this.m_description = description;
        this.m_exportResources = new ArrayList();
        this.m_modifiedResources = new ArrayList();
    }

    public CmsStaticExportExportRule(String name, String description, List modifiedResources, List exportResourcePatterns) {
        this(name, description);
        this.m_modifiedResources.addAll(modifiedResources);
        this.m_exportResources.addAll(exportResourcePatterns);
    }

    public void addExportResourcePattern(String exportResource) {
        this.m_exportResources.add(exportResource);
    }

    public void addModifiedResource(String modifiedRegex) {
        this.m_modifiedResources.add(Pattern.compile(modifiedRegex));
    }

    public String getDescription() {
        return this.m_description;
    }

    public List getExportResourcePatterns() {
        return Collections.unmodifiableList(this.m_exportResources);
    }

    public Set getExportResources(CmsObject cms) throws CmsException {
        HashSet<CmsPublishedResource> resources = new HashSet<CmsPublishedResource>(128);
        Iterator itExpRes = this.m_exportResources.iterator();
        while (itExpRes.hasNext()) {
            String exportRes = (String)itExpRes.next();
            if (!cms.existsResource(exportRes)) continue;
            List vfsResources = cms.readResources(exportRes, CmsResourceFilter.ALL.addExcludeFlags(512));
            Iterator itRes = vfsResources.iterator();
            while (itRes.hasNext()) {
                CmsResource vfsResource = (CmsResource)itRes.next();
                CmsPublishedResource resource = new CmsPublishedResource(vfsResource);
                resources.add(resource);
            }
        }
        return resources;
    }

    public List getModifiedResources() {
        return Collections.unmodifiableList(this.m_modifiedResources);
    }

    public String getName() {
        return this.m_name;
    }

    public Set getRelatedResources(CmsObject cms, CmsPublishedResource publishedResource) throws CmsException {
        if (this.match(publishedResource.getRootPath())) {
            return this.getExportResources(cms);
        }
        return null;
    }

    public boolean match(String vfsName) {
        for (int j = 0; j < this.m_modifiedResources.size(); ++j) {
            Pattern pattern = (Pattern)this.m_modifiedResources.get(j);
            if (!pattern.matcher(vfsName).matches()) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer(this.getClass().getName());
        ret.append(":[");
        ret.append("name: ").append(this.m_name).append("; ");
        ret.append("description: ").append(this.m_description).append("; ");
        ret.append("modified patterns: ").append(this.m_modifiedResources).append("; ");
        ret.append("export resources: ").append(this.m_exportResources).append("; ");
        return ret.append("]").toString();
    }
}

