/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.synchronize;

import java.io.File;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.synchronize.CmsSynchronizeException;
import org.opencms.synchronize.Messages;
import org.opencms.util.CmsStringUtil;

public class CmsSynchronizeSettings
implements Serializable {
    private static final long serialVersionUID = 3713893787290111758L;
    private String m_destinationPathInRfs;
    private boolean m_enabled;
    private List m_sourceListInVfs = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkValues(CmsObject cms) throws CmsException {
        if (this.isEnabled() && this.m_destinationPathInRfs == null) {
            throw new CmsSynchronizeException(Messages.get().container("ERR_NO_RFS_DESTINATION_0"));
        }
        if (this.isEnabled() && (this.m_sourceListInVfs == null || this.m_sourceListInVfs.size() == 0)) {
            throw new CmsSynchronizeException(Messages.get().container("ERR_NO_VFS_SOURCE_0"));
        }
        Iterator i = this.m_sourceListInVfs.iterator();
        String currentSite = cms.getRequestContext().getSiteRoot();
        cms.getRequestContext().setSiteRoot("");
        try {
            while (i.hasNext()) {
                cms.readResource((String)i.next());
            }
        }
        finally {
            cms.getRequestContext().setSiteRoot(currentSite);
        }
    }

    public String getDestinationPathInRfs() {
        return this.m_destinationPathInRfs;
    }

    public List getSourceListInVfs() {
        return this.m_sourceListInVfs;
    }

    public boolean isEnabled() {
        return this.m_enabled;
    }

    public boolean isSyncEnabled() {
        return this.isEnabled() && this.m_sourceListInVfs != null && this.m_destinationPathInRfs != null;
    }

    public void setDestinationPathInRfs(String destinationPathInRfs) {
        String destination = CmsStringUtil.isEmptyOrWhitespaceOnly(destinationPathInRfs) ? null : destinationPathInRfs.trim();
        if (destination != null) {
            File destinationFolder = new File(destination);
            if (!destinationFolder.exists() || !destinationFolder.isDirectory()) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_RFS_DESTINATION_NOT_THERE_1", destination));
            }
            if (!destinationFolder.canWrite()) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_RFS_DESTINATION_NO_WRITE_1", destination));
            }
            destination = destinationFolder.getAbsolutePath();
            if (destination.endsWith(File.separator)) {
                destination = destination.substring(0, destination.length() - 1);
            }
        }
        this.m_destinationPathInRfs = destination;
    }

    public void setEnabled(boolean enabled) {
        this.m_enabled = enabled;
    }

    public void setSourceListInVfs(List sourceListInVfs) {
        this.m_sourceListInVfs = sourceListInVfs == null ? new ArrayList() : this.optimizeSourceList(sourceListInVfs);
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        result.append(this.getClass().getName());
        result.append(", enabled: ");
        result.append(this.m_enabled);
        result.append(", RFS destination path: ");
        result.append(this.m_destinationPathInRfs);
        result.append(", VFS source path list: ");
        if (this.m_sourceListInVfs == null) {
            result.append(this.m_sourceListInVfs);
        } else {
            Iterator i = this.m_sourceListInVfs.iterator();
            while (i.hasNext()) {
                String path = (String)i.next();
                result.append(path);
                if (!i.hasNext()) continue;
                result.append(", ");
            }
        }
        result.append("]");
        return result.toString();
    }

    protected List optimizeSourceList(List sourceListInVfs) {
        ArrayList input = new ArrayList(sourceListInVfs);
        Collections.sort(input);
        ArrayList<String> result = new ArrayList<String>();
        Iterator i = input.iterator();
        while (i.hasNext()) {
            String sourceInVfs = (String)i.next();
            if (CmsStringUtil.isEmpty(sourceInVfs)) continue;
            boolean found = false;
            for (int j = result.size() - 1; j >= 0; --j) {
                String check = (String)result.get(j);
                if (!sourceInVfs.startsWith(check)) continue;
                found = true;
                break;
            }
            if (found) continue;
            result.add(sourceInVfs);
        }
        return result;
    }
}

