/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.Messages;
import org.w3c.tidy.Tidy;

public class CmsHtmlConverter {
    public static final String PARAM_DISABLED = CmsStringUtil.FALSE;
    public static final String PARAM_ENABLED = CmsStringUtil.TRUE;
    public static final String PARAM_WORD = "cleanup";
    public static final String PARAM_XHTML = "xhtml";
    private static final Log LOG = CmsLog.getLog(CmsHtmlConverter.class);
    String[] m_cleanupPatterns = new String[]{"<o:p>.*(\\r\\n)*.*</o:p>", "<o:p>.*(\\r\\n)*.*</O:p>", "<\\?xml:.*(\\r\\n).*/>", "<\\?xml:.*(\\r\\n).*(\\r\\n).*/\\?>", "<\\?xml:.*(\\r\\n).*(\\r\\n).*/>", "<\\?xml:(.*(\\r\\n)).*/\\?>", "<o:SmartTagType.*(\\r\\n)*.*/>", "<o:smarttagtype.*(\\r\\n)*.*/>"};
    Pattern[] m_clearStyle;
    String m_encoding;
    String[] m_replacePatterns = new String[]{"&#160;", "(\\r\\n){2,}", "\u2013", "(\\n){2,}", "\\(\\r\\n<", "\\(\\n<", "\\(\\r\\n(\\ ){1,}<", "\\(\\n(\\ ){1,}<", "\\r\\n<span", "\\n<span"};
    Pattern[] m_replaceStyle;
    String[] m_replaceValues = new String[]{"&nbsp;", "", "&ndash;", "", "(<", "(<", "(<", "(<", "<span", "<span"};
    Tidy m_tidy;
    private int m_lineSeparatorLength;
    private boolean m_modeEnabled;
    private boolean m_modeWord;
    private boolean m_modeXhtml;

    public CmsHtmlConverter() {
        this.init("UTF-8", PARAM_ENABLED);
    }

    public CmsHtmlConverter(String encoding, String mode) {
        this.init(encoding, mode);
    }

    public static String getConversionSettings(CmsObject cms, CmsResource resource) {
        String contentConversion;
        try {
            String resourceName = cms.getSitePath(resource);
            CmsProperty contentConversionProperty = cms.readPropertyObject(resourceName, "content-conversion", true);
            contentConversion = contentConversionProperty.getValue(PARAM_DISABLED);
        }
        catch (CmsException e) {
            contentConversion = PARAM_DISABLED;
        }
        return contentConversion;
    }

    public static boolean isConversionEnabled(String conversionMode) {
        boolean value = true;
        if (conversionMode == null || conversionMode.indexOf(PARAM_DISABLED) != -1) {
            value = false;
        }
        return value;
    }

    public byte[] convertToByte(byte[] htmlInput) throws UnsupportedEncodingException {
        if (this.m_modeEnabled) {
            return this.convertToByte(new String(htmlInput, this.m_encoding));
        }
        return htmlInput;
    }

    public byte[] convertToByte(String htmlInput) throws UnsupportedEncodingException {
        return this.convertToString(htmlInput).getBytes(this.m_encoding);
    }

    public byte[] convertToByteSilent(byte[] htmlInput) {
        try {
            return this.convertToByte(htmlInput);
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_CONVERSION_BYTE_FAILED_0"), (Throwable)e);
            }
            return htmlInput;
        }
    }

    public byte[] convertToByteSilent(String htmlInput) {
        try {
            return this.convertToByte(htmlInput.getBytes(this.m_encoding));
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_CONVERSION_BYTE_FAILED_0"), (Throwable)e);
            }
            try {
                return htmlInput.getBytes(this.m_encoding);
            }
            catch (UnsupportedEncodingException e1) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_CONVERSION_BYTE_FAILED_0"), (Throwable)e1);
                }
                return htmlInput.getBytes();
            }
        }
    }

    public String convertToString(byte[] htmlInput) throws UnsupportedEncodingException {
        return this.convertToString(new String(htmlInput, this.m_encoding));
    }

    public String convertToString(String htmlInput) throws UnsupportedEncodingException {
        if (this.m_modeEnabled) {
            int max = this.m_modeWord ? 10 : 1;
            int count = 0;
            int oldSize = htmlInput.length();
            String workHtml = this.regExp(htmlInput);
            while (count < max) {
                ++count;
                if (this.m_modeWord) {
                    workHtml = this.adjustHtml(workHtml);
                }
                workHtml = this.parse(workHtml, this.m_encoding);
                if (this.m_modeWord) {
                    workHtml = workHtml.substring(0, workHtml.length() - this.m_lineSeparatorLength);
                }
                if (workHtml.length() == oldSize) {
                    workHtml = this.regExp(workHtml);
                    break;
                }
                oldSize = workHtml.length();
                workHtml = this.regExp(workHtml);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_PARSING_RUNS_2", this.getClass().getName(), new Integer(count)));
            }
            htmlInput = workHtml;
        }
        return htmlInput;
    }

    public String convertToStringSilent(byte[] htmlInput) {
        try {
            return this.convertToString(htmlInput);
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_CONVERSION_BYTE_FAILED_0"), (Throwable)e);
            }
            try {
                return new String(htmlInput, this.m_encoding);
            }
            catch (UnsupportedEncodingException e1) {
                if (LOG.isWarnEnabled()) {
                    LOG.warn((Object)Messages.get().getBundle().key("LOG_CONVERSION_BYTE_FAILED_0"), (Throwable)e1);
                }
                return new String(htmlInput);
            }
        }
    }

    public String convertToStringSilent(String htmlInput) {
        try {
            return this.convertToString(htmlInput);
        }
        catch (Exception e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_CONVERSION_BYTE_FAILED_0"), (Throwable)e);
            }
            return htmlInput;
        }
    }

    public String getEncoding() {
        return this.m_encoding;
    }

    private String adjustHtml(String htmlInput) {
        if (htmlInput.toLowerCase().indexOf("<html>") == -1 && htmlInput.toLowerCase().indexOf("</html>") == -1) {
            StringBuffer tmp = new StringBuffer();
            tmp.append("<html xmlns:o=\"\"><body>");
            tmp.append(htmlInput);
            tmp.append("</body></html>");
            htmlInput = tmp.toString();
        }
        return htmlInput;
    }

    private List extractModes(String mode) {
        ArrayList<String> extractedModes = new ArrayList<String>();
        if (mode != null) {
            StringTokenizer extract = new StringTokenizer(mode, ";");
            while (extract.hasMoreTokens()) {
                String tok = extract.nextToken();
                extractedModes.add(tok);
            }
        }
        return extractedModes;
    }

    private void init(String encoding, String mode) {
        List modes = this.extractModes(mode);
        if (modes.contains(PARAM_ENABLED)) {
            this.m_modeEnabled = true;
        }
        if (modes.contains(PARAM_XHTML)) {
            this.m_modeEnabled = true;
            this.m_modeXhtml = true;
        }
        if (modes.contains(PARAM_WORD)) {
            this.m_modeEnabled = true;
            this.m_modeWord = true;
        }
        this.m_encoding = encoding;
        this.m_lineSeparatorLength = System.getProperty("line.separator").length();
        if (this.m_modeEnabled) {
            int i;
            this.m_tidy = new Tidy();
            this.m_tidy.setXHTML(this.m_modeXhtml);
            this.m_tidy.setWord2000(this.m_modeWord);
            Properties additionalTags = new Properties();
            additionalTags.put("new-empty-tags", "o:smarttagtype");
            additionalTags.put("new-inline-tags", "o:smarttagtype");
            this.m_tidy.getConfiguration().addProps(additionalTags);
            this.m_tidy.setInputEncoding(encoding);
            this.m_tidy.setOutputEncoding(encoding);
            this.m_tidy.setTidyMark(false);
            this.m_tidy.setMakeClean(false);
            this.m_tidy.setNumEntities(true);
            this.m_tidy.setPrintBodyOnly(true);
            this.m_tidy.setForceOutput(true);
            this.m_tidy.setQuiet(true);
            this.m_tidy.setShowWarnings(false);
            this.m_tidy.setHideComments(false);
            this.m_tidy.setBreakBeforeBR(false);
            this.m_tidy.setWrapAttVals(false);
            this.m_tidy.setWraplen(100);
            this.m_tidy.setSpaces(0);
            if (this.m_modeWord) {
                this.m_clearStyle = new Pattern[this.m_cleanupPatterns.length];
                for (i = 0; i < this.m_cleanupPatterns.length; ++i) {
                    this.m_clearStyle[i] = Pattern.compile(this.m_cleanupPatterns[i]);
                }
            }
            this.m_replaceStyle = new Pattern[this.m_replacePatterns.length];
            for (i = 0; i < this.m_replacePatterns.length; ++i) {
                this.m_replaceStyle[i] = Pattern.compile(this.m_replacePatterns[i]);
            }
        }
    }

    private String parse(String htmlInput, String encoding) throws UnsupportedEncodingException {
        ByteArrayInputStream in = new ByteArrayInputStream(htmlInput.getBytes(encoding));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.m_tidy.parse((InputStream)in, (OutputStream)out);
        byte[] result = out.toByteArray();
        return new String(result, encoding);
    }

    private String regExp(String htmlInput) {
        int i;
        String parsedHtml = htmlInput.trim();
        if (this.m_modeWord) {
            for (i = 0; i < this.m_cleanupPatterns.length; ++i) {
                parsedHtml = this.m_clearStyle[i].matcher(parsedHtml).replaceAll("");
            }
        }
        for (i = 0; i < this.m_replacePatterns.length; ++i) {
            parsedHtml = this.m_replaceStyle[i].matcher(parsedHtml).replaceAll(this.m_replaceValues[i]);
        }
        return parsedHtml;
    }
}

