/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.collections.ExtendedProperties;
import org.opencms.util.CmsStringUtil;

public final class CmsPropertyUtils {
    private CmsPropertyUtils() {
    }

    public static ExtendedProperties loadProperties(InputStream stream) throws IOException {
        ExtendedProperties properties = new ExtendedProperties();
        properties.load(stream);
        CmsPropertyUtils.unescapeProperties(properties);
        return properties;
    }

    public static ExtendedProperties loadProperties(String file) throws IOException {
        FileInputStream input = null;
        ExtendedProperties properties = null;
        try {
            input = new FileInputStream(new File(file));
            properties = new ExtendedProperties();
            properties.load((InputStream)input);
            input.close();
        }
        catch (IOException e) {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw e;
        }
        CmsPropertyUtils.unescapeProperties(properties);
        return properties;
    }

    public static void unescapeProperties(ExtendedProperties properties) {
        Iterator i = properties.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            String key = (String)entry.getKey();
            Object obj = entry.getValue();
            String[] value = new String[]{};
            if (obj instanceof Vector) {
                value = ((Vector)obj).toArray(value);
            } else {
                String[] v = new String[]{(String)obj};
                value = v;
            }
            for (int j = 0; j < value.length; ++j) {
                value[j] = CmsStringUtil.substitute(value[j], "\\,", ",");
                value[j] = CmsStringUtil.substitute(value[j], "\\=", "=");
            }
            if (value.length > 1) {
                properties.put((Object)key, new Vector<String>(Arrays.asList(value)));
                continue;
            }
            properties.put((Object)key, (Object)value[0]);
        }
    }
}

