/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.CmsHtmlWidgetOption;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.widgets.Messages;
import org.opencms.workplace.galleries.A_CmsGallery;

public abstract class A_CmsHtmlWidget
extends A_CmsWidget {
    private CmsHtmlWidgetOption m_htmlWidgetOption;

    public A_CmsHtmlWidget() {
    }

    public A_CmsHtmlWidget(CmsHtmlWidgetOption configuration) {
        this.m_htmlWidgetOption = configuration;
    }

    public A_CmsHtmlWidget(String configuration) {
        super(configuration);
    }

    public String getConfiguration() {
        if (super.getConfiguration() != null) {
            return super.getConfiguration();
        }
        return CmsHtmlWidgetOption.createConfigurationString(this.getHtmlWidgetOption());
    }

    public CmsHtmlWidgetOption getHtmlWidgetOption() {
        return this.m_htmlWidgetOption;
    }

    public void setConfiguration(String configuration) {
        super.setConfiguration(configuration);
        this.m_htmlWidgetOption = new CmsHtmlWidgetOption(configuration);
    }

    public void setEditorValue(CmsObject cms, Map formParameters, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        String[] values = (String[])formParameters.get(param.getId());
        if (values != null && values.length > 0) {
            String val = CmsEncoder.decode(values[0], "UTF-8");
            param.setStringValue(cms, val);
        }
    }

    public void setHtmlWidgetOption(CmsHtmlWidgetOption htmlWidgetOption) {
        this.m_htmlWidgetOption = htmlWidgetOption;
    }

    protected String buildOpenCmsButtonRow(I_CmsWidgetDialog widgetDialog, String paramId) {
        StringBuffer result = new StringBuffer(2048);
        boolean buttonsActive = false;
        result.append(this.buildOpenCmsButtonRow(0, widgetDialog));
        if (this.getHtmlWidgetOption().showLinkDialog()) {
            result.append(widgetDialog.button("javascript:setActiveEditor('" + paramId + "');openLinkDialog('" + Messages.get().getBundle(widgetDialog.getLocale()).key("GUI_BUTTON_LINKTO_0") + "');", null, "link", "button.linkto", widgetDialog.getButtonStyle()));
            buttonsActive = true;
        }
        if (this.getHtmlWidgetOption().showAnchorDialog()) {
            result.append(widgetDialog.button("javascript:setActiveEditor('" + paramId + "');openAnchorDialog('" + Messages.get().getBundle(widgetDialog.getLocale()).key("ERR_EDITOR_MESSAGE_NOSELECTION_0") + "');", null, "anchor", "GUI_BUTTON_ANCHOR_0", widgetDialog.getButtonStyle()));
            buttonsActive = true;
        }
        Map galleryMap = OpenCms.getWorkplaceManager().getGalleries();
        ArrayList galleries = new ArrayList(galleryMap.values());
        Collections.sort(galleries);
        StringBuffer galleryResult = new StringBuffer(256);
        boolean showGallery = false;
        for (int k = 0; k < galleries.size(); ++k) {
            A_CmsGallery currGallery = (A_CmsGallery)galleries.get(k);
            String galleryType = currGallery.getResourceType().getTypeName();
            if (!this.getHtmlWidgetOption().showGalleryDialog(galleryType)) continue;
            galleryResult.append(widgetDialog.button("javascript:setActiveEditor('" + paramId + "');openGallery('" + galleryType + "');", null, galleryType, Messages.getButtonName(CmsStringUtil.substitute(galleryType, "gallery", "")), widgetDialog.getButtonStyle()));
            showGallery = true;
        }
        if (showGallery) {
            if (buttonsActive) {
                result.append(widgetDialog.buttonBarSeparator(5, 5));
            }
            result.append(galleryResult);
            buttonsActive = true;
        }
        if (!buttonsActive) {
            return "";
        }
        result.append(this.buildOpenCmsButtonRow(1, widgetDialog));
        return result.toString();
    }

    protected String buildOpenCmsButtonRow(int segment, I_CmsWidgetDialog widgetDialog) {
        StringBuffer result = new StringBuffer(256);
        if (segment == 0) {
            result.append(widgetDialog.buttonBarHorizontalLine());
            result.append(widgetDialog.buttonBar(0));
            result.append(widgetDialog.buttonBarStartTab(0, 0));
        } else {
            result.append(widgetDialog.buttonBar(1));
            result.append(widgetDialog.buttonBarHorizontalLine());
        }
        return result.toString();
    }
}

