/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;

public abstract class A_CmsSelectWidget
extends A_CmsWidget {
    private List m_selectOptions;

    public A_CmsSelectWidget() {
    }

    public A_CmsSelectWidget(List configuration) {
        this.m_selectOptions = configuration;
    }

    public A_CmsSelectWidget(String configuration) {
        super(configuration);
    }

    public void addSelectOption(CmsSelectWidgetOption option) {
        if (this.m_selectOptions == null) {
            this.m_selectOptions = new ArrayList();
        }
        this.m_selectOptions.add(option);
    }

    public String getConfiguration() {
        if (super.getConfiguration() != null) {
            return super.getConfiguration();
        }
        return CmsSelectWidgetOption.createConfigurationString(this.m_selectOptions);
    }

    protected String getSelectedValue(CmsObject cms, I_CmsWidgetParameter param) {
        CmsSelectWidgetOption option;
        String paramValue = param.getStringValue(cms);
        if (CmsStringUtil.isEmpty(paramValue) && (option = CmsSelectWidgetOption.getDefaultOption(this.m_selectOptions)) != null) {
            paramValue = option.getValue();
        }
        return paramValue;
    }

    protected List getSelectedValues(CmsObject cms, I_CmsWidgetParameter param) {
        ArrayList<String> values = new ArrayList<String>();
        String paramValue = param.getStringValue(cms);
        if (CmsStringUtil.isEmpty(paramValue)) {
            Iterator itOptions = CmsSelectWidgetOption.getDefaultOptions(this.m_selectOptions).iterator();
            while (itOptions.hasNext()) {
                CmsSelectWidgetOption option = (CmsSelectWidgetOption)itOptions.next();
                values.add(option.getValue());
            }
        } else {
            values.addAll(CmsStringUtil.splitAsList(paramValue, ',', true));
        }
        return values;
    }

    protected List getSelectOptions() {
        return this.m_selectOptions;
    }

    protected List parseSelectOptions(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        if (this.m_selectOptions == null) {
            String configuration = this.getConfiguration();
            if (configuration == null) {
                configuration = param.getDefault(cms);
            }
            configuration = CmsMacroResolver.resolveMacros(configuration, cms, widgetDialog.getMessages());
            this.m_selectOptions = CmsSelectWidgetOption.parseOptions(configuration);
            if (this.m_selectOptions == Collections.EMPTY_LIST) {
                this.m_selectOptions = new ArrayList();
            }
        }
        return this.m_selectOptions;
    }

    protected void setSelectOptions(List selectOptions) {
        this.m_selectOptions = new ArrayList();
        this.m_selectOptions.addAll(selectOptions);
    }
}

