/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsFolder;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.CmsCategoryXmlContentHandler;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.widgets.Messages;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsCategoryWidget
extends A_CmsWidget {
    public static final String CONFIGURATION_CATEGORY = "category";
    public static final String CONFIGURATION_ONLYLEAFS = "onlyleafs";
    public static final String CONFIGURATION_PROPERTY = "property";
    private static final Log LOG = CmsLog.getLog(CmsCategoryWidget.class);
    private String m_category;
    private String m_onlyLeafs;
    private String m_property;

    public CmsCategoryWidget() {
    }

    public CmsCategoryWidget(String configuration) {
        super(configuration);
    }

    public String getConfiguration() {
        StringBuffer result = new StringBuffer(8);
        if (this.m_category != null) {
            if (result.length() > 0) {
                result.append("|");
            }
            result.append(CONFIGURATION_CATEGORY);
            result.append("=");
            result.append(this.m_category);
        }
        if (this.m_onlyLeafs != null) {
            if (result.length() > 0) {
                result.append("|");
            }
            result.append(CONFIGURATION_ONLYLEAFS);
            result.append("=");
            result.append(this.m_onlyLeafs);
        }
        if (this.m_property != null) {
            if (result.length() > 0) {
                result.append("|");
            }
            result.append(CONFIGURATION_PROPERTY);
            result.append("=");
            result.append(this.m_property);
        }
        return result.toString();
    }

    public String getDialogIncludes(CmsObject cms, I_CmsWidgetDialog widgetDialog) {
        StringBuffer result = new StringBuffer(16);
        result.append("<script type=\"text/javascript\" src=\"");
        result.append(CmsWorkplace.getSkinUri());
        result.append("components/widgets/category.js\"></script>\n");
        return result.toString();
    }

    public String getDialogWidget(CmsObject cms, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        CmsResource selected = null;
        try {
            String name = param.getStringValue(cms);
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(name)) {
                selected = cms.readResource(name);
            }
        }
        catch (CmsException e1) {
            // empty catch block
        }
        StringBuffer result = new StringBuffer(16);
        ArrayList levels = new ArrayList();
        try {
            result.append("<script language='javascript'>\n");
            CmsFolder folder = cms.readFolder("/system/categories/" + this.getStartingCategory(cms, param));
            List subresources = cms.readResources(cms.getSitePath(folder), CmsResourceFilter.DEFAULT.addRequireFolder(), true);
            int baseLevel = CmsResource.getPathLevel(folder.getRootPath());
            List<CmsSelectWidgetOption> options = new ArrayList<CmsSelectWidgetOption>();
            String jsId = CmsStringUtil.substitute(param.getId(), ".", "");
            int level = baseLevel + 1;
            while (!subresources.isEmpty()) {
                if (level != baseLevel + 1) {
                    result.append("var cat" + (level - baseLevel) + jsId + " = new Array(\n");
                }
                Iterator itSubs = subresources.iterator();
                while (itSubs.hasNext()) {
                    CmsResource res = (CmsResource)itSubs.next();
                    if (CmsResource.getPathLevel(res.getRootPath()) != level) continue;
                    if (level != baseLevel + 1) {
                        result.append("new Array('" + res.getStructureId() + "', '" + cms.readResource(CmsResource.getParentFolder(res.getRootPath())).getStructureId() + "', '" + cms.readPropertyObject(res, "Title", false).getValue(CmsResource.getName(res.getRootPath())) + "'),\n");
                    }
                    if (level == baseLevel + 1 || selected != null && selected.getRootPath().startsWith(CmsResource.getParentFolder(res.getRootPath()))) {
                        if (levels.size() < level - baseLevel) {
                            options = new ArrayList();
                            levels.add(options);
                            options.add(new CmsSelectWidgetOption("", true, Messages.get().getBundle(widgetDialog.getLocale()).key("GUI_CATEGORY_SELECT_0")));
                        }
                        options.add(new CmsSelectWidgetOption(res.getStructureId().toString(), false, cms.readPropertyObject(res, "Title", false).getValue(CmsResource.getName(res.getRootPath()))));
                    }
                    itSubs.remove();
                }
                if (level != baseLevel + 1) {
                    result.deleteCharAt(result.length() - 1);
                    result.deleteCharAt(result.length() - 1);
                    result.append(");\n");
                }
                ++level;
            }
            result.append("</script>\n");
            result.append("<td class=\"xmlTd\" >");
            result.append("<input id='" + param.getId() + "' name='" + param.getId() + "' type='hidden' value='" + (selected != null ? selected.getStructureId().toString() : "") + "'>\n");
            for (int i = 1; i < level - baseLevel; ++i) {
                result.append("<span id='" + param.getId() + "cat" + i + "IdDisplay'");
                if (levels.size() >= i) {
                    options = (List)levels.get(i - 1);
                } else {
                    result.append(" style='display:none'");
                    options = new ArrayList();
                    options.add(new CmsSelectWidgetOption("", true, Messages.get().getBundle(widgetDialog.getLocale()).key("GUI_CATEGORY_SELECT_0")));
                }
                result.append(">");
                result.append(this.buildSelectBox(param.getId(), i, options, selected != null ? cms.readResource(CmsResource.getPathPart(selected.getRootPath(), i + baseLevel)).getStructureId().toString() : "", param.hasError(), i == level - baseLevel - 1));
                result.append("</span>&nbsp;");
            }
            result.append("</td>");
        }
        catch (CmsException e) {
            result.append(e.getLocalizedMessage());
        }
        return result.toString();
    }

    public boolean isOnlyLeafs() {
        return Boolean.valueOf(this.m_onlyLeafs);
    }

    public I_CmsWidget newInstance() {
        return new CmsCategoryWidget(this.getConfiguration());
    }

    public void setConfiguration(String configuration) {
        this.m_category = "";
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(configuration)) {
            int propertyIndex;
            int onlyLeafsIndex;
            int categoryIndex = configuration.indexOf(CONFIGURATION_CATEGORY);
            if (categoryIndex != -1) {
                String category = configuration.substring(CONFIGURATION_CATEGORY.length() + 1);
                if (category.indexOf(124) != -1) {
                    category = category.substring(0, category.indexOf(124));
                }
                this.m_category = category;
            }
            if ((onlyLeafsIndex = configuration.indexOf(CONFIGURATION_ONLYLEAFS)) != -1) {
                String onlyLeafs = configuration.substring(onlyLeafsIndex + CONFIGURATION_ONLYLEAFS.length() + 1);
                if (onlyLeafs.indexOf(124) != -1) {
                    onlyLeafs = onlyLeafs.substring(0, onlyLeafs.indexOf(124));
                }
                this.m_onlyLeafs = onlyLeafs;
            }
            if ((propertyIndex = configuration.indexOf(CONFIGURATION_PROPERTY)) != -1) {
                String property = configuration.substring(propertyIndex + CONFIGURATION_PROPERTY.length() + 1);
                if (property.indexOf(124) != -1) {
                    property = property.substring(0, property.indexOf(124));
                }
                this.m_property = property;
            }
        }
        super.setConfiguration(configuration);
    }

    public void setEditorValue(CmsObject cms, Map formParameters, I_CmsWidgetDialog widgetDialog, I_CmsWidgetParameter param) {
        super.setEditorValue(cms, formParameters, widgetDialog, param);
        String id = param.getStringValue(cms);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(id)) {
            try {
                CmsResource category = cms.readResource(new CmsUUID(id));
                param.setStringValue(cms, category.getRootPath());
            }
            catch (Exception e) {
                param.setStringValue(cms, "");
            }
        }
    }

    protected String getStartingCategory(CmsObject cms, I_CmsWidgetParameter param) {
        block7: {
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_category) && CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_property)) {
                return "";
            }
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_property)) {
                if (this.m_category.startsWith("/")) {
                    return this.m_category.substring(1);
                }
                return this.m_category;
            }
            I_CmsXmlContentValue value = (I_CmsXmlContentValue)((Object)param);
            CmsFile file = value.getDocument().getFile();
            String resourceName = cms.getSitePath(file);
            if (CmsWorkplace.isTemporaryFile(file)) {
                StringBuffer result = new StringBuffer(resourceName.length() + 2);
                result.append(CmsResource.getFolderPath(resourceName));
                result.append(CmsResource.getName(resourceName).substring(1));
                resourceName = result.toString();
            }
            try {
                List listsib = cms.readSiblings(resourceName, CmsResourceFilter.ALL);
                for (int i = 0; i < listsib.size(); ++i) {
                    CmsResource resource = (CmsResource)listsib.get(i);
                    Locale locale = CmsCategoryXmlContentHandler.getDefaultLocale(cms, cms.getSitePath(resource));
                    if (!locale.equals(value.getLocale())) continue;
                    return cms.readPropertyObject(resource, this.m_property, true).getValue("");
                }
            }
            catch (CmsException ex) {
                if (!LOG.isErrorEnabled()) break block7;
                LOG.error((Object)ex.getLocalizedMessage(), (Throwable)ex);
            }
        }
        return "";
    }

    private String buildSelectBox(String baseId, int level, List options, String selected, boolean hasError, boolean last) {
        StringBuffer result = new StringBuffer(16);
        String id = baseId + "cat" + level + "Id";
        String childId = baseId + "cat" + (level + 1) + "Id";
        result.append("<select class=\"xmlInput");
        if (hasError) {
            result.append(" xmlInputError");
        }
        result.append("\" name=\"");
        result.append(id);
        result.append("\" id=\"");
        result.append(id);
        result.append("\" onchange=\"");
        if (last) {
            result.append("setWidgetValue('" + baseId + "');");
        } else {
            String jsId = CmsStringUtil.substitute(baseId, ".", "");
            result.append("setChildListBox(this, getElemById('" + childId + "'), cat" + (level + 1) + jsId + ");");
        }
        result.append("\">");
        Iterator i = options.iterator();
        while (i.hasNext()) {
            CmsSelectWidgetOption option = (CmsSelectWidgetOption)i.next();
            result.append("<option value=\"");
            result.append(option.getValue());
            result.append("\"");
            if (selected != null && selected.equals(option.getValue())) {
                result.append(" selected=\"selected\"");
            }
            result.append(">");
            result.append(option.getOption());
            result.append("</option>");
        }
        result.append("</select>");
        return result.toString();
    }
}

