/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.site.CmsSite;
import org.opencms.synchronize.CmsSynchronizeSettings;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.CmsWorkplaceView;

public class CmsFrameset
extends CmsWorkplace {
    public static final String JSP_WORKPLACE_URI = "/system/workplace/views/workplace.jsp";
    public static final String PARAM_WP_FRAME = "wpFrame";
    public static final String PARAM_WP_START = "wpStart";
    public static final String PARAM_WP_VIEW = "wpView";
    private static final String[] FRAMES = new String[]{"top", "head", "body", "foot"};
    public static final List FRAMES_LIST = Collections.unmodifiableList(Arrays.asList(FRAMES));
    private static final Log LOG = CmsLog.getLog(CmsFrameset.class);
    private boolean m_reloadRequired;

    public CmsFrameset(CmsJspActionElement jsp) {
        super(jsp);
    }

    public String getBroadcastMessage() {
        StringBuffer result = new StringBuffer(512);
        String message = this.getBroadcastMessageString();
        if (CmsStringUtil.isNotEmpty(message)) {
            result.append("\n<script type=\"text/javascript\">\n<!--\n");
            result.append("function showMessage() {\n");
            result.append("\talert(decodeURIComponent(\"");
            result.append(CmsEncoder.escapeWBlanks(message, "UTF-8"));
            result.append("\"));\n}\n");
            result.append("setTimeout('showMessage();', 2000);");
            result.append("\n//-->\n</script>");
        }
        return result.toString();
    }

    public String getLoginAddress() {
        return this.getCms().getRequestContext().getRemoteAddress();
    }

    public String getLoginTime() {
        return this.getMessages().getDateTime(this.getSettings().getUser().getLastlogin());
    }

    public String getPreferencesButton() {
        int buttonStyle = this.getSettings().getUserSettings().getWorkplaceButtonStyle();
        if (!this.getCms().getRequestContext().currentUser().isManaged()) {
            return this.button("../commons/preferences.jsp", "body", "preferences.png", "GUI_BUTTON_PREFERENCES_0", buttonStyle);
        }
        return this.button(null, null, "preferences_in.png", "GUI_BUTTON_PREFERENCES_0", buttonStyle);
    }

    public String getProjectSelect(String htmlAttributes, String htmlWidth) {
        List allProjects;
        try {
            String ouFqn = "";
            CmsUserSettings settings = new CmsUserSettings(this.getCms());
            if (!settings.getListAllProjects()) {
                ouFqn = this.getCms().getRequestContext().currentUser().getOuFqn();
            }
            allProjects = OpenCms.getOrgUnitManager().getAllAccessibleProjects(this.getCms(), ouFqn, settings.getListAllProjects());
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            allProjects = Collections.EMPTY_LIST;
        }
        boolean singleOu = true;
        String ouFqn = null;
        Iterator itProjects = allProjects.iterator();
        while (itProjects.hasNext()) {
            CmsProject prj = (CmsProject)itProjects.next();
            if (prj.isOnlineProject()) continue;
            if (ouFqn == null) {
                ouFqn = prj.getOuFqn();
            }
            if (ouFqn.equals(prj.getOuFqn())) continue;
            singleOu = false;
            break;
        }
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        int selectedIndex = -1;
        int ouDefaultProjIndex = -1;
        CmsOrganizationalUnit ou = null;
        try {
            ou = OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), this.getCms().getRequestContext().getOuFqn());
        }
        catch (CmsException e) {
            // empty catch block
        }
        int n = allProjects.size();
        for (int i = 0; i < n; ++i) {
            CmsProject project = (CmsProject)allProjects.get(i);
            String projectId = project.getUuid().toString();
            String projectName = project.getSimpleName();
            if (!singleOu && !project.isOnlineProject()) {
                try {
                    projectName = projectName + " - " + OpenCms.getOrgUnitManager().readOrganizationalUnit(this.getCms(), project.getOuFqn()).getDisplayName(this.getLocale());
                }
                catch (CmsException e) {
                    projectName = projectName + " - " + project.getOuFqn();
                }
            }
            values.add(projectId);
            options.add(projectName);
            if (project.getUuid().equals(this.getSettings().getProject())) {
                selectedIndex = i;
            }
            if (ou == null || !project.getUuid().equals(ou.getProjectId())) continue;
            ouDefaultProjIndex = i;
        }
        if (selectedIndex == -1) {
            selectedIndex = ouDefaultProjIndex == -1 ? 0 : ouDefaultProjIndex;
        }
        if (CmsStringUtil.isNotEmpty(htmlWidth)) {
            StringBuffer buf = new StringBuffer(htmlAttributes.length() + htmlWidth.length() + 2);
            buf.append(htmlAttributes);
            buf.append(" ");
            buf.append(htmlWidth);
            htmlAttributes = buf.toString();
        }
        return this.buildSelect(htmlAttributes, options, values, selectedIndex);
    }

    public String getPublishButton() {
        String publishButton = OpenCms.getWorkplaceManager().getDefaultUserSettings().getPublishButtonAppearance();
        if ("never".equals(publishButton)) {
            return "";
        }
        int buttonStyle = this.getSettings().getUserSettings().getWorkplaceButtonStyle();
        if ("auto".equals(publishButton)) {
            if (this.getCms().isManagerOfProject()) {
                return this.button("../commons/publishproject.jsp", "body", "publish.png", "GUI_BUTTON_PUBLISH_0", buttonStyle);
            }
            return "";
        }
        if (this.getCms().isManagerOfProject()) {
            return this.button("../commons/publishproject.jsp", "body", "publish.png", "GUI_BUTTON_PUBLISH_0", buttonStyle);
        }
        return this.button(null, null, "publish_in.png", "GUI_BUTTON_PUBLISH_0", buttonStyle);
    }

    public String getPublishQueueButton() {
        int buttonStyle = this.getSettings().getUserSettings().getWorkplaceButtonStyle();
        StringBuffer js = new StringBuffer(128);
        js.append("javascript:if (parent.body.admin_content && parent.body.admin_menu) {");
        js.append("parent.body.location.href = '");
        js.append(this.getJsp().link("/system/workplace/views/admin/admin-fs.jsp?root=admin&path=/publishqueue"));
        js.append("';");
        js.append("} else {");
        js.append("parent.body.explorer_body.explorer_files.location.href = '");
        js.append(this.getJsp().link("/system/workplace/views/admin/admin-fs.jsp?root=explorer&path=/publishqueue&menu=no"));
        js.append("';");
        js.append("};");
        return this.button(js.toString(), null, "publish_queue.png", "GUI_BUTTON_PUBLISHQUEUE_0", buttonStyle);
    }

    public String getSiteSelect(String htmlAttributes) {
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        int selectedIndex = 0;
        List sites = OpenCms.getSiteManager().getAvailableSites(this.getCms(), true);
        Iterator i = sites.iterator();
        int pos = 0;
        while (i.hasNext()) {
            CmsSite site = (CmsSite)i.next();
            values.add(site.getSiteRoot());
            options.add(site.getTitle());
            if (site.getSiteRoot().equals(this.getSettings().getSite())) {
                selectedIndex = pos;
            }
            ++pos;
        }
        return this.buildSelect(htmlAttributes, options, values, selectedIndex);
    }

    public String getStartupUri() {
        String result = this.getSettings().getViewStartup();
        if (result == null) {
            result = this.getSettings().getViewUri();
        } else {
            this.getSettings().setViewStartup(null);
        }
        if (this.getJsp().getRequest().getParameterMap().size() > 0) {
            Set params = this.getJsp().getRequest().getParameterMap().entrySet();
            Iterator i = params.iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                result = CmsRequestUtil.appendParameter(result, (String)entry.getKey(), ((String[])entry.getValue())[0]);
            }
        }
        return CmsRequestUtil.appendParameter(result, PARAM_WP_FRAME, FRAMES[2]);
    }

    public String getViewSelect(String htmlAttributes) {
        int pos;
        ArrayList<String> options = new ArrayList<String>();
        ArrayList<String> values = new ArrayList<String>();
        int selectedIndex = 0;
        Iterator i = OpenCms.getWorkplaceManager().getViews().iterator();
        int count = -1;
        String currentView = this.getSettings().getViewUri();
        if (CmsStringUtil.isNotEmpty(currentView) && (pos = currentView.indexOf(63)) >= 0) {
            currentView = currentView.substring(0, pos);
        }
        while (i.hasNext()) {
            CmsWorkplaceView view = (CmsWorkplaceView)i.next();
            if (!this.getCms().existsResource(view.getUri(), CmsResourceFilter.ONLY_VISIBLE_NO_DELETED)) continue;
            ++count;
            String loopLink = this.getJsp().link(view.getUri());
            String localizedKey = this.resolveMacros(view.getKey());
            options.add(localizedKey);
            values.add(loopLink);
            if (!loopLink.equals(currentView)) continue;
            selectedIndex = count;
        }
        return this.buildSelect(htmlAttributes, options, values, selectedIndex);
    }

    public String getWorkplaceReloadUri() {
        return this.getJsp().link(JSP_WORKPLACE_URI);
    }

    public boolean isReloadRequired() {
        return this.m_reloadRequired;
    }

    public boolean isSyncEnabled() {
        CmsSynchronizeSettings syncSettings = this.getSettings().getUserSettings().getSynchronizeSettings();
        return syncSettings != null && syncSettings.isSyncEnabled();
    }

    public boolean showSiteSelector() {
        if (this.getSettings().getUserSettings().getRestrictExplorerView()) {
            return false;
        }
        int siteCount = OpenCms.getSiteManager().getAvailableSites(this.getCms(), true).size();
        return siteCount > 1;
    }

    protected void initTimeWarp(CmsUserSettings settings, HttpSession session) {
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        String view;
        String startup;
        String frame = CmsRequestUtil.getNotEmptyDecodedParameter(request, PARAM_WP_FRAME);
        if (frame == null || FRAMES_LIST.indexOf(frame) < 0) {
            frame = FRAMES[0];
        }
        if (FRAMES[0].equals(frame)) {
            this.topFrameReload(settings);
        }
        if ((startup = CmsRequestUtil.getNotEmptyDecodedParameter(request, PARAM_WP_START)) != null) {
            this.m_reloadRequired = true;
            settings.setViewStartup(startup);
        }
        if ((view = request.getParameter(PARAM_WP_VIEW)) != null) {
            this.m_reloadRequired = true;
            settings.setViewUri(view);
            settings.getFrameUris().put("body", view);
        }
        this.m_reloadRequired = this.initSettings(settings, request) || this.m_reloadRequired;
    }

    protected void topFrameReload(CmsWorkplaceSettings settings) {
        CmsFrameset.initUserSettings(this.getCms(), settings, true);
        settings.setListObject(null);
    }
}

