/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace;

import java.util.HashMap;
import java.util.Map;
import org.opencms.db.CmsPublishList;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsUser;
import org.opencms.file.collectors.I_CmsResourceCollector;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.tools.CmsToolUserData;

public class CmsWorkplaceSettings {
    private I_CmsResourceCollector m_collector;
    private String m_currentSite;
    private Object m_dialogObject;
    private CmsMessageContainer m_errorMessage;
    private String m_explorerFlaturl;
    private String m_explorerMode;
    private int m_explorerPage = 1;
    private String m_explorerProjectFilter;
    private CmsUUID m_explorerProjectId;
    private Map m_explorerResource = new HashMap();
    private Map m_frameUris;
    private String m_galleryType;
    private Map m_lastUsedGalleries;
    private Object m_listObject;
    private String m_permissionDetailView;
    private CmsUUID m_project;
    private CmsPublishList m_publishList;
    private CmsToolUserData m_toolUserData;
    private Map m_treeSite;
    private Map m_treeType = new HashMap();
    private CmsUser m_user;
    private CmsUserSettings m_userSettings;
    private String m_viewStartup;
    private String m_viewUri;

    CmsWorkplaceSettings() {
        this.m_treeSite = new HashMap();
        this.m_frameUris = new HashMap();
        this.m_lastUsedGalleries = new HashMap();
        this.m_currentSite = OpenCms.getSiteManager().getDefaultSite().getSiteRoot();
    }

    public I_CmsResourceCollector getCollector() {
        return this.m_collector;
    }

    public Object getDialogObject() {
        return this.m_dialogObject;
    }

    public CmsMessageContainer getErrorMessage() {
        return this.m_errorMessage;
    }

    public String getExplorerFlaturl() {
        return this.m_explorerFlaturl;
    }

    public String getExplorerMode() {
        return this.m_explorerMode;
    }

    public int getExplorerPage() {
        return this.m_explorerPage;
    }

    public String getExplorerProjectFilter() {
        return this.m_explorerProjectFilter;
    }

    public CmsUUID getExplorerProjectId() {
        return this.m_explorerProjectId;
    }

    public String getExplorerResource() {
        String resource;
        String mode = this.getExplorerMode();
        if (mode == null) {
            mode = "explorerview";
        }
        if ("explorerview".equals(mode)) {
            mode = mode + "_" + this.getSite() + "/";
        }
        if ((resource = (String)this.m_explorerResource.get(mode)) == null) {
            resource = "/";
        }
        return resource;
    }

    public Map getFrameUris() {
        return this.m_frameUris;
    }

    public String getGalleryType() {
        return this.m_galleryType;
    }

    public String getLastUsedGallery(int galleryTypeId) {
        return (String)this.m_lastUsedGalleries.get(String.valueOf(galleryTypeId));
    }

    public Object getListObject() {
        return this.m_listObject;
    }

    public String getPermissionDetailView() {
        return this.m_permissionDetailView;
    }

    public CmsUUID getProject() {
        return this.m_project;
    }

    public CmsPublishList getPublishList() {
        return this.m_publishList;
    }

    public String getSite() {
        return this.m_currentSite;
    }

    public CmsToolUserData getToolUserData() {
        return this.m_toolUserData;
    }

    public String getTreeResource(String type) {
        String result = (String)this.m_treeType.get(type);
        if (result == null) {
            result = "/";
        }
        return result;
    }

    public String getTreeSite(String type) {
        String result = (String)this.m_treeSite.get(type);
        return result;
    }

    public CmsUser getUser() {
        return this.m_user;
    }

    public CmsUserSettings getUserSettings() {
        return this.m_userSettings;
    }

    public String getViewStartup() {
        return this.m_viewStartup;
    }

    public String getViewUri() {
        return this.m_viewUri;
    }

    public boolean isViewExplorer() {
        return this.getViewUri().endsWith("/system/workplace/views/explorer/explorer_files.jsp");
    }

    public void setCollector(I_CmsResourceCollector collector) {
        this.m_collector = collector;
    }

    public void setDialogObject(Object dialogObject) {
        this.m_dialogObject = dialogObject;
    }

    public void setErrorMessage(CmsMessageContainer errorMessage) {
        this.m_errorMessage = errorMessage;
    }

    public void setExplorerFlaturl(String value) {
        this.m_explorerFlaturl = value;
    }

    public void setExplorerMode(String value) {
        this.m_explorerMode = value;
    }

    public void setExplorerPage(int page) {
        this.m_explorerPage = page;
    }

    public void setExplorerProjectFilter(String value) {
        this.m_explorerProjectFilter = value;
    }

    public void setExplorerProjectId(CmsUUID value) {
        this.m_explorerProjectId = value;
    }

    public void setExplorerResource(String value) {
        this.setExplorerResource(value, null);
    }

    public void setExplorerResource(String value, CmsObject cms) {
        if (value == null) {
            return;
        }
        String mode = this.getExplorerMode();
        if (mode == null) {
            mode = "explorerview";
        }
        if ("explorerview".equals(mode)) {
            mode = mode + "_" + this.getSite() + "/";
        }
        if (value.startsWith("/system/") && !value.startsWith(this.m_currentSite) && !"galleryview".equals(this.getExplorerMode())) {
            this.m_explorerResource.put(mode, "/");
        } else {
            if (cms != null) {
                try {
                    CmsResource resource = cms.readResource(value);
                    value = cms.getSitePath(resource);
                }
                catch (CmsException cme) {
                    // empty catch block
                }
            }
            this.m_explorerResource.put(mode, value);
        }
    }

    public void setGalleryType(String currentGallery) {
        this.m_galleryType = currentGallery;
    }

    public void setLastUsedGallery(int galleryTypeId, String gallerypath) {
        this.m_lastUsedGalleries.put(String.valueOf(galleryTypeId), gallerypath);
    }

    public void setListObject(Object listObject) {
        this.m_listObject = listObject;
    }

    public void setPermissionDetailView(String value) {
        this.m_permissionDetailView = value;
    }

    public void setProject(CmsUUID project) {
        this.m_project = project;
    }

    public void setPublishList(CmsPublishList publishList) {
        this.m_publishList = publishList;
    }

    public void setSite(String value) {
        if (value != null && !value.equals(this.m_currentSite)) {
            this.m_currentSite = value;
            this.m_treeType = new HashMap();
        }
    }

    public void setToolUserData(CmsToolUserData toolUserData) {
        this.m_toolUserData = toolUserData;
    }

    public void setTreeResource(String type, String value) {
        if (value == null) {
            return;
        }
        if (value.startsWith("/system/") && !value.startsWith(this.m_currentSite)) {
            value = "/";
        }
        this.m_treeType.put(type, value);
    }

    public void setTreeSite(String type, String value) {
        if (value == null) {
            return;
        }
        this.m_treeSite.put(type, value);
    }

    public void setUser(CmsUser user) {
        this.m_user = user;
    }

    public void setUserSettings(CmsUserSettings userSettings) {
        this.m_userSettings = userSettings;
    }

    public void setViewStartup(String viewStartup) {
        this.m_viewStartup = viewStartup;
    }

    public void setViewUri(String string) {
        this.m_viewUri = string;
    }
}

