/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsException;
import org.opencms.file.CmsVfsResourceAlreadyExistsException;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.lock.CmsLockException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.staticexport.CmsLinkManager;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsMultiDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.commons.Messages;

public class CmsCopy
extends CmsMultiDialog {
    public static final int ACTION_COPY = 100;
    public static final String DIALOG_TYPE = "copy";
    public static final String PARAM_KEEPRIGHTS = "keeprights";
    public static final String PARAM_OVERWRITE = "overwrite";
    private static final Log LOG = CmsLog.getLog(CmsCopy.class);
    private String m_paramCopymode;
    private String m_paramKeeprights;
    private String m_paramOverwrite;
    private String m_paramTarget;

    public CmsCopy(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsCopy(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionCopy() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        CmsResource resource = null;
        try {
            boolean isFolder = false;
            String source = (String)this.getResourceList().get(0);
            String target = CmsLinkManager.getAbsoluteUri(this.getParamTarget(), CmsResource.getParentFolder(source));
            if (!this.isMultiOperation()) {
                resource = this.getCms().readResource(source, CmsResourceFilter.ALL);
                isFolder = resource.isFolder();
            } else {
                String siteRootFolder = null;
                try {
                    if (OpenCms.getSiteManager().getSiteRoot(target) != null) {
                        siteRootFolder = this.getCms().getRequestContext().getSiteRoot();
                        if (siteRootFolder.endsWith("/")) {
                            siteRootFolder = siteRootFolder.substring(0, siteRootFolder.length() - 1);
                        }
                        this.getCms().getRequestContext().setSiteRoot("/");
                    }
                    resource = this.getCms().readResource(target, CmsResourceFilter.ALL);
                    Object var7_11 = null;
                    if (siteRootFolder != null) {
                        this.getCms().getRequestContext().setSiteRoot(siteRootFolder);
                    }
                }
                catch (Throwable throwable) {
                    Object var7_12 = null;
                    if (siteRootFolder != null) {
                        this.getCms().getRequestContext().setSiteRoot(siteRootFolder);
                    }
                    throw throwable;
                }
                if (!resource.isFolder()) {
                    throw new CmsVfsException(Messages.get().container("ERR_COPY_MULTI_TARGET_NOFOLDER_1", target));
                }
            }
            if (this.performDialogOperation()) {
                if (this.isMultiOperation() || isFolder) {
                    ArrayList<String> folderList = new ArrayList<String>(1);
                    String targetParent = CmsResource.getParentFolder(target);
                    folderList.add(targetParent);
                    this.getJsp().getRequest().setAttribute("__CmsWorkplace.RELOADTREE", folderList);
                }
                this.actionCloseDialog();
            } else {
                this.getJsp().include("/system/workplace/commons/includes/wait.jsp");
            }
        }
        catch (Throwable e) {
            if (!this.isMultiOperation() && (e instanceof CmsVfsResourceAlreadyExistsException || e instanceof CmsLockException) && resource != null && !resource.isFolder()) {
                int targetType = -1;
                String storedSiteRoot = null;
                try {
                    try {
                        if (OpenCms.getSiteManager().getSiteRoot(this.getParamTarget()) != null) {
                            storedSiteRoot = this.getCms().getRequestContext().getSiteRoot();
                            this.getCms().getRequestContext().setSiteRoot("/");
                        }
                        CmsResource targetRes = this.getCms().readResource(this.getParamTarget());
                        targetType = targetRes.getTypeId();
                    }
                    catch (CmsException e2) {
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)e2.getLocalizedMessage());
                        }
                        Object var9_16 = null;
                        if (storedSiteRoot != null) {
                            this.getCms().getRequestContext().setSiteRoot(storedSiteRoot);
                        }
                    }
                    Object var9_15 = null;
                    if (storedSiteRoot != null) {
                        this.getCms().getRequestContext().setSiteRoot(storedSiteRoot);
                    }
                }
                catch (Throwable throwable) {
                    Object var9_17 = null;
                    if (storedSiteRoot != null) {
                        this.getCms().getRequestContext().setSiteRoot(storedSiteRoot);
                    }
                    throw throwable;
                }
                if (resource.getTypeId() == targetType) {
                    this.setParamMessage(CmsStringUtil.escapeHtml(this.key("GUI_COPY_CONFIRM_OVERWRITE_2", new Object[]{this.getParamResource(), this.getParamTarget()})));
                    this.getJsp().include("/system/workplace/commons/includes/confirmation.jsp");
                } else {
                    this.includeErrorpage(this, e);
                }
            }
            this.includeErrorpage(this, e);
        }
    }

    public String buildRadioCopyMode() {
        StringBuffer retValue = new StringBuffer(256);
        boolean isFolder = this.isOperationOnFolder();
        String checkedAttr = " checked=\"checked\"";
        if (this.isMultiOperation() || isFolder) {
            CmsResource.CmsResourceCopyMode defaultMode = this.getSettings().getUserSettings().getDialogCopyFolderMode();
            retValue.append("<input type=\"radio\" name=\"copymode\" value=\"");
            retValue.append(CmsResource.COPY_AS_SIBLING.getMode());
            retValue.append("\"");
            if (defaultMode == CmsResource.COPY_AS_SIBLING) {
                retValue.append(checkedAttr);
            }
            retValue.append("> ");
            String msgKey = this.isMultiOperation() ? "GUI_COPY_MULTI_CREATE_SIBLINGS_0" : "GUI_COPY_CREATE_SIBLINGS_0";
            retValue.append(this.key(msgKey));
            retValue.append("<br>\n");
            retValue.append("<input type=\"radio\" name=\"copymode\" value=\"");
            retValue.append(CmsResource.COPY_PRESERVE_SIBLING.getMode());
            retValue.append("\"");
            if (defaultMode == CmsResource.COPY_PRESERVE_SIBLING) {
                retValue.append(checkedAttr);
            }
            retValue.append("> ");
            retValue.append(this.key("GUI_COPY_ALL_NO_SIBLINGS_0"));
            retValue.append("<br>\n");
            retValue.append("<input type=\"radio\" name=\"copymode\" value=\"");
            retValue.append(CmsResource.COPY_AS_NEW.getMode());
            retValue.append("\"");
            if (defaultMode == CmsResource.COPY_AS_NEW) {
                retValue.append(checkedAttr);
            }
            retValue.append("> ");
            retValue.append(this.key("GUI_COPY_ALL_0"));
            retValue.append("<br>\n");
            if (this.isMultiOperation()) {
                retValue.append(this.dialogSpacer());
                retValue.append("<input type=\"checkbox\" name=\"");
                retValue.append(PARAM_OVERWRITE);
                retValue.append("\" value=\"true\"> ");
                retValue.append(this.key("GUI_COPY_MULTI_OVERWRITE_0"));
                retValue.append("<br>\n");
            }
        } else {
            CmsResource.CmsResourceCopyMode defaultMode = this.getSettings().getUserSettings().getDialogCopyFileMode();
            retValue.append("<input type=\"radio\" name=\"copymode\" value=\"");
            retValue.append(CmsResource.COPY_AS_SIBLING.getMode());
            retValue.append("\"");
            if (defaultMode == CmsResource.COPY_AS_SIBLING) {
                retValue.append(checkedAttr);
            }
            retValue.append("> ");
            retValue.append(this.key("GUI_CREATE_SIBLING_0"));
            retValue.append("<br>\n");
            retValue.append("<input type=\"radio\" name=\"copymode\" value=\"");
            retValue.append(CmsResource.COPY_AS_NEW.getMode());
            retValue.append("\"");
            if (defaultMode == CmsResource.COPY_AS_NEW) {
                retValue.append(checkedAttr);
            }
            retValue.append("> ");
            retValue.append(this.key("GUI_COPY_AS_NEW_0"));
            retValue.append("<br>\n");
        }
        return retValue.toString();
    }

    public String getParamCopymode() {
        return this.m_paramCopymode;
    }

    public String getParamKeeprights() {
        return this.m_paramKeeprights;
    }

    public String getParamOverwrite() {
        return this.m_paramOverwrite;
    }

    public String getParamTarget() {
        return this.m_paramTarget;
    }

    public void setParamCopymode(String value) {
        this.m_paramCopymode = value;
    }

    public void setParamKeeprights(String value) {
        this.m_paramKeeprights = value;
    }

    public void setParamOverwrite(String paramOverwrite) {
        this.m_paramOverwrite = paramOverwrite;
    }

    public void setParamTarget(String value) {
        this.m_paramTarget = value;
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        if (!this.checkResourcePermissions(CmsPermissionSet.ACCESS_WRITE, false)) {
            this.setParamAction("cancel");
        }
        this.setParamDialogtype(DIALOG_TYPE);
        if (DIALOG_TYPE.equals(this.getParamAction())) {
            this.setAction(100);
        } else if ("confirmed".equals(this.getParamAction())) {
            this.setAction(1);
        } else if ("wait".equals(this.getParamAction())) {
            this.setAction(2);
        } else if ("cancel".equals(this.getParamAction())) {
            this.setAction(4);
        } else {
            this.setAction(0);
            this.setDialogTitle("GUI_COPY_RESOURCE_1", "GUI_COPY_MULTI_2");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean performDialogOperation() throws CmsException {
        CmsResource.CmsResourceCopyMode copyMode;
        block14: {
            boolean isFolder = this.isOperationOnFolder();
            if ((this.isMultiOperation() || isFolder) && !"wait".equals(this.getParamAction())) {
                return false;
            }
            copyMode = CmsResource.COPY_PRESERVE_SIBLING;
            try {
                copyMode = CmsResource.CmsResourceCopyMode.valueOf(Integer.parseInt(this.getParamCopymode()));
            }
            catch (Exception e) {
                if (!LOG.isInfoEnabled()) break block14;
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        boolean overwrite = Boolean.valueOf(this.getParamOverwrite());
        overwrite = this.isMultiOperation() && overwrite || "confirmed".equals(this.getParamAction());
        String target = this.getParamTarget();
        if (target == null) {
            target = "";
        }
        String storedSiteRoot = null;
        try {
            String sitePrefix = "";
            if (OpenCms.getSiteManager().getSiteRoot(target) != null) {
                String siteRootFolder = this.getCms().getRequestContext().getSiteRoot();
                if (siteRootFolder.endsWith("/")) {
                    siteRootFolder = siteRootFolder.substring(0, siteRootFolder.length() - 1);
                }
                sitePrefix = siteRootFolder;
                storedSiteRoot = this.getCms().getRequestContext().getSiteRoot();
                this.getCms().getRequestContext().setSiteRoot("/");
            }
            Iterator i = this.getResourceList().iterator();
            while (i.hasNext()) {
                String resName = (String)i.next();
                try {
                    this.performSingleCopyOperation(resName, target, sitePrefix, copyMode, overwrite);
                }
                catch (CmsException e) {
                    if (this.isMultiOperation()) {
                        this.addMultiOperationException(e);
                        continue;
                    }
                    throw e;
                }
            }
            this.checkMultiOperationException(Messages.get(), "ERR_COPY_MULTI_0");
            Object var11_11 = null;
            if (storedSiteRoot != null) {
                this.getCms().getRequestContext().setSiteRoot(storedSiteRoot);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (storedSiteRoot != null) {
                this.getCms().getRequestContext().setSiteRoot(storedSiteRoot);
            }
            throw throwable;
        }
        return true;
    }

    protected void performSingleCopyOperation(String source, String target, String sitePrefix, CmsResource.CmsResourceCopyMode copyMode, boolean overwrite) throws CmsException {
        String finalTarget;
        block6: {
            finalTarget = CmsLinkManager.getAbsoluteUri(target, CmsResource.getParentFolder(source));
            if (finalTarget.equals(source) || this.isMultiOperation() && finalTarget.startsWith(source)) {
                throw new CmsVfsException(Messages.get().container("ERR_COPY_ONTO_ITSELF_1", finalTarget));
            }
            try {
                CmsResource res = this.getCms().readResource(finalTarget, CmsResourceFilter.ALL);
                if (res.isFolder()) {
                    if (!finalTarget.endsWith("/")) {
                        finalTarget = finalTarget + "/";
                    }
                    finalTarget = finalTarget + CmsResource.getName(source);
                }
            }
            catch (CmsVfsResourceNotFoundException e) {
                if (!LOG.isInfoEnabled()) break block6;
                LOG.info((Object)e.getLocalizedMessage());
            }
        }
        this.setParamTarget(finalTarget);
        if (overwrite && this.getCms().existsResource(finalTarget)) {
            this.checkLock(finalTarget);
            this.getCms().deleteResource(finalTarget, CmsResource.DELETE_PRESERVE_SIBLINGS);
        }
        this.getCms().copyResource(sitePrefix + source, finalTarget, copyMode);
    }
}

