/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsRuntimeException;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.commons.CmsDeletedResourcesList;
import org.opencms.workplace.commons.Messages;

public class CmsDeletedResources
extends CmsDialog {
    public static final String PARAM_READTREE = "readtree";
    private String m_paramListAction;
    private String m_paramReadtree;
    private String m_paramSelItems;

    public CmsDeletedResources(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsDeletedResources(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public String buildIncludeJs() {
        StringBuffer html = new StringBuffer(512);
        html.append("<script type='text/javascript' src='");
        html.append(CmsWorkplace.getSkinUri());
        html.append("commons/ajax.js'></script>\n");
        html.append("<script type='text/javascript' src='");
        html.append(CmsWorkplace.getSkinUri());
        html.append("editors/xmlcontent/help.js'></script>\n");
        html.append("<script type='text/javascript' src='");
        html.append(CmsWorkplace.getSkinUri());
        html.append("admin/javascript/general.js'></script>\n");
        html.append("<script type='text/javascript' src='");
        html.append(CmsWorkplace.getSkinUri());
        html.append("admin/javascript/list.js'></script>\n");
        html.append("<script type='text/javascript'><!--\n");
        html.append("\tvar ");
        html.append("noSelHelp");
        html.append(" = '");
        html.append(CmsStringUtil.escapeJavaScript(this.key("GUI_LIST_ACTION_NO_SELECTION_0")));
        html.append("';\n");
        html.append("function doReportUpdate(msg, state) {\n");
        html.append("\tvar img = state + '.png';\n");
        html.append("\tvar txt = '';\n");
        html.append("\tvar elem = document.getElementById('ajaxreport');\n");
        html.append("\tif (state != 'ok') {\n");
        html.append("\t\tif (state == 'fatal') {\n");
        html.append("\t\t\timg = 'error.png';\n");
        html.append("\t\t\ttxt = '");
        html.append(this.key("GUI_AJAX_REPORT_GIVEUP_0"));
        html.append("';\n");
        html.append("\t\t} else if (state == 'wait') {\n");
        html.append("\t\t\timg = 'wait.gif';\n");
        html.append("\t\t\ttxt = '");
        html.append(this.key("GUI_AJAX_REPORT_WAIT_0"));
        html.append("'\n");
        html.append("\t\t} else if (state == 'error') {\n");
        html.append("\t\t\ttxt = '");
        html.append(this.key("GUI_AJAX_REPORT_ERROR_0"));
        html.append("' + msg;\n");
        html.append("\t\t}\n");
        html.append("\t} else {");
        html.append("\t\telem.innerHTML = msg;\n");
        html.append("\t}\n");
        html.append("\tif (txt != '') {\n");
        html.append("\t\tvar html = \"<table border='0' style='vertical-align:middle; height: 200px;'>\";");
        html.append("\t\thtml += \"<tr><td width='40' align='center' valign='middle'><img src='");
        html.append(CmsDeletedResources.getSkinUri());
        html.append("commons/\";");
        html.append("\t\thtml += img;");
        html.append("\t\thtml += \"' width='32' height='32' alt=''></td>\";");
        html.append("\t\thtml += \"<td valign='middle'><span style='color: #000099; font-weight: bold;'>\";");
        html.append("\t\thtml += txt;");
        html.append("\t\thtml += \"</span><br></td></tr></table>\";");
        html.append("\t\telem.innerHTML = html;");
        html.append("\t}\n");
        html.append("}\n");
        html.append("function reloadReport() {\n");
        html.append("\tvar readtree = document.forms[\"");
        html.append("drl");
        html.append("-form\"].");
        html.append(PARAM_READTREE);
        html.append(".checked;\n");
        html.append("\tmakeRequest('");
        html.append(this.getJsp().link("/system/workplace/commons/report-deleted.jsp"));
        html.append("', '");
        html.append("resource");
        html.append("=");
        html.append(this.getParamResource());
        html.append("&");
        html.append(PARAM_READTREE);
        html.append("=");
        html.append("' + readtree");
        html.append(", 'doReportUpdate');\n");
        html.append("}\n");
        html.append("// -->\n");
        html.append("</script>\n");
        return html.toString();
    }

    public String buildOptions() {
        StringBuffer result = new StringBuffer(128);
        result.append("<input type='checkbox' name='");
        result.append(PARAM_READTREE);
        result.append("' value='true' onclick=\"reloadReport();\"");
        if (Boolean.valueOf(this.getParamReadtree()).booleanValue()) {
            result.append(" checked='checked'");
        }
        result.append(">&nbsp;");
        result.append(this.key("GUI_DELETED_RESOURCES_READ_TREE_0"));
        return result.toString();
    }

    public String buildReport() throws JspException, ServletException, IOException {
        CmsDeletedResourcesList list = new CmsDeletedResourcesList(this.getJsp(), this.getParamResource(), Boolean.valueOf(this.getParamReadtree()));
        list.actionDialog();
        list.getList().setBoxed(false);
        StringBuffer result = new StringBuffer(512);
        result.append("<div style='height:200px; overflow: auto;'>\n");
        result.append(list.getList().listHtml());
        result.append("</div>\n");
        return result.toString();
    }

    public String buildReportRequest() {
        StringBuffer html = new StringBuffer(512);
        html.append("<script type='text/javascript'><!--\n");
        html.append("makeRequest('");
        html.append(this.getJsp().link("/system/workplace/commons/report-deleted.jsp"));
        html.append("', '");
        html.append("resource");
        html.append("=");
        html.append(this.getParamResource());
        html.append("', 'doReportUpdate');\n");
        html.append("// -->\n");
        html.append("</script>\n");
        return html.toString();
    }

    public String dialogButtons() {
        return this.dialogButtonsOkCancel(" onclick=\"listMAction('drl','mr', '', noSelHelp);\"", null);
    }

    public void executeListMultiActions() throws JspException {
        if (this.getParamListAction().equals("mr")) {
            StringBuffer errors = new StringBuffer();
            Iterator iter = this.getSelectedItems().iterator();
            while (iter.hasNext()) {
                CmsUUID id = new CmsUUID((String)iter.next());
                try {
                    this.getCms().restoreDeletedResource(id);
                }
                catch (Exception e) {
                    errors.append(e.getLocalizedMessage());
                }
            }
            if (errors.length() > 0) {
                throw new CmsRuntimeException(Messages.get().container("ERR_RESTORE_SELECTED_RESOURCES_1", errors));
            }
            this.actionCloseDialog();
        }
    }

    public String getParamListAction() {
        return this.m_paramListAction;
    }

    public String getParamReadtree() {
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_paramReadtree)) {
            return "false";
        }
        return this.m_paramReadtree;
    }

    public String getParamSelItems() {
        return this.m_paramSelItems;
    }

    public List getSelectedItems() {
        Iterator it = CmsStringUtil.splitAsList(this.getParamSelItems(), "|", true).iterator();
        ArrayList<String> items = new ArrayList<String>();
        while (it.hasNext()) {
            String id = (String)it.next();
            items.add(id);
        }
        return items;
    }

    public String paramsAsHidden() {
        ArrayList<String> excludes = new ArrayList<String>();
        excludes.add(PARAM_READTREE);
        return this.paramsAsHidden(excludes);
    }

    public void setParamListAction(String paramListAction) {
        this.m_paramListAction = paramListAction;
    }

    public void setParamReadtree(String paramReadtree) {
        this.m_paramReadtree = paramReadtree;
    }

    public void setParamSelItems(String paramSelItems) {
        this.m_paramSelItems = paramSelItems;
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        this.setParamTitle(this.key("GUI_DELETED_RESOURCES_TITLE_1", new Object[]{this.getParamResource()}));
        if (this.getParamListAction() == null) {
            this.setParamListAction("");
        }
        if (this.getParamSelItems() == null) {
            this.setParamSelItems("");
        }
        if ("listmultiaction".equals(this.getParamAction())) {
            this.setAction(85);
        }
    }
}

