/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.staticexport.CmsStaticExportManager;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.commons.Messages;

public class CmsDisplayResource
extends CmsDialog {
    public static final String PARAM_VERSION = "version";
    private static final Log LOG = CmsLog.getLog(CmsDisplayResource.class);
    private String m_paramVersion;

    public CmsDisplayResource(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsDisplayResource(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static byte[] getHistoricalResourceContent(CmsObject cms, String resource, String version) {
        if (CmsStringUtil.isNotEmpty(resource) && CmsStringUtil.isNotEmpty(version)) {
            I_CmsHistoryResource res = null;
            String storedSiteRoot = cms.getRequestContext().getSiteRoot();
            try {
                cms.getRequestContext().setSiteRoot("/");
                res = cms.readResource(cms.readResource(resource, CmsResourceFilter.ALL).getStructureId(), Integer.parseInt(version));
            }
            catch (CmsException e) {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)e.getLocalizedMessage());
                }
                byte[] byArray = "".getBytes();
                return byArray;
            }
            finally {
                cms.getRequestContext().setSiteRoot(storedSiteRoot);
            }
            if (res.isFile()) {
                byte[] historyResourceContent = ((CmsFile)((Object)res)).getContents();
                if (historyResourceContent == null || historyResourceContent.length == 0) {
                    try {
                        CmsFile file = cms.readFile((CmsResource)((Object)res));
                        historyResourceContent = file.getContents();
                    }
                    catch (CmsException e) {
                        // empty catch block
                    }
                }
                historyResourceContent = CmsEncoder.changeEncoding(historyResourceContent, OpenCms.getSystemInfo().getDefaultEncoding(), cms.getRequestContext().getEncoding());
                return historyResourceContent;
            }
        }
        return "".getBytes();
    }

    public void actionShow() throws Exception {
        String resourceStr = this.getParamResource();
        if (CmsStringUtil.isNotEmpty(this.getParamVersion())) {
            byte[] result = CmsDisplayResource.getHistoricalResourceContent(this.getCms(), resourceStr, this.getParamVersion());
            if (result != null) {
                String contentType = OpenCms.getResourceManager().getMimeType(resourceStr, this.getCms().getRequestContext().getEncoding());
                HttpServletResponse res = this.getJsp().getResponse();
                HttpServletRequest req = this.getJsp().getRequest();
                res.setHeader("Content-Disposition", "attachment; filename=\"" + resourceStr + "\"");
                res.setContentLength(result.length);
                CmsFlexController controller = CmsFlexController.getController((ServletRequest)req);
                res = controller.getTopResponse();
                res.setContentType(contentType);
                try {
                    res.getOutputStream().write(result);
                    res.getOutputStream().flush();
                }
                catch (IOException e) {
                    if (LOG.isInfoEnabled()) {
                        LOG.info((Object)e.getLocalizedMessage());
                    }
                    return;
                }
            }
        } else {
            CmsResource resource = null;
            try {
                resource = this.getCms().readResource(resourceStr, CmsResourceFilter.ALL);
            }
            catch (CmsVfsResourceNotFoundException e) {
                // empty catch block
            }
            if (resource != null) {
                String url;
                block18: {
                    if (resource.getState().isDeleted()) {
                        throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_RESOURCE_DELETED_2", resourceStr, this.getCms().getRequestContext().currentProject().getName()));
                    }
                    this.autoTimeWarp(resource);
                    url = this.getJsp().link(resourceStr);
                    if (url.indexOf("://") < 0 && this.getCms().getRequestContext().currentProject().isOnlineProject()) {
                        String site = this.getCms().getRequestContext().getSiteRoot();
                        url = CmsStringUtil.isEmptyOrWhitespaceOnly(site) ? (CmsStringUtil.isEmptyOrWhitespaceOnly(site = OpenCms.getSiteManager().getDefaultUri()) ? OpenCms.getSiteManager().getWorkplaceServer() + url : (OpenCms.getSiteManager().getSiteForSiteRoot(site) == null ? OpenCms.getSiteManager().getWorkplaceServer() + url : OpenCms.getSiteManager().getSiteForSiteRoot(site).getUrl() + url)) : OpenCms.getSiteManager().getSiteForSiteRoot(site).getUrl() + url;
                        try {
                            CmsStaticExportManager manager = OpenCms.getStaticExportManager();
                            HttpURLConnection.setFollowRedirects(false);
                            URL exportUrl = new URL(manager.getExportUrl() + manager.getRfsName(this.getCms(), resourceStr));
                            HttpURLConnection urlcon = (HttpURLConnection)exportUrl.openConnection();
                            urlcon.setRequestMethod("GET");
                            urlcon.setRequestProperty("OpenCms-Export", Boolean.TRUE.toString());
                            if (manager.getAcceptLanguageHeader() != null) {
                                urlcon.setRequestProperty("Accept-Language", manager.getAcceptLanguageHeader());
                            } else {
                                urlcon.setRequestProperty("Accept-Language", manager.getDefaultAcceptLanguageHeader());
                            }
                            if (manager.getAcceptCharsetHeader() != null) {
                                urlcon.setRequestProperty("Accept-Charset", manager.getAcceptCharsetHeader());
                            } else {
                                urlcon.setRequestProperty("Accept-Charset", manager.getDefaultAcceptCharsetHeader());
                            }
                            urlcon.connect();
                            urlcon.getResponseCode();
                            urlcon.disconnect();
                        }
                        catch (Exception e) {
                            if (!LOG.isDebugEnabled()) break block18;
                            LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
                this.getJsp().getResponse().sendRedirect(url);
            } else {
                throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_RESOURCE_DOES_NOT_EXIST_3", resourceStr, this.getCms().getRequestContext().currentProject().getName(), this.getCms().getRequestContext().getSiteRoot()));
            }
        }
    }

    public String getParamVersion() {
        return this.m_paramVersion;
    }

    public void setParamVersionid(String paramVersion) {
        this.m_paramVersion = paramVersion;
    }

    protected void autoTimeWarp(CmsResource resource) throws CmsVfsResourceNotFoundException {
        long surfTime = this.getCms().getRequestContext().getRequestTime();
        if (resource.isReleasedAndNotExpired(surfTime)) {
            return;
        }
        if (this.getSettings().getUserSettings().getTimeWarp() == -1L) {
            long timeWarp = resource.isExpired(surfTime) ? resource.getDateExpired() - 1L : (!resource.isReleased(surfTime) ? resource.getDateReleased() + 1L : -1L);
            if (timeWarp != -1L) {
                this.getSession().setAttribute("__org.opencms.main.CmsContextInfo#m_requestTime", (Object)new Long(timeWarp));
            }
        } else {
            throw new CmsVfsResourceNotFoundException(Messages.get().container("ERR_RESOURCE_OUTSIDE_TIMEWINDOW_1", this.getParamResource()));
        }
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(settings, request);
    }
}

