/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsIllegalStateException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.commons.CmsProgressThread;
import org.opencms.workplace.commons.Messages;
import org.opencms.workplace.list.A_CmsListDialog;

public class CmsProgressWidget {
    public static final String PARAMETER_KEY = "progresskey";
    public static final String PARAMETER_REFRESHRATE = "refreshrate";
    public static final String PARAMETER_SHOWWAITTIME = "showwaittime";
    private static final long CLEANUP_PERIOD = 600000L;
    private static final String DEFAULT_COLOR = "blue";
    private static final int DEFAULT_REFRESH_RATE = 2000;
    private static final String DEFAULT_WIDTH = "200px";
    private static final Log LOG = CmsLog.getLog(CmsProgressWidget.class);
    private static Map m_threads = new HashMap();
    private String m_color;
    private String m_jsFinishMethod;
    private CmsJspActionElement m_jsp;
    private String m_key;
    private int m_refreshRate;
    private int m_showWaitTime;
    private String m_width;

    public CmsProgressWidget(CmsJspActionElement jsp) {
        this.m_jsp = jsp;
        this.m_width = DEFAULT_WIDTH;
        this.m_color = DEFAULT_COLOR;
        this.m_showWaitTime = 0;
        if (this.getJsp().getRequest().getParameter(PARAMETER_SHOWWAITTIME) != null) {
            this.m_showWaitTime = Integer.valueOf(this.getJsp().getRequest().getParameter(PARAMETER_SHOWWAITTIME));
        }
        this.m_refreshRate = 2000;
        if (this.getJsp().getRequest().getParameter(PARAMETER_REFRESHRATE) != null) {
            this.m_refreshRate = Integer.valueOf(this.getJsp().getRequest().getParameter(PARAMETER_REFRESHRATE));
        }
        this.m_key = this.getJsp().getRequest().getParameter(PARAMETER_KEY);
        if (this.m_key == null) {
            this.m_key = new CmsUUID().toString();
        }
    }

    public CmsProgressWidget(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public static CmsProgressThread getProgressThread(String key) {
        return (CmsProgressThread)m_threads.get(key);
    }

    public static void removeProgressThread(String key) {
        m_threads.remove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getActualProgress() {
        try {
            if (CmsProgressWidget.getProgressThread(this.getKey()) != null) {
                CmsProgressThread thread = (CmsProgressThread)m_threads.get(this.getKey());
                if (thread.isAlive()) {
                    CmsProgressWidget cmsProgressWidget;
                    if (thread.getRuntime() < (long)this.getShowWaitTime()) {
                        while (thread.getRuntime() < (long)this.getShowWaitTime() && thread.isAlive()) {
                            cmsProgressWidget = this;
                            synchronized (cmsProgressWidget) {
                                this.wait(500L);
                            }
                        }
                    } else {
                        cmsProgressWidget = this;
                        synchronized (cmsProgressWidget) {
                            this.wait(this.getRefreshRate());
                        }
                    }
                }
                if (!thread.isAlive()) {
                    if (thread.getError() != null) {
                        return this.createError(Messages.get().getBundle(this.getJsp().getRequestContext().getLocale()).key("GUI_PROGRESS_ERROR_IN_THREAD_0"), thread.getError());
                    }
                    return thread.getResult();
                }
                StringBuffer result = new StringBuffer();
                result.append("PRO");
                result.append(thread.getProgress());
                result.append("%");
                result.append("|");
                result.append(thread.getDescription());
                return result.toString();
            }
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_PROGRESS_THREAD_NOT_FOUND_1", this.getKey()));
            }
            return this.createError(Messages.get().getBundle(this.getJsp().getRequestContext().getLocale()).key("GUI_PROGRESS_THREAD_NOT_FOUND_1", this.getKey()));
        }
        catch (Throwable t) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_PROGRESS_ERROR_CALC_PROGRESS_0"), t);
            }
            return this.createError(Messages.get().getBundle(this.getJsp().getRequestContext().getLocale()).key("GUI_PROGRESS_ERROR_CALCULATING_0"), t);
        }
    }

    public String getColor() {
        return this.m_color;
    }

    public String getJsFinishMethod() {
        return this.m_jsFinishMethod;
    }

    public String getJsIncludes() {
        StringBuffer result = new StringBuffer();
        result.append("<script type=\"text/javascript\" src=\"");
        result.append(CmsWorkplace.getSkinUri());
        result.append("commons/ajax.js\"></script>\n");
        result.append("<script type=\"text/javascript\">\n");
        result.append("\tvar progressState = 0;\n");
        result.append("\tvar progressResult = '';\n");
        result.append("\tfunction updateProgressBar(msg, state) {\n");
        result.append("\t\tif (progressState != 1) {\n");
        result.append("\t\t\tprogressState = 0;\n");
        result.append("\t\t\treturn;\n");
        result.append("\t\t}\n");
        result.append("\t\tif (state == 'ok') {\n");
        result.append("\t\t\tvar bar = document.getElementById(\"progressbar_bar\");\n");
        result.append("\t\t\tvar percent = document.getElementById(\"progressbar_percent\");\n");
        result.append("\t\t\tvar wait = document.getElementById(\"progressbar_wait\");\n");
        result.append("\t\t\tvar desc = document.getElementById(\"progressbar_desc\");\n");
        result.append("\t\t\tif (msg != \"\") {\n");
        result.append("\t\t\t\tbar.parentNode.style.display = \"block\";\n");
        result.append("\t\t\t\tpercent.style.display = \"inline\";\n");
        result.append("\t\t\t\twait.style.display = \"none\";\n");
        result.append("\t\t\t\tdesc.style.display = \"block\";\n");
        result.append("\t\t\t\tif (msg.substring(0,3) == \"PRO\") {\n");
        result.append("\t\t\t\t\tvar splitted = msg.split(\"|\");\n");
        result.append("\t\t\t\t\tbar.style.width = splitted[0].substr(3);\n");
        result.append("\t\t\t\t\tpercent.innerHTML = splitted[0].substr(3);\n");
        result.append("\t\t\t\t\tdesc.innerHTML = splitted[1];\n");
        result.append("\t\t\t\t\tmakeRequest('");
        result.append(this.getJsp().link("/system/workplace/commons/report-progress.jsp"));
        result.append("', '");
        result.append(PARAMETER_KEY);
        result.append("=");
        result.append(this.getKey());
        result.append("&");
        result.append(PARAMETER_SHOWWAITTIME);
        result.append("=");
        result.append(this.getShowWaitTime());
        result.append("&");
        result.append(PARAMETER_REFRESHRATE);
        result.append("=");
        result.append(this.getRefreshRate());
        result.append("', 'updateProgressBar');\n");
        result.append("\t\t\t\t} else if (msg.substring(0,3) == \"ERR\") {\n");
        result.append("\t\t\t\t\tsetProgressBarError(msg.substr(3));\n");
        result.append("\t\t\t\t} else {\n");
        result.append("\t\t\t\t\tprogressState = 0;\n");
        result.append("\t\t\t\t\tbar.style.width = \"100%\";\n");
        result.append("\t\t\t\t\tpercent.innerHTML = \"100%\";\n");
        result.append("\t\t\t\t\tprogressResult = msg;\n");
        result.append("\t\t\t\t\tbar.parentNode.style.display = \"none\";\n");
        result.append("\t\t\t\t\tpercent.style.display = \"none\";\n");
        result.append("\t\t\t\t\tdesc.style.display = \"none\";\n");
        result.append("\t\t\t\t\twait.style.display = \"block\";\n");
        result.append("\t\t\t\t\twindow.setTimeout(\"");
        result.append(this.getJsFinishMethod());
        result.append("()\",100);\n");
        result.append("\t\t\t\t}\n");
        result.append("\t\t\t} else {\n");
        result.append("\t\t\t\tbar.style.width = \"100%\";\n");
        result.append("\t\t\t}\n");
        result.append("\t\t} else if (state == 'fatal') {\n");
        result.append("\t\t\tprogressState = 0;\n");
        result.append("\t\t\tsetProgressBarError(\"");
        result.append(org.opencms.workplace.Messages.get().getBundle(this.getJsp().getRequestContext().getLocale()).key("GUI_AJAX_REPORT_GIVEUP_0"));
        result.append("\");\n");
        result.append("\t\t} else if (state == 'error') {\n");
        result.append("\t\t\tprogressState = 0;\n");
        result.append("\t\t\tsetProgressBarError(\"");
        result.append(org.opencms.workplace.Messages.get().getBundle(this.getJsp().getRequestContext().getLocale()).key("GUI_AJAX_REPORT_ERROR_0"));
        result.append(" \" + msg);\n");
        result.append("\t\t} else if (state == 'wait') {\n");
        result.append("\t\t\tbar.parentNode.style.display = \"none\";\n");
        result.append("\t\t\tpercent.style.display = \"none\";\n");
        result.append("\t\t\twait.style.display = \"block\";\n");
        result.append("\t\t}\n");
        result.append("\t}\n");
        result.append("\tfunction setProgressBarError(msg) {\n");
        result.append("\t\tvar error = document.getElementById(\"progressbar_error\");\n");
        result.append("\t\tvar bar = document.getElementById(\"progressbar_bar\");\n");
        result.append("\t\tvar percent = document.getElementById(\"progressbar_percent\");\n");
        result.append("\t\tvar desc = document.getElementById(\"progressbar_desc\");\n");
        result.append("\t\terror.innerHTML = msg;\n");
        result.append("\t\terror.style.display = \"block\";\n");
        result.append("\t\tbar.style.display = \"none\";\n");
        result.append("\t\tpercent.style.display = \"none\";\n");
        result.append("\t\tdesc.style.display = \"none\";\n");
        result.append("\t}\n");
        result.append("\tfunction resetProgressBar() {\n");
        result.append("\t\tvar bar = document.getElementById(\"progressbar_bar\");\n");
        result.append("\t\tbar.parentNode.style.display = \"inline\";\n");
        result.append("\t\tbar.style.width = \"0%\";\n");
        result.append("\t\tbar.style.display = \"block\";\n");
        result.append("\t\tvar percent = document.getElementById(\"progressbar_percent\");\n");
        result.append("\t\tpercent.innerHTML = \"0%\";\n");
        result.append("\t\tpercent.style.display = \"inline\";\n");
        result.append("\t\tvar error = document.getElementById(\"progressbar_error\");\n");
        result.append("\t\terror.innerHTML = \"\";\n");
        result.append("\t\terror.style.display = \"none\";\n");
        result.append("\t\tvar wait = document.getElementById(\"progressbar_wait\");\n");
        result.append("\t\twait.style.display = \"none\";\n");
        result.append("\t\tvar desc = document.getElementById(\"progressbar_desc\");\n");
        result.append("\t\tdesc.style.display = \"block\";\n");
        result.append("\t\tdesc.innerHTML = \"\";\n");
        result.append("\t\t\t\t\tprogressResult = \"\";\n");
        result.append("\t}\n");
        result.append("\tfunction startProgressBar() {\n");
        result.append("\t\tif (progressState > 0) {\n");
        result.append("\t\t\tprogressState = 2;\n");
        result.append("\t\t\twindow.setTimeout(\"startProgressBar()\",");
        result.append(this.getRefreshRate());
        result.append(");\n");
        result.append("\t\t\treturn;\n");
        result.append("\t\t}\n");
        result.append("\t\tprogressState = 1;\n");
        result.append("\t\tmakeRequest('");
        result.append(this.getJsp().link("/system/workplace/commons/report-progress.jsp"));
        result.append("', '");
        result.append(PARAMETER_KEY);
        result.append("=");
        result.append(this.getKey());
        result.append("&");
        result.append(PARAMETER_SHOWWAITTIME);
        result.append("=");
        result.append(this.getShowWaitTime());
        result.append("&");
        result.append(PARAMETER_REFRESHRATE);
        result.append("=");
        result.append(this.getRefreshRate());
        result.append("', 'updateProgressBar');\n");
        result.append("\t}\n");
        result.append("</script>\n");
        return result.toString();
    }

    public CmsJspActionElement getJsp() {
        return this.m_jsp;
    }

    public String getKey() {
        return this.m_key;
    }

    public int getRefreshRate() {
        return this.m_refreshRate;
    }

    public int getShowWaitTime() {
        return this.m_showWaitTime;
    }

    public String getWidget() {
        StringBuffer result = new StringBuffer();
        CmsProgressThread thread = CmsProgressWidget.getProgressThread(this.getKey());
        if (thread != null && !thread.isAlive()) {
            result.append("<script type=\"text/javascript\">\n");
            result.append("\tprogressState = 0;\n");
            result.append("\tprogressResult = '");
            result.append(CmsStringUtil.escapeJavaScript(this.getActualProgress()));
            result.append("';\n");
            result.append("\t");
            result.append(this.getJsFinishMethod());
            result.append("();\n");
            result.append("</script>\n");
        } else {
            boolean showWait = false;
            if (this.getShowWaitTime() > 0) {
                if (thread != null && thread.isAlive() && thread.getRuntime() < (long)this.getShowWaitTime()) {
                    showWait = true;
                } else if (thread == null && this.getShowWaitTime() > 0) {
                    showWait = true;
                }
            }
            result.append("<div id=\"progressbar_desc\" style=\"margin-bottom:5px;display:");
            result.append(showWait ? "none" : "block");
            result.append("\"></div>");
            result.append("<div style=\"width:");
            result.append(this.getWidth());
            result.append(";border-width:1px;border-style:solid;padding:0px;margin:0px;float:left;display:");
            result.append(showWait ? "none" : "inline");
            result.append(";\">\n");
            result.append("\t<div id=\"progressbar_bar\" style=\"width:0%;background-color:");
            result.append(this.getColor());
            result.append(";\">&nbsp;</div>\n");
            result.append("</div>\n");
            result.append("&nbsp;");
            result.append("<div id=\"progressbar_percent\" style=\"display:");
            result.append(showWait ? "none" : "inline");
            result.append(";\" >0%</div>\n");
            result.append("<div id=\"progressbar_error\" style=\"display:none;color:#B40000;font-weight:bold;\"></div>\n");
            result.append("<div id=\"progressbar_wait\" style=\"display:");
            result.append(showWait ? "block" : "none");
            result.append(";color:#000099;font-weight:bold;\"><img src=\"");
            result.append(CmsWorkplace.getSkinUri());
            result.append("commons/wait.gif\" width='32' height='32' alt='' align='absmiddle' />");
            result.append(org.opencms.workplace.Messages.get().getBundle(this.getJsp().getRequestContext().getLocale()).key("GUI_AJAX_REPORT_WAIT_0"));
            result.append("</div>\n");
            result.append("<script type=\"text/javascript\">\n");
            result.append("\tstartProgressBar();\n");
            result.append("</script>\n");
        }
        return result.toString();
    }

    public String getWidth() {
        return this.m_width;
    }

    public void setColor(String color) {
        this.m_color = color;
    }

    public void setJsFinishMethod(String jsFinishMethod) {
        this.m_jsFinishMethod = jsFinishMethod;
    }

    public void setRefreshRate(int refreshRate) {
        this.m_refreshRate = refreshRate;
    }

    public void setShowWaitTime(int showWaitTime) {
        this.m_showWaitTime = showWaitTime;
    }

    public void setWidth(String width) {
        this.m_width = width;
    }

    public void startProgress(A_CmsListDialog list) {
        this.startProgress(list, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startProgress(A_CmsListDialog list, boolean abortExisting) {
        Thread thread;
        if (list == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_PROGRESS_START_INVALID_LIST_0"));
        }
        if (m_threads.get(this.getKey()) != null) {
            if (abortExisting) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_PROGRESS_INTERRUPT_THREAD_1", this.getKey()));
                }
                thread = (Thread)m_threads.get(this.getKey());
                thread.interrupt();
            } else {
                throw new CmsIllegalStateException(Messages.get().container("ERR_PROGRESS_START_THREAD_EXISTS_0"));
            }
        }
        thread = new CmsProgressThread(list, this.getKey(), list.getLocale());
        HashMap threadsAbandoned = new HashMap();
        HashMap threadsAlive = new HashMap();
        Map map = m_threads;
        synchronized (map) {
            Iterator iter = m_threads.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                CmsProgressThread value = (CmsProgressThread)entry.getValue();
                if (!thread.isAlive() && System.currentTimeMillis() - value.getFinishTime() > 600000L) {
                    threadsAbandoned.put(entry.getKey(), entry.getValue());
                    continue;
                }
                threadsAlive.put(entry.getKey(), entry.getValue());
            }
            threadsAlive.put(this.getKey(), thread);
            thread.start();
            m_threads = threadsAlive;
        }
        if (LOG.isDebugEnabled()) {
            Iterator iter = threadsAbandoned.entrySet().iterator();
            while (iter.hasNext()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_PROGRESS_CLEAN_UP_THREAD_1", this.getKey()));
            }
        }
    }

    private String createError(String errorMsg) {
        StringBuffer result = new StringBuffer();
        result.append("ERR");
        result.append(errorMsg);
        return result.toString();
    }

    private String createError(String errorMsg, Throwable t) {
        StringBuffer msg = new StringBuffer();
        msg.append(errorMsg);
        msg.append("\n");
        msg.append(t.getMessage());
        msg.append("\n");
        msg.append(CmsException.getStackTraceAsString(t));
        return this.createError(msg.toString());
    }
}

