/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.commons;

import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsMultiDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.commons.Messages;

public class CmsUndoChanges
extends CmsMultiDialog {
    public static final int ACTION_UNDOCHANGES = 100;
    public static final String DIALOG_TYPE = "undochanges";
    public static final String PARAM_RECURSIVE = "recursive";
    public static final String PARAM_MOVE = "move";
    private static final Log LOG = CmsLog.getLog(CmsUndoChanges.class);
    private CmsResource m_currentResource;
    private String m_paramMove;
    private String m_paramRecursive;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String resourceOriginalPath(CmsObject cms, String resourceName) {
        CmsProject proj = cms.getRequestContext().currentProject();
        try {
            CmsResource resource = cms.readResource(resourceName, CmsResourceFilter.ALL);
            String result = cms.getSitePath(resource);
            cms.getRequestContext().setCurrentProject(cms.readProject(CmsProject.ONLINE_PROJECT_ID));
            result = cms.getSitePath(cms.readResource(resource.getStructureId()));
            if (result.charAt(result.length() - 1) == '/' && resourceName.charAt(resourceName.length() - 1) != '/') {
                result = result.substring(0, result.length() - 1);
            }
            String string = result;
            return string;
        }
        catch (CmsException e) {
            String string = null;
            return string;
        }
        finally {
            cms.getRequestContext().setCurrentProject(proj);
        }
    }

    public CmsUndoChanges(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsUndoChanges(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionUndoChanges() throws JspException {
        this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
        try {
            boolean isFolder = false;
            String source = (String)this.getResourceList().get(0);
            if (!this.isMultiOperation()) {
                CmsResource resource = this.getCms().readResource(source, CmsResourceFilter.ALL);
                isFolder = resource.isFolder();
            }
            ArrayList<String> folderList = new ArrayList<String>(1 + this.getResourceList().size());
            folderList.add(CmsResource.getParentFolder(source));
            Iterator it = this.getResourceList().iterator();
            while (it.hasNext()) {
                CmsResource resource;
                String res = (String)it.next();
                String target = CmsUndoChanges.resourceOriginalPath(this.getCms(), res);
                if (target == null || target.equals(res) || !(resource = this.getCms().readResource(res, CmsResourceFilter.ALL)).isFolder()) continue;
                folderList.add(CmsResource.getParentFolder(target));
            }
            if (this.performDialogOperation()) {
                if (this.isMultiOperation() || isFolder) {
                    this.getJsp().getRequest().setAttribute("__CmsWorkplace.RELOADTREE", folderList);
                }
                this.actionCloseDialog();
            } else {
                this.getJsp().include("/system/workplace/commons/includes/wait.jsp");
            }
        }
        catch (Throwable e) {
            this.includeErrorpage(this, e);
        }
    }

    protected boolean isOperationOnMovedResource() {
        Iterator i = this.getResourceList().iterator();
        while (i.hasNext()) {
            String resName = (String)i.next();
            String target = CmsUndoChanges.resourceOriginalPath(this.getCms(), resName);
            if (target == null || target.equals(resName)) continue;
            return true;
        }
        return false;
    }

    public String buildDialogOptions() {
        StringBuffer result = new StringBuffer(256);
        boolean isMoved = this.isOperationOnMovedResource();
        if (!this.isMultiOperation()) {
            result.append(this.dialogSpacer());
            result.append(this.key("GUI_UNDO_LASTMODIFIED_INFO_3", new Object[]{this.getFileName(), this.getLastModifiedDate(), this.getLastModifiedUser()}));
            if (isMoved) {
                result.append(this.dialogSpacer());
                result.append(this.key("GUI_UNDO_MOVE_OPERATION_INFO_2", new Object[]{this.getFileName(), CmsUndoChanges.resourceOriginalPath(this.getCms(), this.getParamResource())}));
            }
        }
        result.append(this.dialogSpacer());
        result.append(this.key("GUI_UNDO_CONFIRMATION_0"));
        if (isMoved || this.isOperationOnFolder()) {
            result.append(this.dialogSpacer());
            result.append("<input type=\"checkbox\" name=\"");
            result.append(PARAM_MOVE);
            result.append("\" value=\"true\" checked='checked'>&nbsp;");
            if (this.isMultiOperation()) {
                result.append(this.key("GUI_UNDO_CHANGES_MOVE_MULTI_SUBRESOURCES_0"));
            } else {
                result.append(this.key("GUI_UNDO_CHANGES_MOVE_SUBRESOURCES_0"));
            }
        } else if (isMoved) {
            result.append(this.dialogSpacer());
            result.append("<input type=\"hidden\" name=\"");
            result.append(PARAM_MOVE);
            result.append("\" value=\"true\">&nbsp;");
        }
        if (this.isOperationOnFolder()) {
            result.append(this.dialogSpacer());
            result.append(this.dialogBlockStart(this.key("GUI_UNDO_CHANGES_RECURSIVE_TITLE_0")));
            result.append("<input type=\"checkbox\" name=\"");
            result.append(PARAM_RECURSIVE);
            result.append("\" value=\"true\">&nbsp;");
            if (this.isMultiOperation()) {
                result.append(this.key("GUI_UNDO_CHANGES_RECURSIVE_MULTI_SUBRESOURCES_0"));
            } else {
                result.append(this.key("GUI_UNDO_CHANGES_RECURSIVE_SUBRESOURCES_0"));
            }
            result.append(this.dialogBlockEnd());
        }
        return result.toString();
    }

    public String getParamMove() {
        return this.m_paramMove;
    }

    public String getParamRecursive() {
        return this.m_paramRecursive;
    }

    public void setParamMove(String paramMove) {
        this.m_paramMove = paramMove;
    }

    public void setParamRecursive(String value) {
        this.m_paramRecursive = value;
    }

    protected CmsResource getCurrentResource() {
        return this.m_currentResource;
    }

    protected String getFileName() {
        return CmsResource.getName(this.getParamResource());
    }

    protected String getLastModifiedDate() {
        long dateLong = this.getCurrentResource().getDateLastModified();
        return this.getMessages().getDateTime(dateLong);
    }

    protected String getLastModifiedUser() {
        CmsUUID userId = this.getCurrentResource().getUserLastModified();
        try {
            return this.getCms().readUser(userId).getName();
        }
        catch (CmsException e) {
            return "";
        }
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        block12: {
            this.fillParamValues(request);
            if (!this.checkResourcePermissions(CmsPermissionSet.ACCESS_WRITE, false)) {
                this.setParamAction("cancel");
            }
            this.setParamDialogtype(DIALOG_TYPE);
            if (DIALOG_TYPE.equals(this.getParamAction())) {
                this.setAction(100);
            } else if ("wait".equals(this.getParamAction())) {
                this.setAction(2);
            } else if ("cancel".equals(this.getParamAction())) {
                this.setAction(4);
            } else if ("locksconfirmed".equals(this.getParamAction())) {
                this.setAction(99);
            } else {
                this.setAction(0);
                this.setDialogTitle("GUI_UNDO_CHANGES_1", "GUI_UNDO_CHANGES_MULTI_2");
            }
            if (!this.isMultiOperation()) {
                try {
                    this.setCurrentResource(this.getCms().readResource(this.getParamResource(), CmsResourceFilter.ALL));
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) break block12;
                    LOG.info((Object)e.getLocalizedMessage());
                }
            }
        }
    }

    protected boolean performDialogOperation() throws CmsException {
        boolean isFolder = this.isOperationOnFolder();
        if ((this.isMultiOperation() || isFolder) && !"wait".equals(this.getParamAction())) {
            return false;
        }
        boolean undoRecursive = Boolean.valueOf(this.getParamRecursive());
        boolean undoMove = Boolean.valueOf(this.getParamMove());
        CmsResource.CmsResourceUndoMode mode = CmsResource.UNDO_CONTENT;
        if (undoRecursive) {
            mode = CmsResource.UNDO_CONTENT_RECURSIVE;
        }
        if (undoMove) {
            mode = mode.includeMove();
        }
        Iterator i = this.getResourceList().iterator();
        while (i.hasNext()) {
            String resName = (String)i.next();
            try {
                this.checkLock(resName);
                this.getCms().undoChanges(resName, mode);
            }
            catch (CmsException e) {
                if (this.isMultiOperation()) {
                    this.addMultiOperationException(e);
                    continue;
                }
                throw e;
            }
        }
        this.checkMultiOperationException(Messages.get(), "ERR_UNDO_CHANGES_MULTI_0");
        return true;
    }

    protected void setCurrentResource(CmsResource res) {
        this.m_currentResource = res;
    }
}

