/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.editors.Messages;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;

public class CmsDialogCopyLanguage
extends CmsDialog {
    public static final int ACTION_UPDATE_LANGUAGES = 310;
    public static final String DIALOG_TYPE = "copylanguages";
    public static final String DIALOG_UPDATE_LANGUAGES = "updatelanguages";
    public static final String PARAM_LANGUAGE = "language";
    private static final Log LOG = CmsLog.getLog(CmsDialogCopyLanguage.class);
    private Locale m_elementLocale;
    private String m_paramElementlanguage;
    private String m_paramTempFile;
    private Set m_paramSelectedLanguages;

    public CmsDialogCopyLanguage(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsDialogCopyLanguage(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionUpdateLanguages() throws JspException {
        if (this.m_paramSelectedLanguages != null && !this.m_paramSelectedLanguages.isEmpty()) {
            try {
                CmsFile file = this.getCms().readFile(this.getParamTempfile(), CmsResourceFilter.IGNORE_EXPIRATION);
                CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.getCms(), file);
                ArrayList<Locale> toLocales = new ArrayList<Locale>();
                Iterator i = this.m_paramSelectedLanguages.iterator();
                while (i.hasNext()) {
                    String language = (String)i.next();
                    toLocales.add(CmsLocaleManager.getLocale(language));
                }
                this.transferContents(content, this.getElementLocale(), toLocales);
                String decodedContent = content.toString();
                try {
                    file.setContents(decodedContent.getBytes(content.getEncoding()));
                }
                catch (UnsupportedEncodingException e) {
                    throw new CmsException(Messages.get().container("ERR_INVALID_CONTENT_ENC_1", this.getParamResource()), (Throwable)e);
                }
                this.getCms().writeFile(file);
            }
            catch (Throwable e) {
                this.setParamMessage(Messages.get().getBundle(this.getLocale()).key("ERR_UPDATE_LANGUAGES_0"));
                this.includeErrorpage(this, e);
            }
        }
    }

    public String buildLanguageList() {
        try {
            StringBuffer retValue = new StringBuffer(512);
            retValue.append("<table border=\"0\">\n");
            Locale elLocale = this.getElementLocale();
            List localeList = OpenCms.getLocaleManager().getAvailableLocales(this.getCms(), this.getParamTempfile());
            CmsFile file = this.getCms().readFile(this.getParamTempfile(), CmsResourceFilter.IGNORE_EXPIRATION);
            CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.getCms(), file);
            Iterator i = localeList.iterator();
            while (i.hasNext()) {
                Locale curLocale = (Locale)i.next();
                if (elLocale.equals(curLocale)) continue;
                retValue.append("<tr>\n");
                retValue.append("\t<td class=\"textcenter\" unselectable=\"on\"><input type=\"checkbox\" name=\"");
                retValue.append(PARAM_LANGUAGE);
                retValue.append("\" value=\"");
                retValue.append(curLocale.toString());
                retValue.append("\">");
                retValue.append("</td>\n");
                retValue.append("\t<td style=\"white-space: nowrap;\" unselectable=\"on\">");
                retValue.append(curLocale.getDisplayName(this.getLocale()));
                retValue.append(!content.hasLocale(curLocale) ? " [-]" : "");
                retValue.append("</td>\n");
                retValue.append("\t<td style=\"white-space: nowrap;\" unselectable=\"on\">");
                retValue.append(!content.hasLocale(curLocale) ? Messages.get().getBundle(this.getLocale()).key("GUI_EDITOR_DIALOG_COPYLANGUAGE_NEW_0") : "");
                retValue.append("</td>\n");
                retValue.append("</tr>\n");
            }
            retValue.append("</table>\n");
            return retValue.toString();
        }
        catch (Throwable e) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)e);
            }
            return "";
        }
    }

    public Locale getElementLocale() {
        if (this.m_elementLocale == null) {
            this.m_elementLocale = CmsLocaleManager.getLocale(this.getParamElementLanguage());
        }
        return this.m_elementLocale;
    }

    public String getParamElementLanguage() {
        return this.m_paramElementlanguage;
    }

    public String getParamTempfile() {
        return this.m_paramTempFile;
    }

    public void setParamElementLanguage(String elementLanguage) {
        this.m_paramElementlanguage = elementLanguage;
    }

    public void setParamLanguage(String language) {
        if (language != null) {
            if (this.m_paramSelectedLanguages == null) {
                this.m_paramSelectedLanguages = new HashSet();
            }
            String[] values = (String[])this.getParameterMap().get(PARAM_LANGUAGE);
            for (int i = 0; i < values.length; ++i) {
                this.m_paramSelectedLanguages.add(this.decodeParamValue(PARAM_LANGUAGE, values[i]));
            }
        }
    }

    public void setParamTempfile(String fileName) {
        this.m_paramTempFile = fileName;
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        this.setParamDialogtype(DIALOG_TYPE);
        if (DIALOG_UPDATE_LANGUAGES.equals(this.getParamAction())) {
            this.setAction(310);
        } else {
            this.setAction(0);
            this.setParamTitle(this.key("GUI_EDITOR_DIALOG_COPYLANGUAGE_TITLE_0"));
        }
    }

    protected void transferContents(CmsXmlContent content, Locale sourceLocale, List destLocales) throws CmsException {
        Iterator i = destLocales.iterator();
        while (i.hasNext()) {
            Locale to = (Locale)i.next();
            if (content.hasLocale(to)) {
                content.removeLocale(to);
            }
            content.copyLocale(sourceLocale, to);
        }
    }
}

