/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResourceFilter;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.workplace.editors.Messages;

public class CmsEditorDisplayOptions {
    public static final String FOLDER_EDITORCONFIGURATION = "/system/workplace/editors/configuration/";
    public static final String NO_MAPPING_FOR_USER = "na";
    public static final int SIZE_CONFIGURATIONFILES = 12;
    public static final int SIZE_USERENTRIES = 100;
    private static final Log LOG = CmsLog.getLog(CmsEditorDisplayOptions.class);
    private Map m_loadedConfigurations;
    private Map m_userMappings = new LRUMap(100);

    public CmsEditorDisplayOptions() {
        this.m_loadedConfigurations = new LRUMap(12);
    }

    public synchronized void clearCache() {
        this.m_userMappings.clear();
        this.m_loadedConfigurations.clear();
    }

    public Properties getDisplayOptions(CmsJspActionElement jsp) {
        return this.getDisplayOptions(jsp.getCmsObject());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties getDisplayOptions(CmsObject cms) {
        Properties displayOptions;
        String mappedConfigFile = (String)this.m_userMappings.get(cms.getRequestContext().currentUser().getName());
        if (mappedConfigFile == null) {
            List items = CmsJspNavBuilder.getNavigationForFolder(cms, FOLDER_EDITORCONFIGURATION);
            if (items.size() > 0) {
                CmsJspNavElement nav = (CmsJspNavElement)items.get(0);
                mappedConfigFile = nav.getFileName();
                Map map = this.m_loadedConfigurations;
                synchronized (map) {
                    displayOptions = (Properties)this.m_loadedConfigurations.get(nav.getFileName());
                    if (displayOptions == null) {
                        try {
                            CmsFile optionFile = cms.readFile(nav.getResourceName(), CmsResourceFilter.IGNORE_EXPIRATION);
                            ByteArrayInputStream in = new ByteArrayInputStream(optionFile.getContents());
                            displayOptions = new Properties();
                            displayOptions.load(in);
                            this.m_loadedConfigurations.put(nav.getFileName(), displayOptions);
                        }
                        catch (CmsException e) {
                            if (LOG.isInfoEnabled()) {
                                LOG.info((Object)e);
                            }
                            mappedConfigFile = NO_MAPPING_FOR_USER;
                        }
                        catch (IOException e) {
                            if (LOG.isInfoEnabled()) {
                                LOG.info((Object)e);
                            }
                            mappedConfigFile = NO_MAPPING_FOR_USER;
                            displayOptions = null;
                        }
                    }
                }
            }
            mappedConfigFile = NO_MAPPING_FOR_USER;
            displayOptions = null;
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_MAP_CONFIG_FILE_TO_USER_2", mappedConfigFile, cms.getRequestContext().currentUser().getName()));
            }
            this.m_userMappings.put(cms.getRequestContext().currentUser().getName(), mappedConfigFile);
        } else {
            displayOptions = (Properties)this.m_loadedConfigurations.get(mappedConfigFile);
        }
        return displayOptions;
    }

    public boolean showElement(String key, Properties displayOptions) {
        return displayOptions != null && Boolean.valueOf(displayOptions.getProperty(key)) != false;
    }
}

