/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.collectors.I_CmsResourceCollector;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.editors.CmsEditor;
import org.opencms.workplace.editors.CmsXmlContentWidgetVisitor;
import org.opencms.workplace.editors.I_CmsEditorActionHandler;
import org.opencms.workplace.editors.Messages;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentErrorHandler;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentValueSequence;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsXmlContentEditor
extends CmsEditor
implements I_CmsWidgetDialog {
    public static final int ACTION_CHECK = 151;
    public static final int ACTION_CONFIRMCORRECTION = 152;
    public static final int ACTION_COPYLOCALE = 141;
    public static final int ACTION_CORRECTIONCONFIRMED = 153;
    public static final int ACTION_ELEMENT_ADD = 154;
    public static final int ACTION_ELEMENT_MOVE_DOWN = 155;
    public static final int ACTION_ELEMENT_MOVE_UP = 156;
    public static final int ACTION_ELEMENT_REMOVE = 157;
    public static final int ACTION_NEW = 158;
    public static final String EDITOR_ACTION_CHECK = "check";
    public static final String EDITOR_ACTION_CONFIRMCORRECTION = "confirmcorrect";
    public static final String EDITOR_ACTION_ELEMENT_ADD = "addelement";
    public static final String EDITOR_ACTION_ELEMENT_MOVE_DOWN = "elementdown";
    public static final String EDITOR_ACTION_ELEMENT_MOVE_UP = "elementup";
    public static final String EDITOR_ACTION_ELEMENT_REMOVE = "removeelement";
    public static final String EDITOR_ACTION_NEW = "new";
    public static final String EDITOR_COPYLOCALE = "copylocale";
    public static final String EDITOR_CORRECTIONCONFIRMED = "correctconfirmed";
    public static final String PARAM_ELEMENTINDEX = "elementindex";
    public static final String PARAM_ELEMENTNAME = "elementname";
    public static final String PARAM_NEWLINK = "newlink";
    private static final String EDITOR_TYPE = "xmlcontent";
    private static final Log LOG = CmsLog.getLog(CmsXmlContentEditor.class);
    private CmsXmlContent m_content;
    private Locale m_elementLocale;
    private CmsFile m_file;
    private Set m_helpMessageIds;
    private boolean m_optionalElementPresent;
    private String m_paramElementIndex;
    private String m_paramElementName;
    private String m_paramModelFile;
    private String m_paramNewLink;
    private CmsXmlContentErrorHandler m_validationHandler;
    private CmsXmlContentWidgetVisitor m_widgetCollector;

    public CmsXmlContentEditor(CmsJspActionElement jsp) {
        super(jsp);
    }

    public void actionChangeElementLanguage() {
        block11: {
            Locale oldLocale = CmsLocaleManager.getLocale(this.getParamOldelementlanguage());
            Locale newLocale = this.getElementLocale();
            try {
                this.setEditorValues(oldLocale);
                if (!this.m_content.validate(this.getCms()).hasErrors(oldLocale)) {
                    block10: {
                        if (!this.m_content.hasLocale(newLocale)) {
                            boolean addNew = true;
                            List locales = OpenCms.getLocaleManager().getDefaultLocales(this.getCms(), this.getParamResource());
                            if (locales.size() > 1) {
                                try {
                                    this.m_content.copyLocale(locales, newLocale);
                                    addNew = false;
                                }
                                catch (CmsXmlException e) {
                                    // empty catch block
                                }
                            }
                            if (addNew) {
                                try {
                                    this.m_content.addLocale(this.getCms(), newLocale);
                                }
                                catch (CmsXmlException e) {
                                    if (!LOG.isErrorEnabled()) break block10;
                                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                                }
                            }
                        }
                    }
                    this.writeContent();
                    this.setAction(0);
                    break block11;
                }
                this.setParamElementlanguage(this.getParamOldelementlanguage());
                this.m_elementLocale = null;
            }
            catch (Exception e) {
                if (!LOG.isInfoEnabled()) break block11;
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public void actionClear(boolean forceUnlock) {
        block3: {
            this.deleteTempFile();
            boolean directEditMode = Boolean.valueOf(this.getParamDirectedit());
            boolean modified = Boolean.valueOf(this.getParamModified());
            if (directEditMode || forceUnlock || !modified) {
                try {
                    this.getCms().unlockResource(this.getParamResource());
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) break block3;
                    LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    public void actionCopyElementLocale() throws JspException {
        try {
            this.setEditorValues(this.getElementLocale());
            if (!this.hasValidationErrors()) {
                this.writeContent();
                this.getCms().setDateReleased(this.getParamTempfile(), 0L, false);
                this.getCms().setDateExpired(this.getParamTempfile(), Long.MAX_VALUE, false);
            }
        }
        catch (CmsException e) {
            this.showErrorPage(this, e);
        }
    }

    public void actionDeleteElementLocale() throws JspException {
        block6: {
            try {
                Locale loc = this.getElementLocale();
                this.m_content.removeLocale(loc);
                this.writeContent();
                List locales = this.m_content.getLocales();
                if (locales.size() > 0) {
                    Locale newLoc = (Locale)locales.get(0);
                    this.setParamElementlanguage(newLoc.toString());
                    this.m_elementLocale = newLoc;
                } else if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_GET_LOCALES_1", this.getParamResource()));
                }
            }
            catch (CmsXmlException e) {
                this.showErrorPage(e);
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block6;
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public void actionDirectEdit() throws IOException, JspException, ServletException {
        I_CmsEditorActionHandler actionClass = OpenCms.getWorkplaceManager().getEditorActionHandler();
        if (actionClass == null) {
            this.actionSave();
            this.actionExit();
        } else {
            actionClass.editorAction(this, this.getJsp());
        }
    }

    public void actionExit() throws IOException, JspException, ServletException {
        if (this.getAction() == 4) {
            return;
        }
        this.actionClear(false);
        this.actionClose();
    }

    public void actionMoveElement() throws JspException {
        try {
            this.setEditorValues(this.getElementLocale());
        }
        catch (CmsXmlException e) {
            this.showErrorPage(e);
            return;
        }
        int index = 0;
        try {
            index = Integer.parseInt(this.getParamElementIndex());
        }
        catch (Exception e) {
            // empty catch block
        }
        I_CmsXmlContentValue value = this.m_content.getValue(this.getParamElementName(), this.getElementLocale(), index);
        if (this.getAction() == 155) {
            value.moveDown();
        } else {
            value.moveUp();
        }
        if (this.getValidationHandler().hasWarnings(this.getElementLocale())) {
            this.resetErrorHandler();
        }
        try {
            this.writeContent();
        }
        catch (CmsException e) {
            this.showErrorPage(e);
        }
    }

    public void actionNew() throws JspException {
        int pos = this.m_paramNewLink.indexOf(124);
        String collectorName = this.m_paramNewLink.substring(0, pos);
        String param = this.m_paramNewLink.substring(pos + 1);
        I_CmsResourceCollector collector = OpenCms.getResourceManager().getContentCollector(collectorName);
        String newFileName = "";
        try {
            CmsFile templateFile = this.getCms().readFile(this.getParamResource(), CmsResourceFilter.IGNORE_EXPIRATION);
            CmsXmlContent template = CmsXmlContentFactory.unmarshal(this.getCloneCms(), templateFile);
            Locale locale = (Locale)OpenCms.getLocaleManager().getDefaultLocales(this.getCms(), this.getParamResource()).get(0);
            CmsXmlContent newContent = CmsXmlContentFactory.createDocument(this.getCms(), locale, template.getEncoding(), template.getContentDefinition());
            newFileName = collector.getCreateLink(this.getCms(), collectorName, param);
            boolean useModelFile = false;
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getParamModelFile())) {
                this.getCms().getRequestContext().setAttribute(CmsRequestContext.ATTRIBUTE_MODEL, this.getParamModelFile());
                useModelFile = true;
            }
            this.getCms().createResource(newFileName, templateFile.getTypeId());
            CmsFile newFile = this.getCms().readFile(newFileName, CmsResourceFilter.ALL);
            if (!useModelFile) {
                newFile.setContents(newContent.marshal());
                this.getCloneCms().writeFile(newFile);
            }
            this.setParamNewLink(null);
            this.setParamAction(null);
            this.setParamResource(newFileName);
            this.setAction(0);
            this.setParamTempfile(this.createTempFile());
            this.m_file = this.getCms().readFile(this.getParamTempfile(), CmsResourceFilter.ALL);
            this.m_content = !useModelFile ? newContent : CmsXmlContentFactory.unmarshal(this.getCms(), this.m_file);
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_CREATE_XML_CONTENT_ITEM_1", this.m_paramNewLink), (Throwable)e);
            }
            throw new JspException((Throwable)e);
        }
        finally {
            try {
                this.getCms().deleteResource(newFileName, CmsResource.DELETE_REMOVE_SIBLINGS);
            }
            catch (CmsException e) {}
        }
    }

    public void actionPreview() throws IOException, JspException {
        try {
            this.setEditorValues(this.getElementLocale());
            this.writeContent();
            this.getCms().setDateReleased(this.getParamTempfile(), 0L, false);
            this.getCms().setDateExpired(this.getParamTempfile(), Long.MAX_VALUE, false);
        }
        catch (CmsException e) {
            this.showErrorPage(this, e);
        }
        String previewUri = this.m_content.getContentDefinition().getContentHandler().getPreview(this.getCms(), this.m_content, this.getParamTempfile());
        StringBuffer param = new StringBuffer(8);
        if (previewUri.indexOf(63) != -1) {
            param.append("&");
        } else {
            param.append("?");
        }
        param.append("__locale");
        param.append("=");
        param.append(this.getParamElementlanguage());
        this.sendCmsRedirect(previewUri + param);
    }

    public void actionSave() throws JspException {
        this.actionSave(this.getElementLocale());
        if (this.getAction() != 4) {
            this.setAction(121);
        }
    }

    public void actionSave(Locale locale) throws JspException {
        try {
            this.setEditorValues(locale);
            if (!this.hasValidationErrors()) {
                this.writeContent();
                this.commitTempFile();
                this.setParamModified(Boolean.TRUE.toString());
            }
        }
        catch (CmsException e) {
            this.showErrorPage(e);
        }
    }

    public void actionToggleElement() throws JspException {
        try {
            this.setEditorValues(this.getElementLocale());
        }
        catch (CmsXmlException e) {
            this.showErrorPage(e);
            return;
        }
        int index = 0;
        try {
            index = Integer.parseInt(this.getParamElementIndex());
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.getAction() == 157) {
            this.m_content.removeValue(this.getParamElementName(), this.getElementLocale(), index);
        } else {
            if (this.m_content.hasValue(this.getParamElementName(), this.getElementLocale())) {
                ++index;
            }
            this.m_content.addValue(this.getCms(), this.getParamElementName(), this.getElementLocale(), index);
        }
        if (this.getValidationHandler().hasWarnings(this.getElementLocale())) {
            this.resetErrorHandler();
        }
        try {
            this.writeContent();
        }
        catch (CmsException e) {
            this.showErrorPage(e);
        }
    }

    public String buildSelectElementLanguage(String attributes) {
        return this.buildSelectElementLanguage(attributes, this.getParamResource(), this.getElementLocale());
    }

    public int getButtonStyle() {
        return this.getSettings().getUserSettings().getEditorButtonStyle();
    }

    public String getEditorResourceUri() {
        return CmsXmlContentEditor.getSkinUri() + "editors/" + EDITOR_TYPE + "/";
    }

    public Locale getElementLocale() {
        if (this.m_elementLocale == null) {
            if (CmsStringUtil.isNotEmpty(this.getParamElementlanguage()) && !"null".equals(this.getParamElementlanguage())) {
                this.m_elementLocale = CmsLocaleManager.getLocale(this.getParamElementlanguage());
            } else {
                this.initElementLanguage();
                this.m_elementLocale = CmsLocaleManager.getLocale(this.getParamElementlanguage());
            }
        }
        return this.m_elementLocale;
    }

    public Set getHelpMessageIds() {
        if (this.m_helpMessageIds == null) {
            this.m_helpMessageIds = new HashSet();
        }
        return this.m_helpMessageIds;
    }

    public String getParamElementIndex() {
        return this.m_paramElementIndex;
    }

    public String getParamElementName() {
        return this.m_paramElementName;
    }

    public String getParamModelFile() {
        return this.m_paramModelFile;
    }

    public String getParamNewLink() {
        return this.m_paramNewLink;
    }

    public String getUserAgent() {
        return this.getJsp().getRequest().getHeader("user-agent");
    }

    public CmsXmlContentWidgetVisitor getWidgetCollector() {
        if (this.m_widgetCollector == null) {
            this.m_widgetCollector = new CmsXmlContentWidgetVisitor(this.getElementLocale());
            this.m_content.visitAllValuesWith(this.m_widgetCollector);
        }
        return this.m_widgetCollector;
    }

    public String getXmlEditorForm() {
        this.getCms().getRequestContext().setAttribute(CmsRequestContext.ATTRIBUTE_EDITOR, Boolean.TRUE);
        this.addMessages(this.m_content.getContentDefinition().getContentHandler().getMessages(this.getLocale()));
        return this.getXmlEditorForm(this.m_content.getContentDefinition(), "", true).toString();
    }

    public String getXmlEditorHtmlEnd() throws JspException {
        StringBuffer result = new StringBuffer(16384);
        if (this.m_optionalElementPresent) {
            this.resetWidgetCollector();
        }
        try {
            Iterator i = this.getWidgetCollector().getWidgets().keySet().iterator();
            while (i.hasNext()) {
                String key = (String)i.next();
                I_CmsXmlContentValue value = (I_CmsXmlContentValue)this.getWidgetCollector().getValues().get(key);
                I_CmsWidget widget = (I_CmsWidget)this.getWidgetCollector().getWidgets().get(key);
                result.append(widget.getDialogHtmlEnd(this.getCms(), this, (I_CmsWidgetParameter)((Object)value)));
            }
            result.append("<div class=\"help\" id=\"helpText\" ");
            result.append("onmouseover=\"showHelpText();\" onmouseout=\"hideHelpText();\"></div>\n");
            result.append("<div class=\"xmlButtons\" id=\"xmlElementButtons\" ");
            result.append("onmouseover=\"checkElementButtons(true);\" onmouseout=\"checkElementButtons(false);\"></div>\n");
            return result.toString();
        }
        catch (Exception e) {
            this.showErrorPage(e);
            return "";
        }
    }

    public String getXmlEditorIncludes() throws JspException {
        StringBuffer result = new StringBuffer(32);
        try {
            Iterator i = this.getWidgetCollector().getUniqueWidgets().iterator();
            while (i.hasNext()) {
                I_CmsWidget widget = (I_CmsWidget)i.next();
                result.append(widget.getDialogIncludes(this.getCms(), this));
                result.append("\n");
            }
        }
        catch (Exception e) {
            this.showErrorPage(e);
        }
        return result.toString();
    }

    public String getXmlEditorInitCalls() throws JspException {
        StringBuffer result = new StringBuffer(32);
        try {
            Iterator i = this.getWidgetCollector().getUniqueWidgets().iterator();
            while (i.hasNext()) {
                I_CmsWidget widget = (I_CmsWidget)i.next();
                result.append(widget.getDialogInitCall(this.getCms(), this));
            }
        }
        catch (Exception e) {
            this.showErrorPage(e);
        }
        return result.toString();
    }

    public String getXmlEditorInitMethods() throws JspException {
        StringBuffer result = new StringBuffer(32);
        try {
            Iterator i = this.getWidgetCollector().getUniqueWidgets().iterator();
            while (i.hasNext()) {
                I_CmsWidget widget = (I_CmsWidget)i.next();
                result.append(widget.getDialogInitMethod(this.getCms(), this));
                result.append("\n");
            }
        }
        catch (Exception e) {
            this.showErrorPage(e);
        }
        return result.toString();
    }

    public boolean hasValidationErrors() {
        return this.getValidationHandler().hasErrors();
    }

    public boolean isPreviewEnabled() {
        try {
            CmsFile file = this.getCms().readFile(this.getParamResource(), CmsResourceFilter.ALL);
            CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.getCloneCms(), file);
            return content.getContentDefinition().getContentHandler().getPreview(this.getCms(), this.m_content, this.getParamResource()) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setEditorValues(Locale locale) throws CmsXmlException {
        List valueNames = this.getSimpleValueNames(this.m_content.getContentDefinition(), "", locale);
        Iterator i = valueNames.iterator();
        while (i.hasNext()) {
            String valueName = (String)i.next();
            I_CmsXmlContentValue value = this.m_content.getValue(valueName, locale);
            I_CmsWidget widget = value.getContentDefinition().getContentHandler().getWidget(value);
            widget.setEditorValue(this.getCms(), this.getJsp().getRequest().getParameterMap(), this, (I_CmsWidgetParameter)((Object)value));
        }
    }

    public void setParamElementIndex(String elementIndex) {
        this.m_paramElementIndex = elementIndex;
    }

    public void setParamElementName(String elementName) {
        this.m_paramElementName = elementName;
    }

    public void setParamModelFile(String paramMasterFile) {
        this.m_paramModelFile = paramMasterFile;
    }

    public void setParamNewLink(String paramNewLink) {
        this.m_paramNewLink = CmsEncoder.decode(paramNewLink);
    }

    public boolean showElementLanguageSelector() {
        List locales = OpenCms.getLocaleManager().getAvailableLocales(this.getCms(), this.getParamResource());
        return locales != null && locales.size() >= 2;
    }

    public boolean useNewStyle() {
        return false;
    }

    protected void commitTempFile() throws CmsException {
        super.commitTempFile();
        this.m_file = this.getCloneCms().readFile(this.getParamResource());
        this.m_content = CmsXmlContentFactory.unmarshal(this.getCloneCms(), this.m_file);
    }

    protected void initContent() {
    }

    protected void initElementLanguage() {
        List locales = OpenCms.getLocaleManager().getDefaultLocales(this.getCms(), this.getParamResource());
        Locale locale = (Locale)locales.get(0);
        if (this.m_content != null) {
            if (locales.size() > 1 && this.m_content.getLocales().size() > 0 && !this.m_content.hasLocale(locale)) {
                try {
                    this.m_content.copyLocale(locales, locale);
                    this.writeContent();
                }
                catch (CmsException cmsException) {
                    // empty catch block
                }
            }
            if (!this.m_content.hasLocale(locale)) {
                locale = (Locale)this.m_content.getLocales().get(0);
            }
        }
        this.setParamElementlanguage(locale.toString());
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        block75: {
            block69: {
                this.fillParamValues(request);
                this.setParamDialogtype(EDITOR_TYPE);
                if (this.getParamNewLink() != null) {
                    this.setParamAction(EDITOR_ACTION_NEW);
                } else if (this.getParamTempfile() != null && !"null".equals(this.getParamTempfile())) {
                    try {
                        this.m_file = this.getCms().readFile(this.getParamTempfile(), CmsResourceFilter.ALL);
                        this.m_content = CmsXmlContentFactory.unmarshal(this.getCloneCms(), this.m_file);
                    }
                    catch (CmsException e) {
                        try {
                            this.showErrorPage(this, e);
                        }
                        catch (JspException exc) {
                            if (!LOG.isInfoEnabled()) break block69;
                            LOG.info((Object)exc);
                        }
                    }
                }
            }
            if ("save".equals(this.getParamAction())) {
                this.setAction(121);
            } else if ("saveexit".equals(this.getParamAction())) {
                this.setAction(123);
            } else if ("exit".equals(this.getParamAction())) {
                this.setAction(122);
            } else {
                if ("closebrowser".equals(this.getParamAction())) {
                    this.actionClear(true);
                    return;
                }
                if (EDITOR_ACTION_CHECK.equals(this.getParamAction())) {
                    this.setAction(151);
                } else if ("saveaction".equals(this.getParamAction())) {
                    block70: {
                        this.setAction(130);
                        try {
                            this.actionDirectEdit();
                        }
                        catch (Exception e) {
                            if (!LOG.isInfoEnabled()) break block70;
                            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    this.setAction(122);
                } else if (EDITOR_COPYLOCALE.equals(this.getParamAction())) {
                    this.setAction(141);
                } else if ("deletelocale".equals(this.getParamAction())) {
                    this.setAction(140);
                } else if ("show".equals(this.getParamAction())) {
                    this.setAction(125);
                } else if ("error".equals(this.getParamAction())) {
                    this.setAction(127);
                } else if ("changeelement".equals(this.getParamAction())) {
                    this.setAction(125);
                    this.actionChangeElementLanguage();
                } else if (EDITOR_ACTION_ELEMENT_ADD.equals(this.getParamAction())) {
                    block71: {
                        this.setAction(154);
                        try {
                            this.actionToggleElement();
                        }
                        catch (JspException e) {
                            if (!LOG.isErrorEnabled()) break block71;
                            LOG.error((Object)org.opencms.workplace.Messages.get().getBundle().key("LOG_INCLUDE_ERRORPAGE_FAILED_0"));
                        }
                    }
                    if (this.getAction() != 4 && this.getAction() != 127) {
                        this.setAction(125);
                    }
                } else if (EDITOR_ACTION_ELEMENT_REMOVE.equals(this.getParamAction())) {
                    block72: {
                        this.setAction(157);
                        try {
                            this.actionToggleElement();
                        }
                        catch (JspException e) {
                            if (!LOG.isErrorEnabled()) break block72;
                            LOG.error((Object)org.opencms.workplace.Messages.get().getBundle().key("LOG_INCLUDE_ERRORPAGE_FAILED_0"));
                        }
                    }
                    if (this.getAction() != 4 && this.getAction() != 127) {
                        this.setAction(125);
                    }
                } else if (EDITOR_ACTION_ELEMENT_MOVE_DOWN.equals(this.getParamAction())) {
                    block73: {
                        this.setAction(155);
                        try {
                            this.actionMoveElement();
                        }
                        catch (JspException e) {
                            if (!LOG.isErrorEnabled()) break block73;
                            LOG.error((Object)org.opencms.workplace.Messages.get().getBundle().key("LOG_INCLUDE_ERRORPAGE_FAILED_0"));
                        }
                    }
                    if (this.getAction() != 4 && this.getAction() != 127) {
                        this.setAction(125);
                    }
                } else if (EDITOR_ACTION_ELEMENT_MOVE_UP.equals(this.getParamAction())) {
                    block74: {
                        this.setAction(156);
                        try {
                            this.actionMoveElement();
                        }
                        catch (JspException e) {
                            if (!LOG.isErrorEnabled()) break block74;
                            LOG.error((Object)org.opencms.workplace.Messages.get().getBundle().key("LOG_INCLUDE_ERRORPAGE_FAILED_0"));
                        }
                    }
                    if (this.getAction() != 4 && this.getAction() != 127) {
                        this.setAction(125);
                    }
                } else {
                    if (EDITOR_ACTION_NEW.equals(this.getParamAction())) {
                        this.setAction(158);
                        return;
                    }
                    if ("preview".equals(this.getParamAction())) {
                        this.setAction(126);
                    } else {
                        block76: {
                            if (EDITOR_CORRECTIONCONFIRMED.equals(this.getParamAction())) {
                                this.setAction(125);
                                try {
                                    this.correctXmlStructure();
                                }
                                catch (CmsException e) {
                                    try {
                                        this.showErrorPage(this, e);
                                        break block75;
                                    }
                                    catch (JspException exc) {
                                        if (LOG.isInfoEnabled()) {
                                            LOG.info((Object)exc);
                                        }
                                        break block75;
                                    }
                                }
                            }
                            this.setAction(0);
                            try {
                                if (Boolean.valueOf(this.getParamDirectedit()).booleanValue()) {
                                    this.checkLock(this.getParamResource(), CmsLockType.TEMPORARY);
                                } else {
                                    this.checkLock(this.getParamResource());
                                }
                                this.setParamTempfile(this.createTempFile());
                                this.m_file = this.getCms().readFile(this.getParamTempfile(), CmsResourceFilter.ALL);
                                this.m_content = CmsXmlContentFactory.unmarshal(this.getCloneCms(), this.m_file);
                                try {
                                    this.m_content.validateXmlStructure(new CmsXmlEntityResolver(this.getCms()));
                                }
                                catch (CmsXmlException eXml) {
                                    if (OpenCms.getWorkplaceManager().isXmlContentAutoCorrect()) {
                                        this.correctXmlStructure();
                                        break block76;
                                    }
                                    this.setAction(152);
                                }
                            }
                            catch (CmsException e) {
                                try {
                                    this.showErrorPage(this, e);
                                }
                                catch (JspException exc) {
                                    if (!LOG.isInfoEnabled()) break block76;
                                    LOG.info((Object)exc);
                                }
                            }
                        }
                        if (this.getParamElementlanguage() == null) {
                            this.initElementLanguage();
                        }
                    }
                }
            }
        }
    }

    private String buildElementButtons(String elementName, int index, boolean addElement, boolean removeElement) {
        String result;
        StringBuffer jsCall = new StringBuffer(512);
        boolean buttonPresent = false;
        jsCall.append("showElementButtons('");
        jsCall.append(elementName);
        jsCall.append("', ");
        jsCall.append(index);
        jsCall.append(", ");
        if (removeElement) {
            jsCall.append(Boolean.TRUE);
            buttonPresent = true;
        } else {
            jsCall.append(Boolean.FALSE);
        }
        jsCall.append(", ");
        if (index > 0) {
            jsCall.append(Boolean.TRUE);
            buttonPresent = true;
        } else {
            jsCall.append(Boolean.FALSE);
        }
        jsCall.append(", ");
        int indexCount = this.m_content.getIndexCount(elementName, this.getElementLocale());
        if (index < indexCount - 1) {
            jsCall.append(Boolean.TRUE);
            buttonPresent = true;
        } else {
            jsCall.append(Boolean.FALSE);
        }
        jsCall.append(", ");
        if (addElement) {
            jsCall.append(Boolean.TRUE);
            buttonPresent = true;
        } else {
            jsCall.append(Boolean.FALSE);
        }
        jsCall.append(");");
        if (buttonPresent) {
            StringBuffer action;
            String btIcon = "xmledit.png";
            String btAction = jsCall.toString();
            if (addElement && removeElement) {
                btIcon = "xmledit_del_add.png";
            } else if (addElement) {
                btIcon = "xmledit_add.png";
                action = new StringBuffer(128);
                action.append("addElement('");
                action.append(elementName);
                action.append("', ");
                action.append(index);
                action.append(");");
                btAction = action.toString();
            } else if (removeElement) {
                btIcon = "xmledit_del.png";
                action = new StringBuffer(128);
                action.append("removeElement('");
                action.append(elementName);
                action.append("', ");
                action.append(index);
                action.append(");");
                btAction = action.toString();
            }
            StringBuffer href = new StringBuffer(512);
            href.append("javascript:");
            href.append(btAction);
            href.append("\" onmouseover=\"");
            href.append(jsCall);
            href.append("checkElementButtons(true);\" onmouseout=\"checkElementButtons(false);\" id=\"btimg.");
            href.append(elementName).append(".").append(index);
            result = this.button(href.toString(), null, btIcon, "GUI_EDITOR_XMLCONTENT_ELEMENT_BUTTONS_0", 0);
        } else {
            result = this.buttonBarSpacer(1);
        }
        return result;
    }

    private void correctXmlStructure() throws CmsException {
        this.m_content.setAutoCorrectionEnabled(true);
        this.m_content.correctXmlStructure(this.getCms());
        this.writeContent();
    }

    private List getSimpleValueNames(CmsXmlContentDefinition contentDefinition, String pathPrefix, Locale locale) {
        ArrayList<String> valueNames = new ArrayList<String>();
        Iterator i = contentDefinition.getTypeSequence().iterator();
        while (i.hasNext()) {
            I_CmsXmlSchemaType type = (I_CmsXmlSchemaType)i.next();
            String name = pathPrefix + type.getName();
            CmsXmlContentValueSequence elementSequence = this.m_content.getValueSequence(name, locale);
            int elementCount = elementSequence.getElementCount();
            for (int j = 0; j < elementCount; ++j) {
                I_CmsXmlContentValue value = elementSequence.getValue(j);
                StringBuffer xPath = new StringBuffer(pathPrefix.length() + 16);
                xPath.append(pathPrefix);
                xPath.append(CmsXmlUtils.createXpathElement(type.getName(), value.getIndex() + 1));
                if (!type.isSimpleType()) {
                    CmsXmlNestedContentDefinition nestedSchema = (CmsXmlNestedContentDefinition)type;
                    xPath.append("/");
                    valueNames.addAll(this.getSimpleValueNames(nestedSchema.getNestedContentDefinition(), xPath.toString(), locale));
                    continue;
                }
                valueNames.add(xPath.toString());
            }
        }
        return valueNames;
    }

    private CmsXmlContentErrorHandler getValidationHandler() {
        if (this.m_validationHandler == null) {
            this.m_validationHandler = this.m_content.validate(this.getCms());
        }
        return this.m_validationHandler;
    }

    private StringBuffer getXmlEditorForm(CmsXmlContentDefinition contentDefinition, String pathPrefix, boolean showHelpBubble) {
        StringBuffer result = new StringBuffer(1024);
        boolean showErrors = this.getAction() != 158 && this.getAction() != 0;
        try {
            boolean nested = CmsStringUtil.isNotEmpty(pathPrefix);
            result.append("<table class=\"xmlTable");
            if (nested) {
                result.append("Nested");
            }
            result.append("\">\n");
            if (!nested && showErrors && this.getValidationHandler().hasErrors()) {
                result.append("<tr><td colspan=\"4\">&nbsp;</td></tr>\n");
                result.append("<tr><td colspan=\"2\">&nbsp;</td>");
                result.append("<td class=\"xmlTdErrorHeader\">");
                result.append(this.key("ERR_EDITOR_XMLCONTENT_VALIDATION_ERROR_TITLE_0"));
                result.append("</td><td>&nbsp;");
                result.append("</td></tr>\n");
                if (this.getValidationHandler().getErrors(this.getElementLocale()) == null || this.getValidationHandler().getErrors().size() > this.getValidationHandler().getErrors(this.getElementLocale()).size()) {
                    Map locErrors = this.getValidationHandler().getErrors();
                    Iterator locErrorsIter = locErrors.entrySet().iterator();
                    while (locErrorsIter.hasNext()) {
                        Map.Entry locEntry = locErrorsIter.next();
                        Locale locale = (Locale)locEntry.getKey();
                        if (this.getElementLocale().equals(locale)) continue;
                        result.append("<tr><td colspan=\"2\">&nbsp;</td>");
                        result.append("<td class=\"xmlTdError\">");
                        result.append(this.key("ERR_EDITOR_XMLCONTENT_VALIDATION_ERROR_LANG_1", new Object[]{locale.getLanguage()}));
                        result.append("</td><td>&nbsp;");
                        result.append("</td></tr>\n");
                        result.append("<tr><td colspan=\"2\">&nbsp;</td>");
                        result.append("<td class=\"xmlTdError\">");
                        result.append("<ul>");
                        Map elErrors = (Map)locEntry.getValue();
                        Iterator elErrorsIter = elErrors.entrySet().iterator();
                        while (elErrorsIter.hasNext()) {
                            Map.Entry elEntry = elErrorsIter.next();
                            String nodeName = (String)elEntry.getKey();
                            String errorMsg = (String)elEntry.getValue();
                            result.append("<li>");
                            result.append(nodeName);
                            result.append(": ");
                            result.append(errorMsg);
                            result.append("</li>\n");
                        }
                        result.append("</ul>");
                        result.append("</td><td>&nbsp;");
                        result.append("</td></tr>\n");
                    }
                }
            }
            Iterator i = contentDefinition.getTypeSequence().iterator();
            while (i.hasNext()) {
                I_CmsXmlSchemaType type = (I_CmsXmlSchemaType)i.next();
                CmsXmlContentDefinition nestedContentDefinition = contentDefinition;
                if (!type.isSimpleType()) {
                    CmsXmlNestedContentDefinition nestedSchema = (CmsXmlNestedContentDefinition)type;
                    nestedContentDefinition = nestedSchema.getNestedContentDefinition();
                }
                String name = pathPrefix + type.getName();
                CmsXmlContentValueSequence elementSequence = this.m_content.getValueSequence(name, this.getElementLocale());
                int elementCount = elementSequence.getElementCount();
                boolean addValue = false;
                if (elementCount < type.getMaxOccurs()) {
                    addValue = true;
                }
                boolean removeValue = false;
                if (elementCount > type.getMinOccurs()) {
                    removeValue = true;
                }
                boolean disabledElement = false;
                if (elementCount < 1) {
                    elementCount = 1;
                    elementSequence.addValue(this.getCms(), 0);
                    disabledElement = true;
                    this.m_optionalElementPresent = true;
                }
                for (int j = 0; j < elementCount; ++j) {
                    I_CmsXmlContentValue value = elementSequence.getValue(j);
                    I_CmsWidget widget = null;
                    if (type.isSimpleType()) {
                        widget = contentDefinition.getContentHandler().getWidget(value);
                    }
                    String key = value.getPath();
                    if (showErrors && this.getValidationHandler().hasErrors(this.getElementLocale()) && this.getValidationHandler().getErrors(this.getElementLocale()).containsKey(key)) {
                        result.append("<tr><td></td><td><img src=\"");
                        result.append(this.getEditorResourceUri());
                        result.append("error.png");
                        result.append("\" border=\"0\" alt=\"\"></td><td class=\"xmlTdError\">");
                        result.append(this.resolveMacros((String)this.getValidationHandler().getErrors(this.getElementLocale()).get(key)));
                        result.append("</td><td></td></tr>\n");
                    }
                    if (showErrors && this.getValidationHandler().hasWarnings(this.getElementLocale()) && this.getValidationHandler().getWarnings(this.getElementLocale()).containsKey(key)) {
                        result.append("<tr><td></td><td><img src=\"");
                        result.append(this.getEditorResourceUri());
                        result.append("warning.png");
                        result.append("\" border=\"0\" alt=\"\"></td><td class=\"xmlTdWarning\">");
                        result.append(this.resolveMacros((String)this.getValidationHandler().getWarnings(this.getElementLocale()).get(key)));
                        result.append("</td><td></td></tr>\n");
                    }
                    result.append("<tr>");
                    result.append("<td class=\"xmlLabel");
                    if (disabledElement) {
                        result.append("Disabled");
                    }
                    result.append("\">");
                    result.append(this.keyDefault(A_CmsWidget.getLabelKey((I_CmsWidgetParameter)((Object)value)), value.getName()));
                    if (elementCount > 1) {
                        result.append(" [").append(value.getIndex() + 1).append("]");
                    }
                    result.append(": </td>");
                    if (showHelpBubble && widget != null && value.getIndex() == 0) {
                        result.append(widget.getHelpBubble(this.getCms(), this, (I_CmsWidgetParameter)((Object)value)));
                    } else {
                        result.append(this.buttonBarSpacer(16));
                    }
                    if (!disabledElement) {
                        if (widget == null) {
                            String newPath = CmsXmlUtils.createXpathElement(value.getName(), value.getIndex() + 1);
                            result.append("<td class=\"maxwidth\">");
                            boolean showHelp = j == 0;
                            result.append(this.getXmlEditorForm(nestedContentDefinition, pathPrefix + newPath + "/", showHelp));
                            result.append("</td>");
                        } else {
                            result.append(widget.getDialogWidget(this.getCms(), this, (I_CmsWidgetParameter)((Object)value)));
                        }
                    } else {
                        result.append("<td class=\"xmlTdDisabled maxwidth\">");
                        result.append(this.key("GUI_EDITOR_XMLCONTENT_OPTIONALELEMENT_0"));
                        result.append("</td>");
                    }
                    result.append(this.buildElementButtons(name, value.getIndex(), addValue, removeValue));
                    result.append("</tr>\n");
                }
            }
            result.append("</table>\n");
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_XML_EDITOR_0"), t);
        }
        return result;
    }

    private void resetErrorHandler() {
        this.m_validationHandler = null;
    }

    private void resetWidgetCollector() {
        this.m_widgetCollector = null;
    }

    private void writeContent() throws CmsException {
        String decodedContent = this.m_content.toString();
        try {
            this.m_file.setContents(decodedContent.getBytes(this.getFileEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            throw new CmsException(Messages.get().container("ERR_INVALID_CONTENT_ENC_1", this.getParamResource()), (Throwable)e);
        }
        this.m_file = this.getCloneCms().writeFile(this.m_file);
        this.m_content = CmsXmlContentFactory.unmarshal(this.getCloneCms(), this.m_file);
    }
}

