/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors.directedit;

import org.opencms.workplace.editors.directedit.CmsDirectEditButtonSelection;
import org.opencms.workplace.editors.directedit.CmsDirectEditMode;

public class CmsDirectEditParams {
    protected String m_element;
    protected String m_linkForClose;
    protected String m_linkForNew;
    protected CmsDirectEditMode m_mode;
    protected CmsDirectEditButtonSelection m_options;
    protected String m_resourceName;

    public CmsDirectEditParams(String linkForClose) {
        this.m_resourceName = null;
        this.m_options = null;
        this.m_element = null;
        this.m_linkForNew = null;
        this.m_linkForClose = linkForClose;
        this.m_mode = CmsDirectEditMode.TRUE;
    }

    public CmsDirectEditParams(String resourceName, CmsDirectEditButtonSelection options, CmsDirectEditMode mode, String linkForNew) {
        this.m_resourceName = resourceName;
        this.m_options = options;
        this.m_element = null;
        this.m_linkForNew = linkForNew;
        this.m_linkForClose = null;
        this.m_mode = mode != null ? mode : CmsDirectEditMode.TRUE;
    }

    public CmsDirectEditParams(String resourceName, String element) {
        this.m_resourceName = resourceName;
        this.m_options = CmsDirectEditButtonSelection.EDIT;
        this.m_element = element;
        this.m_linkForNew = null;
        this.m_linkForClose = null;
        this.m_mode = CmsDirectEditMode.TRUE;
    }

    public CmsDirectEditButtonSelection getButtonSelection() {
        return this.m_options;
    }

    public String getElement() {
        return this.m_element;
    }

    public String getLinkForClose() {
        return this.m_linkForClose;
    }

    public String getLinkForDelete() {
        return "/system/workplace/commons/delete.jsp";
    }

    public String getLinkForEdit() {
        return "/system/workplace/editors/editor.jsp";
    }

    public String getLinkForNew() {
        return this.m_linkForNew;
    }

    public CmsDirectEditMode getMode() {
        return this.m_mode;
    }

    public String getResourceName() {
        return this.m_resourceName;
    }
}

