/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.explorer;

import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.opencms.db.CmsUserSettings;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.OpenCms;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;

public class CmsExplorerInit
extends CmsWorkplace {
    private HashMap m_generatedScripts = new HashMap();

    public CmsExplorerInit(CmsJspActionElement jsp) {
        super(jsp);
    }

    public String buildContextMenues() {
        String entries = (String)this.m_generatedScripts.get(this.getMessages().getLocale());
        if (entries == null) {
            StringBuffer result = new StringBuffer();
            List allResTypes = OpenCms.getResourceManager().getResourceTypesWithUnknown();
            for (int i = 0; i < allResTypes.size(); ++i) {
                I_CmsResourceType type = (I_CmsResourceType)allResTypes.get(i);
                CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(type.getTypeName());
                if (settings == null) continue;
                result.append(settings.getJSEntries(settings, type.getTypeId(), this.getMessages()));
            }
            entries = result.toString();
            this.m_generatedScripts.put(this.getMessages().getLocale(), entries);
        }
        return entries;
    }

    public int getExplorerSettings() {
        CmsUserSettings settings = new CmsUserSettings(this.getCms());
        int value = settings.getExplorerSettings();
        return value;
    }

    public String getServerName() {
        return this.getJsp().getRequest().getServerName();
    }

    public String getServerPath() {
        return OpenCms.getStaticExportManager().getVfsPrefix();
    }

    public String getShowFileUploadButtons() {
        return OpenCms.getWorkplaceManager().getDefaultUserSettings().getShowFileUploadButtonString();
    }

    public String getUserName() {
        return this.getSettings().getUser().getName();
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
    }
}

