/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.galleries;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeFolderExtended;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.loader.CmsLoaderException;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsPermissionSet;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.galleries.Messages;

public abstract class A_CmsGallery
extends CmsDialog
implements Comparable {
    public static final int ACTION_DELETE = 101;
    public static final int ACTION_LIST = 102;
    public static final int ACTION_SEARCH = 103;
    public static final int ACTION_UPLOAD = 104;
    public static final String CSS_FILENAME = "gallery.css";
    public static final String DIALOG_DELETE = "delete";
    public static final String DIALOG_EDITPROPERTY = "editproperty";
    public static final String DIALOG_LIST = "list";
    public static final String DIALOG_SEARCH = "search";
    public static final String DIALOG_TYPE = "gallery";
    public static final String DIALOG_UPLOAD = "upload";
    public static final String MODE_EDITOR = "editor";
    public static final String MODE_VIEW = "view";
    public static final String MODE_WIDGET = "widget";
    public static final String OPEN_URI_SUFFIX = "gallery_fs.jsp";
    public static final String PARAM_CSSPATH = "csspath";
    public static final String PARAM_DIALOGMODE = "dialogmode";
    public static final String PARAM_FIELDID = "fieldid";
    public static final String PARAM_GALLERY_TYPENAME = "gallerytypename";
    public static final String PARAM_GALLERYPATH = "gallerypath";
    public static final String PARAM_PAGE = "page";
    public static final String PARAM_PROPERTYVALUE = "propertyvalue";
    public static final String PARAM_RESOURCEPATH = "resourcepath";
    public static final String PARAM_SEARCHWORD = "searchword";
    public static final String PATH_GALLERIES = "/system/workplace/galleries/";
    private static final Log LOG = CmsLog.getLog(A_CmsGallery.class);
    private CmsResource m_currentResource;
    private List m_galleryItems;
    private int m_galleryTypeId;
    private String m_galleryTypeName;
    private String m_galleryTypeParams;
    private String m_paramCssPath;
    private String m_paramDialogMode;
    private String m_paramFieldId;
    private String m_paramGalleryPath;
    private String m_paramPage;
    private String m_paramPropertyValue;
    private String m_paramResourcePath;
    private String m_paramSearchWord;
    private CmsResourceTypeFolderExtended m_resourceType;

    public A_CmsGallery() {
        this(null);
    }

    public A_CmsGallery(CmsJspActionElement jsp) {
        super(jsp);
    }

    public static A_CmsGallery createInstance(CmsJspActionElement jsp) {
        String galleryTypeName = null;
        if (jsp != null) {
            galleryTypeName = jsp.getRequest().getParameter(PARAM_GALLERY_TYPENAME);
        }
        return A_CmsGallery.createInstance(galleryTypeName, jsp);
    }

    public static A_CmsGallery createInstance(String galleryTypeName, CmsJspActionElement jsp) {
        A_CmsGallery template;
        HttpSession session;
        CmsWorkplaceSettings settings;
        if (jsp != null && (settings = (CmsWorkplaceSettings)(session = jsp.getRequest().getSession()).getAttribute("__CmsWorkplace.WORKPLACE_SETTINGS")) != null) {
            if (CmsStringUtil.isEmpty(galleryTypeName)) {
                galleryTypeName = settings.getGalleryType();
            } else {
                settings.setGalleryType(galleryTypeName);
            }
        }
        if ((template = (A_CmsGallery)OpenCms.getWorkplaceManager().getGalleries().get(galleryTypeName)) == null) {
            CmsMessageContainer message = jsp == null ? Messages.get().container("LOG_UNKNOWN_GALLERY_TYPE_REQ_1", galleryTypeName) : Messages.get().container("LOG_UNKNOWN_GALLERY_TYPE_REQ_JSP_2", galleryTypeName, jsp.info("opencms.request.element.uri"));
            LOG.error((Object)message.key());
            throw new CmsRuntimeException(message);
        }
        try {
            Class<?> galleryClass = Class.forName(template.getResourceType().getFolderClassName());
            A_CmsGallery galleryInstance = (A_CmsGallery)galleryClass.newInstance();
            galleryInstance.m_galleryTypeName = galleryTypeName;
            galleryInstance.m_resourceType = template.getResourceType();
            galleryInstance.m_galleryTypeParams = template.getResourceType().getFolderClassParams();
            galleryInstance.m_galleryTypeId = template.getResourceType().getTypeId();
            galleryInstance.initWorkplaceMembers(jsp);
            galleryInstance.init();
            return galleryInstance;
        }
        catch (Exception e) {
            CmsMessageContainer message = jsp == null ? Messages.get().container("LOG_CREATE_GALLERY_INSTANCE_FAILED_2", template.getResourceType().getFolderClassName(), galleryTypeName) : Messages.get().container("LOG_CREATE_GALLERY_INSTANCE_FAILED_JSP_3", template.getResourceType().getFolderClassName(), galleryTypeName, jsp.info("opencms.request.element.uri"));
            LOG.error((Object)message.key());
            throw new CmsRuntimeException(message);
        }
    }

    public static void initGallery(CmsDialog wp) {
        String galleryTypeName = null;
        galleryTypeName = wp.useNewStyle() ? CmsResource.getName(CmsResource.getFolderPath(wp.getAdminTool().getHandler().getLink())) : CmsResource.getName(CmsResource.getFolderPath(wp.getJsp().getRequestContext().getUri()));
        if (galleryTypeName.endsWith("/")) {
            galleryTypeName = galleryTypeName.substring(0, galleryTypeName.length() - 1);
        }
        if (!galleryTypeName.equals("commons")) {
            wp.getSettings().setGalleryType(galleryTypeName);
        }
    }

    public String applyButton() {
        if (MODE_VIEW.equals(this.getParamDialogMode())) {
            return this.button(null, null, "apply_in.png", "GUI_BUTTON_PASTE_0", 0);
        }
        String uri = this.getParamResourcePath();
        if (CmsStringUtil.isEmpty(this.getParamDialogMode())) {
            uri = this.getJsp().link(uri);
        }
        return this.button("javascript:link('" + uri + "',document.form.title.value, document.form.title.value);", null, "apply.png", "GUI_BUTTON_PASTE_0", 0);
    }

    public String buildGalleryButtonBar() {
        StringBuffer buttonBar = new StringBuffer();
        try {
            if (CmsStringUtil.isNotEmpty(this.getParamResourcePath())) {
                CmsResource res = this.getCms().readResource(this.getParamResourcePath());
                if (res != null) {
                    this.setCurrentResource(res);
                    if (this.hasWritePermissions() && DIALOG_EDITPROPERTY.equals(this.getParamAction())) {
                        this.writeTitleProperty(res);
                    }
                    String title = CmsEncoder.escapeXml(this.getPropertyValue(res, "Title"));
                    buttonBar.append("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" ");
                    buttonBar.append("class=\"gallerybuttonbar\">");
                    buttonBar.append("<tr align=\"left\">");
                    buttonBar.append(this.buttonBarStartTab(0, 0));
                    buttonBar.append(this.applyButton());
                    buttonBar.append(this.publishButton());
                    buttonBar.append(this.deleteButton());
                    buttonBar.append(this.buttonBarSeparator(5, 5));
                    buttonBar.append("<td class=\"nowrap\"><b>");
                    buttonBar.append(this.key("GUI_INPUT_TITLE_0"));
                    buttonBar.append("</b>&nbsp;</td>");
                    buttonBar.append("<td class=\"maxwidth\">");
                    buttonBar.append("<input name=\"title\" value=\"");
                    buttonBar.append(title);
                    buttonBar.append("\" style=\"width: 95%\">");
                    buttonBar.append("</td>\r\n");
                    buttonBar.append("<input type=\"hidden\" name=\"");
                    buttonBar.append(PARAM_PROPERTYVALUE);
                    buttonBar.append("\" value=\"");
                    buttonBar.append(title);
                    buttonBar.append("\">\r\n");
                    buttonBar.append(this.editPropertyButton());
                    buttonBar.append(this.targetSelectBox());
                    buttonBar.append(this.previewButton());
                    buttonBar.append(this.buttonBar(1));
                }
            } else {
                buttonBar.append("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td>");
                buttonBar.append("<img height=\"22\" border=\"0\" src=\"");
                buttonBar.append(this.getJsp().link("/system/workplace/resources/tree/empty.gif"));
                buttonBar.append("\">");
                buttonBar.append("</td></tr></table>");
            }
        }
        catch (CmsException e) {
            buttonBar.append("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td>");
            buttonBar.append("<img height=\"22\" border=\"0\" src=\"");
            buttonBar.append(this.getJsp().link("/system/workplace/resources/tree/empty.gif"));
            buttonBar.append("\">");
            buttonBar.append("</td></tr></table>");
        }
        return buttonBar.toString();
    }

    public abstract String buildGalleryItemPreview();

    public String buildGalleryItems() {
        StringBuffer result = new StringBuffer(64);
        result.append("<table border=\"0\" cellpadding=\"0\" cellspacing=\"0\" class=\"maxwidth\">");
        result.append(this.buildGalleryItemListHeadline());
        List items = this.getGalleryItems();
        String pageno = this.getParamPage();
        if (pageno == null) {
            pageno = "1";
        }
        if (items != null && items.size() > 0) {
            int start = 0;
            int end = this.getSettings().getUserSettings().getExplorerFileEntries();
            start = Integer.parseInt(pageno) * end - end;
            end = Integer.parseInt(pageno) * end;
            if (end > items.size()) {
                end = items.size();
            }
            if (start > end) {
                start = 0;
            }
            for (int i = start; i < end; ++i) {
                CmsResource res = (CmsResource)items.get(i);
                CmsResourceState state = res.getState();
                String tdClass = state.isChanged() ? "fc" : (state.isNew() ? "fn" : DIALOG_LIST);
                String resPath = this.getCms().getSitePath(res);
                String resName = CmsResource.getName(resPath);
                String title = this.getPropertyValue(res, "Title");
                result.append("<tr>\n");
                result.append(this.buildGalleryItemListCustomStartCols(res, tdClass));
                result.append("\t<td class=\"");
                result.append(tdClass);
                result.append("\"><a class=\"");
                result.append(tdClass);
                result.append("\" href=\"javascript: preview('");
                result.append(resPath);
                result.append("');\" title=\"");
                result.append(this.key("GUI_BUTTON_PREVIEW_0"));
                result.append("\">");
                result.append(resName);
                result.append("</a></td>\n");
                result.append("\t<td class=\"");
                result.append(tdClass);
                result.append("\">");
                result.append(CmsEncoder.escapeXml(title));
                result.append("</td>\n");
                result.append(this.buildGalleryItemListCustomEndCols(res, tdClass));
                result.append("</tr>\n");
            }
        }
        result.append("</table>");
        return result.toString();
    }

    public String buildGallerySelectBox() {
        List galleries = this.getGalleries();
        if (galleries != null && galleries.size() == 1) {
            CmsResource res = (CmsResource)galleries.get(0);
            StringBuffer result = new StringBuffer(128);
            String path = this.getCms().getSitePath(res);
            String title = "";
            try {
                title = this.getCms().readPropertyObject(path, "Title", false).getValue("");
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            result.append(title);
            result.append(" (");
            result.append(path);
            result.append(" )\r\n");
            result.append("<input type=\"hidden\" name=\"");
            result.append(PARAM_GALLERYPATH);
            result.append("\" value=\"");
            result.append(path);
            result.append("\">");
            return result.toString();
        }
        if (galleries != null && galleries.size() > 1) {
            int galleryCount = galleries.size();
            ArrayList<String> options = new ArrayList<String>(galleryCount);
            ArrayList<String> values = new ArrayList<String>(galleryCount);
            int selectedIndex = -1;
            for (int i = 0; i < galleryCount; ++i) {
                String title;
                String path;
                block8: {
                    CmsResource res = (CmsResource)galleries.get(i);
                    path = this.getCms().getSitePath(res);
                    if (path.equals(this.getParamGalleryPath())) {
                        selectedIndex = i;
                    }
                    title = "";
                    try {
                        title = this.getCms().readPropertyObject(path, "Title", false).getValue("");
                    }
                    catch (CmsException e) {
                        if (!LOG.isErrorEnabled()) break block8;
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                options.add(title + " (" + path + ")");
                values.add(path);
            }
            selectedIndex = this.sortOptions(options, values);
            String attrs = "name=\"gallerypath";
            attrs = attrs + "\" size=\"1\" style=\"width: 100%;\" onchange=\"displayGallery();\"";
            return this.buildSelect(attrs, options, values, selectedIndex);
        }
        StringBuffer result = new StringBuffer(128);
        result.append(this.key(Messages.getGalleryNotFoundKey(this.getGalleryTypeName())));
        result.append("\r\n<input type=\"hidden\" name=\"");
        result.append(PARAM_GALLERYPATH);
        result.append("\">");
        return result.toString();
    }

    public String buildPageSelectBox() {
        StringBuffer html = new StringBuffer(16);
        List items = this.getGalleryItems();
        String pageno = this.getParamPage();
        if (pageno == null) {
            pageno = "1";
        }
        int count = 0;
        int pages = 1;
        int rest = 0;
        int maxentries = this.getSettings().getUserSettings().getExplorerFileEntries();
        if (items != null) {
            count = items.size();
        }
        if (count > maxentries) {
            pages = count / maxentries;
            rest = count % maxentries;
            rest = rest > 0 ? 1 : 0;
            pages += rest;
        }
        if (pages > 1) {
            html.append("<select name=\"page\" class=\"location\" onchange=\"displayGallery();\">");
            String selected = "";
            for (int i = 1; i < pages + 1; ++i) {
                if (i == Integer.parseInt(pageno)) {
                    selected = " selected=\"selected\"";
                }
                html.append("<option value='");
                html.append(i);
                html.append("'");
                html.append(selected);
                html.append(">");
                html.append(i);
                html.append("</option>");
                selected = "";
            }
            html.append("</select>");
        }
        return html.toString();
    }

    public int compareTo(Object o) {
        if (!(o instanceof A_CmsGallery)) {
            return 0;
        }
        return this.getOrder().compareTo(((A_CmsGallery)o).getOrder());
    }

    public String deleteButton() {
        block3: {
            try {
                if (this.hasWritePermissions()) {
                    return this.button("javascript:deleteResource('" + this.getParamResourcePath() + "');", null, "deletecontent.png", "GUI_TITLE_DELETE_0", 0);
                }
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return this.button(null, null, "deletecontent_in.png", "", 0);
    }

    public String editPropertyButton() {
        try {
            if (this.hasWritePermissions()) {
                return this.button("javascript:editProperty('" + this.getParamResourcePath() + "');", null, "edit.png", "GUI_INPUT_EDITPROPERTYINFO_0", 0);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return this.button(null, null, "edit_in.png", "", 0);
    }

    public boolean galleriesExists() {
        List galleries = this.getGalleries();
        return galleries != null && galleries.size() > 0;
    }

    public String getBodyOnload() {
        StringBuffer onload = new StringBuffer();
        onload.append("self.focus();");
        if (CmsStringUtil.isEmpty(this.getParamGalleryPath())) {
            onload.append("displayGallery();");
        }
        return onload.toString();
    }

    public String getCssPath() {
        return this.getJsp().link("/system/workplace/galleries/gallery.css");
    }

    public CmsResource getCurrentResource() {
        return this.m_currentResource;
    }

    public List getGalleries() {
        List galleries = new ArrayList();
        int galleryTypeId = this.getGalleryTypeId();
        try {
            galleries = this.getCms().readResources("/", CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(galleryTypeId));
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        if (!this.getCms().getRequestContext().getSiteRoot().equals("")) {
            List systemGalleries = null;
            try {
                systemGalleries = this.getCms().readResources("/system/", CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(galleryTypeId));
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            if (systemGalleries != null && systemGalleries.size() > 0) {
                galleries.addAll(systemGalleries);
            }
        }
        return galleries;
    }

    public List getGalleryItems() {
        if (this.m_galleryItems == null) {
            int resTypeId = this.getGalleryItemsTypeId();
            if (CmsStringUtil.isNotEmpty(this.getParamGalleryPath())) {
                try {
                    this.getSettings().setLastUsedGallery(this.getGalleryTypeId(), this.getParamGalleryPath());
                    CmsResourceFilter filter = resTypeId == -1 ? CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireTimerange().addRequireFile() : CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireTimerange().addRequireType(resTypeId);
                    this.m_galleryItems = this.getCms().readResources(this.getParamGalleryPath(), filter, false);
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
        List items = this.m_galleryItems;
        if (CmsStringUtil.isNotEmpty(this.getParamSearchWord())) {
            items = this.getSearchHits(this.m_galleryItems);
        }
        return items;
    }

    public abstract int getGalleryItemsTypeId();

    public int getGalleryTypeId() {
        return this.m_galleryTypeId;
    }

    public String getGalleryTypeName() {
        return this.m_galleryTypeName;
    }

    public String getGalleryTypeParams() {
        return this.m_galleryTypeParams;
    }

    public String getHeadFrameSetHeight() {
        return "280";
    }

    public String getKeyTitle() {
        return this.key(Messages.getTitleGalleryKey(this.getGalleryTypeName()));
    }

    public String getNoGalleryErrorMsg() {
        return this.key(Messages.getGalleryNotFoundKey(this.getGalleryTypeName()));
    }

    public Integer getOrder() {
        return new Integer(Integer.MAX_VALUE);
    }

    public String getParamCssPath() {
        return this.m_paramCssPath;
    }

    public String getParamDialogMode() {
        if (this.m_paramDialogMode == null) {
            return "";
        }
        return this.m_paramDialogMode;
    }

    public String getParamFieldId() {
        return this.m_paramFieldId;
    }

    public String getParamGalleryPath() {
        if (CmsStringUtil.isEmpty(this.m_paramGalleryPath)) {
            this.m_paramGalleryPath = "";
        }
        return this.m_paramGalleryPath;
    }

    public String getParamPage() {
        return this.m_paramPage;
    }

    public String getParamPropertyValue() {
        return this.m_paramPropertyValue;
    }

    public String getParamResourcePath() {
        return this.m_paramResourcePath;
    }

    public String getParamSearchWord() {
        if (CmsStringUtil.isEmpty(this.m_paramSearchWord)) {
            this.m_paramSearchWord = "";
        }
        return this.m_paramSearchWord;
    }

    public String getPreviewBodyStyle() {
        return " class=\"dialog gallerypreview\" unselectable=\"on\"";
    }

    public String getPreviewDivStyle() {
        return "style=\"text-align: center; width: 100%; margin-top: 5px\"";
    }

    public CmsResourceTypeFolderExtended getResourceType() {
        return this.m_resourceType;
    }

    public String getWizardUrl() {
        StringBuffer wizardUrl = new StringBuffer(16);
        wizardUrl.append(this.getJsp().link("/system/workplace/commons/" + OpenCms.getWorkplaceManager().getExplorerTypeSetting(DIALOG_UPLOAD).getNewResourceUri()));
        wizardUrl.append("?");
        wizardUrl.append("redirecturl");
        wizardUrl.append("=");
        wizardUrl.append(PATH_GALLERIES);
        wizardUrl.append("gallery_list.jsp&");
        wizardUrl.append("targetframe");
        wizardUrl.append("=gallery_list&");
        wizardUrl.append("currentfolder");
        wizardUrl.append("=");
        return wizardUrl.toString();
    }

    public void init() {
    }

    public String previewButton() {
        StringBuffer previewButton = new StringBuffer(8);
        previewButton.append(this.buttonBarSeparator(5, 5));
        previewButton.append(this.button(this.getJsp().link(this.getCms().getSitePath(this.getCurrentResource())), "_preview", "preview.png", "GUI_BUTTON_PREVIEW_0", 0));
        return previewButton.toString();
    }

    public String previewRow(String column1, String column2) {
        StringBuffer previewRow = new StringBuffer();
        previewRow.append("<tr align=\"left\">\n");
        previewRow.append("<td>\n<b>");
        previewRow.append(column1);
        previewRow.append("</b>\n</td>\n");
        previewRow.append("<td>\n");
        previewRow.append(column2);
        previewRow.append("</td>\n");
        previewRow.append("</tr>\n");
        return previewRow.toString();
    }

    public String publishButton() {
        try {
            OpenCms.getPublishManager().getPublishList(this.getCms(), this.getCms().readResource(this.getParamResourcePath()), false);
            return this.button("javascript:publishResource('" + this.getParamResourcePath() + "');", null, "publish.png", "GUI_MESSAGEBOX_TITLE_PUBLISHRESOURCE_0", 0);
        }
        catch (Exception e) {
            return this.button(null, null, "publish_in.png", "", 0);
        }
    }

    public String searchButton() {
        return this.button("javascript:displayGallery();", null, "search.png", "GUI_INPUT_SEARCH_0", 0);
    }

    public void setCurrentResource(CmsResource currentResource) {
        this.m_currentResource = currentResource;
    }

    public void setParamCssPath(String paramCssPath) {
        this.m_paramCssPath = paramCssPath;
    }

    public void setParamDialogMode(String dialogMode) {
        this.m_paramDialogMode = dialogMode;
    }

    public void setParamFieldId(String fieldId) {
        this.m_paramFieldId = fieldId;
    }

    public void setParamGalleryPath(String galleryPath) {
        this.m_paramGalleryPath = galleryPath;
    }

    public void setParamPage(String page) {
        this.m_paramPage = page;
    }

    public void setParamPropertyValue(String paramPropertyValue) {
        this.m_paramPropertyValue = paramPropertyValue;
    }

    public void setParamResourcePath(String resourcePath) {
        this.m_paramResourcePath = resourcePath;
    }

    public void setParamSearchWord(String searchWord) {
        this.m_paramSearchWord = searchWord;
    }

    public void setResourceType(CmsResourceTypeFolderExtended type) {
        this.m_resourceType = type;
    }

    public String targetSelectBox() {
        StringBuffer targetSelectBox = new StringBuffer(32);
        targetSelectBox.append(this.buttonBarSpacer(5));
        targetSelectBox.append("<td nowrap><b>");
        targetSelectBox.append(this.key("GUI_INPUT_LINKTARGET_0"));
        targetSelectBox.append("</b>&nbsp;</td>");
        targetSelectBox.append("<td>\r\n");
        targetSelectBox.append("<select name=\"linktarget\" id=\"linktarget\" size=\"1\" style=\"width:150px\"");
        if (MODE_VIEW.equals(this.getParamDialogMode())) {
            targetSelectBox.append(" disabled=\"disabled\"");
        }
        targetSelectBox.append(">");
        targetSelectBox.append(this.getTargetOptions());
        targetSelectBox.append("</select>");
        targetSelectBox.append("</td>");
        return targetSelectBox.toString();
    }

    public String wizardButton() {
        return this.button("javascript:wizard();", null, "upload.png", OpenCms.getWorkplaceManager().getExplorerTypeSetting(DIALOG_UPLOAD).getKey(), 0);
    }

    protected String buildGalleryItemListCustomEndCols(CmsResource res, String tdClass) {
        StringBuffer result = new StringBuffer(64);
        result.append("\t<td class=\"");
        result.append(tdClass);
        result.append("\" style=\"text-align: right;\">");
        result.append(res.getLength() / 1024);
        result.append(" ");
        result.append(this.key("GUI_LABEL_KILOBYTES_0"));
        result.append("</td>\n");
        return result.toString();
    }

    protected String buildGalleryItemListCustomStartCols(CmsResource res, String tdClass) {
        String resType;
        try {
            resType = OpenCms.getResourceManager().getResourceType(res.getTypeId()).getTypeName();
        }
        catch (CmsLoaderException e) {
            resType = null;
        }
        StringBuffer result = new StringBuffer(64);
        result.append("\t<td>");
        if (resType != null && tdClass != null) {
            result.append("<img src=\"");
            result.append(A_CmsGallery.getSkinUri());
            result.append("filetypes/");
            result.append(resType);
            result.append(".gif\">");
        }
        result.append("</td>\n");
        return result.toString();
    }

    protected String buildGalleryItemListHeadline() {
        StringBuffer headline = new StringBuffer(32);
        headline.append("<tr>");
        headline.append("<td class=\"headline\">&nbsp;</td>");
        headline.append("<td class=\"headline\" width=\"35%\">");
        headline.append(this.key("GUI_LABEL_NAME_0"));
        headline.append("</td>");
        headline.append("<td class=\"headline\" width=\"55%\">");
        headline.append(this.key("GUI_LABEL_TITLE_0"));
        headline.append("</td>");
        headline.append("<td class=\"headline\" style=\"text-align: right;\" width=\"10%\">");
        headline.append(this.key("GUI_LABEL_SIZE_0"));
        headline.append("</td>");
        headline.append("</tr>");
        return headline.toString();
    }

    protected String getPropertyValue(CmsResource resource, String propertydefinition) {
        String value = "";
        if (resource != null) {
            String resPath = this.getCms().getSitePath(resource);
            String resName = CmsResource.getName(resPath);
            try {
                CmsProperty property = this.getCms().readPropertyObject(resPath, propertydefinition, false);
                value = property.getValue("[" + resName + "]");
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return value;
    }

    protected List getSearchHits(List items) {
        String searchword = this.getParamSearchWord().toLowerCase();
        ArrayList<CmsResource> hitlist = new ArrayList<CmsResource>();
        if (items != null) {
            Iterator i = items.iterator();
            while (i.hasNext()) {
                CmsResource res = (CmsResource)i.next();
                String resname = res.getName().toLowerCase();
                String restitle = this.getJsp().property("Title", this.getCms().getSitePath(res), resname).toLowerCase();
                if (restitle.indexOf(searchword) == -1 && resname.indexOf(searchword) == -1) continue;
                hitlist.add(res);
            }
        }
        return hitlist;
    }

    protected String getTargetOptions() {
        StringBuffer options = new StringBuffer();
        options.append("<option value=\"_self\">");
        options.append(this.key("GUI_INPUT_LINKTARGETSELF_0"));
        options.append("</option>\r\n");
        options.append("<option value=\"_blank\">");
        options.append(this.key("GUI_INPUT_LINKTARGETBLANK_0"));
        options.append("</option>\r\n");
        options.append("<option value=\"_top\">");
        options.append(this.key("GUI_INPUT_LINKTARGETTOP_0"));
        options.append("</option>\r\n");
        return options.toString();
    }

    protected boolean hasWritePermissions() throws CmsException {
        return this.getCms().hasPermissions(this.getCurrentResource(), CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ALL);
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        String lastUsedGallery;
        this.fillParamValues(request);
        this.setParamDialogtype(DIALOG_TYPE);
        if (CmsStringUtil.isEmpty(this.getParamGalleryPath()) && CmsStringUtil.isNotEmpty(lastUsedGallery = this.getSettings().getLastUsedGallery(this.getGalleryTypeId()))) {
            try {
                this.getCms().readResource(lastUsedGallery, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
                this.setParamGalleryPath(lastUsedGallery);
            }
            catch (CmsException e) {
                // empty catch block
            }
        }
    }

    protected int sortOptions(List options, List values) {
        String value;
        String option;
        int selectedIndex = -1;
        TreeMap<String, String> valuesByOption = new TreeMap<String, String>();
        int n = options.size();
        for (int i = 0; i < n; ++i) {
            option = (String)options.get(i);
            value = (String)values.get(i);
            if (!CmsStringUtil.isNotEmpty(option) || !CmsStringUtil.isNotEmpty(value)) continue;
            valuesByOption.put(option, value);
        }
        values.clear();
        options.clear();
        Iterator it = valuesByOption.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            option = (String)entry.getKey();
            value = (String)entry.getValue();
            if (value.equals(this.getParamGalleryPath())) {
                selectedIndex = options.size();
            }
            options.add(option);
            values.add(value);
        }
        return selectedIndex;
    }

    protected void writeTitleProperty(CmsResource res) {
        String resPath = this.getCms().getSitePath(res);
        String currentPropertyValue = this.getParamPropertyValue();
        try {
            CmsProperty currentProperty = this.getCms().readPropertyObject(resPath, "Title", false);
            if (currentProperty.isNullProperty()) {
                currentProperty = new CmsProperty();
                currentProperty.setName("Title");
                if (OpenCms.getWorkplaceManager().isDefaultPropertiesOnStructure()) {
                    currentProperty.setStructureValue(currentPropertyValue);
                    currentProperty.setResourceValue(null);
                } else {
                    currentProperty.setStructureValue(null);
                    currentProperty.setResourceValue(currentPropertyValue);
                }
            } else if (currentProperty.getStructureValue() != null) {
                currentProperty.setStructureValue(currentPropertyValue);
                currentProperty.setResourceValue(null);
            } else {
                currentProperty.setStructureValue(null);
                currentProperty.setResourceValue(currentPropertyValue);
            }
            CmsLock lock = this.getCms().getLock(res);
            if (lock.isUnlocked()) {
                this.getCms().lockResource(resPath);
            }
            this.getCms().writePropertyObject(resPath, currentProperty);
            this.getCms().unlockResource(resPath);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }
}

