/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.galleries;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypePointer;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.galleries.A_CmsGallery;

public class CmsLinkGallery
extends A_CmsGallery {
    public static final String PARAM_EDITPROPERTY = "editproperty";
    public static final String PARAM_EDITPROPERTY_VALUE = "editpropertyvalue";
    public static final String URI_GALLERY = "/system/workplace/galleries/link_fs.jsp";
    public static final String VALUE_EDITPROPERTY_LINK = "editpropertylink";
    public static final String VALUE_EDITPROPERTY_TITLE = "editpropertytitle";
    private static final Log LOG = CmsLog.getLog(CmsLinkGallery.class);
    private static final Integer ORDER_GALLERY = new Integer(30);
    private String m_paramEditProperty;
    private String m_paramEditPropertyValue;

    public CmsLinkGallery() {
    }

    public CmsLinkGallery(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsLinkGallery(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public String applyButton() {
        if ("view".equals(this.getParamDialogMode())) {
            return this.button(null, null, "apply_in.png", "GUI_BUTTON_PASTE_0", 0);
        }
        String uri = this.getParamResourcePath();
        if ("widget".equals(this.getParamDialogMode())) {
            try {
                CmsResource res = this.getCms().readResource(this.getParamResourcePath());
                uri = new String(this.getCms().readFile(res).getContents());
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        } else {
            uri = this.getJsp().link(uri);
        }
        return this.button("javascript:link('" + uri + "',document.form.title.value, document.form.title.value);", null, "apply.png", "GUI_BUTTON_PASTE_0", 0);
    }

    public String buildGalleryButtonBar() {
        StringBuffer buttonBar = new StringBuffer();
        try {
            if (CmsStringUtil.isNotEmpty(this.getParamResourcePath())) {
                CmsResource res = this.getCms().readResource(this.getParamResourcePath());
                if (res != null) {
                    this.setCurrentResource(res);
                    String title = CmsEncoder.escapeXml(this.getPropertyValue(res, "Title"));
                    buttonBar.append("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\" ");
                    buttonBar.append("style=\"align: left; width:100%; background-color: ThreeDFace; margin: 0; border-right: 1px solid ThreeDShadow\">");
                    buttonBar.append("<tr align=\"left\">");
                    buttonBar.append(this.buttonBarStartTab(0, 0));
                    buttonBar.append(this.applyButton());
                    buttonBar.append(this.publishButton());
                    buttonBar.append(this.deleteButton());
                    buttonBar.append(this.buttonBarSeparator(5, 5));
                    buttonBar.append("<td class=\"nowrap\"><b><nobr>");
                    buttonBar.append(title).append("</nobr></b>&nbsp;</td>\n");
                    buttonBar.append("<td class=\"maxwidth\">&nbsp;</td>\n");
                    buttonBar.append("<input type=\"hidden\" name=\"");
                    buttonBar.append("propertyvalue");
                    buttonBar.append("\" value=\"");
                    buttonBar.append(title);
                    buttonBar.append("\">\r\n");
                    buttonBar.append(this.targetSelectBox());
                    buttonBar.append(this.previewButton());
                    buttonBar.append(this.buttonBar(1));
                }
            } else {
                buttonBar.append("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td>");
                buttonBar.append("<img height=\"22\" border=\"0\" src=\"");
                buttonBar.append(this.getJsp().link("/system/workplace/resources/tree/empty.gif"));
                buttonBar.append("\">");
                buttonBar.append("</td></tr></table>");
            }
        }
        catch (CmsException e) {
            buttonBar.append("<table cellpadding=\"0\" cellspacing=\"0\" border=\"0\"><tr><td>");
            buttonBar.append("<img height=\"22\" border=\"0\" src=\"");
            buttonBar.append(this.getJsp().link("/system/workplace/resources/tree/empty.gif"));
            buttonBar.append("\">");
            buttonBar.append("</td></tr></table>");
        }
        return buttonBar.toString();
    }

    public String buildGalleryItemPreview() {
        StringBuffer html = new StringBuffer(32);
        try {
            CmsResource res;
            if (CmsStringUtil.isNotEmpty(this.getParamResourcePath()) && (res = this.getCms().readResource(this.getParamResourcePath())) != null) {
                this.setCurrentResource(res);
                this.changePointer(res);
                String pointer = new String(this.getCms().readFile(res).getContents());
                if (CmsStringUtil.isEmptyOrWhitespaceOnly(pointer)) {
                    pointer = this.getJsp().link(this.getCms().getSitePath(res));
                }
                String title = this.getPropertyValue(res, "Title");
                String description = this.getJsp().property("Description", this.getParamResourcePath());
                String keywords = this.getJsp().property("Keywords", this.getParamResourcePath());
                String lastmodified = this.getMessages().getDateTime(res.getDateLastModified());
                html.append("<table cellpadding=\"2\" cellspacing=\"2\" border=\"0\" style=\"align: middle; width:100%; background-color: ThreeDFace; margin: 0;\">\n");
                String link = this.key("GUI_INPUT_LINKTO_0") + " (<a href=\"#\" onclick=\"javascript:window.open('" + this.getJsp().link(this.getCms().getSitePath(res)) + "','_preview','')\">" + this.key("GUI_BUTTON_PREVIEW_0") + "</a>)";
                html.append(this.previewRow(link, pointer, VALUE_EDITPROPERTY_LINK));
                html.append(this.previewRow(this.key("GUI_INPUT_TITLE_0"), title, VALUE_EDITPROPERTY_TITLE));
                html.append(this.previewRow(this.key("GUI_LABEL_NAME_0"), res.getName(), false));
                html.append(this.previewRow(this.key("GUI_INPUT_DATELASTMODIFIED_0"), lastmodified, false));
                if (CmsStringUtil.isNotEmpty(description)) {
                    html.append(this.previewRow(this.key("GUI_INPUT_DESCRIPTION_0"), description));
                }
                if (CmsStringUtil.isNotEmpty(keywords)) {
                    html.append(this.previewRow(this.key("GUI_INPUT_KEYWORDS_0"), keywords));
                }
                html.append("<form name=\"pointerchange\" action=\"").append(this.getJsp().link("gallery_preview.jsp")).append("\" target=\"gallery_preview\" method=\"post\" class=\"nomargin\">\n");
                html.append("\t<input type=\"hidden\" id=\"").append(PARAM_EDITPROPERTY).append("\" name=\"").append(PARAM_EDITPROPERTY).append("\"/>\n");
                html.append("\t<input type=\"hidden\" id=\"").append(PARAM_EDITPROPERTY_VALUE).append("\" name=\"").append(PARAM_EDITPROPERTY_VALUE).append("\"/>\n");
                html.append("\t<input type=\"hidden\" id=\"").append("action").append("\" name=\"").append("action").append("\" value=\"").append(PARAM_EDITPROPERTY).append("\"/>\n");
                html.append("\t<input type=\"hidden\" id=\"").append("resourcepath").append("\" name=\"").append("resourcepath").append("\"pointerPropertyValue\" value=\"").append(this.getParamResourcePath()).append("\"/>\n");
                html.append("</form>\n");
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return html.toString();
    }

    public String dialogScriptSubmit() {
        if (this.useNewStyle()) {
            return super.dialogScriptSubmit();
        }
        StringBuffer result = new StringBuffer(512);
        result.append("function submitAction(submitFieldId) {\n");
        result.append("\tdocument.pointerchange.").append(PARAM_EDITPROPERTY).append(".value = submitFieldId;\n");
        result.append("\tdocument.pointerchange.").append(PARAM_EDITPROPERTY_VALUE).append(".value = document.getElementById(submitFieldId).value;\n");
        result.append("\tdocument.pointerchange.submit();\n");
        result.append("\ttop.setTimeout('top.gallery_fs.gallery_head.displayGallery()', 1000);\n");
        result.append("\ttop.setTimeout('top.preview_fs.gallery_buttonbar.location.reload()', 1000);\n");
        result.append("}\n");
        return result.toString();
    }

    public int getGalleryItemsTypeId() {
        return CmsResourceTypePointer.getStaticTypeId();
    }

    public String getHeadFrameSetHeight() {
        return "450";
    }

    public Integer getOrder() {
        return ORDER_GALLERY;
    }

    public String getParamEditProperty() {
        return this.m_paramEditProperty;
    }

    public String getParamEditPropertyValue() {
        return this.m_paramEditPropertyValue;
    }

    public String getWizardUrl() {
        StringBuffer wizardUrl = new StringBuffer(8);
        wizardUrl.append(this.getJsp().link("/system/workplace/commons/" + OpenCms.getWorkplaceManager().getExplorerTypeSetting(CmsResourceTypePointer.getStaticTypeName()).getNewResourceUri()));
        wizardUrl.append("?action=newform&");
        wizardUrl.append("redirecturl");
        wizardUrl.append("=");
        wizardUrl.append("/system/workplace/galleries/");
        wizardUrl.append("gallery_list.jsp&");
        wizardUrl.append("targetframe");
        wizardUrl.append("=gallery_list&");
        wizardUrl.append("currentfolder");
        wizardUrl.append("=");
        return wizardUrl.toString();
    }

    public String previewRow(String column1, String column2) {
        return this.previewRow(column1, column2, true);
    }

    public String previewRow(String column1, String column2, boolean inputField) {
        String result;
        if (inputField) {
            result = this.previewRow(column1, column2, column1);
        } else {
            StringBuffer previewRow = new StringBuffer();
            previewRow.append("<tr align=\"left\">\n");
            previewRow.append("<td>\n<b><nobr>");
            previewRow.append(column1);
            previewRow.append("&nbsp;</nobr></b>\n</td>\n");
            previewRow.append("<td>\n");
            previewRow.append(column2);
            previewRow.append("</td>\n");
            previewRow.append("<td>&nbsp;</td>\n");
            previewRow.append("<td class=\"maxwidth\">&nbsp;</td>\n");
            previewRow.append("</tr>\n");
            result = previewRow.toString();
        }
        return result;
    }

    public void setParamEditProperty(String paramEditProperty) {
        this.m_paramEditProperty = paramEditProperty;
    }

    public void setParamEditPropertyValue(String paramEditPropertyValue) {
        this.m_paramEditPropertyValue = paramEditPropertyValue;
    }

    public String wizardButton() {
        return this.button("javascript:wizard();", null, "upload.png", "GUI_TITLE_NEW_0", 0);
    }

    protected String buildGalleryItemListCustomEndCols(CmsResource res, String tdClass) {
        String linkTarget;
        StringBuffer result = new StringBuffer(64);
        result.append("\t<td class=\"");
        result.append(tdClass);
        result.append("\">");
        try {
            CmsFile file = this.getCms().readFile(res);
            linkTarget = new String(file.getContents());
        }
        catch (CmsException e) {
            linkTarget = "";
        }
        result.append(linkTarget);
        result.append("</td>\n");
        return result.toString();
    }

    protected String buildGalleryItemListHeadline() {
        StringBuffer headline = new StringBuffer(16);
        headline.append("<tr>");
        headline.append("<td class=\"headline\">&nbsp;</td>");
        headline.append("<td class=\"headline\" width=\"25%\">");
        headline.append(this.key("GUI_LABEL_NAME_0"));
        headline.append("</td>");
        headline.append("<td class=\"headline\" width=\"45%\">");
        headline.append(this.key("GUI_LABEL_TITLE_0"));
        headline.append("</td>");
        headline.append("<td class=\"headline\" width=\"30%\">");
        headline.append(this.key("GUI_INPUT_LINKTO_0"));
        headline.append("</td>");
        headline.append("</tr>");
        return headline.toString();
    }

    protected List getSearchHits(List items) {
        String searchword = this.getParamSearchWord().toLowerCase();
        ArrayList<CmsResource> hitlist = new ArrayList<CmsResource>();
        if (items != null) {
            Iterator i = items.iterator();
            while (i.hasNext()) {
                try {
                    CmsResource res = (CmsResource)i.next();
                    String resname = res.getName().toLowerCase();
                    String restitle = this.getJsp().property("Title", this.getCms().getSitePath(res), resname).toLowerCase();
                    CmsFile file = this.getCms().readFile(res);
                    String link = new String(file.getContents()).toLowerCase();
                    if (restitle.indexOf(searchword) == -1 && resname.indexOf(searchword) == -1 && link.indexOf(searchword) == -1) continue;
                    hitlist.add(res);
                }
                catch (CmsException e) {}
            }
        }
        return hitlist;
    }

    protected void writeTitleProperty(CmsResource res) {
        String resPath = this.getCms().getSitePath(res);
        String currentPropertyValue = this.getParamEditPropertyValue();
        try {
            CmsProperty currentProperty = this.getCms().readPropertyObject(resPath, "Title", false);
            if (currentProperty.isNullProperty()) {
                currentProperty = new CmsProperty();
                currentProperty.setName("Title");
                if (OpenCms.getWorkplaceManager().isDefaultPropertiesOnStructure()) {
                    currentProperty.setStructureValue(currentPropertyValue);
                    currentProperty.setResourceValue(null);
                } else {
                    currentProperty.setStructureValue(null);
                    currentProperty.setResourceValue(currentPropertyValue);
                }
            } else if (currentProperty.getStructureValue() != null) {
                currentProperty.setStructureValue(currentPropertyValue);
                currentProperty.setResourceValue(null);
            } else {
                currentProperty.setStructureValue(null);
                currentProperty.setResourceValue(currentPropertyValue);
            }
            boolean locked = true;
            CmsLock lock = this.getCms().getLock(res);
            if (lock.isUnlocked()) {
                this.getCms().lockResource(resPath);
                locked = false;
            }
            this.getCms().writePropertyObject(resPath, currentProperty);
            if (!locked) {
                this.getCms().unlockResource(resPath);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    private void changePointer(CmsResource res) throws CmsException {
        if (PARAM_EDITPROPERTY.equals(this.getParamAction()) && this.hasWritePermissions()) {
            if (VALUE_EDITPROPERTY_LINK.equals(this.m_paramEditProperty)) {
                this.writePointerLink(res);
            } else if (VALUE_EDITPROPERTY_TITLE.equals(this.m_paramEditProperty)) {
                this.writeTitleProperty(res);
            }
        }
    }

    private String editPropertyButton(String property) {
        try {
            if (this.hasWritePermissions()) {
                return this.button("javascript:submitAction('" + property + "');", null, "edit.png", "GUI_INPUT_EDITPROPERTYINFO_0", 0);
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return this.button(null, null, "edit_in.png", "", 0);
    }

    private String previewRow(String column1, String column2, String inputFieldId) {
        StringBuffer previewRow = new StringBuffer();
        previewRow.append("<tr align=\"left\">\n");
        previewRow.append("<td>\n<b><nobr>");
        previewRow.append(column1);
        previewRow.append("&nbsp;</nobr></b>\n</td>\n");
        previewRow.append("<td>\n");
        previewRow.append("<input id=\"").append(inputFieldId).append("\" name=\"").append(inputFieldId).append("\" value=\"").append(column2).append("\" size=\"50\"/>");
        previewRow.append("</td>\n");
        previewRow.append(this.editPropertyButton(inputFieldId));
        previewRow.append("<td class=\"maxwidth\">&nbsp;</td>\n");
        previewRow.append("</tr>\n");
        return previewRow.toString();
    }

    private void writePointerLink(CmsResource res) throws CmsException {
        String resPath = this.getCms().getSitePath(res);
        boolean locked = true;
        CmsLock lock = this.getCms().getLock(res);
        if (lock.isUnlocked()) {
            this.getCms().lockResource(resPath);
            locked = false;
        }
        CmsFile file = this.getCms().readFile(res);
        file.setContents(this.m_paramEditPropertyValue.getBytes());
        this.checkLock(this.getCms().getSitePath(res));
        this.getCms().writeFile(file);
        if (!locked) {
            this.getCms().unlockResource(resPath);
        }
    }
}

