/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.logging.Log;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.list.CmsHtmlList;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.CmsListPrintIAction;
import org.opencms.workplace.list.CmsListSearchAction;
import org.opencms.workplace.list.CmsListState;
import org.opencms.workplace.list.Messages;

public abstract class A_CmsListDialog
extends CmsDialog {
    public static final int ACTION_LIST_INDEPENDENT_ACTION = 83;
    public static final int ACTION_LIST_MULTI_ACTION = 85;
    public static final int ACTION_LIST_SEARCH = 81;
    public static final int ACTION_LIST_SELECT_PAGE = 82;
    public static final int ACTION_LIST_SINGLE_ACTION = 84;
    public static final int ACTION_LIST_SORT = 80;
    public static final String ICON_ACTIVE = "list/active.png";
    public static final String ICON_ADD = "list/add.png";
    public static final String ICON_DELETE = "list/delete.png";
    public static final String ICON_DETAILS_HIDE = "list/details_hide.png";
    public static final String ICON_DETAILS_SHOW = "list/details_show.png";
    public static final String ICON_DISABLED = "list/disabled.png";
    public static final String ICON_INACTIVE = "list/inactive.png";
    public static final String ICON_MINUS = "list/minus.png";
    public static final String ICON_MULTI_ACTIVATE = "list/multi_activate.png";
    public static final String ICON_MULTI_ADD = "list/multi_add.png";
    public static final String ICON_MULTI_DEACTIVATE = "list/multi_deactivate.png";
    public static final String ICON_MULTI_DELETE = "list/multi_delete.png";
    public static final String ICON_MULTI_MINUS = "list/multi_minus.png";
    public static final String LIST_INDEPENDENT_ACTION = "listindependentaction";
    public static final String LIST_MULTI_ACTION = "listmultiaction";
    public static final String LIST_SEARCH = "listsearch";
    public static final String LIST_SELECT_PAGE = "listselectpage";
    public static final String LIST_SINGLE_ACTION = "listsingleaction";
    public static final String LIST_SORT = "listsort";
    public static final String PARAM_FORMNAME = "formname";
    public static final String PARAM_LIST_ACTION = "listaction";
    public static final String PARAM_PAGE = "page";
    public static final String PARAM_SEARCH_FILTER = "searchfilter";
    public static final String PARAM_SEL_ITEMS = "selitems";
    public static final String PARAM_SORT_COL = "sortcol";
    private static final Log LOG = CmsLog.getLog(A_CmsListDialog.class);
    private static Map m_metadatas = new HashMap();
    private boolean m_active;
    private CmsHtmlList m_list;
    private String m_listId;
    private CmsListState m_listState;
    private String m_paramFormName;
    private String m_paramListAction;
    private String m_paramPage;
    private String m_paramSearchFilter;
    private String m_paramSelItems;
    private String m_paramSortCol;
    private String m_searchColId;

    protected A_CmsListDialog(CmsJspActionElement jsp, String listId, CmsMessageContainer listName, String sortedColId, CmsListOrderEnum sortOrder, String searchableColId) {
        super(jsp);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_START_INIT_LIST_1", listId));
        }
        this.m_listId = listId;
        this.m_active = (this.getListId() + "-form").equals(this.getParamFormName());
        this.setParamFormName(this.getListId() + "-form");
        if (this.isForwarded()) {
            return;
        }
        this.m_searchColId = searchableColId;
        this.listRecovery(listId);
        if (this.getList() == null) {
            this.setList(new CmsHtmlList(listId, listName, this.getMetadata(this.getClass().getName(), listId)));
            this.getList().setMaxItemsPerPage(this.getSettings().getUserSettings().getExplorerFileEntries());
            if (sortedColId != null && this.getList().getMetadata().getColumnDefinition(sortedColId) != null) {
                this.getList().setWp(this);
                this.getList().setSortedColumn(sortedColId);
                if (sortOrder != null && sortOrder == CmsListOrderEnum.ORDER_DESCENDING) {
                    this.getList().setSortedColumn(sortedColId);
                }
            }
            this.listSave();
        }
        this.getList().setWp(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_END_INIT_LIST_1", listId));
        }
    }

    public static CmsHtmlList getListObject(Class listDialog, CmsWorkplaceSettings settings) {
        return (CmsHtmlList)A_CmsListDialog.getListObjectMap(settings).get(listDialog.getName());
    }

    public static CmsListMetadata getMetadata(String listDialogName) {
        return (CmsListMetadata)m_metadatas.get(listDialogName);
    }

    private static Map getListObjectMap(CmsWorkplaceSettings settings) {
        Hashtable objects = (Hashtable)settings.getListObject();
        if (objects == null) {
            objects = new Hashtable();
            settings.setListObject(objects);
        }
        return objects;
    }

    public void actionDialog() throws JspException, ServletException, IOException {
        if (this.isForwarded()) {
            return;
        }
        if (this.getAction() == 4) {
            this.actionCloseDialog();
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_START_ACTION_LIST_2", this.getListId(), new Integer(this.getAction())));
        }
        switch (this.getAction()) {
            case 80: 
            case 81: 
            case 82: {
                this.executeDefaultActions();
                break;
            }
            case 84: {
                if (this.getSelectedItem() == null) break;
                this.executeListSingleActions();
                break;
            }
            case 85: {
                this.executeListMultiActions();
                break;
            }
            case 83: {
                this.executeListIndepActions();
                break;
            }
            default: {
                this.setParamAction("initial");
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_END_ACTION_LIST_2", this.getListId(), new Integer(this.getAction())));
        }
        this.refreshList();
    }

    public String defaultActionHtml() {
        if (this.getList() != null && this.getList().getAllContent().isEmpty()) {
            this.refreshList();
        }
        StringBuffer result = new StringBuffer(2048);
        result.append(this.defaultActionHtmlStart());
        result.append(this.customHtmlStart());
        result.append(this.defaultActionHtmlContent());
        result.append(this.customHtmlEnd());
        result.append(this.defaultActionHtmlEnd());
        return result.toString();
    }

    public void displayDialog() throws JspException, IOException, ServletException {
        this.displayDialog(false);
    }

    public void displayDialog(boolean writeLater) throws JspException, IOException, ServletException {
        this.actionDialog();
        if (writeLater) {
            return;
        }
        this.writeDialog();
    }

    public void executeDefaultActions() {
        switch (this.getAction()) {
            case 81: {
                this.executeSearch();
                break;
            }
            case 80: {
                this.executeSort();
                break;
            }
            case 82: {
                this.executeSelectPage();
                break;
            }
        }
        this.listSave();
    }

    public void executeListIndepActions() {
        if (this.getList().getMetadata().getItemDetailDefinition(this.getParamListAction()) != null) {
            this.getList().getMetadata().toogleDetailState(this.getParamListAction());
            this.initializeDetail(this.getParamListAction());
        }
        this.listSave();
    }

    public abstract void executeListMultiActions() throws IOException, ServletException, CmsRuntimeException;

    public abstract void executeListSingleActions() throws IOException, ServletException, CmsRuntimeException;

    public CmsHtmlList getList() {
        if (this.m_list != null && this.m_list.getMetadata() == null) {
            this.m_list.setMetadata(this.getMetadata(this.getClass().getName(), this.m_list.getId()));
        }
        return this.m_list;
    }

    public final String getListId() {
        return this.m_listId;
    }

    public String getParamFormName() {
        return this.m_paramFormName;
    }

    public String getParamListAction() {
        return this.m_paramListAction;
    }

    public String getParamPage() {
        return this.m_paramPage;
    }

    public String getParamSearchFilter() {
        return this.m_paramSearchFilter;
    }

    public String getParamSelItems() {
        return this.m_paramSelItems;
    }

    public String getParamSortCol() {
        return this.m_paramSortCol;
    }

    public CmsListItem getSelectedItem() {
        try {
            return this.getList().getItem(CmsStringUtil.splitAsArray(this.getParamSelItems(), "|")[0].trim());
        }
        catch (Exception e) {
            try {
                return this.getList().getItem("");
            }
            catch (Exception e1) {
                return null;
            }
        }
    }

    public List getSelectedItems() {
        Iterator it = CmsStringUtil.splitAsList(this.getParamSelItems(), "|", true).iterator();
        ArrayList<CmsListItem> items = new ArrayList<CmsListItem>();
        while (it.hasNext()) {
            String id = (String)it.next();
            items.add(this.getList().getItem(id));
        }
        return items;
    }

    public boolean isActive() {
        return this.m_active;
    }

    public synchronized void refreshList() {
        if (this.getList() == null) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_START_REFRESH_LIST_1", this.getListId()));
        }
        this.m_listState = this.getList().getState();
        this.getList().clear();
        this.fillList();
        this.getList().setState(this.m_listState);
        this.m_listState = null;
        this.listSave();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_END_REFRESH_LIST_1", this.getListId()));
        }
    }

    public void removeList() {
        this.setList(null);
        this.listSave();
    }

    public void setList(CmsHtmlList list) {
        this.m_list = list;
    }

    public void setListObject(Class listDialog, CmsHtmlList listObject) {
        if (listObject == null) {
            A_CmsListDialog.getListObjectMap(this.getSettings()).remove(listDialog.getName());
        } else {
            if (listObject.getMetadata() != null && listObject.getMetadata().isVolatile()) {
                listObject.setMetadata(null);
            }
            A_CmsListDialog.getListObjectMap(this.getSettings()).put(listDialog.getName(), listObject);
        }
    }

    public void setParamFormName(String formName) {
        this.m_paramFormName = formName;
    }

    public void setParamListAction(String listAction) {
        this.m_paramListAction = listAction;
    }

    public void setParamPage(String page) {
        this.m_paramPage = page;
    }

    public void setParamSearchFilter(String searchFilter) {
        this.m_paramSearchFilter = searchFilter;
    }

    public void setParamSelItems(String paramSelItems) {
        this.m_paramSelItems = paramSelItems;
    }

    public void setParamSortCol(String sortCol) {
        this.m_paramSortCol = sortCol;
    }

    public void writeDialog() throws IOException {
        if (this.isForwarded()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_START_WRITE_LIST_1", this.getListId()));
        }
        JspWriter out = this.getJsp().getJspContext().getOut();
        out.print(this.defaultActionHtml());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_END_WRITE_LIST_1", this.getListId()));
        }
    }

    protected String customHtmlEnd() {
        return this.dialogContentEnd();
    }

    protected String customHtmlStart() {
        return "";
    }

    protected String defaultActionHtmlContent() {
        StringBuffer result = new StringBuffer(2048);
        result.append("<form name='");
        result.append(this.getList().getId());
        result.append("-form' action='");
        result.append(this.getDialogRealUri());
        result.append("' method='post' class='nomargin'");
        if (this.getList().getMetadata().isSearchable()) {
            result.append(" onsubmit=\"listSearchAction('");
            result.append(this.getList().getId());
            result.append("', '");
            result.append(this.getList().getMetadata().getSearchAction().getId());
            result.append("', '");
            result.append(this.getList().getMetadata().getSearchAction().getConfirmationMessage().key(this.getLocale()));
            result.append("');\"");
        }
        result.append(">\n");
        result.append(this.allParamsAsHidden());
        result.append("\n");
        this.getList().setWp(this);
        result.append(this.getList().listHtml());
        result.append("\n</form>\n");
        return result.toString();
    }

    protected String defaultActionHtmlEnd() {
        StringBuffer result = new StringBuffer(2048);
        result.append(this.dialogEnd());
        result.append(this.bodyEnd());
        result.append(this.htmlEnd());
        return result.toString();
    }

    protected String defaultActionHtmlStart() {
        StringBuffer result = new StringBuffer(2048);
        result.append(this.htmlStart(null));
        result.append(this.getList().listJs());
        result.append(this.bodyStart("dialog", null));
        result.append(this.dialogStart());
        result.append(this.dialogContentStart(this.getParamTitle()));
        return result.toString();
    }

    protected void executeSearch() {
        this.getList().setSearchFilter(this.getParamSearchFilter());
    }

    protected void executeSelectPage() {
        int page = Integer.valueOf(this.getParamPage());
        this.getList().setCurrentPage(page);
    }

    protected void executeSort() {
        this.getList().setSortedColumn(this.getParamSortCol());
    }

    protected abstract void fillDetails(String var1);

    protected void fillList() {
        try {
            this.getList().setContent(this.getListItems());
            Iterator itDetails = this.getList().getMetadata().getItemDetailDefinitions().iterator();
            while (itDetails.hasNext()) {
                this.initializeDetail(((CmsListItemDetails)itDetails.next()).getId());
            }
        }
        catch (Exception e) {
            throw new CmsRuntimeException(Messages.get().container("ERR_LIST_FILL_1", this.getList().getName().key(this.getLocale()), null), (Throwable)e);
        }
    }

    protected abstract List getListItems() throws CmsException;

    protected CmsListState getListState() {
        if (this.m_listState != null) {
            return this.m_listState;
        }
        return this.getList().getState();
    }

    protected synchronized CmsListMetadata getMetadata(String listDialogName, String listId) {
        if (m_metadatas.get(listDialogName) == null || ((CmsListMetadata)m_metadatas.get(listDialogName)).isVolatile()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_START_METADATA_LIST_1", this.getListId()));
            }
            CmsListMetadata metadata = new CmsListMetadata(listId);
            this.setColumns(metadata);
            this.setSearchAction(metadata, this.m_searchColId);
            this.setIndependentActions(metadata);
            metadata.addIndependentAction(new CmsListPrintIAction());
            this.setMultiActions(metadata);
            metadata.checkIds();
            m_metadatas.put(listDialogName, metadata);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_END_METADATA_LIST_1", this.getListId()));
            }
        }
        return A_CmsListDialog.getMetadata(listDialogName);
    }

    protected void initializeDetail(String detailId) {
        if (this.getList().getMetadata().getItemDetailDefinition(detailId).isVisible() && this.getList().getTotalSize() > 0 && ((CmsListItem)this.getList().getAllContent().get(0)).get(detailId) == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_START_DETAILS_LIST_2", this.getListId(), detailId));
            }
            this.fillDetails(detailId);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Messages.get().getBundle().key("LOG_END_DETAILS_LIST_2", this.getListId(), detailId));
            }
        }
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        if (LIST_SEARCH.equals(this.getParamAction())) {
            this.setAction(81);
        } else if (LIST_SORT.equals(this.getParamAction())) {
            this.setAction(80);
        } else if (LIST_SELECT_PAGE.equals(this.getParamAction())) {
            this.setAction(82);
        } else if (LIST_INDEPENDENT_ACTION.equals(this.getParamAction())) {
            this.setAction(83);
        } else if (LIST_SINGLE_ACTION.equals(this.getParamAction())) {
            this.setAction(84);
        } else if (LIST_MULTI_ACTION.equals(this.getParamAction())) {
            this.setAction(85);
        }
        this.setParamStyle("new");
        try {
            this.validateParamaters();
        }
        catch (Exception e) {
            this.setAction(4);
            try {
                this.actionCloseDialog();
            }
            catch (JspException e1) {
                // empty catch block
            }
            return;
        }
    }

    protected synchronized void listRecovery(String listId) {
        CmsHtmlList list = A_CmsListDialog.getListObject(this.getClass(), this.getSettings());
        if (list != null && !list.getId().equals(listId)) {
            list = null;
        }
        this.setList(list);
    }

    protected synchronized void listSave() {
        this.setListObject(this.getClass(), this.getList());
    }

    protected abstract void setColumns(CmsListMetadata var1);

    protected abstract void setIndependentActions(CmsListMetadata var1);

    protected abstract void setMultiActions(CmsListMetadata var1);

    protected void setSearchAction(CmsListMetadata metadata, String columnId) {
        CmsListColumnDefinition col = metadata.getColumnDefinition(columnId);
        if (columnId != null && col != null && metadata.getSearchAction() == null) {
            CmsListSearchAction searchAction = new CmsListSearchAction(col);
            searchAction.useDefaultShowAllAction();
            metadata.setSearchAction(searchAction);
        }
    }

    protected void throwListUnsupportedActionException() throws CmsRuntimeException {
        throw new CmsRuntimeException(Messages.get().container("ERR_LIST_UNSUPPORTED_ACTION_2", this.getList().getName().key(this.getLocale()), this.getParamListAction()));
    }

    protected void validateParamaters() throws Exception {
    }
}

