/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import org.opencms.i18n.CmsMessageContainer;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.CmsListIndependentAction;
import org.opencms.workplace.list.I_CmsListAction;
import org.opencms.workplace.list.Messages;
import org.opencms.workplace.tools.A_CmsHtmlIconButton;
import org.opencms.workplace.tools.CmsHtmlIconButtonStyleEnum;

public abstract class A_CmsListSearchAction
extends CmsListIndependentAction {
    public static final String SEARCH_ACTION_ID = "search";
    public static final String SHOWALL_ACTION_ID = "showall";
    private static final CmsMessageContainer SEARCH_CONFIRMATION = new CmsMessageContainer(Messages.get(), "GUI_LIST_ACTION_SEARCH_CONF_0");
    private static final String SEARCH_ICON = "list/search.png";
    private static final CmsMessageContainer SEARCH_NAME = new CmsMessageContainer(Messages.get(), "GUI_LIST_ACTION_SEARCH_NAME_0");
    private static final CmsMessageContainer SHOWALL_CONFIRMATION = new CmsMessageContainer(Messages.get(), "GUI_LIST_ACTION_SHOWALL_CONF_0");
    private static final CmsMessageContainer SHOWALL_HELPTEXT = new CmsMessageContainer(Messages.get(), "GUI_LIST_ACTION_SHOWALL_HELP_0");
    private static final String SHOWALL_ICON = "list/showall.png";
    private static final CmsMessageContainer SHOWALL_NAME = new CmsMessageContainer(Messages.get(), "GUI_LIST_ACTION_SHOWALL_NAME_0");
    public final I_CmsListAction m_defaultShowAllAction;
    private I_CmsListAction m_showAllAction = null;

    protected A_CmsListSearchAction() {
        super(SEARCH_ACTION_ID);
        this.setName(SEARCH_NAME);
        this.setIconPath(SEARCH_ICON);
        this.setConfirmationMessage(SEARCH_CONFIRMATION);
        this.setHelpText(null);
        this.m_defaultShowAllAction = this.createDefaultShowAllAction();
    }

    public String buttonHtml(CmsWorkplace wp) {
        if (!this.isVisible()) {
            return "";
        }
        String onClic = "listSearchAction('" + this.getListId() + "', '" + this.getId() + "', '" + CmsStringUtil.escapeJavaScript(wp.resolveMacros(this.getConfirmationMessage().key(wp.getLocale()))) + "');";
        return A_CmsHtmlIconButton.defaultButtonHtml(CmsHtmlIconButtonStyleEnum.SMALL_ICON_TEXT, this.getId(), this.getName().key(wp.getLocale()), this.getHelpText().key(wp.getLocale()), this.isEnabled(), this.getIconPath(), null, onClic);
    }

    public I_CmsListAction getShowAllAction() {
        return this.m_showAllAction;
    }

    public void setListId(String listId) {
        super.setListId(listId);
        this.m_defaultShowAllAction.setListId(listId);
    }

    public void setShowAllAction(I_CmsListAction showAllAction) {
        this.m_showAllAction = showAllAction;
    }

    public void useDefaultShowAllAction() {
        this.m_showAllAction = this.m_defaultShowAllAction;
    }

    private I_CmsListAction createDefaultShowAllAction() {
        CmsListIndependentAction defaultShowAllAction = new CmsListIndependentAction(SHOWALL_ACTION_ID){

            public String buttonHtml(CmsWorkplace wp) {
                if (!this.isVisible()) {
                    return "";
                }
                String onClic = "listSearchAction('" + this.getListId() + "', '" + this.getId() + "', '" + CmsStringUtil.escapeJavaScript(wp.resolveMacros(this.getConfirmationMessage().key(wp.getLocale()))) + "');";
                return A_CmsHtmlIconButton.defaultButtonHtml(CmsHtmlIconButtonStyleEnum.SMALL_ICON_TEXT, this.getId(), this.getName().key(wp.getLocale()), this.getHelpText().key(wp.getLocale()), this.isEnabled(), this.getIconPath(), null, onClic);
            }
        };
        defaultShowAllAction.setName(SHOWALL_NAME);
        defaultShowAllAction.setHelpText(SHOWALL_HELPTEXT);
        defaultShowAllAction.setIconPath(SHOWALL_ICON);
        defaultShowAllAction.setConfirmationMessage(SHOWALL_CONFIRMATION);
        return defaultShowAllAction;
    }
}

