/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.CmsListIndependentAction;
import org.opencms.workplace.tools.CmsIdentifiableObjectContainer;

public class CmsListDropdownAction
extends CmsListIndependentAction {
    public static final String SUFFIX_PARAM = "-sel";
    private List m_ids = new ArrayList();
    private CmsIdentifiableObjectContainer m_items = new CmsIdentifiableObjectContainer(true, false);
    private String m_selection = null;

    public CmsListDropdownAction(String id) {
        super(id);
    }

    public void addItem(String id, CmsMessageContainer name) {
        this.m_ids.add(id);
        this.m_items.addIdentifiableObject(id, name);
    }

    public String buttonHtml(CmsWorkplace wp) {
        StringBuffer html = new StringBuffer(512);
        html.append("\t<span class='link'");
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getHelpText().key(wp.getLocale()))) {
            html.append(" onMouseOver=\"sMH('");
            html.append(this.getId());
            html.append("');\" onMouseOut=\"hMH('");
            html.append(this.getId());
            html.append("');\"");
        }
        html.append("><p>");
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getIconPath())) {
            html.append("<img src='");
            html.append(CmsWorkplace.getSkinUri());
            if (!this.isEnabled()) {
                StringBuffer icon = new StringBuffer(128);
                icon.append(this.getIconPath().substring(0, this.getIconPath().lastIndexOf(46)));
                icon.append("_disabled");
                icon.append(this.getIconPath().substring(this.getIconPath().lastIndexOf(46)));
                if (wp.getCms().existsResource("/system/workplace/resources/" + icon.toString())) {
                    html.append(icon);
                } else {
                    html.append(this.getIconPath());
                }
            } else {
                html.append(this.getIconPath());
            }
            html.append("'");
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getName().key(wp.getLocale()))) {
                html.append(" alt='");
                html.append(this.getName().key(wp.getLocale()));
                html.append("'");
                html.append(" title='");
                html.append(this.getName().key(wp.getLocale()));
                html.append("'");
            }
            html.append(">");
        }
        html.append(this.getName().key(wp.getLocale()));
        html.append("<select name='").append(this.getId()).append(SUFFIX_PARAM).append("' onchange=\"");
        html.append(this.resolveOnClic(wp)).append("\">\n");
        Iterator it = this.m_ids.iterator();
        while (it.hasNext()) {
            String itemId = (String)it.next();
            html.append("\t\t\t\t<option value='");
            html.append(itemId);
            html.append("'");
            html.append(itemId.equals(this.getSelection()) ? " selected" : "");
            html.append(">");
            html.append(((CmsMessageContainer)this.m_items.getObject(itemId)).key(wp.getLocale()));
            html.append("</option>\n");
        }
        html.append("</select>\n");
        html.append("</p></span>");
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getHelpText().key(wp.getLocale()))) {
            html.append("<div class='help' id='help");
            html.append(this.getId());
            html.append("' onMouseOver=\"sMH('");
            html.append(this.getId());
            html.append("');\" onMouseOut=\"hMH('");
            html.append(this.getId());
            html.append("');\">");
            html.append(this.getHelpText().key(wp.getLocale()));
            html.append("</div>\n");
        }
        return html.toString();
    }

    public String getSelection() {
        return this.m_selection;
    }

    public void setSelection(String selection) {
        this.m_selection = selection;
    }
}

