/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsHtmlList;
import org.opencms.workplace.list.CmsListExplorerColumn;
import org.opencms.workplace.list.Messages;
import org.opencms.workplace.tools.A_CmsHtmlIconButton;
import org.opencms.workplace.tools.CmsHtmlIconButtonStyleEnum;
import org.opencms.workplace.tools.CmsToolMacroResolver;

public class CmsListPrintDialog
extends CmsDialog {
    public static final String PARAM_LISTCLASS = "listclass";
    private final CmsHtmlList m_list;
    private String m_paramListclass;

    public CmsListPrintDialog(CmsJspActionElement jsp) throws ClassNotFoundException {
        super(jsp);
        this.setParamStyle("new");
        this.m_list = A_CmsListDialog.getListObject(Class.forName(this.getParamListclass()), this.getSettings());
    }

    public CmsListPrintDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) throws ClassNotFoundException {
        this(new CmsJspActionElement(context, req, res));
    }

    public String dialogTitle() {
        StringBuffer html = new StringBuffer(512);
        CmsMessages message = Messages.get().getBundle(this.getLocale());
        html.append("<div class='screenTitle'>\n");
        html.append("\t<table width='100%' cellspacing='0'>\n");
        html.append("\t\t<tr>\n");
        html.append("\t\t\t<td>\n");
        html.append(this.m_list.getName().key(this.getLocale()));
        html.append("\n\t\t\t</td>");
        html.append("\t\t\t<td class='uplevel'>\n\t\t\t\t");
        html.append(A_CmsHtmlIconButton.defaultButtonHtml(CmsHtmlIconButtonStyleEnum.SMALL_ICON_TEXT, "id-print", message.key("GUI_ACTION_PRINT_NAME_0"), message.key("GUI_ACTION_PRINT_HELP_0"), true, "list/print.png", null, "print();"));
        html.append("\n\t\t\t</td>\n");
        html.append("\t\t</tr>\n");
        html.append("\t</table>\n");
        html.append("</div>\n");
        return CmsToolMacroResolver.resolveMacros(html.toString(), this);
    }

    public String generateHtml() {
        StringBuffer result = new StringBuffer(2048);
        result.append(this.htmlStart(null));
        result.append(CmsListExplorerColumn.getExplorerStyleDef());
        result.append(this.bodyStart("dialog", null));
        result.append(this.dialogStart());
        result.append(this.dialogContentStart(this.getParamTitle()));
        result.append(this.m_list.printableHtml());
        result.append(this.dialogContentEnd());
        result.append(this.dialogEnd());
        result.append(this.bodyEnd());
        result.append(this.htmlEnd());
        return result.toString();
    }

    public String getParamListclass() {
        return this.m_paramListclass;
    }

    public void setParamListclass(String listclass) {
        this.m_paramListclass = listclass;
    }
}

