/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.list;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.A_CmsListSearchAction;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.I_CmsSearchMethod;
import org.opencms.workplace.list.Messages;

public class CmsListSearchAction
extends A_CmsListSearchAction
implements I_CmsSearchMethod {
    private final List m_columns = new ArrayList();

    public CmsListSearchAction(CmsListColumnDefinition column) {
        this.useDefaultShowAllAction();
        this.m_columns.add(column);
    }

    public void addColumn(CmsListColumnDefinition column) {
        this.m_columns.add(column);
    }

    public String buttonHtml(CmsWorkplace wp) {
        if (this.getHelpText() == EMPTY_MESSAGE) {
            String columns = "";
            Iterator it = this.m_columns.iterator();
            while (it.hasNext()) {
                CmsListColumnDefinition col = (CmsListColumnDefinition)it.next();
                columns = columns + "${key." + col.getName().getKey() + "}";
                if (!it.hasNext()) continue;
                columns = columns + ", ";
            }
            if (columns.lastIndexOf(", ") > 0) {
                columns = columns.substring(0, columns.lastIndexOf(", ")) + " and " + columns.substring(columns.lastIndexOf(", ") + 2);
            }
            this.setHelpText(new CmsMessageContainer(Messages.get(), "GUI_LIST_ACTION_SEARCH_HELP_1", new Object[]{columns}));
        }
        return super.buttonHtml(wp);
    }

    public List filter(List items, String filter) {
        ArrayList<CmsListItem> res = new ArrayList<CmsListItem>();
        Iterator itItems = items.iterator();
        block0: while (itItems.hasNext()) {
            CmsListItem item = (CmsListItem)itItems.next();
            if (res.contains(item)) continue;
            Iterator itCols = this.m_columns.iterator();
            while (itCols.hasNext()) {
                CmsListColumnDefinition col = (CmsListColumnDefinition)itCols.next();
                if (item.get(col.getId()) == null || item.get(col.getId()).toString().indexOf(filter) <= -1) continue;
                res.add(item);
                continue block0;
            }
        }
        return res;
    }

    public List getColumns() {
        return Collections.unmodifiableList(this.m_columns);
    }

    public void setWp(A_CmsListDialog wp) {
        super.setWp(wp);
        if (this.getShowAllAction() != null) {
            this.getShowAllAction().setWp(wp);
        }
    }
}

