/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.search.CmsSearch;
import org.opencms.search.CmsSearchParameters;
import org.opencms.search.CmsSearchResult;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.explorer.CmsResourceUtil;
import org.opencms.workplace.list.A_CmsListExplorerDialog;
import org.opencms.workplace.list.A_CmsListResourceCollector;
import org.opencms.workplace.list.CmsListItem;

public class CmsSearchResourcesCollector
extends A_CmsListResourceCollector {
    public static final String COLLECTOR_NAME = "searchresources";
    public static final String PARAM_FIELDS = "fields";
    public static final String PARAM_MAXCREATIONDATE = "maxCreationDate";
    public static final String PARAM_MAXLASTMODIFICATIONDATE = "maxLastModificationDate";
    public static final String PARAM_MINCREATIONDATE = "minCreationDate";
    public static final String PARAM_MINLASTMODIFICATIONDATE = "minLastModificationDate";
    public static final String PARAM_QUERY = "query";
    public static final String PARAM_SORT = "sort";
    protected Map m_srCache = new HashMap();
    private CmsSearch m_searchBean;
    private List m_searchResults;

    public CmsSearchResourcesCollector(A_CmsListExplorerDialog wp, String query, String sort, String fields, List searchRoots, String minCreationDate, String maxCreationDate, String minLastModificationDate, String maxLastModificationDate) {
        super(wp);
        this.m_collectorParameter = this.m_collectorParameter + "|query:" + query;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(sort)) {
            this.m_collectorParameter = this.m_collectorParameter + "|sort:" + sort;
        }
        this.m_collectorParameter = this.m_collectorParameter + "|fields:" + fields;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(minCreationDate) && !minCreationDate.equals("0")) {
            this.m_collectorParameter = this.m_collectorParameter + "|minCreationDate:" + minCreationDate;
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(maxCreationDate) && !maxCreationDate.equals("0")) {
            this.m_collectorParameter = this.m_collectorParameter + "|maxCreationDate:" + maxCreationDate;
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(minLastModificationDate) && !minLastModificationDate.equals("0")) {
            this.m_collectorParameter = this.m_collectorParameter + "|minLastModificationDate:" + minLastModificationDate;
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(maxLastModificationDate) && !maxLastModificationDate.equals("0")) {
            this.m_collectorParameter = this.m_collectorParameter + "|maxLastModificationDate:" + maxLastModificationDate;
        }
        this.setResourcesParam(searchRoots);
    }

    public List getCollectorNames() {
        ArrayList<String> names = new ArrayList<String>();
        names.add(COLLECTOR_NAME);
        return names;
    }

    public List getResources(CmsObject cms, Map params) throws CmsException {
        List result = this.getSearchResults(params);
        int count = this.getSearchBean(params).getSearchResultCount();
        Object[] objs = new Object[count];
        Arrays.fill(objs, new Object());
        int from = (this.getSearchBean(params).getSearchPage() - 1) * this.getSearchBean(params).getMatchesPerPage();
        int siteLen = cms.getRequestContext().getSiteRoot().length();
        Iterator it = result.iterator();
        while (it.hasNext()) {
            CmsSearchResult sr = (CmsSearchResult)it.next();
            CmsResource resource = cms.readResource(sr.getPath().substring(siteLen), CmsResourceFilter.ALL);
            this.m_resCache.put(resource.getStructureId().toString(), resource);
            this.m_srCache.put(resource.getStructureId().toString(), sr);
            objs[from] = resource;
            ++from;
        }
        return Arrays.asList(objs);
    }

    public CmsSearchResult getSearchResult(String structureId) {
        return (CmsSearchResult)this.m_srCache.get(structureId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPage(int page) {
        CmsSearchResourcesCollector cmsSearchResourcesCollector = this;
        synchronized (cmsSearchResourcesCollector) {
            super.setPage(page);
            this.m_searchBean = null;
            this.m_searchResults = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getInternalResources(CmsObject cms, Map params) throws CmsException {
        CmsSearchResourcesCollector cmsSearchResourcesCollector = this;
        synchronized (cmsSearchResourcesCollector) {
            if (this.m_resources == null) {
                this.m_resources = this.getResources(cms, params);
            }
        }
        return this.m_resources;
    }

    protected void setAdditionalColumns(CmsListItem item, CmsResourceUtil resUtil) {
        item.set("cs", new Integer(this.getSearchResult(item.getId()).getScore()));
    }

    private CmsSearch getSearchBean(Map params) {
        if (this.m_searchBean == null) {
            this.m_searchBean = new CmsSearch();
            this.m_searchBean.init(this.getWp().getCms());
            this.m_searchBean.setParameters(this.getSearchParameters(params));
            this.m_searchBean.setIndex(this.getWp().getSettings().getUserSettings().getWorkplaceSearchIndexName());
            this.m_searchBean.setMatchesPerPage(this.getWp().getSettings().getUserSettings().getExplorerFileEntries());
            this.m_searchBean.setSearchPage(Integer.parseInt((String)params.get("page")));
            List resources = this.getResourceNamesFromParam(params);
            String[] searchRoots = new String[resources.size()];
            resources.toArray(searchRoots);
            this.m_searchBean.setSearchRoots(searchRoots);
        } else {
            int page = Integer.parseInt((String)params.get("page"));
            if (this.m_searchBean.getSearchPage() != page) {
                this.m_searchBean.setSearchPage(page);
                this.m_searchResults = null;
            }
        }
        return this.m_searchBean;
    }

    private CmsSearchParameters getSearchParameters(Map params) {
        CmsSearchParameters searchParams = new CmsSearchParameters();
        searchParams.setQuery((String)params.get(PARAM_QUERY));
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)params.get(PARAM_SORT))) {
            searchParams.setSortName((String)params.get(PARAM_SORT));
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)params.get(PARAM_MINCREATIONDATE))) {
            searchParams.setMinDateCreated(Long.parseLong((String)params.get(PARAM_MINCREATIONDATE)));
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)params.get(PARAM_MAXCREATIONDATE))) {
            searchParams.setMaxDateCreated(Long.parseLong((String)params.get(PARAM_MAXCREATIONDATE)));
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)params.get(PARAM_MINLASTMODIFICATIONDATE))) {
            searchParams.setMinDateLastModified(Long.parseLong((String)params.get(PARAM_MINLASTMODIFICATIONDATE)));
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)params.get(PARAM_MAXLASTMODIFICATIONDATE))) {
            searchParams.setMaxDateLastModified(Long.parseLong((String)params.get(PARAM_MAXLASTMODIFICATIONDATE)));
        }
        List fields = CmsStringUtil.splitAsList((String)params.get(PARAM_FIELDS), ',');
        searchParams.setFields(fields);
        searchParams.setSearchPage(Integer.parseInt((String)params.get("page")));
        return searchParams;
    }

    private List getSearchResults(Map params) {
        if (this.m_searchResults == null) {
            this.m_searchResults = this.getSearchBean(params).getSearchResult();
            this.m_searchResults = this.m_searchResults == null ? Collections.EMPTY_LIST : this.m_searchResults;
        }
        return this.m_searchResults;
    }
}

