/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.threads;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.report.A_CmsReportThread;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.threads.Messages;

public class CmsProjectDeleteThread
extends A_CmsReportThread {
    private static final Log LOG = CmsLog.getLog(CmsProjectDeleteThread.class);
    private Throwable m_error;
    private CmsUUID m_projectId;

    public CmsProjectDeleteThread(CmsObject cms, CmsUUID projectId) {
        super(cms, Messages.get().getBundle().key("GUI_DELETE_PROJECT_THREAD_NAME_1", projectId));
        this.m_projectId = projectId;
    }

    public Throwable getError() {
        return this.m_error;
    }

    public String getReportUpdate() {
        return "";
    }

    public void run() {
        try {
            this.getCms().deleteProject(this.m_projectId);
        }
        catch (Throwable e) {
            this.m_error = e;
            LOG.warn((Object)Messages.get().getBundle().key("LOG_PROJECT_DELETE_FAILED_1", this.m_projectId), e);
        }
    }
}

