/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsMessages;
import org.opencms.jsp.CmsJspNavBuilder;
import org.opencms.jsp.CmsJspNavElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.tools.CmsToolRootHandler;
import org.opencms.workplace.tools.I_CmsToolHandler;

public abstract class A_CmsToolHandler
implements I_CmsToolHandler {
    public static final String ARG_PARAM_NAME = "params";
    public static final String ARG_PATH_NAME = "path";
    public static final String ARGS_PROPERTY_DEFINITION = "admintoolhandler-args";
    public static final String ARGUMENT_SEPARATOR = "|";
    public static final String DEFAULT_DISABLED_HELPTEXT = "${key.GUI_TOOLS_DISABLED_HELP_0}";
    public static final String VALUE_SEPARATOR = ":";
    private static final String ARG_CONFIRMATION_NAME = "confirmation";
    private static final Log LOG = CmsLog.getLog(A_CmsToolHandler.class);
    private String m_confirmationMessage;
    private String m_disabledHelpText;
    private String m_group;
    private String m_helpText;
    private String m_iconPath;
    private String m_link;
    private String m_name;
    private String m_parameters;
    private String m_path;
    private float m_position;
    private String m_shortName;
    private String m_smallIconPath;

    public String getConfirmationMessage() {
        return this.m_confirmationMessage;
    }

    public String getDisabledHelpText() {
        return this.m_disabledHelpText;
    }

    public String getGroup() {
        return this.m_group;
    }

    public String getHelpText() {
        return this.m_helpText;
    }

    public String getIconPath() {
        return this.m_iconPath;
    }

    public String getLink() {
        return this.m_link;
    }

    public String getName() {
        return this.m_name;
    }

    public Map getParameters(CmsWorkplace wp) {
        HashMap<String, String> argMap = new HashMap<String, String>();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.m_parameters)) {
            String toolParams = CmsEncoder.decode(wp.resolveMacros(this.m_parameters));
            Iterator itArgs = CmsStringUtil.splitAsList(toolParams, "&").iterator();
            while (itArgs.hasNext()) {
                int pos;
                String arg = (String)itArgs.next();
                if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(arg.substring((pos = arg.indexOf("=")) + 1))) continue;
                argMap.put(arg.substring(0, pos), arg.substring(pos + 1));
            }
        }
        return argMap;
    }

    public String getPath() {
        return this.m_path;
    }

    public float getPosition() {
        return this.m_position;
    }

    public String getShortName() {
        return this.m_shortName;
    }

    public String getSmallIconPath() {
        return this.m_smallIconPath;
    }

    public boolean isEnabled(CmsWorkplace wp) {
        return this.isEnabled(wp.getCms());
    }

    public boolean isVisible(CmsWorkplace wp) {
        return this.isVisible(wp.getCms());
    }

    public void setConfirmationMessage(String confirmationMessage) {
        this.m_confirmationMessage = confirmationMessage;
    }

    public void setDisabledHelpText(String disabledHelpText) {
        this.m_disabledHelpText = disabledHelpText;
    }

    public void setGroup(String group) {
        this.m_group = group;
    }

    public void setHelpText(String helpText) {
        this.m_helpText = helpText;
    }

    public void setIconPath(String iconPath) {
        this.m_iconPath = iconPath;
    }

    public void setLink(String link) {
        this.m_link = link;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setParameterString(String paramString) {
        this.m_parameters = paramString;
    }

    public void setPath(String path) {
        this.m_path = path;
    }

    public void setPosition(float position) {
        this.m_position = position;
    }

    public void setShortName(String shortName) {
        this.m_shortName = shortName;
    }

    public void setSmallIconPath(String smallIconPath) {
        this.m_smallIconPath = smallIconPath;
    }

    public boolean setup(CmsObject cms, CmsToolRootHandler root, String resourcePath) {
        block10: {
            try {
                resourcePath = cms.getSitePath(cms.readResource(resourcePath));
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block10;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        CmsJspNavElement navElem = CmsJspNavBuilder.getNavigationForResource(cms, resourcePath);
        String name = navElem.getNavText();
        if (CmsMessages.isUnknownKey(name)) {
            name = navElem.getTitle();
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(name)) {
            name = "${key.GUI_TOOLS_DEFAULT_NAME_0}";
        }
        String shortName = name;
        if (name.indexOf(VALUE_SEPARATOR) >= 0) {
            shortName = name.substring(0, name.indexOf(VALUE_SEPARATOR));
            name = name.substring(name.indexOf(VALUE_SEPARATOR) + 1);
        }
        this.setName(name);
        this.setShortName(shortName);
        String iconPath = navElem.getNavImage();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(iconPath)) {
            iconPath = "admin/images/default_tool_big.png:admin/images/default_tool_small.png";
        }
        String smallIconPath = iconPath;
        if (iconPath.indexOf(VALUE_SEPARATOR) >= 0) {
            smallIconPath = iconPath.substring(iconPath.indexOf(VALUE_SEPARATOR) + 1);
            iconPath = iconPath.substring(0, iconPath.indexOf(VALUE_SEPARATOR));
        }
        this.setIconPath(iconPath);
        this.setSmallIconPath(smallIconPath);
        String helpText = navElem.getDescription();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(helpText)) {
            helpText = "${key.GUI_TOOLS_DEFAULT_HELP_0}";
        }
        String disabledHelpText = DEFAULT_DISABLED_HELPTEXT;
        if (helpText.indexOf(VALUE_SEPARATOR) >= 0) {
            disabledHelpText = helpText.substring(helpText.indexOf(VALUE_SEPARATOR) + 1);
            helpText = helpText.substring(0, helpText.indexOf(VALUE_SEPARATOR));
        }
        this.setHelpText(helpText);
        this.setDisabledHelpText(disabledHelpText);
        String group = navElem.getInfo();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(group)) {
            group = "${key.GUI_TOOLS_DEFAULT_GROUP_0}";
        }
        String path = resourcePath;
        this.setLink(cms, resourcePath);
        path = CmsResource.isFolder(path) ? "/" + resourcePath.substring(root.getUri().length(), resourcePath.lastIndexOf("/")) : (resourcePath.lastIndexOf(46) > -1 ? "/" + resourcePath.substring(root.getUri().length(), resourcePath.lastIndexOf(46)) : "/" + resourcePath.substring(root.getUri().length()));
        this.setPath(path);
        this.setGroup(group);
        this.setPosition(navElem.getNavPosition());
        this.setParameters(cms, resourcePath);
        return !path.equals(resourcePath);
    }

    public String toString() {
        return this.m_path + " - " + this.m_group + " - " + this.m_position;
    }

    protected void setLink(CmsObject cms, String resourcePath) {
        String link = resourcePath;
        try {
            cms.readFolder(resourcePath);
            if (resourcePath.endsWith("/")) {
                resourcePath = resourcePath.substring(0, resourcePath.lastIndexOf("/"));
            }
            link = "/system/workplace/views/admin/admin-main.jsp";
            CmsProperty prop = cms.readPropertyObject(resourcePath, "default-file", false);
            String defFile = "index.jsp";
            if (!prop.isNullProperty()) {
                defFile = prop.getValue();
            }
            if (!defFile.startsWith("/")) {
                defFile = resourcePath + "/" + defFile;
            }
            if (defFile.indexOf("?") > 0) {
                if (cms.existsResource(defFile.substring(0, defFile.indexOf("?")))) {
                    link = defFile;
                }
            } else if (cms.existsResource(defFile)) {
                link = defFile;
            }
        }
        catch (CmsException e) {
            // empty catch block
        }
        this.setLink(link);
    }

    protected void setParameters(CmsObject cms, String resourcePath) {
        block9: {
            try {
                CmsProperty prop = cms.readPropertyObject(resourcePath, ARGS_PROPERTY_DEFINITION, false);
                if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(prop.getValue())) {
                    HashMap<String, String> argsMap = new HashMap<String, String>();
                    Iterator itArgs = CmsStringUtil.splitAsList(prop.getValue(), ARGUMENT_SEPARATOR).iterator();
                    while (itArgs.hasNext()) {
                        String arg = "";
                        try {
                            arg = (String)itArgs.next();
                            int pos = arg.indexOf(VALUE_SEPARATOR);
                            argsMap.put(arg.substring(0, pos), arg.substring(pos + 1));
                        }
                        catch (StringIndexOutOfBoundsException e) {
                            LOG.error((Object)("sep: :arg: " + arg));
                            throw e;
                        }
                    }
                    if (argsMap.get(ARG_PATH_NAME) != null) {
                        this.setPath((String)argsMap.get(ARG_PATH_NAME));
                    }
                    if (argsMap.get(ARG_CONFIRMATION_NAME) != null) {
                        this.setConfirmationMessage((String)argsMap.get(ARG_CONFIRMATION_NAME));
                    }
                    if (argsMap.get(ARG_PARAM_NAME) != null) {
                        this.setParameterString((String)argsMap.get(ARG_PARAM_NAME));
                    }
                }
            }
            catch (CmsException e) {
                if (!LOG.isErrorEnabled()) break block9;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }
}

