/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opencms.workplace.tools.I_CmsIdentifiableObjectContainer;

public class CmsIdentifiableObjectContainer
implements I_CmsIdentifiableObjectContainer {
    private List m_cache;
    private final List m_objectList = new ArrayList();
    private final Map m_objectsById = new HashMap();
    private final boolean m_relativeOrdered;
    private final boolean m_uniqueIds;

    public CmsIdentifiableObjectContainer(boolean uniqueIds, boolean relativeOrdered) {
        this.m_uniqueIds = uniqueIds;
        this.m_relativeOrdered = relativeOrdered;
    }

    public void addIdentifiableObject(String id, Object idObject) {
        this.m_cache = null;
        if (this.m_uniqueIds && this.m_objectsById.get(id) != null) {
            this.removeObject(id);
        }
        if (this.m_relativeOrdered) {
            float pos = 1.0f;
            if (!this.m_objectList.isEmpty()) {
                pos = ((CmsIdObjectElement)this.m_objectList.get(this.m_objectList.size() - 1)).getPosition() + 1.0f;
            }
            this.m_objectList.add(new CmsIdObjectElement(idObject, pos));
        } else {
            this.m_objectList.add(idObject);
        }
        if (this.m_uniqueIds) {
            this.m_objectsById.put(id, idObject);
        } else {
            Object prevObj = this.m_objectsById.get(id);
            if (prevObj == null) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(idObject);
                this.m_objectsById.put(id, list);
            } else {
                ((List)prevObj).add(idObject);
            }
        }
    }

    public void addIdentifiableObject(String id, Object idObject, float position) {
        this.m_cache = null;
        if (this.m_uniqueIds && this.m_objectsById.get(id) != null) {
            this.removeObject(id);
        }
        if (this.m_relativeOrdered) {
            CmsIdObjectElement element;
            int pos = 0;
            Iterator itElems = this.m_objectList.iterator();
            while (itElems.hasNext() && !((element = (CmsIdObjectElement)itElems.next()).getPosition() > position)) {
                ++pos;
            }
            this.m_objectList.add(pos, new CmsIdObjectElement(idObject, position));
        } else {
            this.m_objectList.add((int)position, idObject);
        }
        if (this.m_uniqueIds) {
            this.m_objectsById.put(id, idObject);
        } else {
            Object prevObj = this.m_objectsById.get(id);
            if (prevObj == null) {
                ArrayList<Object> list = new ArrayList<Object>();
                list.add(idObject);
                this.m_objectsById.put(id, list);
            } else {
                ((List)prevObj).add(idObject);
            }
        }
    }

    public void clear() {
        this.m_cache = null;
        this.m_objectList.clear();
        this.m_objectsById.clear();
    }

    public List elementList() {
        if (this.m_cache != null) {
            return this.m_cache;
        }
        if (this.m_relativeOrdered) {
            ArrayList<Object> objectList = new ArrayList<Object>();
            Iterator itObjs = this.m_objectList.iterator();
            while (itObjs.hasNext()) {
                CmsIdObjectElement object = (CmsIdObjectElement)itObjs.next();
                objectList.add(object.getObject());
            }
            this.m_cache = Collections.unmodifiableList(objectList);
        } else {
            this.m_cache = Collections.unmodifiableList(this.m_objectList);
        }
        return this.m_cache;
    }

    public Object getObject(String id) {
        return this.m_objectsById.get(id);
    }

    public synchronized void removeObject(String id) {
        this.m_cache = null;
        if (this.m_relativeOrdered) {
            if (this.m_uniqueIds) {
                Object o = this.getObject(id);
                Iterator itObjs = this.m_objectList.iterator();
                while (itObjs.hasNext()) {
                    CmsIdObjectElement object = (CmsIdObjectElement)itObjs.next();
                    if (object.getObject() != o) continue;
                    itObjs.remove();
                    break;
                }
                this.m_objectsById.remove(id);
            } else {
                Iterator itRemove = ((List)this.getObject(id)).iterator();
                block1: while (itRemove.hasNext()) {
                    Object o = itRemove.next();
                    Iterator itObjs = this.m_objectList.iterator();
                    while (itObjs.hasNext()) {
                        CmsIdObjectElement object = (CmsIdObjectElement)itObjs.next();
                        if (object.getObject() != o) continue;
                        itObjs.remove();
                        continue block1;
                    }
                }
                this.m_objectsById.remove(id);
            }
        } else {
            Object o = this.getObject(id);
            this.m_objectList.remove(o);
            this.m_objectsById.remove(id);
        }
    }

    private static class CmsIdObjectElement {
        private final Object m_object;
        private final float m_position;

        public CmsIdObjectElement(Object object, float position) {
            this.m_object = object;
            this.m_position = position;
        }

        public Object getObject() {
            return this.m_object;
        }

        public float getPosition() {
            return this.m_position;
        }
    }
}

