/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.FastHashMap;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.Messages;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsXmlContentTypeManager {
    private static final Log LOG = CmsLog.getLog(CmsXmlContentTypeManager.class);
    private Map m_contentHandlers;
    private Map m_defaultWidgets;
    private Map m_registeredTypes = new HashMap();
    private Map m_registeredWidgets;
    private Map m_widgetAliases;

    public CmsXmlContentTypeManager() {
        this.m_defaultWidgets = new HashMap();
        this.m_registeredWidgets = new HashMap();
        this.m_widgetAliases = new HashMap();
        FastHashMap fastMap = new FastHashMap();
        fastMap.setFast(true);
        this.m_contentHandlers = fastMap;
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_START_CONTENT_CONFIG_0"));
        }
    }

    public static CmsXmlContentTypeManager createTypeManagerForTestCases() {
        CmsXmlContentTypeManager typeManager = new CmsXmlContentTypeManager();
        typeManager.addWidget("org.opencms.widgets.CmsCalendarWidget", null);
        typeManager.addWidget("org.opencms.widgets.CmsHtmlWidget", null);
        typeManager.addWidget("org.opencms.widgets.CmsInputWidget", null);
        typeManager.addSchemaType("org.opencms.xml.types.CmsXmlDateTimeValue", "org.opencms.widgets.CmsCalendarWidget");
        typeManager.addSchemaType("org.opencms.xml.types.CmsXmlHtmlValue", "org.opencms.widgets.CmsHtmlWidget");
        typeManager.addSchemaType("org.opencms.xml.types.CmsXmlLocaleValue", "org.opencms.widgets.CmsInputWidget");
        typeManager.addSchemaType("org.opencms.xml.types.CmsXmlStringValue", "org.opencms.widgets.CmsInputWidget");
        try {
            typeManager.initialize(null);
        }
        catch (CmsRoleViolationException e) {
            throw new CmsRuntimeException(Messages.get().container("ERR_INIT_TYPE_MANAGER_0"));
        }
        return typeManager;
    }

    public I_CmsXmlSchemaType addContentType(Class clazz) throws CmsXmlException {
        I_CmsXmlSchemaType type;
        try {
            type = (I_CmsXmlSchemaType)clazz.newInstance();
        }
        catch (InstantiationException e) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_XCC_TYPE_REGISTERED_0"));
        }
        catch (IllegalAccessException e) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_XCC_TYPE_REGISTERED_0"));
        }
        catch (ClassCastException e) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_XCC_TYPE_REGISTERED_0"));
        }
        this.m_registeredTypes.put(type.getTypeName(), type);
        return type;
    }

    public void addSchemaType(String className, String defaultWidget) {
        I_CmsXmlSchemaType type;
        Class<?> classClazz;
        try {
            classClazz = Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_XML_CONTENT_SCHEMA_TYPE_CLASS_NOT_FOUND_1", className), (Throwable)e);
            return;
        }
        try {
            type = this.addContentType(classClazz);
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INIT_XML_CONTENT_SCHEMA_TYPE_CLASS_ERROR_1", classClazz.getName()), (Throwable)e);
            return;
        }
        I_CmsWidget widget = this.getWidget(defaultWidget);
        if (widget == null) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_INIT_DEFAULT_WIDGET_FOR_CONTENT_TYPE_2", defaultWidget, type.getTypeName()));
            return;
        }
        this.m_defaultWidgets.put(type.getTypeName(), widget);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_ST_USING_WIDGET_2", type.getTypeName(), widget.getClass().getName()));
        }
    }

    public void addWidget(String className, String aliasName) {
        I_CmsWidget widget;
        Class<?> widgetClazz;
        try {
            widgetClazz = Class.forName(className);
            widget = (I_CmsWidget)widgetClazz.newInstance();
        }
        catch (Exception e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_XML_WIDGET_INITIALIZING_ERROR_1", className), (Throwable)e);
            return;
        }
        this.m_registeredWidgets.put(widgetClazz.getName(), widget);
        if (aliasName != null) {
            this.m_widgetAliases.put(aliasName, widgetClazz.getName());
        }
        if (CmsLog.INIT.isInfoEnabled()) {
            if (aliasName != null) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_WIDGET_1", widgetClazz.getName()));
            } else {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_ADD_WIDGET_ALIAS_2", widgetClazz.getName(), aliasName));
            }
        }
    }

    public I_CmsXmlContentHandler getContentHandler(String className, String schemaLocation) throws CmsXmlException {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(schemaLocation);
        buffer.append('#');
        buffer.append(className);
        String key = buffer.toString();
        I_CmsXmlContentHandler contentHandler = (I_CmsXmlContentHandler)this.m_contentHandlers.get(key);
        if (contentHandler != null) {
            return contentHandler;
        }
        try {
            contentHandler = (I_CmsXmlContentHandler)Class.forName(className).newInstance();
        }
        catch (InstantiationException e) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_CONTENT_HANDLER_1", key));
        }
        catch (IllegalAccessException e) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_CONTENT_HANDLER_1", key));
        }
        catch (ClassCastException e) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_CONTENT_HANDLER_1", key));
        }
        catch (ClassNotFoundException e) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_CONTENT_HANDLER_1", key));
        }
        this.m_contentHandlers.put(key, contentHandler);
        return contentHandler;
    }

    public I_CmsXmlSchemaType getContentType(Element typeElement, Set nestedDefinitions) throws CmsXmlException {
        if (!CmsXmlContentDefinition.XSD_NODE_ELEMENT.equals((Object)typeElement.getQName())) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_CD_SCHEMA_STRUCTURE_0"));
        }
        if (typeElement.elements().size() > 0) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_CD_SCHEMA_STRUCTURE_0"));
        }
        String elementName = typeElement.attributeValue("name");
        String typeName = typeElement.attributeValue("type");
        String defaultValue = typeElement.attributeValue("default");
        String maxOccrs = typeElement.attributeValue("maxOccurs");
        String minOccrs = typeElement.attributeValue("minOccurs");
        if (CmsStringUtil.isEmpty(elementName) || CmsStringUtil.isEmpty(typeName)) {
            throw new CmsXmlException(Messages.get().container("ERR_INVALID_CD_SCHEMA_STRUCTURE_0"));
        }
        boolean simpleType = true;
        I_CmsXmlSchemaType schemaType = (I_CmsXmlSchemaType)this.m_registeredTypes.get(typeName);
        if (schemaType == null) {
            Iterator i = nestedDefinitions.iterator();
            while (i.hasNext()) {
                CmsXmlContentDefinition cd = (CmsXmlContentDefinition)i.next();
                if (!typeName.equals(cd.getTypeName())) continue;
                simpleType = false;
                return new CmsXmlNestedContentDefinition(cd, elementName, minOccrs, maxOccrs);
            }
            if (simpleType) {
                throw new CmsXmlException(Messages.get().container("ERR_UNKNOWN_SCHEMA_1", typeName));
            }
        }
        if (simpleType && schemaType != null) {
            schemaType = schemaType.newInstance(elementName, minOccrs, maxOccrs);
            if (CmsStringUtil.isNotEmpty(defaultValue)) {
                schemaType.setDefault(defaultValue);
            }
        }
        return schemaType;
    }

    public I_CmsXmlSchemaType getContentType(String typeName) {
        return (I_CmsXmlSchemaType)this.m_registeredTypes.get(typeName);
    }

    public List getRegisteredSchemaTypes() {
        ArrayList result = new ArrayList(this.m_registeredTypes.values());
        Collections.sort(result);
        return result;
    }

    public String getRegisteredWidgetAlias(String className) {
        Iterator i = this.m_widgetAliases.keySet().iterator();
        while (i.hasNext()) {
            String aliasName = (String)i.next();
            String clazzName = (String)this.m_widgetAliases.get(aliasName);
            if (!clazzName.equals(className)) continue;
            return aliasName;
        }
        return null;
    }

    public List getRegisteredWidgetNames() {
        ArrayList result = new ArrayList(this.m_registeredWidgets.keySet());
        Collections.sort(result);
        return result;
    }

    public I_CmsWidget getWidget(String name) {
        String className;
        I_CmsWidget result = (I_CmsWidget)this.m_registeredWidgets.get(name);
        if (result == null && (className = (String)this.m_widgetAliases.get(name)) != null) {
            result = (I_CmsWidget)this.m_registeredWidgets.get(className);
        }
        if (result != null) {
            result = result.newInstance();
        }
        return result;
    }

    public I_CmsWidget getWidgetDefault(String typeName) {
        I_CmsWidget result = (I_CmsWidget)this.m_defaultWidgets.get(typeName);
        if (result != null) {
            result = result.newInstance();
        }
        return result;
    }

    public synchronized void initialize(CmsObject cms) throws CmsRoleViolationException {
        if (OpenCms.getRunLevel() > 1) {
            OpenCms.getRoleManager().checkRole(cms, CmsRole.ROOT_ADMIN);
        }
        CmsXmlEntityResolver.initialize(cms, this.getSchemaBytes());
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_NUM_ST_INITIALIZED_1", new Integer(this.m_registeredTypes.size())));
        }
    }

    private byte[] getSchemaBytes() {
        StringBuffer schema = new StringBuffer(512);
        schema.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        schema.append("<xsd:schema xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" elementFormDefault=\"qualified\">");
        Iterator i = this.m_registeredTypes.values().iterator();
        while (i.hasNext()) {
            I_CmsXmlSchemaType type = (I_CmsXmlSchemaType)i.next();
            schema.append(type.getSchemaDefinition());
        }
        schema.append("</xsd:schema>");
        String schemaStr = schema.toString();
        try {
            Document doc = CmsXmlUtils.unmarshalHelper(schemaStr, null);
            schemaStr = CmsXmlUtils.marshal(doc, "UTF-8");
        }
        catch (CmsXmlException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_PRETTY_PRINT_SCHEMA_BYTES_ERROR_0"), (Throwable)e);
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_XML_TYPE_DEFINITION_XSD_2", "opencms://opencms-xmlcontent.xsd", schemaStr));
        }
        try {
            return schemaStr.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            LOG.error((Object)Messages.get().getBundle().key("LOG_CONVERTING_SCHEMA_BYTES_ERROR_0"), (Throwable)e);
            return null;
        }
    }
}

