/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Node;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlValidationErrorHandler;
import org.opencms.xml.Messages;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class CmsXmlUtils {
    private static final Log LOG = CmsLog.getLog(CmsXmlUtils.class);

    private CmsXmlUtils() {
    }

    public static String concatXpath(String prefix, String suffix) {
        if (suffix == null) {
            suffix = "";
        } else if (suffix.length() > 0 && suffix.charAt(0) == '/') {
            suffix = suffix.substring(1);
        }
        if (prefix != null) {
            StringBuffer result = new StringBuffer(32);
            result.append(prefix);
            if (!CmsResource.isFolder(prefix)) {
                result.append('/');
            }
            result.append(suffix);
            return result.toString();
        }
        return suffix;
    }

    public static String createXpath(String path, int index) {
        if (path.indexOf(47) > -1) {
            StringBuffer result = new StringBuffer(path.length() + 32);
            List elements = CmsStringUtil.splitAsList(path, '/');
            int end = elements.size() - 1;
            for (int i = 0; i <= end; ++i) {
                result.append(CmsXmlUtils.createXpathElementCheck((String)elements.get(i), i == end ? index : 1));
                if (i >= end) continue;
                result.append('/');
            }
            return result.toString();
        }
        return CmsXmlUtils.createXpathElementCheck(path, index);
    }

    public static String createXpathElement(String path, int index) {
        StringBuffer result = new StringBuffer(path.length() + 5);
        result.append(path);
        result.append('[');
        result.append(index);
        result.append(']');
        return result.toString();
    }

    public static String createXpathElementCheck(String path, int index) {
        if (path.charAt(path.length() - 1) == ']') {
            return path;
        }
        return CmsXmlUtils.createXpathElement(path, index);
    }

    public static String getFirstXpathElement(String path) {
        int pos = path.indexOf(47);
        if (pos >= 0) {
            path = path.substring(0, pos);
        }
        return CmsXmlUtils.removeXpathIndex(path);
    }

    public static String getLastXpathElement(String path) {
        int pos = path.lastIndexOf(47);
        if (pos >= 0) {
            path = path.substring(pos + 1);
        }
        return CmsXmlUtils.removeXpathIndex(path);
    }

    public static String getXpathIndex(String path) {
        int pos1 = path.lastIndexOf(47);
        int pos2 = path.lastIndexOf(91);
        if (pos2 < 0 || pos1 > pos2) {
            return "";
        }
        return path.substring(pos2);
    }

    public static boolean isDeepXpath(String path) {
        return path.indexOf(47) > 0;
    }

    public static OutputStream marshal(Document document, OutputStream out, String encoding) throws CmsXmlException {
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding(encoding);
            XMLWriter writer = new XMLWriter(out, format);
            writer.setEscapeText(false);
            writer.write(document);
            writer.close();
        }
        catch (Exception e) {
            throw new CmsXmlException(Messages.get().container("ERR_MARSHALLING_XML_DOC_0"), (Throwable)e);
        }
        return out;
    }

    public static String marshal(Document document, String encoding) throws CmsXmlException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        CmsXmlUtils.marshal(document, out, encoding);
        try {
            return out.toString(encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new CmsXmlException(Messages.get().container("ERR_MARSHALLING_XML_DOC_TO_STRING_0"), (Throwable)e);
        }
    }

    public static String marshal(Node node, String encoding) throws CmsXmlException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding(encoding);
            format.setSuppressDeclaration(true);
            XMLWriter writer = new XMLWriter((OutputStream)out, format);
            writer.setEscapeText(false);
            writer.write(node);
            writer.close();
        }
        catch (Exception e) {
            throw new CmsXmlException(Messages.get().container("ERR_MARSHALLING_XML_DOC_0"), (Throwable)e);
        }
        return new String(out.toByteArray());
    }

    public static String removeFirstXpathElement(String path) {
        int pos = path.indexOf(47);
        if (pos < 0) {
            return path;
        }
        return path.substring(pos + 1);
    }

    public static String removeLastComplexXpathElement(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return path;
        }
        int p = pos;
        int count = -1;
        while (p > 0) {
            ++count;
            p = path.indexOf("'", p + 1);
        }
        String parentPath = path.substring(0, pos);
        if (count % 2 == 0) {
            return parentPath;
        }
        p = parentPath.lastIndexOf("'");
        if (p >= 0) {
            return CmsXmlUtils.removeLastComplexXpathElement(parentPath.substring(0, p));
        }
        return parentPath;
    }

    public static String removeLastXpathElement(String path) {
        int pos = path.lastIndexOf(47);
        if (pos < 0) {
            return path;
        }
        return path.substring(0, pos);
    }

    public static String removeXpath(String path) {
        if (path.indexOf(47) > -1) {
            StringBuffer result = new StringBuffer(path.length() + 32);
            List elements = CmsStringUtil.splitAsList(path, '/');
            int end = elements.size() - 1;
            for (int i = 0; i <= end; ++i) {
                result.append(CmsXmlUtils.removeXpathIndex((String)elements.get(i)));
                if (i >= end) continue;
                result.append('/');
            }
            return result.toString();
        }
        return CmsXmlUtils.removeXpathIndex(path);
    }

    public static String removeXpathIndex(String path) {
        int pos1 = path.lastIndexOf(47);
        int pos2 = path.lastIndexOf(91);
        if (pos2 < 0 || pos1 > pos2) {
            return path;
        }
        return path.substring(0, pos2);
    }

    public static String simplifyXpath(String path) {
        int pos;
        StringBuffer result = new StringBuffer(path);
        if (result.charAt(0) == '/') {
            result.deleteCharAt(0);
        }
        if (result.charAt(pos = result.length() - 1) == '/') {
            result.deleteCharAt(pos);
        }
        return result.toString();
    }

    public static Document unmarshalHelper(byte[] xmlData, EntityResolver resolver) throws CmsXmlException {
        return CmsXmlUtils.unmarshalHelper(new InputSource(new ByteArrayInputStream(xmlData)), resolver);
    }

    public static Document unmarshalHelper(byte[] xmlData, EntityResolver resolver, boolean validate) throws CmsXmlException {
        return CmsXmlUtils.unmarshalHelper(new InputSource(new ByteArrayInputStream(xmlData)), resolver, validate);
    }

    public static Document unmarshalHelper(InputSource source, EntityResolver resolver) throws CmsXmlException {
        return CmsXmlUtils.unmarshalHelper(source, resolver, false);
    }

    public static Document unmarshalHelper(InputSource source, EntityResolver resolver, boolean validate) throws CmsXmlException {
        try {
            SAXReader reader = new SAXReader();
            if (resolver != null) {
                reader.setEntityResolver(resolver);
            }
            reader.setMergeAdjacentText(true);
            reader.setStripWhitespaceText(true);
            if (!validate) {
                reader.setValidation(false);
                reader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            return reader.read(source);
        }
        catch (DocumentException e) {
            throw new CmsXmlException(Messages.get().container("ERR_UNMARSHALLING_XML_DOC_0"), (Throwable)e);
        }
        catch (SAXException e) {
            throw new CmsXmlException(Messages.get().container("ERR_UNMARSHALLING_XML_DOC_0"), (Throwable)e);
        }
    }

    public static Document unmarshalHelper(String xmlData, EntityResolver resolver) throws CmsXmlException {
        return CmsXmlUtils.unmarshalHelper(new InputSource(new StringReader(xmlData)), resolver);
    }

    public static void validateXmlStructure(byte[] xmlData, EntityResolver resolver) throws CmsXmlException {
        CmsXmlUtils.validateXmlStructure(new ByteArrayInputStream(xmlData), resolver);
    }

    public static void validateXmlStructure(Document document, String encoding, EntityResolver resolver) throws CmsXmlException {
        byte[] xmlData = ((ByteArrayOutputStream)CmsXmlUtils.marshal(document, new ByteArrayOutputStream(512), encoding)).toByteArray();
        CmsXmlUtils.validateXmlStructure(xmlData, resolver);
    }

    public static void validateXmlStructure(InputStream xmlStream, EntityResolver resolver) throws CmsXmlException {
        XMLReader reader;
        try {
            reader = XMLReaderFactory.createXMLReader("org.apache.xerces.parsers.SAXParser");
        }
        catch (SAXException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_VALIDATION_INIT_XERXES_SAX_READER_FAILED_0"), (Throwable)e);
            }
            return;
        }
        try {
            reader.setFeature("http://xml.org/sax/features/validation", true);
            reader.setFeature("http://apache.org/xml/features/validation/schema", true);
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXNotRecognizedException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_SAX_READER_FEATURE_NOT_RECOGNIZED_0"), (Throwable)e);
            }
            return;
        }
        catch (SAXNotSupportedException e) {
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_SAX_READER_FEATURE_NOT_SUPPORTED_0"), (Throwable)e);
            }
            return;
        }
        CmsXmlValidationErrorHandler errorHandler = new CmsXmlValidationErrorHandler();
        reader.setErrorHandler((ErrorHandler)((Object)errorHandler));
        if (resolver != null) {
            reader.setEntityResolver(resolver);
        }
        try {
            reader.parse(new InputSource(xmlStream));
        }
        catch (IOException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_READ_XML_FROM_BYTE_ARR_FAILED_0"), (Throwable)e);
            }
            return;
        }
        catch (SAXException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_PARSE_SAX_EXC_0"), (Throwable)e);
            }
            return;
        }
        if (errorHandler.getErrors().elements().size() > 0) {
            StringWriter out;
            block17: {
                out = new StringWriter(256);
                OutputFormat format = OutputFormat.createPrettyPrint();
                XMLWriter writer = new XMLWriter((Writer)out, format);
                try {
                    writer.write(errorHandler.getErrors());
                    writer.write(errorHandler.getWarnings());
                    writer.close();
                }
                catch (IOException e) {
                    if (!LOG.isErrorEnabled()) break block17;
                    LOG.error((Object)Messages.get().getBundle().key("LOG_STRINGWRITER_IO_EXC_0"), (Throwable)e);
                }
            }
            throw new CmsXmlException(Messages.get().container("ERR_XML_VALIDATION_1", out.toString()));
        }
    }
}

