/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.content;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsMessages;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsRelationType;
import org.opencms.site.CmsSite;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsHtmlConverter;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentErrorHandler;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.content.Messages;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.CmsXmlVarLinkValue;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsDefaultXmlContentHandler
implements I_CmsXmlContentHandler {
    public static final String APPINFO_APPINFO = "appinfo";
    public static final String APPINFO_ATTR_CONFIGURATION = "configuration";
    public static final String APPINFO_ATTR_ELEMENT = "element";
    public static final String APPINFO_ATTR_INVALIDATE = "invalidate";
    public static final String APPINFO_ATTR_MAPTO = "mapto";
    public static final String APPINFO_ATTR_MESSAGE = "message";
    public static final String APPINFO_ATTR_NAME = "name";
    public static final String APPINFO_ATTR_REGEX = "regex";
    public static final String APPINFO_ATTR_SEARCHCONTENT = "searchcontent";
    public static final String APPINFO_ATTR_TYPE = "type";
    public static final String APPINFO_ATTR_TYPE_NODE = "node";
    public static final String APPINFO_ATTR_TYPE_PARENT = "parent";
    public static final String APPINFO_ATTR_TYPE_WARNING = "warning";
    public static final String APPINFO_ATTR_URI = "uri";
    public static final String APPINFO_ATTR_VALUE = "value";
    public static final String APPINFO_ATTR_WIDGET = "widget";
    public static final String APPINFO_DEFAULT = "default";
    public static final String APPINFO_DEFAULTS = "defaults";
    public static final String APPINFO_LAYOUT = "layout";
    public static final String APPINFO_LAYOUTS = "layouts";
    public static final String APPINFO_MAPPING = "mapping";
    public static final String APPINFO_MAPPINGS = "mappings";
    public static final String APPINFO_MODELFOLDER = "modelfolder";
    public static final String APPINFO_PREVIEW = "preview";
    public static final String APPINFO_RELATION = "relation";
    public static final String APPINFO_RELATIONS = "relations";
    public static final String APPINFO_RESOURCEBUNDLE = "resourcebundle";
    public static final String APPINFO_RULE = "rule";
    public static final String APPINFO_SCHEMA_FILE = "org/opencms/xml/content/DefaultAppinfo.xsd";
    public static final String APPINFO_SCHEMA_FILE_TYPES = "org/opencms/xml/content/DefaultAppinfoTypes.xsd";
    public static final String APPINFO_SCHEMA_SYSTEM_ID = "http://www.opencms.org/dtd/6.0/org/opencms/xml/content/DefaultAppinfo.xsd";
    public static final String APPINFO_SCHEMA_TYPES_SYSTEM_ID = "http://www.opencms.org/dtd/6.0/org/opencms/xml/content/DefaultAppinfoTypes.xsd";
    public static final String APPINFO_SEARCHSETTING = "searchsetting";
    public static final String APPINFO_SEARCHSETTINGS = "searchsettings";
    public static final String APPINFO_VALIDATIONRULE = "validationrule";
    public static final String APPINFO_VALIDATIONRULES = "validationrules";
    public static final String MACRO_PREVIEW_TEMPFILE = "previewtempfile";
    protected static final String MESSAGE_VALIDATION_DEFAULT_ERROR = "${validation.path}: ${key.GUI_EDITOR_XMLCONTENT_VALIDATION_ERROR_2|${validation.value}|[${validation.regex}]}";
    protected static final String MESSAGE_VALIDATION_DEFAULT_WARNING = "${validation.path}: ${key.GUI_EDITOR_XMLCONTENT_VALIDATION_WARNING_2|${validation.value}|[${validation.regex}]}";
    private static final Log LOG;
    private static final String RELATION_TYPE_PREFIX = "rt_";
    protected Map m_configurationValues;
    protected Map m_defaultValues;
    protected Map m_elementMappings;
    protected Map m_elementWidgets;
    protected String m_messageBundleName;
    protected String m_modelFolder;
    protected String m_previewLocation;
    protected Map m_relations;
    protected Map m_searchSettings;
    protected Map m_validationErrorMessages;
    protected Map m_validationErrorRules;
    protected Map m_validationWarningMessages;
    protected Map m_validationWarningRules;

    public CmsDefaultXmlContentHandler() {
        this.init();
    }

    public String getConfiguration(I_CmsXmlSchemaType type) {
        String elementName = type.getName();
        return (String)this.m_configurationValues.get(elementName);
    }

    public String getDefault(CmsObject cms, I_CmsXmlContentValue value, Locale locale) {
        String defaultValue;
        if (value.getElement() == null) {
            defaultValue = value.getDefault(locale);
        } else {
            String xpath = value.getPath();
            defaultValue = (String)this.m_defaultValues.get(xpath);
            if (defaultValue == null) {
                xpath = CmsXmlUtils.removeXpath(xpath);
                xpath = CmsXmlUtils.createXpath(xpath, 1);
                defaultValue = (String)this.m_defaultValues.get(xpath);
            }
        }
        if (defaultValue != null) {
            CmsObject newCms = cms;
            try {
                CmsFile file = value.getDocument().getFile();
                CmsSite site = OpenCms.getSiteManager().getSiteForRootPath(file.getRootPath());
                if (site != null) {
                    newCms = OpenCms.initCmsObject(cms);
                    newCms.getRequestContext().setSiteRoot(site.getSiteRoot());
                    newCms.getRequestContext().setUri(newCms.getSitePath(file));
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            CmsMacroResolver resolver = CmsMacroResolver.newInstance().setCmsObject(newCms).setMessages(this.getMessages(locale));
            return resolver.resolveMacros(defaultValue);
        }
        return null;
    }

    public String getMapping(String elementName) {
        String[] mappings = this.getMappings(elementName);
        return mappings == null ? null : mappings[0];
    }

    public String[] getMappings(String elementName) {
        return (String[])this.m_elementMappings.get(elementName);
    }

    public CmsMessages getMessages(Locale locale) {
        if (this.m_messageBundleName == null) {
            return null;
        }
        return new CmsMessages(this.m_messageBundleName, locale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getModelFolder(CmsObject cms, String currentFolder) {
        String result = this.m_modelFolder;
        String uri = cms.getRequestContext().getUri();
        try {
            cms.getRequestContext().setUri(currentFolder);
            CmsMacroResolver resolver = CmsMacroResolver.newInstance().setCmsObject(cms);
            result = resolver.resolveMacros(this.m_modelFolder);
        }
        finally {
            cms.getRequestContext().setUri(uri);
        }
        return result;
    }

    public String getPreview(CmsObject cms, CmsXmlContent content, String resourcename) {
        CmsMacroResolver resolver = CmsMacroResolver.newInstance().setCmsObject(cms);
        resolver.addMacro(MACRO_PREVIEW_TEMPFILE, resourcename);
        return resolver.resolveMacros(this.m_previewLocation);
    }

    public CmsRelationType getRelationType(I_CmsXmlContentValue value) {
        String path;
        if (value == null) {
            return null;
        }
        String xpath = value.getPath();
        CmsRelationType relationType = null;
        relationType = (CmsRelationType)this.m_relations.get(RELATION_TYPE_PREFIX + xpath);
        if (relationType == null) {
            path = CmsXmlUtils.removeXpathIndex(xpath);
            relationType = (CmsRelationType)this.m_relations.get(RELATION_TYPE_PREFIX + path);
        }
        if (relationType == null) {
            path = CmsXmlUtils.getLastXpathElement(xpath);
            relationType = (CmsRelationType)this.m_relations.get(RELATION_TYPE_PREFIX + path);
        }
        if (relationType == null) {
            return CmsRelationType.XML_WEAK;
        }
        return relationType;
    }

    public I_CmsWidget getWidget(I_CmsXmlContentValue value) {
        I_CmsWidget result = (I_CmsWidget)this.m_elementWidgets.get(value.getName());
        result = result == null ? OpenCms.getXmlContentTypeManager().getWidgetDefault(value.getTypeName()) : result.newInstance();
        result.setConfiguration(this.getConfiguration(value));
        return result;
    }

    public synchronized void initialize(Element appInfoElement, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        if (appInfoElement != null) {
            this.validateAppinfoElement(appInfoElement);
            this.init();
            Iterator i = appInfoElement.elements().iterator();
            while (i.hasNext()) {
                Element element = (Element)i.next();
                String nodeName = element.getName();
                if (nodeName.equals(APPINFO_MAPPINGS)) {
                    this.initMappings(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_LAYOUTS)) {
                    this.initLayouts(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_VALIDATIONRULES)) {
                    this.initValidationRules(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_RELATIONS)) {
                    this.initRelations(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_DEFAULTS)) {
                    this.initDefaultValues(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_MODELFOLDER)) {
                    this.initModelFolder(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_PREVIEW)) {
                    this.initPreview(element, contentDefinition);
                    continue;
                }
                if (nodeName.equals(APPINFO_RESOURCEBUNDLE)) {
                    this.initResourceBundle(element, contentDefinition);
                    continue;
                }
                if (!nodeName.equals(APPINFO_SEARCHSETTINGS)) continue;
                this.initSearchSettings(element, contentDefinition);
            }
        }
        this.addDefaultCheckRules(contentDefinition, null, null);
    }

    public void invalidateBrokenLinks(CmsObject cms, CmsXmlContent document) {
        if (cms == null || cms.getRequestContext().getRequestTime() == Long.MIN_VALUE) {
            return;
        }
        boolean needReinitialization = false;
        Iterator itLocales = document.getLocales().iterator();
        while (itLocales.hasNext()) {
            Locale locale = (Locale)itLocales.next();
            ArrayList<String> removedNodes = new ArrayList<String>();
            Iterator itValues = document.getValues(locale).iterator();
            while (itValues.hasNext()) {
                I_CmsXmlContentValue value = (I_CmsXmlContentValue)itValues.next();
                String path = value.getPath();
                boolean alreadyRemoved = false;
                Iterator itRemNodes = removedNodes.iterator();
                while (itRemNodes.hasNext()) {
                    String remNode = (String)itRemNodes.next();
                    if (!path.startsWith(remNode)) continue;
                    alreadyRemoved = true;
                    break;
                }
                if (alreadyRemoved || this.m_relations.get(path) == null && this.m_relations.get(CmsXmlUtils.removeXpath(path)) == null) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_XMLCONTENT_CHECK_RULE_MATCH_1", path));
                }
                if (!this.validateLink(cms, value, null)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_XMLCONTENT_CHECK_WARNING_2", path, value.getStringValue(cms)));
                }
                String parentPath = path;
                while (this.isInvalidateParent(parentPath)) {
                    parentPath = CmsXmlUtils.removeLastXpathElement(parentPath);
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_XMLCONTENT_CHECK_PARENT_2", path, parentPath));
                }
                value = document.getValue(parentPath, locale);
                value.getElement().detach();
                removedNodes.add(parentPath);
            }
            if (removedNodes.isEmpty()) continue;
            needReinitialization = true;
        }
        if (needReinitialization) {
            document.initDocument();
        }
    }

    public boolean isSearchable(I_CmsXmlContentValue value) {
        Boolean anno = (Boolean)this.m_searchSettings.get(value.getName());
        return anno == null ? value.isSearchable() : anno.booleanValue();
    }

    public CmsXmlContent prepareForUse(CmsObject cms, CmsXmlContent content) {
        return content;
    }

    public CmsFile prepareForWrite(CmsObject cms, CmsXmlContent content, CmsFile file) throws CmsException {
        String contentConversion;
        if (!content.isAutoCorrectionEnabled()) {
            Object attribute = cms.getRequestContext().getAttribute(CmsXmlContent.AUTO_CORRECTION_ATTRIBUTE);
            boolean autoCorrectionEnabled = attribute != null && (Boolean)attribute != false;
            content.setAutoCorrectionEnabled(autoCorrectionEnabled);
        }
        if (!content.isAutoCorrectionEnabled()) {
            content.validateXmlStructure(new CmsXmlEntityResolver(cms));
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(contentConversion = CmsHtmlConverter.getConversionSettings(cms, file))) {
            contentConversion = "xhtml";
        }
        content.setConversion(contentConversion);
        file = content.correctXmlStructure(cms);
        content.setFile(file);
        content.resolveMappings(cms);
        this.removeEmptyMappings(cms, content);
        return file;
    }

    public void resolveMapping(CmsObject cms, CmsXmlContent content, I_CmsXmlContentValue value) throws CmsException {
        if (!value.isSimpleType()) {
            return;
        }
        CmsFile file = content.getFile();
        if (file == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_RESOLVE_FILE_NOT_FOUND_0"));
        }
        String[] mappings = this.getMappings(value.getPath());
        if (mappings == null) {
            return;
        }
        CmsObject rootCms = OpenCms.initCmsObject(cms);
        rootCms.getRequestContext().setSiteRoot("/");
        List siblings = rootCms.readSiblings(content.getFile().getRootPath(), CmsResourceFilter.IGNORE_EXPIRATION);
        for (int m = mappings.length - 1; m >= 0; --m) {
            String mapping = mappings[m];
            if (!CmsStringUtil.isNotEmpty(mapping)) continue;
            block9: for (int i = siblings.size() - 1; i >= 0; --i) {
                String property;
                String filename = ((CmsResource)siblings.get(i)).getRootPath();
                Locale locale = OpenCms.getLocaleManager().getDefaultLocale(rootCms, filename);
                if (!locale.equals(value.getLocale())) continue;
                CmsLock lock = rootCms.getLock(filename);
                if (lock.isUnlocked()) {
                    rootCms.lockResource(filename);
                } else if (!lock.isExclusiveOwnedBy(rootCms.getRequestContext().currentUser())) {
                    rootCms.changeLock(filename);
                }
                String stringValue = value.getStringValue(rootCms);
                if (mapping.startsWith("propertyList:") && value.getIndex() == 0) {
                    int prefixLength;
                    boolean mapToShared;
                    if (mapping.startsWith("propertyList:shared:")) {
                        mapToShared = true;
                        prefixLength = "propertyList:shared:".length();
                    } else if (mapping.startsWith("propertyList:individual:")) {
                        mapToShared = false;
                        prefixLength = "propertyList:individual:".length();
                    } else {
                        mapToShared = false;
                        prefixLength = "propertyList:".length();
                    }
                    property = mapping.substring(prefixLength);
                    String path = CmsXmlUtils.removeXpathIndex(value.getPath());
                    List values = content.getValues(path, locale);
                    Iterator j = values.iterator();
                    StringBuffer result = new StringBuffer(values.size() * 64);
                    while (j.hasNext()) {
                        I_CmsXmlContentValue val = (I_CmsXmlContentValue)j.next();
                        result.append(val.getStringValue(rootCms));
                        if (!j.hasNext()) continue;
                        result.append('|');
                    }
                    CmsProperty p = mapToShared ? new CmsProperty(property, null, result.toString()) : new CmsProperty(property, result.toString(), null);
                    rootCms.writePropertyObject(filename, p);
                    if (!mapToShared) continue;
                    i = 0;
                    continue;
                }
                if (mapping.startsWith("property:")) {
                    int prefixLength;
                    boolean mapToShared;
                    if (mapping.startsWith("property:shared:")) {
                        mapToShared = true;
                        prefixLength = "property:shared:".length();
                    } else if (mapping.startsWith("property:individual:")) {
                        mapToShared = false;
                        prefixLength = "property:individual:".length();
                    } else {
                        mapToShared = false;
                        prefixLength = "property:".length();
                    }
                    property = mapping.substring(prefixLength);
                    CmsProperty p = mapToShared ? new CmsProperty(property, null, stringValue) : new CmsProperty(property, stringValue, null);
                    rootCms.writePropertyObject(filename, p);
                    if (!mapToShared) continue;
                    i = 0;
                    continue;
                }
                if (!mapping.startsWith("attribute:")) continue;
                String attribute = mapping.substring("attribute:".length());
                switch (ATTRIBUTES.indexOf(attribute)) {
                    case 0: {
                        long date = 0L;
                        try {
                            date = Long.valueOf(stringValue);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        if (date == 0L) {
                            date = 0L;
                        }
                        rootCms.setDateReleased(filename, date, false);
                        if (!filename.equals(rootCms.getSitePath(file))) continue block9;
                        file.setDateReleased(date);
                        continue block9;
                    }
                    case 1: {
                        long date = 0L;
                        try {
                            date = Long.valueOf(stringValue);
                        }
                        catch (NumberFormatException e) {
                            // empty catch block
                        }
                        if (date == 0L) {
                            date = Long.MAX_VALUE;
                        }
                        rootCms.setDateExpired(filename, date, false);
                        if (!filename.equals(rootCms.getSitePath(file))) continue block9;
                        file.setDateExpired(date);
                        continue block9;
                    }
                }
            }
        }
        CmsLock lock = rootCms.getLock(file);
        if (lock.isUnlocked()) {
            rootCms.lockResource(file.getRootPath());
        } else if (!lock.isExclusiveOwnedBy(rootCms.getRequestContext().currentUser())) {
            rootCms.changeLock(file.getRootPath());
        }
    }

    public CmsXmlContentErrorHandler resolveValidation(CmsObject cms, I_CmsXmlContentValue value, CmsXmlContentErrorHandler errorHandler) {
        if (errorHandler == null) {
            errorHandler = new CmsXmlContentErrorHandler();
        }
        if (!value.isSimpleType()) {
            return errorHandler;
        }
        errorHandler = this.validateValue(cms, value, errorHandler, this.m_validationErrorRules, false);
        errorHandler = this.validateValue(cms, value, errorHandler, this.m_validationWarningRules, true);
        return errorHandler;
    }

    protected void addCheckRule(CmsXmlContentDefinition contentDefinition, String elementName, String invalidate, String type) throws CmsXmlException {
        I_CmsXmlSchemaType schemaType = contentDefinition.getSchemaType(elementName);
        if (schemaType == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_CHECK_INVALID_ELEM_1", elementName));
        }
        if (!"OpenCmsVfsFile".equals(schemaType.getTypeName()) && !"OpenCmsVarLink".equals(schemaType.getTypeName())) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_CHECK_INVALID_TYPE_1", elementName));
        }
        Boolean invalidateParent = null;
        if (invalidate == null || invalidate.equalsIgnoreCase(Boolean.TRUE.toString()) || invalidate.equalsIgnoreCase(APPINFO_ATTR_TYPE_NODE)) {
            invalidateParent = Boolean.FALSE;
        } else if (invalidate.equalsIgnoreCase(APPINFO_ATTR_TYPE_PARENT)) {
            invalidateParent = Boolean.TRUE;
        }
        if (invalidateParent != null) {
            this.m_relations.put(elementName, invalidateParent);
        }
        CmsRelationType relationType = type == null ? CmsRelationType.XML_WEAK : CmsRelationType.valueOfXml(type);
        this.m_relations.put(RELATION_TYPE_PREFIX + elementName, relationType);
        if (invalidateParent != null) {
            String path = elementName;
            while (CmsStringUtil.isNotEmptyOrWhitespaceOnly(path)) {
                if (!this.isInvalidateParent(path)) {
                    if (contentDefinition.getSchemaType(path).getMinOccurs() <= 0) break;
                    throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_CHECK_NOT_OPTIONAL_1", path));
                }
                if (!CmsXmlUtils.isDeepXpath(path)) {
                    throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_CHECK_NOT_EMPTY_DOC_0"));
                }
                path = CmsXmlUtils.removeLastXpathElement(path);
            }
        }
    }

    protected void addConfiguration(CmsXmlContentDefinition contentDefinition, String elementName, String configurationValue) throws CmsXmlException {
        if (contentDefinition.getSchemaType(elementName) == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_CONFIG_ELEM_UNKNOWN_1", elementName));
        }
        this.m_configurationValues.put(elementName, configurationValue);
    }

    protected void addDefault(CmsXmlContentDefinition contentDefinition, String elementName, String defaultValue) throws CmsXmlException {
        if (contentDefinition.getSchemaType(elementName) == null) {
            throw new CmsXmlException(org.opencms.xml.types.Messages.get().container("ERR_XMLCONTENT_INVALID_ELEM_DEFAULT_1", elementName));
        }
        String xpath = CmsXmlUtils.createXpath(elementName, 1);
        this.m_defaultValues.put(xpath, defaultValue);
    }

    protected void addDefaultCheckRules(CmsXmlContentDefinition rootContentDefinition, I_CmsXmlSchemaType schemaType, String elementPath) throws CmsXmlException {
        if (schemaType != null && schemaType.isSimpleType()) {
            if (schemaType.getMinOccurs() == 0 && ("OpenCmsVfsFile".equals(schemaType.getTypeName()) || "OpenCmsVarLink".equals(schemaType.getTypeName())) && !this.m_relations.containsKey(elementPath) && !this.m_relations.containsKey(RELATION_TYPE_PREFIX + elementPath)) {
                this.addCheckRule(rootContentDefinition, elementPath, null, null);
            }
        } else {
            CmsXmlContentDefinition nestedContentDefinition = rootContentDefinition;
            if (schemaType != null) {
                CmsXmlNestedContentDefinition nestedDefinition = (CmsXmlNestedContentDefinition)schemaType;
                nestedContentDefinition = nestedDefinition.getNestedContentDefinition();
            }
            Iterator itElems = nestedContentDefinition.getSchemaTypes().iterator();
            while (itElems.hasNext()) {
                String element = (String)itElems.next();
                String path = schemaType != null ? CmsXmlUtils.concatXpath(elementPath, element) : element;
                this.addDefaultCheckRules(rootContentDefinition, nestedContentDefinition.getSchemaType(element), path);
            }
        }
    }

    protected void addMapping(CmsXmlContentDefinition contentDefinition, String elementName, String mapping) throws CmsXmlException {
        if (contentDefinition.getSchemaType(elementName) == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_ELEM_MAPPING_1", elementName));
        }
        String xpath = CmsXmlUtils.createXpath(elementName, 1);
        String[] values = (String[])this.m_elementMappings.get(xpath);
        if (values == null) {
            values = new String[]{mapping};
        } else {
            String[] newValues = new String[values.length + 1];
            System.arraycopy(values, 0, newValues, 0, values.length);
            newValues[values.length] = mapping;
            values = newValues;
        }
        this.m_elementMappings.put(xpath, values);
    }

    protected void addSearchSetting(CmsXmlContentDefinition contentDefinition, String elementName, Boolean value) throws CmsXmlException {
        if (contentDefinition.getSchemaType(elementName) == null) {
            throw new CmsXmlException(org.opencms.xml.types.Messages.get().container("ERR_XMLCONTENT_INVALID_ELEM_SEARCHSETTINGS_1", elementName));
        }
        this.m_searchSettings.put(elementName, value);
    }

    protected void addValidationRule(CmsXmlContentDefinition contentDefinition, String elementName, String regex, String message, boolean isWarning) throws CmsXmlException {
        if (contentDefinition.getSchemaType(elementName) == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_ELEM_VALIDATION_1", elementName));
        }
        if (isWarning) {
            this.m_validationWarningRules.put(elementName, regex);
            if (message != null) {
                this.m_validationWarningMessages.put(elementName, message);
            }
        } else {
            this.m_validationErrorRules.put(elementName, regex);
            if (message != null) {
                this.m_validationErrorMessages.put(elementName, message);
            }
        }
    }

    protected void addWidget(CmsXmlContentDefinition contentDefinition, String elementName, String widgetClassOrAlias) throws CmsXmlException {
        if (contentDefinition.getSchemaType(elementName) == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_ELEM_LAYOUTWIDGET_1", elementName));
        }
        I_CmsWidget widget = OpenCms.getXmlContentTypeManager().getWidget(widgetClassOrAlias);
        if (widget == null) {
            if (CmsStringUtil.isValidJavaClassName(widgetClassOrAlias)) {
                try {
                    Class<?> specialWidgetClass = Class.forName(widgetClassOrAlias);
                    widget = (I_CmsWidget)specialWidgetClass.newInstance();
                }
                catch (Exception e) {
                    throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_CUSTOM_CLASS_3", widgetClassOrAlias, elementName, contentDefinition.getSchemaLocation()), (Throwable)e);
                }
            }
            if (widget == null) {
                throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_WIDGET_3", widgetClassOrAlias, elementName, contentDefinition.getSchemaLocation()));
            }
        }
        this.m_elementWidgets.put(elementName, widget);
    }

    protected String getValidationMessage(CmsObject cms, I_CmsXmlContentValue value, String regex, String valueStr, boolean matchResult, boolean isWarning) {
        String message = null;
        message = isWarning ? (String)this.m_validationWarningMessages.get(value.getName()) : (String)this.m_validationErrorMessages.get(value.getName());
        if (message == null) {
            message = isWarning ? MESSAGE_VALIDATION_DEFAULT_WARNING : MESSAGE_VALIDATION_DEFAULT_ERROR;
        }
        HashMap<String, String> additionalValues = new HashMap<String, String>();
        additionalValues.put("validation.value", valueStr);
        additionalValues.put("validation.regex", (!matchResult ? "!" : "") + regex);
        additionalValues.put("validation.path", value.getPath());
        CmsMacroResolver resolver = CmsMacroResolver.newInstance().setCmsObject(cms).setMessages(this.getMessages(cms.getRequestContext().getLocale())).setAdditionalMacros(additionalValues);
        return resolver.resolveMacros(message);
    }

    protected void init() {
        this.m_elementMappings = new HashMap();
        this.m_elementWidgets = new HashMap();
        this.m_validationErrorRules = new HashMap();
        this.m_validationErrorMessages = new HashMap();
        this.m_validationWarningRules = new HashMap();
        this.m_validationWarningMessages = new HashMap();
        this.m_defaultValues = new HashMap();
        this.m_configurationValues = new HashMap();
        this.m_searchSettings = new HashMap();
        this.m_relations = new HashMap();
        this.m_previewLocation = null;
        this.m_modelFolder = null;
    }

    protected void initDefaultValues(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        Iterator i = root.elementIterator(APPINFO_DEFAULT);
        while (i.hasNext()) {
            Element element = (Element)i.next();
            String elementName = element.attributeValue(APPINFO_ATTR_ELEMENT);
            String defaultValue = element.attributeValue(APPINFO_ATTR_VALUE);
            if (elementName == null || defaultValue == null) continue;
            this.addDefault(contentDefinition, elementName, defaultValue);
        }
    }

    protected void initLayouts(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        Iterator i = root.elementIterator(APPINFO_LAYOUT);
        while (i.hasNext()) {
            Element element = (Element)i.next();
            String elementName = element.attributeValue(APPINFO_ATTR_ELEMENT);
            String widgetClassOrAlias = element.attributeValue(APPINFO_ATTR_WIDGET);
            String configuration = element.attributeValue(APPINFO_ATTR_CONFIGURATION);
            if (elementName == null || widgetClassOrAlias == null) continue;
            this.addWidget(contentDefinition, elementName, widgetClassOrAlias);
            if (configuration == null) continue;
            this.addConfiguration(contentDefinition, elementName, configuration);
        }
    }

    protected void initMappings(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        Iterator i = root.elementIterator(APPINFO_MAPPING);
        while (i.hasNext()) {
            Element element = (Element)i.next();
            String elementName = element.attributeValue(APPINFO_ATTR_ELEMENT);
            String maptoName = element.attributeValue(APPINFO_ATTR_MAPTO);
            if (elementName == null || maptoName == null) continue;
            this.addMapping(contentDefinition, elementName, maptoName);
        }
    }

    protected void initModelFolder(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        String master = root.attributeValue(APPINFO_ATTR_URI);
        if (master == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_MISSING_MODELFOLDER_URI_2", root.getName(), contentDefinition.getSchemaLocation()));
        }
        this.m_modelFolder = master;
    }

    protected void initPreview(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        String preview = root.attributeValue(APPINFO_ATTR_URI);
        if (preview == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_MISSING_PREVIEW_URI_2", root.getName(), contentDefinition.getSchemaLocation()));
        }
        this.m_previewLocation = preview;
    }

    protected void initRelations(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        Iterator i = root.elementIterator(APPINFO_RELATION);
        while (i.hasNext()) {
            String type;
            Element element = (Element)i.next();
            String elementName = element.attributeValue(APPINFO_ATTR_ELEMENT);
            String invalidate = element.attributeValue(APPINFO_ATTR_INVALIDATE);
            if (invalidate != null) {
                invalidate = invalidate.toUpperCase();
            }
            if ((type = element.attributeValue(APPINFO_ATTR_TYPE)) != null) {
                type = type.toLowerCase();
            }
            if (elementName == null) continue;
            this.addCheckRule(contentDefinition, elementName, invalidate, type);
        }
    }

    protected void initResourceBundle(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        String name = root.attributeValue(APPINFO_ATTR_NAME);
        if (name == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_MISSING_RESOURCE_BUNDLE_NAME_2", root.getName(), contentDefinition.getSchemaLocation()));
        }
        this.m_messageBundleName = name;
    }

    protected void initSearchSettings(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        Iterator i = root.elementIterator(APPINFO_SEARCHSETTING);
        while (i.hasNext()) {
            boolean include;
            Element element = (Element)i.next();
            String elementName = element.attributeValue(APPINFO_ATTR_ELEMENT);
            String searchContent = element.attributeValue(APPINFO_ATTR_SEARCHCONTENT);
            boolean bl = include = CmsStringUtil.isEmpty(searchContent) || Boolean.valueOf(searchContent) != false;
            if (elementName == null) continue;
            this.addSearchSetting(contentDefinition, elementName, include);
        }
    }

    protected void initValidationRules(Element root, CmsXmlContentDefinition contentDefinition) throws CmsXmlException {
        ArrayList elements = new ArrayList(root.elements(APPINFO_RULE));
        elements.addAll(root.elements(APPINFO_VALIDATIONRULE));
        Iterator i = elements.iterator();
        while (i.hasNext()) {
            Element element = (Element)i.next();
            String elementName = element.attributeValue(APPINFO_ATTR_ELEMENT);
            String regex = element.attributeValue(APPINFO_ATTR_REGEX);
            String type = element.attributeValue(APPINFO_ATTR_TYPE);
            if (type != null) {
                type = type.toLowerCase();
            }
            String message = element.attributeValue(APPINFO_ATTR_MESSAGE);
            if (elementName == null || regex == null) continue;
            this.addValidationRule(contentDefinition, elementName, regex, message, APPINFO_ATTR_TYPE_WARNING.equals(type));
        }
    }

    protected boolean isInvalidateParent(String xpath) {
        if (!CmsXmlUtils.isDeepXpath(xpath)) {
            return false;
        }
        Boolean isInvalidateParent = null;
        isInvalidateParent = (Boolean)this.m_relations.get(xpath);
        if (isInvalidateParent == null) {
            String path = CmsXmlUtils.removeXpath(xpath);
            isInvalidateParent = (Boolean)this.m_relations.get(path);
        }
        if (isInvalidateParent == null) {
            return false;
        }
        return isInvalidateParent;
    }

    protected String key(String keyName, Locale locale) {
        CmsMessages messages = this.getMessages(locale);
        if (messages != null) {
            return messages.key(keyName);
        }
        return CmsMessages.formatUnknownKey(keyName);
    }

    protected void removeEmptyMappings(CmsObject cms, CmsXmlContent content) throws CmsException {
        List siblings = null;
        CmsObject rootCms = null;
        Iterator mappings = this.m_elementMappings.entrySet().iterator();
        while (mappings.hasNext()) {
            Map.Entry e = mappings.next();
            String path = String.valueOf(e.getKey());
            String[] values = (String[])e.getValue();
            if (values == null) continue;
            if (siblings == null || rootCms == null) {
                rootCms = OpenCms.initCmsObject(cms);
                rootCms.getRequestContext().setSiteRoot("/");
                siblings = rootCms.readSiblings(content.getFile().getRootPath(), CmsResourceFilter.IGNORE_EXPIRATION);
            }
            for (int v = values.length - 1; v >= 0; --v) {
                String mapping = values[v];
                if (!mapping.startsWith("propertyList:") && !mapping.startsWith("property:")) continue;
                for (int i = 0; i < siblings.size(); ++i) {
                    String filename = ((CmsResource)siblings.get(i)).getRootPath();
                    Locale locale = OpenCms.getLocaleManager().getDefaultLocale(rootCms, filename);
                    if (!content.hasLocale(locale) || content.hasValue(path, locale)) continue;
                    String property = mapping.startsWith("propertyList:") ? mapping.substring("propertyList:".length()) : mapping.substring("property:".length());
                    rootCms.writePropertyObject(filename, new CmsProperty(property, "", null));
                }
            }
        }
    }

    protected void validateAppinfoElement(Element appinfoElement) throws CmsXmlException {
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement(APPINFO_APPINFO);
        root.add(I_CmsXmlSchemaType.XSI_NAMESPACE);
        root.addAttribute(I_CmsXmlSchemaType.XSI_NAMESPACE_ATTRIBUTE_NO_SCHEMA_LOCATION, APPINFO_SCHEMA_SYSTEM_ID);
        root.appendContent((Branch)appinfoElement);
        CmsXmlUtils.validateXmlStructure(doc, "UTF-8", new CmsXmlEntityResolver(null));
    }

    protected boolean validateLink(CmsObject cms, I_CmsXmlContentValue value, CmsXmlContentErrorHandler errorHandler) {
        if (value == null || !(value instanceof CmsXmlVfsFileValue) && !(value instanceof CmsXmlVarLinkValue)) {
            return false;
        }
        CmsLink link = null;
        if (value instanceof CmsXmlVfsFileValue) {
            link = ((CmsXmlVfsFileValue)value).getLink(cms);
        } else if (value instanceof CmsXmlVarLinkValue) {
            link = ((CmsXmlVarLinkValue)value).getLink(cms);
        }
        if (link == null || !link.isInternal()) {
            return false;
        }
        try {
            CmsResource res = cms.readResource(link.getStructureId(), CmsResourceFilter.IGNORE_EXPIRATION);
            if (res != null) {
                long time = System.currentTimeMillis();
                if (!res.isReleased(time)) {
                    if (errorHandler != null) {
                        errorHandler.addWarning(value, Messages.get().getBundle(value.getLocale()).key("GUI_XMLCONTENT_CHECK_WARNING_NOT_RELEASED_0"));
                    }
                    return true;
                }
                if (res.isExpired(time)) {
                    if (errorHandler != null) {
                        errorHandler.addWarning(value, Messages.get().getBundle(value.getLocale()).key("GUI_XMLCONTENT_CHECK_WARNING_EXPIRED_0"));
                    }
                    return true;
                }
            }
        }
        catch (CmsException e) {
            if (errorHandler != null) {
                errorHandler.addError(value, Messages.get().getBundle(value.getLocale()).key("GUI_XMLCONTENT_CHECK_ERROR_0"));
            }
            return true;
        }
        return false;
    }

    protected CmsXmlContentErrorHandler validateValue(CmsObject cms, I_CmsXmlContentValue value, CmsXmlContentErrorHandler errorHandler, Map rules, boolean isWarning) {
        String matchValue;
        String valueStr;
        if (this.validateLink(cms, value, errorHandler)) {
            return errorHandler;
        }
        try {
            if (value.getContentDefinition().getContentHandler().getWidget(value) instanceof CmsDisplayWidget) {
                return errorHandler;
            }
        }
        catch (CmsXmlException e) {
            errorHandler.addError(value, e.getMessage());
            return errorHandler;
        }
        try {
            valueStr = value.getStringValue(cms);
        }
        catch (Exception e) {
            errorHandler.addError(value, e.getMessage());
            return errorHandler;
        }
        String regex = (String)rules.get(value.getName());
        if (regex == null) {
            return this.validateValue(cms, value, valueStr, errorHandler, isWarning);
        }
        boolean matchResult = true;
        if (regex.charAt(0) == '!') {
            matchResult = false;
            regex = regex.substring(1);
        }
        if ((matchValue = valueStr) == null) {
            matchValue = "";
        }
        if (matchResult != Pattern.matches(regex, matchValue)) {
            String message = this.getValidationMessage(cms, value, regex, valueStr, matchResult, isWarning);
            if (isWarning) {
                errorHandler.addWarning(value, message);
            } else {
                errorHandler.addError(value, message);
                return errorHandler;
            }
        }
        return this.validateValue(cms, value, valueStr, errorHandler, isWarning);
    }

    protected CmsXmlContentErrorHandler validateValue(CmsObject cms, I_CmsXmlContentValue value, String valueStr, CmsXmlContentErrorHandler errorHandler, boolean isWarning) {
        if (isWarning) {
            return errorHandler;
        }
        if (!value.validateValue(valueStr)) {
            String message = this.getValidationMessage(cms, value, value.getTypeName(), valueStr, true, false);
            errorHandler.addError(value, message);
        }
        return errorHandler;
    }

    static {
        byte[] appinfoSchema;
        byte[] appinfoSchemaTypes;
        LOG = CmsLog.getLog(CmsDefaultXmlContentHandler.class);
        try {
            appinfoSchemaTypes = CmsFileUtil.readFile(APPINFO_SCHEMA_FILE_TYPES);
        }
        catch (Exception e) {
            throw new CmsRuntimeException(Messages.get().container("ERR_XMLCONTENT_LOAD_SCHEMA_1", APPINFO_SCHEMA_FILE_TYPES), (Throwable)e);
        }
        CmsXmlEntityResolver.cacheSystemId(APPINFO_SCHEMA_TYPES_SYSTEM_ID, appinfoSchemaTypes);
        try {
            appinfoSchema = CmsFileUtil.readFile(APPINFO_SCHEMA_FILE);
        }
        catch (Exception e) {
            throw new CmsRuntimeException(Messages.get().container("ERR_XMLCONTENT_LOAD_SCHEMA_1", APPINFO_SCHEMA_FILE), (Throwable)e);
        }
        CmsXmlEntityResolver.cacheSystemId(APPINFO_SCHEMA_SYSTEM_ID, appinfoSchema);
    }
}

