/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.content;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.staticexport.CmsLinkProcessor;
import org.opencms.staticexport.CmsLinkTable;
import org.opencms.util.CmsMacroResolver;
import org.opencms.xml.A_CmsXmlDocument;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.content.CmsXmlContentErrorHandler;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentMacroVisitor;
import org.opencms.xml.content.CmsXmlContentMappingVisitor;
import org.opencms.xml.content.CmsXmlContentValidationVisitor;
import org.opencms.xml.content.CmsXmlContentValueSequence;
import org.opencms.xml.content.I_CmsXmlContentValueVisitor;
import org.opencms.xml.content.Messages;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;
import org.xml.sax.EntityResolver;
import org.xml.sax.SAXException;

public class CmsXmlContent
extends A_CmsXmlDocument
implements I_CmsXmlDocument {
    public static final String AUTO_CORRECTION_ATTRIBUTE = CmsXmlContent.class.getName() + ".autoCorrectionEnabled";
    public static final String XERCES_SCHEMA_PROPERTY = "http://apache.org/xml/properties/schema/external-noNamespaceSchemaLocation";
    private static final Log LOG = CmsLog.getLog(CmsXmlContent.class);
    protected boolean m_autoCorrectionEnabled;
    protected CmsXmlContentDefinition m_contentDefinition;

    protected CmsXmlContent() {
    }

    protected CmsXmlContent(CmsObject cms, Document document, String encoding, EntityResolver resolver) {
        this.m_document = document;
        this.m_contentDefinition = this.getContentDefinition(resolver);
        this.initDocument(cms, this.m_document, encoding, this.m_contentDefinition);
    }

    protected CmsXmlContent(CmsObject cms, Locale locale, String modelUri) throws CmsException {
        CmsFile modelFile = cms.readFile(modelUri, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
        CmsXmlContent model = CmsXmlContentFactory.unmarshal(cms, modelFile);
        CmsMacroResolver macroResolver = CmsMacroResolver.newInstance().setCmsObject(cms);
        this.m_contentDefinition = model.getContentDefinition();
        Document document = (Document)model.m_document.clone();
        this.initDocument(cms, document, model.getEncoding(), this.m_contentDefinition);
        this.visitAllValuesWith(new CmsXmlContentMacroVisitor(cms, macroResolver));
        if (!this.hasLocale(locale)) {
            try {
                this.addLocale(cms, locale);
            }
            catch (CmsXmlException e) {
                // empty catch block
            }
        }
    }

    protected CmsXmlContent(CmsObject cms, Locale locale, String encoding, CmsXmlContentDefinition contentDefinition) {
        this.m_contentDefinition = contentDefinition;
        Document document = this.m_contentDefinition.createDocument(cms, this, locale);
        this.initDocument(cms, document, encoding, this.m_contentDefinition);
    }

    public void addLocale(CmsObject cms, Locale locale) throws CmsXmlException {
        if (this.hasLocale(locale)) {
            throw new CmsXmlException(org.opencms.xml.page.Messages.get().container("ERR_XML_PAGE_LOCALE_EXISTS_1", locale));
        }
        this.m_contentDefinition.createLocale(cms, this, this.m_document.getRootElement(), locale);
        this.initDocument(cms, this.m_document, this.m_encoding, this.m_contentDefinition);
    }

    public I_CmsXmlContentValue addValue(CmsObject cms, String path, Locale locale, int index) throws CmsIllegalArgumentException, CmsRuntimeException {
        int insertIndex;
        CmsXmlContentDefinition contentDefinition;
        String elementName;
        Element parentElement;
        I_CmsXmlSchemaType type = this.m_contentDefinition.getSchemaType(path);
        if (type == null) {
            throw new CmsIllegalArgumentException(Messages.get().container("ERR_XMLCONTENT_UNKNOWN_ELEM_PATH_SCHEMA_1", path));
        }
        if (CmsXmlUtils.isDeepXpath(path)) {
            String parentPath = CmsXmlUtils.removeLastXpathElement(path);
            Object o = this.getBookmark(parentPath, locale);
            if (o == null) {
                throw new CmsIllegalArgumentException(Messages.get().container("ERR_XMLCONTENT_UNKNOWN_ELEM_PATH_1", path));
            }
            CmsXmlNestedContentDefinition parentValue = (CmsXmlNestedContentDefinition)o;
            parentElement = parentValue.getElement();
            elementName = CmsXmlUtils.getLastXpathElement(path);
            contentDefinition = parentValue.getNestedContentDefinition();
        } else {
            parentElement = this.getLocaleNode(locale);
            elementName = CmsXmlUtils.removeXpathIndex(path);
            contentDefinition = this.m_contentDefinition;
        }
        List siblings = parentElement.elements(elementName);
        if (siblings.size() > 0) {
            if (siblings.size() >= type.getMaxOccurs()) {
                throw new CmsRuntimeException(Messages.get().container("ERR_XMLCONTENT_ELEM_MAXOCCURS_2", elementName, new Integer(type.getMaxOccurs())));
            }
            if (index > siblings.size()) {
                throw new CmsRuntimeException(Messages.get().container("ERR_XMLCONTENT_ADD_ELEM_INVALID_IDX_3", new Integer(index), new Integer(siblings.size())));
            }
            int offset = index == siblings.size() ? 1 : 0;
            Element sibling = (Element)siblings.get(index - offset);
            insertIndex = sibling.getParent().content().indexOf(sibling) + offset;
        } else {
            if (index > 0) {
                throw new CmsRuntimeException(Messages.get().container("ERR_XMLCONTENT_ADD_ELEM_INVALID_IDX_2", new Integer(index), elementName));
            }
            int typeIndex = contentDefinition.getTypeSequence().indexOf(type);
            if (typeIndex == 0) {
                insertIndex = 0;
            } else {
                Node node;
                ArrayList<String> previousTypeNames = new ArrayList<String>();
                for (int i = 0; i < typeIndex; ++i) {
                    I_CmsXmlSchemaType t = (I_CmsXmlSchemaType)contentDefinition.getTypeSequence().get(i);
                    previousTypeNames.add(t.getName());
                }
                Iterator i = parentElement.content().iterator();
                int pos = 0;
                while (i.hasNext() && (!((node = (Node)i.next()) instanceof Element) || previousTypeNames.contains(node.getName()))) {
                    ++pos;
                }
                insertIndex = pos;
            }
        }
        I_CmsXmlContentValue newValue = this.addValue(cms, parentElement, type, locale, insertIndex);
        this.initDocument(this.m_document, this.m_encoding, this.m_contentDefinition);
        return (I_CmsXmlContentValue)this.getBookmark(CmsXmlContent.getBookmarkName(newValue.getPath(), locale));
    }

    public void copyLocale(Locale source, Locale destination, Set elements) throws CmsXmlException {
        if (!this.hasLocale(source)) {
            throw new CmsXmlException(Messages.get().container("ERR_LOCALE_NOT_AVAILABLE_1", source));
        }
        if (this.hasLocale(destination)) {
            throw new CmsXmlException(Messages.get().container("ERR_LOCALE_ALREADY_EXISTS_1", destination));
        }
        Element sourceElement = null;
        Element rootNode = this.m_document.getRootElement();
        Iterator i = rootNode.elementIterator();
        String localeStr = source.toString();
        while (i.hasNext()) {
            Element element = (Element)i.next();
            String language = element.attributeValue("language", null);
            if (language == null || !localeStr.equals(language)) continue;
            sourceElement = this.createDeepElementCopy(element, elements);
            break;
        }
        if (sourceElement == null) {
            throw new CmsXmlException(Messages.get().container("ERR_LOCALE_NOT_AVAILABLE_1", source));
        }
        sourceElement.addAttribute("language", destination.toString());
        rootNode.add(sourceElement);
        this.initDocument(this.m_document, this.m_encoding, this.getContentDefinition());
    }

    public CmsXmlContentDefinition getContentDefinition() {
        return this.m_contentDefinition;
    }

    public CmsLinkProcessor getLinkProcessor(CmsObject cms, CmsLinkTable linkTable) {
        String relativeRoot = null;
        if (this.m_file != null) {
            relativeRoot = CmsResource.getParentFolder(cms.getSitePath(this.m_file));
        }
        return new CmsLinkProcessor(cms, linkTable, this.getEncoding(), relativeRoot);
    }

    public CmsXmlContentValueSequence getValueSequence(String name, Locale locale) {
        I_CmsXmlSchemaType type = this.m_contentDefinition.getSchemaType(name);
        if (type == null) {
            return null;
        }
        return new CmsXmlContentValueSequence(name, type, locale, this);
    }

    public boolean isAutoCorrectionEnabled() {
        return this.m_autoCorrectionEnabled;
    }

    public void removeValue(String name, Locale locale, int index) {
        I_CmsXmlContentValue value = this.getValue(name, locale, index);
        List values = this.getValues(name, locale);
        if (values.size() <= value.getMinOccurs()) {
            throw new CmsRuntimeException(Messages.get().container("ERR_XMLCONTENT_ELEM_MINOCCURS_2", name, new Integer(value.getMinOccurs())));
        }
        value.getElement().detach();
        this.initDocument(this.m_document, this.m_encoding, this.m_contentDefinition);
    }

    public void resolveMappings(CmsObject cms) {
        CmsXmlContentMappingVisitor visitor = new CmsXmlContentMappingVisitor(cms, this);
        this.visitAllValuesWith(visitor);
    }

    public void setAutoCorrectionEnabled(boolean value) {
        this.m_autoCorrectionEnabled = value;
    }

    public CmsXmlContentErrorHandler validate(CmsObject cms) {
        CmsXmlContentValidationVisitor visitor = new CmsXmlContentValidationVisitor(cms);
        this.visitAllValuesWith(visitor);
        return visitor.getErrorHandler();
    }

    public void visitAllValuesWith(I_CmsXmlContentValueVisitor visitor) {
        ArrayList bookmarks = new ArrayList(this.getBookmarks());
        Collections.sort(bookmarks);
        for (int i = 0; i < bookmarks.size(); ++i) {
            String key = (String)bookmarks.get(i);
            I_CmsXmlContentValue value = (I_CmsXmlContentValue)this.getBookmark(key);
            visitor.visit(value);
        }
    }

    protected Object getBookmark(String bookmark) {
        return super.getBookmark(bookmark);
    }

    protected Set getBookmarks() {
        return super.getBookmarks();
    }

    protected Element getLocaleNode(Locale locale) throws CmsRuntimeException {
        String localeStr = locale.toString();
        Iterator i = this.m_document.getRootElement().elements().iterator();
        while (i.hasNext()) {
            Element element = (Element)i.next();
            if (!localeStr.equals(element.attributeValue("language"))) continue;
            return element;
        }
        throw new CmsRuntimeException(Messages.get().container("ERR_XMLCONTENT_MISSING_LOCALE_1", locale));
    }

    protected void initDocument(CmsObject cms, Document document, String encoding, CmsXmlContentDefinition definition) {
        this.initDocument(document, encoding, definition);
        if (cms != null) {
            this.getContentDefinition().getContentHandler().invalidateBrokenLinks(cms, this);
        }
    }

    protected void initDocument(Document document, String encoding, CmsXmlContentDefinition definition) {
        this.m_document = document;
        this.m_contentDefinition = definition;
        this.m_encoding = CmsEncoder.lookupEncoding(encoding, encoding);
        this.m_elementLocales = new HashMap();
        this.m_elementNames = new HashMap();
        this.m_locales = new HashSet();
        this.clearBookmarks();
        Iterator i = this.m_document.getRootElement().elementIterator();
        while (i.hasNext()) {
            Element node = (Element)i.next();
            try {
                Locale locale = CmsLocaleManager.getLocale(node.attribute("language").getValue());
                this.addLocale(locale);
                this.processSchemaNode(node, null, locale, definition);
            }
            catch (NullPointerException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_XMLCONTENT_INIT_BOOKMARKS_0"), (Throwable)e);
            }
        }
    }

    protected void setFile(CmsFile file) {
        this.m_file = file;
    }

    private I_CmsXmlContentValue addValue(CmsObject cms, Element parent, I_CmsXmlSchemaType type, Locale locale, int insertIndex) {
        Element element = type.generateXml(cms, this, parent, locale);
        element.detach();
        parent.content().add(insertIndex, element);
        I_CmsXmlContentValue value = type.createValue(this, element, locale);
        String defaultValue = this.m_contentDefinition.getContentHandler().getDefault(cms, value, locale);
        if (defaultValue != null) {
            value.setStringValue(cms, defaultValue);
        }
        return value;
    }

    private CmsXmlContentDefinition getContentDefinition(EntityResolver resolver) throws CmsRuntimeException {
        String schemaLocation = this.m_document.getRootElement().attributeValue(I_CmsXmlSchemaType.XSI_NAMESPACE_ATTRIBUTE_NO_SCHEMA_LOCATION);
        if (schemaLocation == null) {
            throw new CmsRuntimeException(Messages.get().container("ERR_XMLCONTENT_MISSING_SCHEMA_0"));
        }
        try {
            return CmsXmlContentDefinition.unmarshal(schemaLocation, resolver);
        }
        catch (SAXException e) {
            throw new CmsRuntimeException(Messages.get().container("ERR_XML_SCHEMA_PARSE_0"), (Throwable)e);
        }
        catch (IOException e) {
            throw new CmsRuntimeException(Messages.get().container("ERR_XML_SCHEMA_IO_0"), (Throwable)e);
        }
        catch (CmsXmlException e) {
            throw new CmsRuntimeException(Messages.get().container("ERR_XMLCONTENT_UNMARSHAL_0"), (Throwable)e);
        }
    }

    private void processSchemaNode(Element root, String rootPath, Locale locale, CmsXmlContentDefinition definition) {
        int count = 1;
        String previousName = null;
        List content = root.content();
        for (int i = content.size() - 1; i >= 0; --i) {
            Node node = (Node)content.get(i);
            if (node instanceof Element) continue;
            content.remove(i);
        }
        Iterator i = root.content().iterator();
        while (i.hasNext()) {
            String path;
            Element element = (Element)i.next();
            String name = element.getName();
            if (previousName == null || !previousName.equals(name)) {
                previousName = name;
                count = 1;
            }
            if (rootPath != null) {
                StringBuffer b = new StringBuffer(rootPath.length() + name.length() + 6);
                b.append(rootPath);
                b.append('/');
                b.append(CmsXmlUtils.createXpathElement(name, count));
                path = b.toString();
            } else {
                path = CmsXmlUtils.createXpathElement(name, count);
            }
            I_CmsXmlSchemaType schemaType = definition.getSchemaType(name);
            if (schemaType != null) {
                I_CmsXmlContentValue value = schemaType.createValue(this, element, locale);
                this.addBookmark(path, locale, true, value);
                if (!schemaType.isSimpleType()) {
                    CmsXmlNestedContentDefinition nestedSchema = (CmsXmlNestedContentDefinition)schemaType;
                    this.processSchemaNode(element, path, locale, nestedSchema.getNestedContentDefinition());
                }
            } else if (LOG.isWarnEnabled()) {
                LOG.warn((Object)Messages.get().getBundle().key("LOG_XMLCONTENT_INVALID_ELEM_2", name, definition.getSchemaLocation()));
            }
            ++count;
        }
    }
}

