/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.content;

import java.util.List;
import java.util.Locale;
import org.opencms.file.CmsObject;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsXmlContentValueSequence {
    private CmsXmlContent m_content;
    private Locale m_locale;
    private String m_path;
    private I_CmsXmlSchemaType m_schemaType;
    private List m_values;

    public CmsXmlContentValueSequence(String path, I_CmsXmlSchemaType schemaType, Locale locale, CmsXmlContent content) {
        this.m_schemaType = schemaType;
        this.m_locale = locale;
        this.m_content = content;
        this.m_values = this.m_content.getValues(path, this.m_locale);
        this.m_path = CmsXmlUtils.removeXpathIndex(path);
    }

    public I_CmsXmlContentValue addValue(CmsObject cms, int index) {
        I_CmsXmlContentValue newValue = this.m_content.addValue(cms, this.getPath(), this.getLocale(), index);
        this.m_values = this.m_content.getValues(this.getPath(), this.getLocale());
        return newValue;
    }

    public int getElementCount() {
        return this.m_values.size();
    }

    public String getElementName() {
        return this.m_schemaType.getName();
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public int getMaxOccurs() {
        return this.m_schemaType.getMaxOccurs();
    }

    public int getMinOccurs() {
        return this.m_schemaType.getMinOccurs();
    }

    public String getPath() {
        return this.m_path;
    }

    public I_CmsXmlContentValue getValue(int index) {
        return (I_CmsXmlContentValue)this.m_values.get(index);
    }

    public List getValues() {
        return this.m_values;
    }

    public I_CmsXmlSchemaType getXmlSchemaType() {
        return this.m_schemaType;
    }

    public boolean isExtendable() {
        return this.getElementCount() < this.getMaxOccurs();
    }

    public boolean isReducable() {
        return this.getElementCount() > this.getMinOccurs();
    }

    public boolean isSimpleType() {
        return this.m_schemaType.isSimpleType();
    }

    public void removeValue(int index) {
        this.m_content.removeValue(this.getPath(), this.getLocale(), index);
        this.m_values = this.m_content.getValues(this.getPath(), this.getLocale());
    }
}

