/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.types;

import java.util.Iterator;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.dom4j.Attribute;
import org.dom4j.Element;
import org.htmlparser.util.ParserException;
import org.opencms.file.CmsObject;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsLinkUpdateUtil;
import org.opencms.staticexport.CmsLinkProcessor;
import org.opencms.staticexport.CmsLinkTable;
import org.opencms.util.CmsHtmlConverter;
import org.opencms.util.CmsHtmlExtractor;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.types.A_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;
import org.opencms.xml.types.Messages;

public class CmsXmlHtmlValue
extends A_CmsXmlContentValue
implements I_CmsXmlContentValue {
    public static final String TYPE_NAME = "OpenCmsHtml";
    private static final Log LOG = CmsLog.getLog(CmsXmlHtmlValue.class);
    private static String m_schemaDefinition;
    private static final I_CmsXmlSchemaType TYPE_BASE;
    private String m_stringValue;

    public CmsXmlHtmlValue() {
    }

    public CmsXmlHtmlValue(I_CmsXmlDocument document, Element element, Locale locale) {
        super(document, element, locale, TYPE_BASE);
    }

    public CmsXmlHtmlValue(I_CmsXmlDocument document, Element element, Locale locale, I_CmsXmlSchemaType type) {
        super(document, element, locale, type);
    }

    public CmsXmlHtmlValue(String name, String minOccurs, String maxOccurs) {
        super(name, minOccurs, maxOccurs);
    }

    public I_CmsXmlContentValue createValue(I_CmsXmlDocument document, Element element, Locale locale) {
        return new CmsXmlHtmlValue(document, element, locale, this);
    }

    public Element generateXml(CmsObject cms, I_CmsXmlDocument document, Element root, Locale locale) {
        Element element = root.addElement(this.getName());
        int index = element.getParent().elements(element.getQName()).indexOf(element);
        element.addAttribute("name", this.getName() + index);
        element.addElement("links");
        element.addElement("content");
        String defaultValue = document.getContentDefinition().getContentHandler().getDefault(cms, this, locale);
        if (defaultValue != null) {
            try {
                I_CmsXmlContentValue value = this.createValue(document, element, locale);
                value.setStringValue(cms, defaultValue);
            }
            catch (CmsRuntimeException e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_XMLCONTENT_INVALID_ELEM_DEFAULT_1", defaultValue), (Throwable)e);
                element.clearContent();
            }
        }
        return element;
    }

    public CmsLinkTable getLinkTable() {
        CmsLinkTable linkTable = new CmsLinkTable();
        Element links = this.m_element.element("links");
        if (links != null) {
            Iterator itLinks = links.elementIterator("link");
            while (itLinks.hasNext()) {
                Element lelem = (Element)itLinks.next();
                linkTable.addLink(new CmsLink(lelem));
            }
        }
        return linkTable;
    }

    public String getPlainText(CmsObject cms) {
        try {
            return CmsHtmlExtractor.extractText(this.getStringValue(cms), this.m_document.getEncoding());
        }
        catch (Exception exc) {
            return null;
        }
    }

    public String getSchemaDefinition() {
        if (m_schemaDefinition == null) {
            m_schemaDefinition = this.readSchemaDefinition("org/opencms/xml/types/XmlHtmlValue.xsd");
        }
        return m_schemaDefinition;
    }

    public String getStringValue(CmsObject cms) {
        if (this.m_stringValue == null) {
            this.m_stringValue = this.createStringValue(cms, this.m_document);
        }
        return this.m_stringValue;
    }

    public String getTypeName() {
        return TYPE_NAME;
    }

    public I_CmsXmlSchemaType newInstance(String name, String minOccurs, String maxOccurs) {
        return new CmsXmlHtmlValue(name, minOccurs, maxOccurs);
    }

    public void setStringValue(CmsObject cms, String value) {
        String contentConversion;
        Element content = this.m_element.element("content");
        Element links = this.m_element.element("links");
        CmsLinkProcessor linkProcessor = null;
        String encoding = this.m_document.getEncoding();
        linkProcessor = this.m_document.getLinkProcessor(cms, new CmsLinkTable());
        String finalValue = value;
        if (encoding != null) {
            finalValue = CmsEncoder.adjustHtmlEncoding(finalValue, encoding);
        }
        if (CmsHtmlConverter.isConversionEnabled(contentConversion = this.m_document.getConversion())) {
            CmsHtmlConverter converter = new CmsHtmlConverter(encoding, contentConversion);
            finalValue = converter.convertToStringSilent(finalValue);
        }
        if (linkProcessor != null) {
            try {
                finalValue = linkProcessor.replaceLinks(finalValue);
            }
            catch (Exception exc) {
                throw new CmsRuntimeException(Messages.get().container("ERR_HTML_DATA_PROCESSING_0"), (Throwable)exc);
            }
        }
        content.clearContent();
        links.clearContent();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(finalValue)) {
            content.addCDATA(finalValue);
            if (linkProcessor != null) {
                CmsLinkTable linkTable = linkProcessor.getLinkTable();
                Iterator i = linkTable.iterator();
                while (i.hasNext()) {
                    CmsLink link = (CmsLink)i.next();
                    CmsLinkUpdateUtil.updateXmlForHtmlValue(link, link.getName(), links.addElement("link"));
                }
            }
        }
        this.m_stringValue = null;
    }

    private String createStringValue(CmsObject cms, I_CmsXmlDocument document) {
        Element data = this.m_element.element("content");
        Attribute enabled = this.m_element.attribute("enabled");
        String content = "";
        if (enabled == null || Boolean.valueOf(enabled.getText()).booleanValue()) {
            content = data.getText();
            CmsLinkTable linkTable = this.getLinkTable();
            if (!linkTable.isEmpty()) {
                CmsLinkProcessor linkProcessor = document.getLinkProcessor(cms, linkTable);
                try {
                    content = linkProcessor.processLinks(content);
                }
                catch (ParserException e) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_XMLCONTENT_LINK_PROCESS_FAILED_0"), (Throwable)e);
                }
            }
        }
        return content;
    }

    static {
        TYPE_BASE = new CmsXmlHtmlValue("base", "1", "1");
    }
}

