/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.administration;

import java.util.Iterator;
import java.util.List;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.administration.CmsAdminMenuItem;
import org.opencms.workplace.tools.CmsIdentifiableObjectContainer;
import org.opencms.workplace.tools.CmsToolMacroResolver;

public class CmsAdminMenuGroup {
    private final CmsIdentifiableObjectContainer m_container = new CmsIdentifiableObjectContainer(true, true);
    private final String m_id;
    private final String m_name;

    public CmsAdminMenuGroup(String id, String name) {
        this.m_id = id;
        this.m_name = name;
    }

    public void addMenuItem(CmsAdminMenuItem item) {
        this.m_container.addIdentifiableObject(item.getId(), (Object)item);
    }

    public void addMenuItem(CmsAdminMenuItem item, float position) {
        this.m_container.addIdentifiableObject(item.getId(), (Object)item, position);
    }

    public String getId() {
        return this.m_id;
    }

    public List getMenuItems() {
        return this.m_container.elementList();
    }

    public String getName() {
        return this.m_name;
    }

    public String groupHtml(CmsWorkplace wp) {
        StringBuffer html = new StringBuffer(512);
        html.append(this.htmlStart(wp));
        Iterator itItem = this.m_container.elementList().iterator();
        while (itItem.hasNext()) {
            CmsAdminMenuItem item = (CmsAdminMenuItem)itItem.next();
            html.append(item.itemHtml(wp));
            html.append("\n");
        }
        html.append(this.htmlEnd());
        return html.toString();
    }

    private String htmlEnd() {
        StringBuffer html = new StringBuffer(512);
        html.append("\t\t\t\t\t\t</td>\n");
        html.append("\t\t\t\t\t</tr>\n");
        html.append("\t\t\t\t</table>\n");
        html.append("\t\t\t</div>\n");
        html.append("\t\t</td>\n");
        html.append("\t</tr>\n");
        html.append("</table>\n");
        return html.toString();
    }

    private String htmlStart(CmsWorkplace wp) {
        StringBuffer html = new StringBuffer(1024);
        html.append("<table border='0' cellspacing='0' cellpadding='0' width='100%' class='navOpened' id='");
        html.append(this.getId());
        html.append("'>\n");
        html.append("\t<tr>\n");
        html.append("\t\t<td class='titleBorder'>\n");
        html.append("\t\t\t<table border='0' cellspacing='0' cellpadding='0' width='100%' class='navTitle' onMouseOver='mouseGroupEvent(this, true);' onMouseOut='mouseGroupEvent(this, false);' onClick=\"return openGroup('");
        html.append(this.getId());
        html.append("');\" >\n");
        html.append("\t\t\t\t<tr>\n");
        html.append("\t\t\t\t\t<td class='titleText' width='100%'>");
        html.append(CmsToolMacroResolver.resolveMacros((String)this.getName(), (CmsWorkplace)wp));
        html.append("</td>\n");
        html.append("\t\t\t\t</tr>\n");
        html.append("\t\t\t</table>\n");
        html.append("\t\t</td>\n");
        html.append("\t</tr><tr>\n");
        html.append("\t\t<td class='treeBorder'>\n");
        html.append("\t\t\t<div class='tree'>\n");
        html.append("\t\t\t\t<table border='0' cellspacing='0' cellpadding='0' width='100%'>\n");
        html.append("\t\t\t\t\t<tr>\n");
        html.append("\t\t\t\t\t\t<td>\n");
        return html.toString();
    }
}

