/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.scheduler;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsContextInfo;
import org.opencms.main.OpenCms;
import org.opencms.monitor.CmsMemoryMonitor;
import org.opencms.notification.CmsContentNotificationJob;
import org.opencms.relations.CmsExternalLinksValidator;
import org.opencms.relations.CmsInternalRelationsValidationJob;
import org.opencms.scheduler.CmsScheduledJobInfo;
import org.opencms.scheduler.jobs.CmsCreateImageSizeJob;
import org.opencms.scheduler.jobs.CmsHistoryClearJob;
import org.opencms.scheduler.jobs.CmsImageCacheCleanupJob;
import org.opencms.scheduler.jobs.CmsPublishJob;
import org.opencms.scheduler.jobs.CmsStaticExportJob;
import org.opencms.search.CmsSearchManager;
import org.opencms.util.CmsDateUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.CmsCheckboxWidget;
import org.opencms.widgets.CmsComboWidget;
import org.opencms.widgets.CmsDisplayWidget;
import org.opencms.widgets.CmsInputWidget;
import org.opencms.widgets.CmsSelectWidgetOption;
import org.opencms.widgets.CmsUserWidget;
import org.opencms.widgets.CmsVfsFileWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWidgetDialog;
import org.opencms.workplace.CmsWidgetDialogParameter;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.tools.scheduler.CmsSchedulerList;
import org.opencms.workplace.tools.scheduler.Messages;

public class CmsEditScheduledJobInfoDialog
extends CmsWidgetDialog {
    public static final String DIALOG_COPYJOB = "copyjob";
    public static final String[] PAGES = new String[]{"page1", "page2"};
    public static final String PARAM_JOBID = "jobid";
    protected CmsScheduledJobInfo m_jobInfo;
    protected String m_paramJobid;
    protected String m_serverTime;

    public CmsEditScheduledJobInfoDialog(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsEditScheduledJobInfoDialog(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void actionCommit() {
        ArrayList<Throwable> errors = new ArrayList<Throwable>();
        try {
            OpenCms.getScheduleManager().scheduleJob(this.getCms(), this.m_jobInfo);
            OpenCms.writeConfiguration((Class)CmsSystemConfiguration.class);
            Map objects = (Map)this.getSettings().getListObject();
            if (objects != null) {
                objects.remove(CmsSchedulerList.class.getName());
            }
        }
        catch (Throwable t) {
            errors.add(t);
        }
        this.setCommitErrors(errors);
    }

    public String getParamJobid() {
        return this.m_paramJobid;
    }

    public String getServerTime() {
        if (this.m_serverTime == null) {
            this.m_serverTime = CmsDateUtil.getDateTime((Date)new Date(), (int)1, (Locale)this.getLocale());
        }
        return this.m_serverTime;
    }

    public void setParamJobid(String jobid) {
        this.m_paramJobid = jobid;
    }

    public void setServerTime(String serverTime) {
        this.m_serverTime = serverTime;
    }

    protected String createDialogHtml(String dialog) {
        StringBuffer result = new StringBuffer(1024);
        result.append(this.createWidgetTableStart());
        result.append(this.createWidgetErrorHeader());
        if (dialog.equals(PAGES[0])) {
            result.append(this.createWidgetBlockStart(this.key("GUI_EDITOR_LABEL_SERVERTIME_BLOCK_0")));
            result.append(this.createDialogRowsHtml(0, 0));
            result.append(this.createWidgetBlockEnd());
            result.append(this.createWidgetBlockStart(this.key("GUI_EDITOR_LABEL_JOBSETTINGS_BLOCK_0")));
            result.append(this.createDialogRowsHtml(1, 5));
            result.append(this.createWidgetBlockEnd());
            result.append(this.createWidgetBlockStart(this.key("GUI_EDITOR_LABEL_CONTEXTINFO_BLOCK_0")));
            result.append(this.createDialogRowsHtml(6, 12));
            result.append(this.createWidgetBlockEnd());
        } else if (dialog.equals(PAGES[1])) {
            result.append(this.createWidgetBlockStart(this.key("GUI_EDITOR_LABEL_PARAMETERS_BLOCK_0")));
            result.append(this.createDialogRowsHtml(13, 13));
            result.append(this.createWidgetBlockEnd());
        }
        result.append(this.createWidgetTableEnd());
        return result.toString();
    }

    protected void defineWidgets() {
        this.initScheduledJobObject();
        CmsContextInfo dC = new CmsContextInfo();
        this.addWidget(new CmsWidgetDialogParameter((Object)this, "serverTime", PAGES[0], (I_CmsWidget)new CmsDisplayWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_jobInfo, "jobName", PAGES[0], (I_CmsWidget)new CmsInputWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_jobInfo, "className", PAGES[0], (I_CmsWidget)new CmsComboWidget(this.getComboClasses())));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_jobInfo, "cronExpression", PAGES[0], (I_CmsWidget)new CmsComboWidget(this.getComboCronExpressions())));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_jobInfo, "reuseInstance", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_jobInfo, "active", PAGES[0], (I_CmsWidget)new CmsCheckboxWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_jobInfo, "contextInfo.userName", PAGES[0], (I_CmsWidget)new CmsUserWidget(null, null)));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_jobInfo, "contextInfo.projectName", PAGES[0], (I_CmsWidget)new CmsInputWidget()));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_jobInfo, "contextInfo.siteRoot", dC.getSiteRoot(), PAGES[0], (I_CmsWidget)new CmsVfsFileWidget(), 0, 1));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_jobInfo, "contextInfo.requestedUri", dC.getRequestedUri(), PAGES[0], (I_CmsWidget)new CmsVfsFileWidget(), 0, 1));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_jobInfo, "contextInfo.localeName", dC.getLocaleName(), PAGES[0], (I_CmsWidget)new CmsInputWidget(), 0, 1));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_jobInfo, "contextInfo.encoding", dC.getEncoding(), PAGES[0], (I_CmsWidget)new CmsInputWidget(), 0, 1));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_jobInfo, "contextInfo.remoteAddr", dC.getRemoteAddr(), PAGES[0], (I_CmsWidget)new CmsInputWidget(), 0, 1));
        this.addWidget(new CmsWidgetDialogParameter((Object)this.m_jobInfo, "parameters", PAGES[1], (I_CmsWidget)new CmsInputWidget()));
    }

    protected List getComboClasses() {
        ArrayList<CmsSelectWidgetOption> result = new ArrayList<CmsSelectWidgetOption>();
        result.add(new CmsSelectWidgetOption(CmsInternalRelationsValidationJob.class.getName(), false, null, this.key("GUI_EDITOR_CRONCLASS_INTERNALVALIDATION_0")));
        result.add(new CmsSelectWidgetOption(CmsPublishJob.class.getName(), false, null, this.key("GUI_EDITOR_CRONCLASS_PUBLISH_0")));
        result.add(new CmsSelectWidgetOption(CmsStaticExportJob.class.getName(), false, null, this.key("GUI_EDITOR_CRONCLASS_STATICEXPORT_0")));
        result.add(new CmsSelectWidgetOption(CmsExternalLinksValidator.class.getName(), false, null, this.key("GUI_EDITOR_CRONCLASS_POINTERVALIDATION_0")));
        result.add(new CmsSelectWidgetOption(CmsMemoryMonitor.class.getName(), false, null, this.key("GUI_EDITOR_CRONCLASS_MEMORYMONITOR_0")));
        result.add(new CmsSelectWidgetOption(CmsSearchManager.class.getName(), false, null, this.key("GUI_EDITOR_CRONCLASS_SEARCHINDEX_0")));
        result.add(new CmsSelectWidgetOption(CmsContentNotificationJob.class.getName(), false, null, this.key("GUI_EDITOR_CRONCLASS_CONTENTNOTIFICATION_0")));
        result.add(new CmsSelectWidgetOption(CmsCreateImageSizeJob.class.getName(), false, null, this.key("GUI_EDITOR_CRONCLASS_IMAGESIZE_0")));
        result.add(new CmsSelectWidgetOption(CmsImageCacheCleanupJob.class.getName(), false, null, this.key("GUI_EDITOR_CRONCLASS_IMAGE_CACHECLEAN_0")));
        result.add(new CmsSelectWidgetOption(CmsHistoryClearJob.class.getName(), false, null, this.key("GUI_EDITOR_CRONCLASS_CLEARHISTORY_0")));
        return result;
    }

    protected List getComboCronExpressions() {
        ArrayList<CmsSelectWidgetOption> result = new ArrayList<CmsSelectWidgetOption>();
        result.add(new CmsSelectWidgetOption("0 0 3 * * ?", false, null, this.key("GUI_EDITOR_CRONJOB_EXAMPLE1_0")));
        result.add(new CmsSelectWidgetOption("0 0/30 * * * ?", false, null, this.key("GUI_EDITOR_CRONJOB_EXAMPLE2_0")));
        result.add(new CmsSelectWidgetOption("0 30 8 ? * 4", false, null, this.key("GUI_EDITOR_CRONJOB_EXAMPLE3_0")));
        result.add(new CmsSelectWidgetOption("0 15 18 20 * ?", false, null, this.key("GUI_EDITOR_CRONJOB_EXAMPLE4_0")));
        result.add(new CmsSelectWidgetOption("0 45 15 ? * 1 2007-2009", false, null, this.key("GUI_EDITOR_CRONJOB_EXAMPLE5_0")));
        return result;
    }

    protected String[] getPageArray() {
        return PAGES;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void initScheduledJobObject() {
        Object o;
        boolean setActive = false;
        if (CmsStringUtil.isEmpty((String)this.getParamAction()) || "initial".equals(this.getParamAction()) || DIALOG_COPYJOB.equals(this.getParamAction())) {
            if (CmsStringUtil.isNotEmpty((String)this.getParamJobid())) {
                o = OpenCms.getScheduleManager().getJob(this.getParamJobid()).clone();
                setActive = ((CmsScheduledJobInfo)o).isActive();
            } else {
                o = null;
            }
        } else {
            o = this.getDialogObject();
        }
        if (!(o instanceof CmsScheduledJobInfo)) {
            this.m_jobInfo = new CmsScheduledJobInfo();
            this.m_jobInfo.setContextInfo(new CmsContextInfo());
        } else {
            this.m_jobInfo = (CmsScheduledJobInfo)o;
        }
        if (setActive) {
            this.m_jobInfo.setActive(true);
        }
        if (DIALOG_COPYJOB.equals(this.getParamAction())) {
            this.m_jobInfo.clearId();
        }
    }

    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        super.initWorkplaceRequestValues(settings, request);
        this.setDialogObject(this.m_jobInfo);
    }

    protected boolean isNewJob() {
        return this.getCurrentToolPath().equals("/scheduler/new");
    }

    protected void validateParamaters() throws Exception {
        if (!this.isNewJob()) {
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly((String)this.getParamJobid()) && OpenCms.getScheduleManager().getJob(this.getParamJobid()) != null) {
                return;
            }
            throw new Exception();
        }
    }
}

