/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.tools.scheduler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.configuration.CmsSystemConfiguration;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.scheduler.CmsScheduledJobInfo;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.list.A_CmsListDialog;
import org.opencms.workplace.list.CmsListColumnAlignEnum;
import org.opencms.workplace.list.CmsListColumnDefinition;
import org.opencms.workplace.list.CmsListDateMacroFormatter;
import org.opencms.workplace.list.CmsListDefaultAction;
import org.opencms.workplace.list.CmsListDirectAction;
import org.opencms.workplace.list.CmsListItem;
import org.opencms.workplace.list.CmsListItemActionIconComparator;
import org.opencms.workplace.list.CmsListItemDefaultComparator;
import org.opencms.workplace.list.CmsListItemDetails;
import org.opencms.workplace.list.CmsListItemDetailsFormatter;
import org.opencms.workplace.list.CmsListMetadata;
import org.opencms.workplace.list.CmsListMultiAction;
import org.opencms.workplace.list.CmsListOrderEnum;
import org.opencms.workplace.list.I_CmsListDirectAction;
import org.opencms.workplace.list.I_CmsListFormatter;
import org.opencms.workplace.list.I_CmsListItemComparator;
import org.opencms.workplace.tools.scheduler.CmsContextInfoDetailsFormatter;
import org.opencms.workplace.tools.scheduler.Messages;

public class CmsSchedulerList
extends A_CmsListDialog {
    public static final String LIST_ACTION_ACTIVATE = "aa";
    public static final String LIST_ACTION_COPY = "ac";
    public static final String LIST_ACTION_DEACTIVATE = "at";
    public static final String LIST_ACTION_DELETE = "ad";
    public static final String LIST_ACTION_EDIT = "ae";
    public static final String LIST_COLUMN_ACTIVATE = "ca";
    public static final String LIST_COLUMN_CLASS = "cs";
    public static final String LIST_COLUMN_ACTIVE = "cac";
    public static final String LIST_COLUMN_COPY = "cc";
    public static final String LIST_COLUMN_DELETE = "cd";
    public static final String LIST_COLUMN_EDIT = "ce";
    public static final String LIST_COLUMN_LASTEXE = "cl";
    public static final String LIST_COLUMN_NAME = "cn";
    public static final String LIST_COLUMN_NEXTEXE = "cx";
    public static final String LIST_DEFACTION_EDIT = "de";
    public static final String LIST_DETAIL_CONTEXTINFO = "dc";
    public static final String LIST_DETAIL_PARAMETER = "dp";
    public static final String LIST_ID = "lj";
    public static final String LIST_MACTION_ACTIVATE = "ma";
    public static final String LIST_MACTION_DEACTIVATE = "mc";
    public static final String LIST_MACTION_DELETE = "md";
    public static final String PATH_BUTTONS = "tools/scheduler/buttons/";

    public CmsSchedulerList(CmsJspActionElement jsp) {
        super(jsp, LIST_ID, new CmsMessageContainer(Messages.get(), "GUI_JOBS_LIST_NAME_0"), LIST_COLUMN_NAME, CmsListOrderEnum.ORDER_ASCENDING, LIST_COLUMN_NAME);
    }

    public CmsSchedulerList(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        this(new CmsJspActionElement(context, req, res));
    }

    public void executeListMultiActions() throws CmsRuntimeException {
        if (this.getParamListAction().equals(LIST_MACTION_DELETE)) {
            ArrayList<String> removedItems = new ArrayList<String>();
            Iterator itItems = this.getSelectedItems().iterator();
            while (itItems.hasNext()) {
                CmsListItem listItem = (CmsListItem)itItems.next();
                try {
                    OpenCms.getScheduleManager().unscheduleJob(this.getCms(), listItem.getId());
                    removedItems.add(listItem.getId());
                }
                catch (CmsException e) {
                    throw new CmsRuntimeException(Messages.get().container("ERR_UNSCHEDULE_JOB_1", (Object)listItem.getId()), (Throwable)e);
                }
            }
            this.writeConfiguration(false);
        } else if (this.getParamListAction().equals(LIST_MACTION_ACTIVATE) || this.getParamListAction().equals(LIST_MACTION_DEACTIVATE)) {
            Iterator itItems = this.getSelectedItems().iterator();
            boolean activate = this.getParamListAction().equals(LIST_MACTION_ACTIVATE);
            while (itItems.hasNext()) {
                CmsListItem listItem = (CmsListItem)itItems.next();
                try {
                    CmsScheduledJobInfo job = (CmsScheduledJobInfo)OpenCms.getScheduleManager().getJob(listItem.getId()).clone();
                    job.setActive(activate);
                    OpenCms.getScheduleManager().scheduleJob(this.getCms(), job);
                }
                catch (CmsException e) {
                    throw new CmsRuntimeException(Messages.get().container("ERR_SCHEDULE_JOB_1", (Object)listItem.getId()), (Throwable)e);
                }
            }
            this.writeConfiguration(true);
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    public void executeListSingleActions() throws IOException, ServletException {
        if (this.getParamListAction().equals(LIST_ACTION_EDIT) || this.getParamListAction().equals(LIST_DEFACTION_EDIT)) {
            String jobId = this.getSelectedItem().getId();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("jobid", jobId);
            params.put("action", "initial");
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/scheduler/edit", params);
        } else if (this.getParamListAction().equals(LIST_ACTION_COPY)) {
            String jobId = this.getSelectedItem().getId();
            HashMap<String, String> params = new HashMap<String, String>();
            params.put("jobid", jobId);
            params.put("action", "copyjob");
            this.getToolManager().jspForwardTool((CmsWorkplace)this, "/scheduler/new", params);
        } else if (this.getParamListAction().equals(LIST_ACTION_ACTIVATE)) {
            String jobId = this.getSelectedItem().getId();
            CmsScheduledJobInfo job = (CmsScheduledJobInfo)OpenCms.getScheduleManager().getJob(jobId).clone();
            job.setActive(true);
            try {
                OpenCms.getScheduleManager().scheduleJob(this.getCms(), job);
                this.writeConfiguration(true);
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_SCHEDULE_JOB_1", (Object)jobId), (Throwable)e);
            }
        } else if (this.getParamListAction().equals(LIST_ACTION_DEACTIVATE)) {
            String jobId = this.getSelectedItem().getId();
            CmsScheduledJobInfo job = (CmsScheduledJobInfo)OpenCms.getScheduleManager().getJob(jobId).clone();
            job.setActive(false);
            try {
                OpenCms.getScheduleManager().scheduleJob(this.getCms(), job);
                this.writeConfiguration(true);
            }
            catch (CmsException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_UNSCHEDULE_JOB_1", (Object)jobId), (Throwable)e);
            }
        } else if (this.getParamListAction().equals(LIST_ACTION_DELETE)) {
            String jobId = this.getSelectedItem().getId();
            try {
                OpenCms.getScheduleManager().unscheduleJob(this.getCms(), jobId);
                this.writeConfiguration(false);
            }
            catch (CmsRoleViolationException e) {
                throw new CmsRuntimeException(Messages.get().container("ERR_DELETE_JOB_1", (Object)jobId), (Throwable)e);
            }
        } else {
            this.throwListUnsupportedActionException();
        }
        this.listSave();
    }

    protected void fillDetails(String detailId) {
        Iterator i = this.getList().getAllContent().iterator();
        while (i.hasNext()) {
            CmsListItem item = (CmsListItem)i.next();
            CmsScheduledJobInfo job = OpenCms.getScheduleManager().getJob(item.getId());
            if (detailId.equals(LIST_DETAIL_CONTEXTINFO)) {
                item.set(LIST_DETAIL_CONTEXTINFO, (Object)job.getContextInfo());
                continue;
            }
            if (!detailId.equals(LIST_DETAIL_PARAMETER)) continue;
            StringBuffer params = new StringBuffer(32);
            Iterator paramIt = job.getParameters().keySet().iterator();
            while (paramIt.hasNext()) {
                String param = (String)paramIt.next();
                String value = (String)job.getParameters().get(param);
                params.append(param).append("=");
                params.append(value).append("<br>");
            }
            item.set(LIST_DETAIL_PARAMETER, (Object)params);
        }
    }

    protected List getListItems() {
        ArrayList<CmsListItem> items = new ArrayList<CmsListItem>();
        Iterator i = OpenCms.getScheduleManager().getJobs().iterator();
        while (i.hasNext()) {
            CmsScheduledJobInfo job = (CmsScheduledJobInfo)i.next();
            CmsListItem item = this.getList().newItem(job.getId());
            item.set(LIST_COLUMN_NAME, (Object)job.getJobName());
            item.set(LIST_COLUMN_CLASS, (Object)job.getClassName());
            item.set(LIST_COLUMN_LASTEXE, (Object)job.getExecutionTimePrevious());
            item.set(LIST_COLUMN_NEXTEXE, (Object)job.getExecutionTimeNext());
            item.set(LIST_COLUMN_ACTIVE, (Object)job.isActive());
            items.add(item);
        }
        return items;
    }

    protected void initMessages() {
        this.addMessages(Messages.get().getBundleName());
        super.initMessages();
    }

    protected void setColumns(CmsListMetadata metadata) {
        CmsListColumnDefinition editCol = new CmsListColumnDefinition(LIST_COLUMN_EDIT);
        editCol.setName(Messages.get().container("GUI_JOBS_LIST_COL_EDIT_0"));
        editCol.setHelpText(Messages.get().container("GUI_JOBS_LIST_COL_EDIT_HELP_0"));
        editCol.setWidth("20");
        editCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        editCol.setSorteable(false);
        CmsListDirectAction editColAction = new CmsListDirectAction(LIST_ACTION_EDIT);
        editColAction.setName(Messages.get().container("GUI_JOBS_LIST_ACTION_EDIT_NAME_0"));
        editColAction.setIconPath("tools/scheduler/buttons/edit.png");
        editColAction.setHelpText(Messages.get().container("GUI_JOBS_LIST_ACTION_EDIT_HELP_0"));
        editColAction.setConfirmationMessage(Messages.get().container("GUI_JOBS_LIST_ACTION_EDIT_CONF_0"));
        editCol.addDirectAction((I_CmsListDirectAction)editColAction);
        metadata.addColumn(editCol);
        CmsListColumnDefinition activateCol = new CmsListColumnDefinition(LIST_COLUMN_ACTIVATE);
        activateCol.setName(Messages.get().container("GUI_JOBS_LIST_COL_ACTIVE_0"));
        activateCol.setHelpText(Messages.get().container("GUI_JOBS_LIST_COL_ACTIVE_HELP_0"));
        activateCol.setWidth("20");
        activateCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        activateCol.setListItemComparator((I_CmsListItemComparator)new CmsListItemActionIconComparator());
        CmsListDirectAction jobActAction = new CmsListDirectAction(LIST_ACTION_ACTIVATE){

            public boolean isVisible() {
                if (this.getItem() != null) {
                    return (Boolean)this.getItem().get(CmsSchedulerList.LIST_COLUMN_ACTIVE) == false;
                }
                return super.isVisible();
            }
        };
        jobActAction.setName(Messages.get().container("GUI_JOBS_LIST_ACTION_ACTIVATE_NAME_0"));
        jobActAction.setConfirmationMessage(Messages.get().container("GUI_JOBS_LIST_ACTION_ACTIVATE_CONF_0"));
        jobActAction.setIconPath("list/inactive.png");
        jobActAction.setHelpText(Messages.get().container("GUI_JOBS_LIST_ACTION_ACTIVATE_HELP_0"));
        activateCol.addDirectAction((I_CmsListDirectAction)jobActAction);
        CmsListDirectAction jobDeactAction = new CmsListDirectAction(LIST_ACTION_DEACTIVATE){

            public boolean isVisible() {
                if (this.getItem() != null) {
                    return (Boolean)this.getItem().get(CmsSchedulerList.LIST_COLUMN_ACTIVE);
                }
                return super.isVisible();
            }
        };
        jobDeactAction.setName(Messages.get().container("GUI_JOBS_LIST_ACTION_DEACTIVATE_NAME_0"));
        jobDeactAction.setConfirmationMessage(Messages.get().container("GUI_JOBS_LIST_ACTION_DEACTIVATE_CONF_0"));
        jobDeactAction.setIconPath("list/active.png");
        jobDeactAction.setHelpText(Messages.get().container("GUI_JOBS_LIST_ACTION_DEACTIVATE_HELP_0"));
        activateCol.addDirectAction((I_CmsListDirectAction)jobDeactAction);
        metadata.addColumn(activateCol);
        CmsListColumnDefinition copyCol = new CmsListColumnDefinition(LIST_COLUMN_COPY);
        copyCol.setName(Messages.get().container("GUI_JOBS_LIST_COL_COPY_0"));
        copyCol.setHelpText(Messages.get().container("GUI_JOBS_LIST_COL_COPY_HELP_0"));
        copyCol.setWidth("20");
        copyCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        copyCol.setListItemComparator(null);
        CmsListDirectAction copyJob = new CmsListDirectAction(LIST_ACTION_COPY);
        copyJob.setName(Messages.get().container("GUI_JOBS_LIST_ACTION_COPY_NAME_0"));
        copyJob.setConfirmationMessage(Messages.get().container("GUI_JOBS_LIST_ACTION_COPY_CONF_0"));
        copyJob.setIconPath("tools/scheduler/buttons/copy.png");
        copyJob.setHelpText(Messages.get().container("GUI_JOBS_LIST_ACTION_COPY_HELP_0"));
        copyCol.addDirectAction((I_CmsListDirectAction)copyJob);
        metadata.addColumn(copyCol);
        CmsListColumnDefinition delCol = new CmsListColumnDefinition(LIST_COLUMN_DELETE);
        delCol.setName(Messages.get().container("GUI_JOBS_LIST_COL_DELETE_0"));
        delCol.setHelpText(Messages.get().container("GUI_JOBS_LIST_COL_DELETE_HELP_0"));
        delCol.setWidth("20");
        delCol.setAlign(CmsListColumnAlignEnum.ALIGN_CENTER);
        delCol.setListItemComparator(null);
        CmsListDirectAction delJob = new CmsListDirectAction(LIST_ACTION_DELETE);
        delJob.setName(Messages.get().container("GUI_JOBS_LIST_ACTION_DELETE_NAME_0"));
        delJob.setConfirmationMessage(Messages.get().container("GUI_JOBS_LIST_ACTION_DELETE_CONF_0"));
        delJob.setIconPath("list/delete.png");
        delJob.setHelpText(Messages.get().container("GUI_JOBS_LIST_ACTION_DELETE_HELP_0"));
        delCol.addDirectAction((I_CmsListDirectAction)delJob);
        metadata.addColumn(delCol);
        CmsListColumnDefinition nameCol = new CmsListColumnDefinition(LIST_COLUMN_NAME);
        nameCol.setName(Messages.get().container("GUI_JOBS_LIST_COL_NAME_0"));
        nameCol.setWidth("30%");
        nameCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        nameCol.setListItemComparator((I_CmsListItemComparator)new CmsListItemDefaultComparator());
        CmsListDefaultAction nameColAction = new CmsListDefaultAction(LIST_DEFACTION_EDIT);
        nameColAction.setName(Messages.get().container("GUI_JOBS_LIST_ACTION_EDIT_NAME_0"));
        nameColAction.setHelpText(Messages.get().container("GUI_JOBS_LIST_ACTION_EDIT_HELP_0"));
        nameColAction.setConfirmationMessage(Messages.get().container("GUI_JOBS_LIST_ACTION_EDIT_CONF_0"));
        nameCol.addDefaultAction(nameColAction);
        metadata.addColumn(nameCol);
        CmsListColumnDefinition classCol = new CmsListColumnDefinition(LIST_COLUMN_CLASS);
        classCol.setName(Messages.get().container("GUI_JOBS_LIST_COL_CLASS_0"));
        classCol.setWidth("20%");
        classCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        classCol.setListItemComparator((I_CmsListItemComparator)new CmsListItemDefaultComparator());
        metadata.addColumn(classCol);
        CmsListColumnDefinition lastExecCol = new CmsListColumnDefinition(LIST_COLUMN_LASTEXE);
        lastExecCol.setName(Messages.get().container("GUI_JOBS_LIST_COL_LASTEXE_0"));
        lastExecCol.setWidth("25%");
        lastExecCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        lastExecCol.setListItemComparator((I_CmsListItemComparator)new CmsListItemDefaultComparator());
        lastExecCol.setFormatter(CmsListDateMacroFormatter.getDefaultDateFormatter());
        metadata.addColumn(lastExecCol);
        CmsListColumnDefinition nextExecCol = new CmsListColumnDefinition(LIST_COLUMN_NEXTEXE);
        nextExecCol.setName(Messages.get().container("GUI_JOBS_LIST_COL_NEXTEXE_0"));
        nextExecCol.setWidth("25%");
        nextExecCol.setAlign(CmsListColumnAlignEnum.ALIGN_LEFT);
        nextExecCol.setListItemComparator((I_CmsListItemComparator)new CmsListItemDefaultComparator());
        CmsListColumnDefinition actInfoCol = new CmsListColumnDefinition(LIST_COLUMN_ACTIVE);
        actInfoCol.setVisible(false);
        metadata.addColumn(actInfoCol);
        nextExecCol.setFormatter(CmsListDateMacroFormatter.getDefaultDateFormatter());
        metadata.addColumn(nextExecCol);
    }

    protected void setIndependentActions(CmsListMetadata metadata) {
        CmsListItemDetails jobsContextInfoDetails = new CmsListItemDetails(LIST_DETAIL_CONTEXTINFO);
        jobsContextInfoDetails.setAtColumn(LIST_COLUMN_NAME);
        jobsContextInfoDetails.setVisible(false);
        jobsContextInfoDetails.setShowActionName(Messages.get().container("GUI_JOBS_DETAIL_SHOW_CONTEXTINFO_NAME_0"));
        jobsContextInfoDetails.setShowActionHelpText(Messages.get().container("GUI_JOBS_DETAIL_SHOW_CONTEXTINFO_HELP_0"));
        jobsContextInfoDetails.setHideActionName(Messages.get().container("GUI_JOBS_DETAIL_HIDE_CONTEXTINFO_NAME_0"));
        jobsContextInfoDetails.setHideActionHelpText(Messages.get().container("GUI_JOBS_DETAIL_HIDE_CONTEXTINFO_HELP_0"));
        CmsContextInfoDetailsFormatter contextFormatter = new CmsContextInfoDetailsFormatter();
        contextFormatter.setUserMessage(Messages.get().container("GUI_JOBS_DETAIL_CONTEXTINFO_USER_0"));
        contextFormatter.setProjectMessage(Messages.get().container("GUI_JOBS_DETAIL_CONTEXTINFO_PROJECT_0"));
        contextFormatter.setLocaleMessage(Messages.get().container("GUI_JOBS_DETAIL_CONTEXTINFO_LOCALE_0"));
        contextFormatter.setRootSiteMessage(Messages.get().container("GUI_JOBS_DETAIL_CONTEXTINFO_ROOTSITE_0"));
        contextFormatter.setEncodingMessage(Messages.get().container("GUI_JOBS_DETAIL_CONTEXTINFO_ENCODING_0"));
        contextFormatter.setRemoteAddrMessage(Messages.get().container("GUI_JOBS_DETAIL_CONTEXTINFO_REMADR_0"));
        contextFormatter.setRequestedURIMessage(Messages.get().container("GUI_JOBS_DETAIL_CONTEXTINFO_REQURI_0"));
        jobsContextInfoDetails.setFormatter((I_CmsListFormatter)contextFormatter);
        metadata.addItemDetails(jobsContextInfoDetails);
        CmsListItemDetails jobsParameterDetails = new CmsListItemDetails(LIST_DETAIL_PARAMETER);
        jobsParameterDetails.setAtColumn(LIST_COLUMN_NAME);
        jobsParameterDetails.setVisible(false);
        jobsParameterDetails.setShowActionName(Messages.get().container("GUI_JOBS_DETAIL_SHOW_PARAMETER_NAME_0"));
        jobsParameterDetails.setShowActionHelpText(Messages.get().container("GUI_JOBS_DETAIL_SHOW_PARAMETER_HELP_0"));
        jobsParameterDetails.setHideActionName(Messages.get().container("GUI_JOBS_DETAIL_HIDE_PARAMETER_NAME_0"));
        jobsParameterDetails.setHideActionHelpText(Messages.get().container("GUI_JOBS_DETAIL_HIDE_PARAMETER_HELP_0"));
        jobsParameterDetails.setFormatter((I_CmsListFormatter)new CmsListItemDetailsFormatter(Messages.get().container("GUI_JOBS_DETAIL_PARAMETER_FORMAT_0")));
        metadata.addItemDetails(jobsParameterDetails);
    }

    protected void setMultiActions(CmsListMetadata metadata) {
        CmsListMultiAction activateJob = new CmsListMultiAction(LIST_MACTION_ACTIVATE);
        activateJob.setName(Messages.get().container("GUI_JOBS_LIST_ACTION_MACTIVATE_NAME_0"));
        activateJob.setConfirmationMessage(Messages.get().container("GUI_JOBS_LIST_ACTION_MACTIVATE_CONF_0"));
        activateJob.setIconPath("list/multi_activate.png");
        activateJob.setHelpText(Messages.get().container("GUI_JOBS_LIST_ACTION_MACTIVATE_HELP_0"));
        metadata.addMultiAction(activateJob);
        CmsListMultiAction deactivateJob = new CmsListMultiAction(LIST_MACTION_DEACTIVATE);
        deactivateJob.setName(Messages.get().container("GUI_JOBS_LIST_ACTION_MDEACTIVATE_NAME_0"));
        deactivateJob.setConfirmationMessage(Messages.get().container("GUI_JOBS_LIST_ACTION_MDEACTIVATE_CONF_0"));
        deactivateJob.setIconPath("list/multi_deactivate.png");
        deactivateJob.setHelpText(Messages.get().container("GUI_JOBS_LIST_ACTION_MDEACTIVATE_HELP_0"));
        metadata.addMultiAction(deactivateJob);
        CmsListMultiAction deleteJobs = new CmsListMultiAction(LIST_MACTION_DELETE);
        deleteJobs.setName(Messages.get().container("GUI_JOBS_LIST_ACTION_MDELETE_NAME_0"));
        deleteJobs.setConfirmationMessage(Messages.get().container("GUI_JOBS_LIST_ACTION_MDELETE_CONF_0"));
        deleteJobs.setIconPath("list/multi_delete.png");
        deleteJobs.setHelpText(Messages.get().container("GUI_JOBS_LIST_ACTION_MDELETE_HELP_0"));
        metadata.addMultiAction(deleteJobs);
    }

    protected void writeConfiguration(boolean refresh) {
        OpenCms.writeConfiguration((Class)CmsSystemConfiguration.class);
        if (refresh) {
            this.refreshList();
        }
    }
}

