/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordDescriptionEvent;
import com.ibm.as400.access.RecordDescriptionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import java.util.Vector;

public class RecordFormat
implements Serializable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    static final long serialVersionUID = 4L;
    public static final int FIXED_LAYOUT_LENGTH = 1;
    public static final int VARIABLE_LAYOUT_LENGTH = 2;
    private char delimiter_;
    private Vector fieldDescriptions_ = new Vector();
    private Hashtable fieldNameToIndexMap_ = new Hashtable();
    private boolean hasDependentFields_;
    private Vector keyFieldDescriptions_ = new Vector();
    private Hashtable keyFieldNameToIndexMap_ = new Hashtable();
    private Vector lengthDependentFields_ = new Vector();
    private String name_ = "";
    private static final Integer NOT_DEPENDENT_ = new Integer(-1);
    private Vector offsetDependentFields_ = new Vector();
    private int recordFormatType_;
    private String recordFormatID_ = "";
    private transient PropertyChangeSupport changes_;
    private transient Vector rdListeners_;
    private transient VetoableChangeSupport vetos_;

    public RecordFormat() {
        this.initializeTransient();
    }

    public RecordFormat(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.name_ = string.toUpperCase();
        this.initializeTransient();
    }

    public void addFieldDescription(FieldDescription fieldDescription) {
        if (fieldDescription == null) {
            throw new NullPointerException("field");
        }
        this.fieldNameToIndexMap_.put(fieldDescription.getFieldName(), new Integer(this.fieldDescriptions_.size()));
        this.fieldDescriptions_.addElement(fieldDescription);
        this.lengthDependentFields_.addElement(NOT_DEPENDENT_);
        this.offsetDependentFields_.addElement(NOT_DEPENDENT_);
        this.fireEvent(1);
    }

    public void addKeyFieldDescription(int n) {
        if (n < 0 || n > this.fieldDescriptions_.size() - 1) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        FieldDescription fieldDescription = (FieldDescription)this.fieldDescriptions_.elementAt(n);
        this.keyFieldNameToIndexMap_.put(fieldDescription.getFieldName(), new Integer(this.keyFieldDescriptions_.size()));
        this.keyFieldDescriptions_.addElement(fieldDescription);
        this.fireEvent(2);
    }

    public void addKeyFieldDescription(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        this.addKeyFieldDescription(this.getIndexOfFieldName(string));
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ == null) {
            this.changes_ = new PropertyChangeSupport(this);
        }
        this.changes_.addPropertyChangeListener(propertyChangeListener);
    }

    public void addRecordDescriptionListener(RecordDescriptionListener recordDescriptionListener) {
        if (recordDescriptionListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.rdListeners_ == null) {
            this.rdListeners_ = new Vector();
        }
        this.rdListeners_.addElement(recordDescriptionListener);
    }

    public void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ == null) {
            this.vetos_ = new VetoableChangeSupport(this);
        }
        this.vetos_.addVetoableChangeListener(vetoableChangeListener);
    }

    private void fireEvent(int n) {
        if (this.rdListeners_ == null) {
            return;
        }
        Vector vector = (Vector)this.rdListeners_.clone();
        RecordDescriptionEvent recordDescriptionEvent = new RecordDescriptionEvent(this, n);
        block4: for (int i = 0; i < vector.size(); ++i) {
            RecordDescriptionListener recordDescriptionListener = (RecordDescriptionListener)vector.elementAt(i);
            switch (n) {
                case 1: {
                    recordDescriptionListener.fieldDescriptionAdded(recordDescriptionEvent);
                    continue block4;
                }
                case 2: {
                    recordDescriptionListener.keyFieldDescriptionAdded(recordDescriptionEvent);
                    continue block4;
                }
            }
        }
    }

    public char getDelimiter() {
        return this.delimiter_;
    }

    public FieldDescription getFieldDescription(int n) {
        if (n < 0 || n > this.fieldDescriptions_.size() - 1) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        return (FieldDescription)this.fieldDescriptions_.elementAt(n);
    }

    public FieldDescription getFieldDescription(String string) {
        return (FieldDescription)this.fieldDescriptions_.elementAt(this.getIndexOfFieldName(string));
    }

    public FieldDescription[] getFieldDescriptions() {
        Object[] objectArray = new FieldDescription[this.fieldDescriptions_.size()];
        this.fieldDescriptions_.copyInto(objectArray);
        return objectArray;
    }

    public String[] getFieldNames() {
        int n = this.fieldDescriptions_.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((FieldDescription)this.fieldDescriptions_.elementAt(i)).getFieldName();
        }
        return stringArray;
    }

    boolean getHasDependentFields() {
        return this.hasDependentFields_;
    }

    public int getIndexOfFieldName(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        Integer n = (Integer)this.fieldNameToIndexMap_.get(string);
        if (n == null) {
            throw new ExtendedIllegalArgumentException("name (" + string + ")", 5);
        }
        return n;
    }

    public int getIndexOfKeyFieldName(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        Integer n = (Integer)this.keyFieldNameToIndexMap_.get(string);
        if (n == null) {
            throw new ExtendedIllegalArgumentException("name (" + string + ")", 5);
        }
        return n;
    }

    public FieldDescription getKeyFieldDescription(int n) {
        if (n < 0 || n > this.fieldDescriptions_.size() - 1) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        return (FieldDescription)this.keyFieldDescriptions_.elementAt(n);
    }

    public FieldDescription getKeyFieldDescription(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        return (FieldDescription)this.keyFieldDescriptions_.elementAt(this.getIndexOfKeyFieldName(string));
    }

    public FieldDescription[] getKeyFieldDescriptions() {
        Object[] objectArray = new FieldDescription[this.keyFieldDescriptions_.size()];
        this.keyFieldDescriptions_.copyInto(objectArray);
        return objectArray;
    }

    public String[] getKeyFieldNames() {
        int n = this.keyFieldDescriptions_.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ((FieldDescription)this.keyFieldDescriptions_.elementAt(i)).getFieldName();
        }
        return stringArray;
    }

    public int getLengthDependency(int n) {
        if (n < 0 || n > this.fieldDescriptions_.size() - 1) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        return (Integer)this.lengthDependentFields_.elementAt(n);
    }

    public int getLengthDependency(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        return (Integer)this.lengthDependentFields_.elementAt(this.getIndexOfFieldName(string));
    }

    public String getName() {
        return this.name_;
    }

    public Record getNewRecord() {
        if (this.fieldDescriptions_.size() == 0) {
            return null;
        }
        return new Record(this);
    }

    public Record getNewRecord(String string) {
        if (string == null) {
            throw new NullPointerException("recordName");
        }
        if (this.fieldDescriptions_.size() == 0) {
            return null;
        }
        return new Record(this, string);
    }

    public Record getNewRecord(byte[] byArray) throws UnsupportedEncodingException {
        return this.getNewRecord(byArray, 0);
    }

    public Record getNewRecord(byte[] byArray, String string) throws UnsupportedEncodingException {
        return this.getNewRecord(byArray, 0, string);
    }

    public Record getNewRecord(byte[] byArray, int n) throws UnsupportedEncodingException {
        if (byArray == null) {
            throw new NullPointerException("contents");
        }
        if (byArray.length == 0) {
            throw new ExtendedIllegalArgumentException("contents", 1);
        }
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("offset", 2);
        }
        if (this.fieldDescriptions_.size() == 0) {
            return null;
        }
        return new Record(this, byArray, n);
    }

    public Record getNewRecord(byte[] byArray, int n, String string) throws UnsupportedEncodingException {
        if (byArray == null) {
            throw new NullPointerException("contents");
        }
        if (byArray.length == 0) {
            throw new ExtendedIllegalArgumentException("contents", 1);
        }
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("offset", 2);
        }
        if (string == null) {
            throw new NullPointerException("recordName");
        }
        if (this.fieldDescriptions_.size() == 0) {
            return null;
        }
        return new Record(this, byArray, n, string);
    }

    public int getNumberOfFields() {
        return this.fieldDescriptions_.size();
    }

    public int getNumberOfKeyFields() {
        return this.keyFieldDescriptions_.size();
    }

    public int getOffsetDependency(int n) {
        if (n < 0 || n > this.fieldDescriptions_.size() - 1) {
            throw new ExtendedIllegalArgumentException("index", 4);
        }
        return (Integer)this.offsetDependentFields_.elementAt(n);
    }

    public int getOffsetDependency(String string) {
        if (string == null) {
            throw new NullPointerException("name");
        }
        return (Integer)this.offsetDependentFields_.elementAt(this.getIndexOfFieldName(string));
    }

    public String getRecordFormatID() {
        return this.recordFormatID_;
    }

    public int getRecordFormatType() {
        return this.recordFormatType_;
    }

    void initializeTextObjects(AS400 aS400) {
        for (int i = 0; i < this.fieldDescriptions_.size(); ++i) {
            AS400DataType aS400DataType = ((FieldDescription)this.fieldDescriptions_.elementAt((int)i)).dataType_;
            if (aS400DataType.getInstanceType() != 9) continue;
            ((AS400Text)aS400DataType).setConverter(aS400);
        }
    }

    private void initializeTransient() {
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        this.initializeTransient();
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        if (propertyChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.changes_ != null) {
            this.changes_.removePropertyChangeListener(propertyChangeListener);
        }
    }

    public void removeRecordDescriptionListener(RecordDescriptionListener recordDescriptionListener) {
        if (recordDescriptionListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.rdListeners_ != null) {
            this.rdListeners_.removeElement(recordDescriptionListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (vetoableChangeListener == null) {
            throw new NullPointerException("listener");
        }
        if (this.vetos_ != null) {
            this.vetos_.removeVetoableChangeListener(vetoableChangeListener);
        }
    }

    public void setDelimiter(char c) {
        this.delimiter_ = c;
    }

    public void setLengthDependency(int n, int n2) {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("dependentField", 4);
        }
        if (n > this.fieldDescriptions_.size() - 1) {
            throw new ExtendedIllegalArgumentException("dependentField", 4);
        }
        if (n2 < 0) {
            throw new ExtendedIllegalArgumentException("fieldDependedOn", 4);
        }
        if (n > this.fieldDescriptions_.size() - 1) {
            throw new ExtendedIllegalArgumentException("dependentField", 4);
        }
        if (n2 >= n) {
            throw new ExtendedIllegalArgumentException("fieldDependedOn", 2);
        }
        this.lengthDependentFields_.setElementAt(new Integer(n2), n);
        this.hasDependentFields_ = true;
    }

    public void setLengthDependency(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("dependentField");
        }
        if (string2 == null) {
            throw new NullPointerException("fieldDependedOn");
        }
        int n = this.getIndexOfFieldName(string2);
        int n2 = this.getIndexOfFieldName(string);
        this.setLengthDependency(n2, n);
    }

    public void setName(String string) throws PropertyVetoException {
        if (string == null) {
            throw new NullPointerException("name");
        }
        String string2 = this.name_;
        if (this.vetos_ != null) {
            this.vetos_.fireVetoableChange("name", string2, string.toUpperCase());
        }
        this.name_ = string.toUpperCase();
        if (this.changes_ != null) {
            this.changes_.firePropertyChange("name", string2, this.name_);
        }
    }

    public void setOffsetDependency(int n, int n2) {
        if (n < 0) {
            throw new ExtendedIllegalArgumentException("dependentField", 4);
        }
        if (n2 < 0) {
            throw new ExtendedIllegalArgumentException("fieldDependedOn", 4);
        }
        if (n > this.fieldDescriptions_.size() - 1) {
            throw new ExtendedIllegalArgumentException("dependentField", 4);
        }
        if (n2 >= n) {
            throw new ExtendedIllegalArgumentException("fieldDependedOn", 2);
        }
        this.offsetDependentFields_.setElementAt(new Integer(n2), n);
        this.hasDependentFields_ = true;
    }

    public void setOffsetDependency(String string, String string2) {
        if (string == null) {
            throw new NullPointerException("dependentField");
        }
        if (string2 == null) {
            throw new NullPointerException("fieldDependedOn");
        }
        int n = this.getIndexOfFieldName(string2);
        int n2 = this.getIndexOfFieldName(string);
        this.setOffsetDependency(n2, n);
    }

    public void setRecordFormatID(String string) {
        String string2 = "          ";
        if (string.length() > 10) {
            throw new ExtendedIllegalArgumentException("id", 1);
        }
        if (string.length() < 10) {
            int n = 10 - string.length();
            this.recordFormatID_ = string + string2.substring(0, n);
        } else {
            this.recordFormatID_ = string;
        }
    }

    public void setRecordFormatType(int n) {
        if (n != 2 && n != 1) {
            throw new ExtendedIllegalArgumentException("type", 2);
        }
        this.recordFormatType_ = n;
    }
}

