/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import java.awt.Color;
import java.awt.image.RGBImageFilter;
import java.io.Serializable;

public class HSBAdjustFilter
extends RGBImageFilter
implements Serializable {
    static final long serialVersionUID = 4578927872126740383L;
    public double hFactor;
    public double sFactor;
    public double bFactor;
    private float[] hsb = new float[3];

    public HSBAdjustFilter() {
        this(0.0, 0.0, 0.0);
    }

    public HSBAdjustFilter(double d, double d2, double d3) {
        this.hFactor = d;
        this.sFactor = d2;
        this.bFactor = d3;
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int n, int n2, int n3) {
        int n4 = n3 & 0xFF000000;
        int n5 = n3 >> 16 & 0xFF;
        int n6 = n3 >> 8 & 0xFF;
        int n7 = n3 & 0xFF;
        Color.RGBtoHSB(n5, n6, n7, this.hsb);
        this.hsb[0] = (float)((double)this.hsb[0] + this.hFactor);
        while (this.hsb[0] < 0.0f) {
            this.hsb[0] = (float)((double)this.hsb[0] + Math.PI * 2);
        }
        this.hsb[1] = (float)((double)this.hsb[1] + this.sFactor);
        if (this.hsb[1] < 0.0f) {
            this.hsb[1] = 0.0f;
        } else if ((double)this.hsb[1] > 1.0) {
            this.hsb[1] = 1.0f;
        }
        this.hsb[2] = (float)((double)this.hsb[2] + this.bFactor);
        if (this.hsb[2] < 0.0f) {
            this.hsb[2] = 0.0f;
        } else if ((double)this.hsb[2] > 1.0) {
            this.hsb[2] = 1.0f;
        }
        n3 = Color.HSBtoRGB(this.hsb[0], this.hsb[1], this.hsb[2]);
        return n4 | n3 & 0xFFFFFF;
    }

    public String toString() {
        return "Colors/Adjust HSB...";
    }
}

