/*
 * Decompiled with CFR 0.152.
 */
package com.jhlabs.image;

import com.jhlabs.image.ImageMath;
import com.jhlabs.image.WholeImageFilter;
import java.awt.Rectangle;

public abstract class TransformFilter
extends WholeImageFilter {
    public static final int ZERO = 0;
    public static final int CLAMP = 1;
    public static final int WRAP = 2;
    protected int edgeAction = 0;

    public void setEdgeAction(int n) {
        this.edgeAction = n;
    }

    public int getEdgeAction() {
        return this.edgeAction;
    }

    protected abstract void transformInverse(int var1, int var2, double[] var3);

    protected void transformSpace(Rectangle rectangle) {
    }

    public void imageComplete(int n) {
        if (n == 1 || n == 4) {
            this.consumer.imageComplete(n);
            return;
        }
        int n2 = this.originalSpace.width;
        int n3 = this.originalSpace.height;
        int n4 = this.transformedSpace.width;
        int n5 = this.transformedSpace.height;
        int n6 = 0;
        int[] nArray = new int[n4 * n5];
        int n7 = this.transformedSpace.x;
        int n8 = this.transformedSpace.y;
        int[] nArray2 = new int[4];
        double[] dArray = new double[2];
        int n9 = 0;
        while (n9 < n5) {
            int n10 = 0;
            while (n10 < n4) {
                this.transformInverse(n7 + n10, n8 + n9, dArray);
                int n11 = (int)dArray[0];
                int n12 = (int)dArray[1];
                if (n11 < 0 || n11 >= n2 || n12 < 0 || n12 >= n3) {
                    int n13;
                    switch (this.edgeAction) {
                        default: {
                            n13 = 0;
                            break;
                        }
                        case 2: {
                            n13 = this.inPixels[ImageMath.mod(n12, n3) * n2 + ImageMath.mod(n11, n2)];
                            break;
                        }
                        case 1: {
                            n13 = this.inPixels[ImageMath.clamp(n12, 0, n3 - 1) * n2 + ImageMath.clamp(n11, 0, n2 - 1)];
                        }
                    }
                    nArray[n6++] = n13;
                } else {
                    double d = dArray[0] - (double)n11;
                    double d2 = dArray[1] - (double)n12;
                    int n14 = n2 * n12 + n11;
                    int n15 = n11 == n2 - 1 ? 0 : 1;
                    int n16 = n12 == n3 - 1 ? 0 : n2;
                    nArray2[0] = this.inPixels[n14];
                    nArray2[1] = this.inPixels[n14 + n15];
                    nArray2[2] = this.inPixels[n14 + n16];
                    nArray2[3] = this.inPixels[n14 + n15 + n16];
                    nArray[n6++] = ImageMath.bilinearInterpolate(d, d2, nArray2);
                }
                ++n10;
            }
            ++n9;
        }
        this.consumer.setPixels(0, 0, n4, n5, this.defaultRGBModel, nArray, 0, n4);
        this.consumer.imageComplete(n);
        this.inPixels = null;
        nArray = null;
    }
}

