/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import javax.activation.DataSource;

public class ByteArrayDataSource
implements DataSource {
    private ByteArrayOutputStream baos;
    private String type;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ByteArrayDataSource(byte[] data, String type) throws IOException {
        this.baos = null;
        this.type = "application/octet-stream";
        ByteArrayInputStream Bis = null;
        try {
            Bis = new ByteArrayInputStream(data);
            this.byteArrayDataSource(Bis, type);
            Object var6_4 = null;
        }
        catch (Throwable throwable) {
            Object var6_5 = null;
            try {
                if (Bis == null) throw throwable;
                Bis.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        if (Bis == null) return;
        Bis.close();
        return;
    }

    public ByteArrayDataSource(InputStream aIs, String type) throws IOException {
        this.baos = null;
        this.type = "application/octet-stream";
        this.byteArrayDataSource(aIs, type);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void byteArrayDataSource(InputStream aIs, String type) throws IOException {
        this.type = type;
        BufferedInputStream Bis = null;
        FilterOutputStream osWriter = null;
        try {
            int length = 0;
            byte[] buffer = new byte[512];
            Bis = new BufferedInputStream(aIs);
            this.baos = new ByteArrayOutputStream();
            osWriter = new BufferedOutputStream(this.baos);
            while ((length = Bis.read(buffer)) != -1) {
                ((BufferedOutputStream)osWriter).write(buffer, 0, length);
            }
            ((BufferedOutputStream)osWriter).flush();
            osWriter.close();
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            try {
                if (Bis != null) {
                    Bis.close();
                }
                if (this.baos != null) {
                    this.baos.close();
                }
                if (osWriter == null) throw throwable;
                osWriter.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException ignored) {}
        if (Bis != null) {
            Bis.close();
        }
        if (this.baos != null) {
            this.baos.close();
        }
        if (osWriter == null) return;
        osWriter.close();
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public ByteArrayDataSource(String data, String type) throws IOException {
        block14: {
            this.baos = null;
            this.type = "application/octet-stream";
            this.type = type;
            this.baos = new ByteArrayOutputStream();
            this.baos.write(data.getBytes("iso-8859-1"));
            this.baos.flush();
            this.baos.close();
            Object var5_3 = null;
            try {
                if (this.baos != null) {
                    this.baos.close();
                }
                break block14;
            }
            catch (IOException ignored) {}
            break block14;
            {
                catch (UnsupportedEncodingException uex) {
                    Object var5_4 = null;
                    try {
                        if (this.baos != null) {
                            this.baos.close();
                        }
                        break block14;
                    }
                    catch (IOException ignored) {}
                    break block14;
                }
                catch (IOException iOException) {
                    Object var5_5 = null;
                    try {
                        if (this.baos != null) {
                            this.baos.close();
                        }
                        break block14;
                    }
                    catch (IOException ignored) {}
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                try {
                    if (this.baos != null) {
                        this.baos.close();
                    }
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    public String getContentType() {
        return this.type == null ? "application/octet-stream" : this.type;
    }

    public InputStream getInputStream() throws IOException {
        if (this.baos == null) {
            throw new IOException("no data");
        }
        return new ByteArrayInputStream(this.baos.toByteArray());
    }

    public String getName() {
        return "ByteArrayDataSource";
    }

    public OutputStream getOutputStream() throws IOException {
        this.baos = new ByteArrayOutputStream();
        return this.baos;
    }
}

