/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.mail.DefaultAuthenticator;

public abstract class Email {
    public static final String SENDER_EMAIL = "sender.email";
    public static final String SENDER_NAME = "sender.name";
    public static final String RECEIVER_EMAIL = "receiver.email";
    public static final String RECEIVER_NAME = "receiver.name";
    public static final String EMAIL_SUBJECT = "email.subject";
    public static final String EMAIL_BODY = "email.body";
    public static final String CONTENT_TYPE = "content.type";
    public static final String MAIL_HOST = "mail.host";
    public static final String MAIL_SMTP_FROM = "mail.smtp.from";
    public static final String MAIL_SMTP_AUTH = "mail.smtp.auth";
    public static final String MAIL_TRANSPORT_PROTOCOL = "mail.transport.protocol";
    public static final String SMTP = "smtp";
    public static final String TEXT_HTML = "text/html";
    public static final String TEXT_PLAIN = "text/plain";
    public static final String ATTACHMENTS = "attachments";
    public static final String FILE_SERVER = "file.server";
    public static final String MAIL_DEBUG = "mail.debug";
    public static final String KOI8_R = "koi8-r";
    public static final String ISO_8859_1 = "iso-8859-1";
    public static final String US_ASCII = "us-ascii";
    protected MimeMessage message = null;
    protected String charset = null;
    private InternetAddress fromAddress = null;
    private String subject = null;
    private MimeMultipart emailBody = null;
    private Object content = null;
    private String contentType = null;
    private boolean debug = false;
    private Date sentDate;
    private Authenticator authenticator;
    private String hostName = null;
    private ArrayList toList = null;
    private ArrayList ccList = null;
    private ArrayList bccList = null;
    private ArrayList replyList = null;
    private Hashtable headers = null;

    public void setDebug(boolean d) {
        this.debug = d;
    }

    public void setAuthentication(String userName, String password) {
        DefaultAuthenticator authenticator = new DefaultAuthenticator(userName, password);
        this.setAuthenticator(authenticator);
    }

    public void setAuthenticator(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void setContent(MimeMultipart aMimeMultipart) {
        this.emailBody = aMimeMultipart;
    }

    public void setContent(Object aObject, String aContentType) {
        this.content = aObject;
        if (aContentType == null) {
            this.contentType = aContentType;
        } else {
            int charsetPos = aContentType.toLowerCase().indexOf("; charset=");
            if (charsetPos > 0) {
                aContentType.substring(0, charsetPos);
                this.charset = aContentType.substring(charsetPos + 10);
            } else {
                this.contentType = aContentType;
            }
        }
    }

    public void setHostName(String aHostName) {
        this.hostName = aHostName;
    }

    private Session getMailSession() throws MessagingException {
        Properties properties = System.getProperties();
        properties.setProperty(MAIL_TRANSPORT_PROTOCOL, SMTP);
        if (this.hostName == null) {
            this.hostName = properties.getProperty(MAIL_HOST);
        }
        if (this.hostName == null) {
            throw new MessagingException("Cannot find valid hostname for mail session");
        }
        properties.setProperty(MAIL_HOST, this.hostName);
        properties.setProperty(MAIL_DEBUG, new Boolean(this.debug).toString());
        if (this.authenticator != null) {
            properties.setProperty(MAIL_SMTP_AUTH, "true");
        }
        Session session = Session.getDefaultInstance((Properties)properties, (Authenticator)this.authenticator);
        return session;
    }

    public Email setFrom(String email) throws MessagingException {
        return this.setFrom(email, null);
    }

    public Email setFrom(String email, String name) throws MessagingException {
        try {
            if (name == null || name.trim().equals("")) {
                name = email;
            }
            if (this.fromAddress == null) {
                this.fromAddress = this.charset != null ? new InternetAddress(email, name, this.charset) : new InternetAddress(email, name);
            } else {
                this.fromAddress.setAddress(email);
                this.fromAddress.setPersonal(name);
            }
        }
        catch (Exception e) {
            throw new MessagingException("cannot set from", e);
        }
        return this;
    }

    public Email addTo(String email) throws MessagingException {
        return this.addTo(email, null);
    }

    public Email addTo(String email, String name) throws MessagingException {
        try {
            if (name == null || name.trim().equals("")) {
                name = email;
            }
            if (this.toList == null) {
                this.toList = new ArrayList();
            }
            if (this.charset != null) {
                this.toList.add(new InternetAddress(email, name, this.charset));
            } else {
                this.toList.add(new InternetAddress(email, name));
            }
        }
        catch (Exception e) {
            throw new MessagingException("cannot add to", e);
        }
        return this;
    }

    public Email setTo(Collection aCollection) {
        this.toList = new ArrayList(aCollection);
        return this;
    }

    public Email addCc(String email) throws MessagingException {
        return this.addCc(email, null);
    }

    public Email addCc(String email, String name) throws MessagingException {
        try {
            if (name == null || name.trim().equals("")) {
                name = email;
            }
            if (this.ccList == null) {
                this.ccList = new ArrayList();
            }
            if (this.charset != null) {
                this.ccList.add(new InternetAddress(email, name, this.charset));
            } else {
                this.ccList.add(new InternetAddress(email, name));
            }
        }
        catch (Exception e) {
            throw new MessagingException("cannot add cc", e);
        }
        return this;
    }

    public Email setCc(Collection aCollection) {
        this.ccList = new ArrayList(aCollection);
        return this;
    }

    public Email addBcc(String email) throws MessagingException {
        return this.addBcc(email, null);
    }

    public Email addBcc(String email, String name) throws MessagingException {
        try {
            if (name == null || name.trim().equals("")) {
                name = email;
            }
            if (this.bccList == null) {
                this.bccList = new ArrayList();
            }
            this.bccList.add(new InternetAddress(email, name));
        }
        catch (Exception e) {
            throw new MessagingException("cannot add bcc", e);
        }
        return this;
    }

    public Email setBcc(Collection aCollection) {
        this.bccList = new ArrayList(aCollection);
        return this;
    }

    public Email addReplyTo(String email) throws MessagingException {
        return this.addReplyTo(email, null);
    }

    public Email addReplyTo(String email, String name) throws MessagingException {
        try {
            if (name == null || name.trim().equals("")) {
                name = email;
            }
            if (this.replyList == null) {
                this.replyList = new ArrayList();
            }
            if (this.charset != null) {
                this.replyList.add(new InternetAddress(email, name, this.charset));
            } else {
                this.replyList.add(new InternetAddress(email, name));
            }
        }
        catch (Exception e) {
            throw new MessagingException("cannot add replyTo", e);
        }
        return this;
    }

    public void setHeaders(Hashtable h) {
        this.headers = h;
    }

    public void addHeader(String name, String value) {
        if (name == null) {
            throw new IllegalArgumentException("name can not be null");
        }
        if (value == null) {
            throw new IllegalArgumentException("value can not be null");
        }
        if (this.headers == null) {
            this.headers = new Hashtable();
        }
        this.headers.put(name, value);
    }

    public Email setSubject(String aSubject) {
        this.subject = aSubject;
        return this;
    }

    public abstract Email setMsg(String var1) throws MessagingException;

    public void send() throws MessagingException {
        Session session = this.getMailSession();
        MimeMessage message = new MimeMessage(session);
        if (this.subject != null) {
            if (this.charset == null) {
                message.setSubject(this.subject);
            } else {
                message.setSubject(this.subject, this.charset);
            }
        }
        if (this.content != null) {
            String type = this.contentType;
            if (type != null && this.charset != null) {
                type = type + "; charset=" + this.charset;
            }
            message.setContent(this.content, type);
        } else if (this.emailBody != null) {
            message.setContent((Multipart)this.emailBody);
        } else {
            message.setContent((Object)"", TEXT_PLAIN);
        }
        if (this.fromAddress == null) {
            throw new MessagingException("Sender address required");
        }
        message.setFrom((Address)this.fromAddress);
        if (this.toList == null && this.ccList == null && this.bccList == null) {
            throw new MessagingException("At least one receiver address required");
        }
        if (this.toList != null) {
            message.setRecipients(Message.RecipientType.TO, (Address[])this.toInternetAddressArray(this.toList));
        }
        if (this.ccList != null) {
            message.setRecipients(Message.RecipientType.CC, (Address[])this.toInternetAddressArray(this.ccList));
        }
        if (this.bccList != null) {
            message.setRecipients(Message.RecipientType.BCC, (Address[])this.toInternetAddressArray(this.bccList));
        }
        if (this.replyList != null) {
            message.setReplyTo((Address[])this.toInternetAddressArray(this.replyList));
        }
        if (this.headers != null) {
            Enumeration e = this.headers.keys();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                String value = (String)this.headers.get(name);
                message.addHeader(name, value);
            }
        }
        if (message.getSentDate() == null) {
            message.setSentDate(this.getSentDate());
        }
        Transport.send((Message)message);
    }

    public void setSentDate(Date date) {
        this.sentDate = date;
    }

    public Date getSentDate() {
        return this.sentDate == null ? new Date() : this.sentDate;
    }

    private InternetAddress[] toInternetAddressArray(ArrayList aList) {
        InternetAddress[] ia = aList.toArray(new InternetAddress[0]);
        return ia;
    }
}

