/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.mail;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.activation.URLDataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import org.apache.commons.mail.Email;
import org.apache.commons.mail.EmailAttachment;
import org.apache.commons.mail.StringUtils;

public class MultiPartEmail
extends Email {
    private MimeMultipart container = null;
    private MimeBodyPart primaryBodyPart = null;
    private boolean initialized = false;

    private void init() throws MessagingException {
        if (this.initialized) {
            throw new IllegalStateException("Already initialized");
        }
        this.container = new MimeMultipart();
        super.setContent(this.container);
        this.primaryBodyPart = new MimeBodyPart();
        this.container.addBodyPart((BodyPart)this.primaryBodyPart);
        this.initialized = true;
    }

    public Email setMsg(String msg) throws MessagingException {
        if (this.charset != null) {
            this.getPrimaryBodyPart().setText(msg, this.charset);
        } else {
            this.getPrimaryBodyPart().setText(msg);
        }
        return this;
    }

    public void send() throws MessagingException {
        MimeBodyPart body = this.getPrimaryBodyPart();
        Object content = null;
        try {
            content = body.getContent();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (content == null) {
            body.setContent((Object)"", "text/plain");
        }
        super.send();
    }

    public MultiPartEmail attach(EmailAttachment attachment) throws MessagingException {
        MultiPartEmail result = null;
        URL url = attachment.getURL();
        if (url == null) {
            String fileName = null;
            try {
                fileName = attachment.getPath();
                File file = new File(fileName);
                if (!file.exists()) {
                    throw new IOException("\"" + fileName + "\" does not exist");
                }
                result = this.attach((DataSource)new FileDataSource(file), attachment.getName(), attachment.getDescription(), attachment.getDisposition());
            }
            catch (Exception e) {
                throw new MessagingException("Cannot attach file \"" + fileName + "\"", e);
            }
        } else {
            result = this.attach(url, attachment.getName(), attachment.getDescription(), attachment.getDisposition());
        }
        return result;
    }

    public MultiPartEmail attach(URL url, String name, String description) throws MessagingException {
        return this.attach(url, name, description, "attachment");
    }

    public MultiPartEmail attach(URL url, String name, String description, String disposition) throws MessagingException {
        return this.attach((DataSource)new URLDataSource(url), name, description, disposition);
    }

    public MultiPartEmail attach(DataSource ds, String name, String description) throws MessagingException {
        return this.attach(ds, name, description, "attachment");
    }

    public MultiPartEmail attach(DataSource ds, String name, String description, String disposition) throws MessagingException {
        MimeBodyPart mbp = new MimeBodyPart();
        this.getContainer().addBodyPart((BodyPart)mbp);
        mbp.setDisposition(disposition);
        if (StringUtils.isEmpty(name)) {
            name = ds.getName();
        }
        mbp.setFileName(name);
        mbp.setDescription(description);
        mbp.setDataHandler(new DataHandler(ds));
        return this;
    }

    protected MimeBodyPart getPrimaryBodyPart() throws MessagingException {
        if (!this.initialized) {
            this.init();
        }
        return this.primaryBodyPart;
    }

    protected MimeMultipart getContainer() throws MessagingException {
        if (!this.initialized) {
            this.init();
        }
        return this.container;
    }
}

